<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\CloseDay;
use App\Models\DayCloseRecord;
use App\Models\ItemStockLedger;
use App\Models\InventoryReport;
use App\Models\CostOfSaleAnalysis;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use DB;

class DayClose extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'dayclose:cron';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
       
        $time = date('H:i:s'); // current time 
        $dayClose = \DB::table('close_days')->first();

        $cos = \DB::table('cost_of_sale_analyses')->where('date', $dayClose->day_close)->delete();
        $items_cost = \DB::table('invoices')
         ->selectRaw('invoice_product_name as name,branch as branch, invoice_category as invoice_category, product_id as product_id, sum(invoice_total_price) as total, sum(invoice_quantity) as quantity, invoice_unit_price as price')
                 ->where('invoice_category', '!=', "TRANSPORT")
         ->groupBy('invoice_product_name')
         ->groupBy('invoice_category')
         ->groupBy('branch')
         ->groupBy('invoice_unit_price')
         ->groupBy('product_id')
         ->whereIn('invoice_status', [1,2])
         ->whereDate('created_at', $dayClose->day_close)
         ->get();

         $mTax = \DB::table('taxes')->first();
        $gTax = $mTax->covid+$mTax->nhil+$mTax->getfund+$mTax->tourism;
    
         foreach ($items_cost as $key => $validateProduct) {
              // Records for Cost of Salels
              CostOfSaleAnalysis::create([
                 'item_name' => $validateProduct->name,
                 'item_id' => $validateProduct->product_id,
                 'branch' => $validateProduct->branch,
                 'user_id' => 1,
                 'category' =>  $validateProduct->invoice_category,
                 'quantity' => $validateProduct->quantity,
                 'gross_amount' => $validateProduct->total,
                 'net_amount' => (($validateProduct->total)/(1+ ($gTax) + ($mTax->vat) + ($gTax*$mTax->vat)) ),
                 'cost' => \DB::table('material_product_compositons')->where('product_id', $validateProduct->product_id)->pluck('cost')->sum() *  $validateProduct->quantity,
                 'adjusted_cost' => \DB::table('material_product_compositons')->where('product_id', $validateProduct->product_id)->pluck('adjusted_cost')->sum() *  $validateProduct->quantity,
                 'date' =>  $dayClose->day_close
             ]);
         }


        $date = $dayClose->day_close;
        $newdate = date('Y-m-d', strtotime('+1 day', strtotime($date)));
    
    
        \DB::table('close_days')->update([
            'day_close' => $newdate,
            'app_state' => 1
        ]);

        \Log::info('day closed successfully');
    }

    
}
