<?php

namespace App\Http\Controllers;

use App\Models\Account;
use App\Models\AccountTransaction;
use Illuminate\Http\Request;
use App\Models\Income;
use App\Models\AccountValidation;
use App\Models\CustomerStatement;
use App\Models\CostOfSaleDump;
use App\Models\Discount;

class AccountController extends Controller
{
    
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        
        $this->validate(request(), [
            'account_name' => 'required|max:300',
            'account_number' => 'required|max:300'
        ]);

        try {
            // Perform DB Transaction
            \DB::beginTransaction();

        $dayClose = \DB::table('close_days')->first();

        $sub_account = \DB::table('account_types')->where('account_type_name', request('account_type'))->first();
        $account = Account::create([
            'user_id' => auth()->id(), 
            'account_name' => request('account_name'),
            'added_by' => auth()->user()->name,
            'account_code' => rand(90,500).date('Yd'), 
            'account_number' => request('account_number'),
            'account_type' => request('account_type'), 
            'account_sub_type' => $sub_account->account_type_parent,
            'sub_account' => request('sub_account'),
            'account_opening_balance' => request('account_opening_balance'), 
            'account_details' => request('account_details'), 
            'account_note' => request('account_note'), 
            'control_account_id' => request('control_account'), 
        ]);
        


            AccountTransaction::create([
                'user_id' => auth()->id(), 
                'added_by' => auth()->user()->name,
                'account_code' => $account->account_code, 
                'account_id' => $account->id,
                'transaction_code' => "AC".rand(90,500).date('Yd'), 
                'date' => $dayClose->day_close, 
                'description' => "Opening Balance", 
                'debit' => request('account_opening_balance'),
            ]);

            $earnings = \DB::table('accounts')->where('account_name', 'Retained Earnings')->first();
            AccountTransaction::create([
                'user_id' => auth()->id(), 
                'added_by' => auth()->user()->name,
                'account_code' => $earnings->account_code,   
                'account_id' => $earnings->id,
                'transaction_code' => "AC".rand(90,500).date('Yd'), 
                'date' => $dayClose->day_close, 
                'description' => "Opening Balance - " . request('account_name'), 
                'credit' => request('account_opening_balance'),
            ]);
        

        \DB::commit();
        return back()->with('status', "Account Added successfully");

        } catch (\Throwable $th) {
            \DB::rollback();
            $res = response([
                'status' => 501,
                "message" => $th
            ]);
           
            
        } 

        
    }


    public function FundsTransfer(Account $account)
    {
        $this->validate(request(), [
            'date' => 'required',
            'transfer_to' => 'required|max:300'
        ]);
        try {
            // Perform DB Transaction
            \DB::beginTransaction();
        session()->put('transaction_number', "ACT".rand(90,500).date('Yd'));
       $transfer_account = \DB::table('accounts')->where('account_name', request('transfer_to'))->first();

        // CREDIT GIVER ACCOUNT
       $balance_giver = \DB::table('account_transactions')->where('account_id', $account->id)->sum('debit' ) - \DB::table('account_transactions')->where('account_id', $account->id)->sum('credit');
        AccountTransaction::create([
            'user_id' => auth()->id(),
            'added_by' => auth()->user()->name, 
            'account_code' => $account->account_code, 
            'account_id' => $account->id,
            'transaction_code' => session()->get('transaction_number'),
            'date' => request('date'), 
            'description' => "Inter Account Transfer" . " (TO: " . request('transfer_to') . ")" .'<br>' . '<strong style="font-weight:400">Payment Method: </strong>' .  request('payment_method'),
            'note' => request('note'),
            'payment_method' => request('payment_method'),
            'credit' => request('amount'),
        ]);

        // DEBIT RECIEVER ACCOUNT
        $balance_reciever = \DB::table('account_transactions')->where('account_id', $transfer_account->id)->sum('debit') - \DB::table('account_transactions')->where('account_id', $transfer_account->id)->sum('credit');
        AccountTransaction::create([
            'user_id' => auth()->id(),
            'added_by' => auth()->user()->name, 
            'account_code' => $transfer_account->account_code, 
            'account_id' => $transfer_account->id,
            'transaction_code' => session()->get('transaction_number'), 
            'date' => request('date'), 
            'description' => "Inter Account Transfer" . " (FROM: " . $account->account_name . ")".'<br>' . '<strong>Payment Method: </strong>' .  request('payment_method'),
            'note' => request('note'),
            'payment_method' => request('payment_method'),
            'debit' => request('amount'),
        ]);

        session()->forget('transaction_number');
        \DB::commit(); 
        return back()->with('status', 'Funds successfully transfered from ' . $account->account_name . " to ". request('transfer_to'));

        } catch (\Throwable $th) {
            \DB::rollback();
            $res = response([
                'status' => 501,
                "message" => $th
            ]);
            return back()->with('statuspass', "Oops Something Happend, Transaction unsuccessufull");
            
        } 
    }


    public function Deposit(Account $account)
    {
        try {
            // Perform DB Transaction
            \DB::beginTransaction();
        session()->put('transaction_number', "DEP".rand(90,500).date('Yd'));
        $depositer_account = \DB::table('accounts')->where('account_name', request('deposit_from'))->first();

        // DEBIT RECIEVER OF DEPOSIT 
       $balance_deposit_reciever = \DB::table('account_transactions')->where('account_id', $account->id)->sum('debit') - \DB::table('account_transactions')->where('account_id', $account->id)->sum('credit');
        AccountTransaction::create([
            'user_id' => auth()->id(), 
            'added_by' => auth()->user()->name,
            'account_code' => $account->account_code, 
            'account_id' => $account->id,
            'transaction_code' => session()->get('transaction_number'),
            'date' => request('date'), 
            'description' => request('trans_type') . " (FROM: " . request('deposit_from') . ")",
            'note' => request('note'),
            'debit' => request('amount'),
        ]);

        // CREDIT ACCOUNT
        $balance_deposit_giver = \DB::table('account_transactions')->where('account_id', $depositer_account->id)->sum('debit') - \DB::table('account_transactions')->where('account_id', $depositer_account->id)->sum('credit');
        AccountTransaction::create([
            'user_id' => auth()->id(), 
            'added_by' => auth()->user()->name,
            'account_code' => $depositer_account->account_code, 
            'account_id' => $depositer_account->id,
            'transaction_code' => session()->get('transaction_number'), 
            'date' => request('date'), 
            'description' => request('trans_type') . " (FROM: " . $account->account_name . ")",
            'note' => request('note'),
            'credit' => request('amount'),
        ]);

        session()->forget('transaction_number');
        \DB::commit(); 
        return back()->with('status', 'Funds successfully  deposited to ' .  $account->account_name);

        } catch (\Throwable $th) {
            \DB::rollback();
            $res = response([
                'status' => 501,
                "message" => $th
            ]);
            return back()->with('statuspass', "Oops Something Happend, Transaction unsuccessufull");
            
        } 
    }


    public function cashFlow()
    {

        return view('accounting.cash-flow', [
            'transactions' =>\DB::table('account_transactions')->where('transaction_type', 1)->where('debit', '!=', "")->get(),
            'transfers' => \DB::table('account_transactions')->where('transaction_type', 0)->get()

        ]);
    }

    public function transactions(Account $account)
    {
        $dayClose = \DB::table('close_days')->first();
        $date =  $dayClose->day_close . " - " . $dayClose->day_close; 

        $value = explode(' - ', $date);
         
        $source1 = $value[0];
        $date1 = new \DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new \DateTime($source2);
        $to = $date2->format('Y-m-d');

        if ($from == $to) {
            $balance_b_f =  \DB::table('account_transactions')->where('account_id', $account->id)->whereDate('date', '<', $to)->sum('debit') - 
            \DB::table('account_transactions')->where('account_id', $account->id)->whereDate('date', '<', $to)->sum('credit');
            
            $transactions_db = \DB::table('account_transactions')->where('account_id', $account->id)
            ->WhereDate('date','>=', $from)
            ->WhereDate('date','<=', $to)
            ->OrderBy('id', 'DESC')
            ->get();
            $ending_b_f = null;
        }else {
            $balance_b_f =  \DB::table('account_transactions')->where('account_id', $account->id)->whereDate('date', '<', $from)->sum('debit') - 
            \DB::table('account_transactions')->where('account_id', $account->id)->whereDate('date', '<', $from)->sum('credit');

            $ending_b_f =  \DB::table('account_transactions')->where('account_id', $account->id)
            ->WhereDate('date','>=', $from)
            ->WhereDate('date','<=', $to)
            ->OrderBy('id', 'DESC')->first();

           $transactions_db = \DB::table('account_transactions')->where('account_id', $account->id)
            ->WhereDate('date','>=', $from)
            ->WhereDate('date','<=', $to)
            ->get();
        }
        
        return view('accounting.account-book', [
            'account_details' => $account,
            'transactions_db' => $transactions_db,
            'balance_b_f_' => empty($balance_b_f) ? 0  : $balance_b_f,
            'from' => $from,
            'to' => $to,
            'ending_b_f' => $ending_b_f,
            'account_id' => $account->id,
            'main_balance' => $transactions_db->first()
        ]);
    }


    public function AccountFilter(Request $request)
    {
        $account = Account::where('account_number', request('account_number'))->first();

        $this->validate(request(), [
            'start_date' => 'required',
            'end_date' => 'required'
        ]);

        $from = request('start_date');
        $to = request('end_date');

        if ($from == $to) {
            
           $balance_db =  \DB::table('account_transactions')->where('account_id', $account->id)->whereDate('date', '<', $from)->OrderBy('id', 'DESC')->pluck('id');

           $debit = \DB::table('account_transactions')->where('account_id', $account->id)
           ->whereIn('id', $balance_db)
           ->sum('debit');

           $credit = \DB::table('account_transactions')->where('account_id', $account->id)
           ->whereIn('id', $balance_db)
           ->sum('credit');

           $balance_b_f = $debit - $credit;

            $transactions_db = \DB::table('account_transactions')->where('account_id', $account->id)
            ->WhereDate('date','>=', $from)
            ->WhereDate('date','<=', $to)
            ->OrderBy('id', 'DESC')
            ->get();
            $ending_b_f = null;
        }else {
           $balance_db =  \DB::table('account_transactions')->where('account_id', $account->id)->whereDate('date', '<', $from)->OrderBy('id', 'DESC')->pluck('id');

           $debit = \DB::table('account_transactions')->where('account_id', $account->id)
           ->whereIn('id', $balance_db)
           ->sum('debit');

           $credit = \DB::table('account_transactions')->where('account_id', $account->id)
           ->whereIn('id', $balance_db)
           ->sum('credit');

           $balance_b_f = $debit - $credit;


           $transactions_db = \DB::table('account_transactions')->where('account_id', $account->id)
            ->WhereDate('date','>=', $from)
            ->WhereDate('date','<=', $to)
            ->get();
        }
        
        return view('accounting.account-book', [
            'account_details' => $account,
            'transactions_db' => $transactions_db,
            'balance_b_f_' => empty($balance_b_f) ? 0  : $balance_b_f,
            'from' => $from,
            'to' => $to,
            'account_id' => $account->id,
            'main_balance' => $transactions_db->first()
        ]);
    }


    public function AccountFilterMain(Request $request)
    {
        $this->validate(request(), [
            'account_id' => 'required'
        ]);

        $account = Account::where('id', request('account_id'))->first();
        
        $this->validate(request(), [
            'start_date' => 'required',
            'end_date' => 'required'
        ]);

        $from = request('start_date');
        $to = request('end_date');

        if ($from == $to) {
            
           $balance_db =  \DB::table('account_transactions')->where('account_id', $account->id)->whereDate('date', '<', $from)->OrderBy('id', 'DESC')->pluck('id');

           $debit = \DB::table('account_transactions')->where('account_id', $account->id)
           ->whereIn('id', $balance_db)
           ->sum('debit');

           $credit = \DB::table('account_transactions')->where('account_id', $account->id)
           ->whereIn('id', $balance_db)
           ->sum('credit');

           $balance_b_f = $debit - $credit;

            $transactions_db = \DB::table('account_transactions')->where('account_id', $account->id)
            ->WhereDate('date','>=', $from)
            ->WhereDate('date','<=', $to)
            ->OrderBy('id', 'DESC')
            ->get();
            $ending_b_f = null;
        }else {
           $balance_db =  \DB::table('account_transactions')->where('account_id', $account->id)->whereDate('date', '<', $from)->OrderBy('id', 'DESC')->pluck('id');

           $debit = \DB::table('account_transactions')->where('account_id', $account->id)
           ->whereIn('id', $balance_db)
           ->sum('debit');

           $credit = \DB::table('account_transactions')->where('account_id', $account->id)
           ->whereIn('id', $balance_db)
           ->sum('credit');

           $balance_b_f = $debit - $credit;


           $transactions_db = \DB::table('account_transactions')->where('account_id', $account->id)
            ->WhereDate('date','>=', $from)
            ->WhereDate('date','<=', $to)
            ->get();
        }
        
        return view('accounting.account-book', [
            'account_details' => $account,
            'transactions_db' => $transactions_db,
            'balance_b_f_' => empty($balance_b_f) ? 0  : $balance_b_f,
            'from' => $from,
            'to' => $to,
            'account_id' => $account->id,
            'main_balance' => $transactions_db->first()
        ]);
    }


    public function BankAccountSummary()
    {
        $accounts = \DB::table('accounts')->where('id', request('account_id'))->first();
        return view('accounting.bank-summary', [
            'accounts' => $accounts
        ]);
    }


    public function AccountFilterPrint(Request $request)
    {
        
        $account = Account::where('id', request('account_id'))->first();

        $this->validate(request(), [
            'start_date' => 'required',
            'end_date' => 'required'
        ]);

        $from = request('start_date');
        $to = request('end_date');

        if ($from == $to) {
            
           $balance_db =  \DB::table('account_transactions')->where('account_id', $account->id)->whereDate('date', '<', $from)->OrderBy('id', 'DESC')->pluck('id');

           $debit = \DB::table('account_transactions')->where('account_id', $account->id)
           ->whereIn('id', $balance_db)
           ->sum('debit');

           $credit = \DB::table('account_transactions')->where('account_id', $account->id)
           ->whereIn('id', $balance_db)
           ->sum('credit');

           $balance_b_f = $debit - $credit;

            $transactions_db = \DB::table('account_transactions')->where('account_id', $account->id)
            ->WhereDate('date','>=', $from)
            ->WhereDate('date','<=', $to)
            ->orderBy('id', 'ASC')
            ->get();
            $ending_b_f = null;
        }else {
           $balance_db =  \DB::table('account_transactions')->where('account_id', $account->id)->whereDate('date', '<', $from)->OrderBy('id', 'DESC')->pluck('id');

           $debit = \DB::table('account_transactions')->where('account_id', $account->id)
           ->whereIn('id', $balance_db)
           ->sum('debit');

           $credit = \DB::table('account_transactions')->where('account_id', $account->id)
           ->whereIn('id', $balance_db)
           ->sum('credit');

           $balance_b_f = $debit - $credit;


           $transactions_db = \DB::table('account_transactions')->where('account_id', $account->id)
            ->WhereDate('date','>=', $from)
            ->WhereDate('date','<=', $to)
            ->orderBy('id', 'ASC')
            ->get();
        }
        
        return view('accounting.account-book-print', [
            'account_details' => $account,
            'transactions_db' => $transactions_db,
            'balance_b_f_' => empty($balance_b_f) ? 0  : $balance_b_f,
            'from' => $from,
            'to' => $to,
            'account_id' => $account->id,
            'main_balance' => $transactions_db->first()
        ]);
    }

    public function printAccountBooks(Account $account)
    {
        return view('accounting.print-account-book', [
            'account_details' => $account
        ]);
    }


    public function NonLinked()
    {
        $summaryRe =  \DB::table('invoices')
            ->selectRaw('branch as branch, sum(invoice_total_price) as total, sum(amount_deducted) as deducted')
                        ->where('invoice_category', '!=', "TRANSPORT")
                        ->where('invoice_status', 1)
            ->groupBy('branch')
            ->where('account_linked', 0)
            ->get();

            return view('accounting.non-linked-transaction', [
                'summary' => $summaryRe
            ]);
            
    }


    public function LinkSales()
    {
        $time = date('H:i:s'); // current time 
        $getDayClose = \DB::table('close_days')->first();

        $check_sales = \DB::table('account_validations')->whereDate('date', $getDayClose->day_close)->where('state', 1)->get();
        $all_invoice = \DB::table('invoices')
            ->where('invoice_status', 1)
            ->where('invoice_category', '!=', "TRANSPORT")
            ->whereDate('created_at', $getDayClose->day_close)
            ->sum('invoice_total_price');

            $discounts = \DB::table('discounts')
            ->whereDate('created_at', $getDayClose->day_close)
            ->sum('amount_deducted');

            $net_sales = $all_invoice -  $discounts;

        if ($check_sales ->isEmpty()) {
            AccountValidation::create([
                'sales_amount' => $net_sales,
                'date' =>  $getDayClose->day_close,
                'state' => 1,
                'added_by' => auth()->user()->name
            ]);
        }else {
            return back()->with('status', 'account linked Already');
        }

        session()->put('invoice_number', "SAL".rand(12347,898634));

            // DEBIT CASH ACCOUNT
         $paying_account = \DB::table('accounts')->where('account_number', 100)->first();
         if (!empty($paying_account) || null) {
             $sales = \DB::table('account_transactions')->where('account_id', $paying_account->id)->sum('debit') - \DB::table('account_transactions')->where('account_id', $paying_account->id)->sum('credit');
             AccountTransaction::create([
                 'user_id' => auth()->id(), 
                 'account_code' => $paying_account->account_code, 
                 'account_id' => $paying_account->id,
                 'transaction_code' => session()->get('invoice_number'), 
                 'date' => date('Y-m-d H:i:s', strtotime("$getDayClose->day_close $time")), 
                 'description' => 'TOTAL SALES TRANSACTIONS FOR '. $getDayClose->day_close. '</br>',
                 'debit' => $net_sales,
                 'transaction_type' => 1,
                 'added_by' => auth()->user()->name
             ]);
         }

        // CREDIT SALES ACCOUNT
        $outing = \DB::table('accounts')->where('account_number', 145)->first();
        if (!empty($outing) || null) {
            $sales = \DB::table('account_transactions')->where('account_id', $outing->id)->sum('debit') - \DB::table('account_transactions')->where('account_id', $outing->id)->sum('credit');
            AccountTransaction::create([
                'user_id' => auth()->id(), 
                'account_code' => $outing->account_code, 
                'account_id' => $outing->id,
                'transaction_code' => session()->get('invoice_number'), 
                'date' => date('Y-m-d H:i:s', strtotime("$getDayClose->day_close $time")), 
                'description' => 'TOTAL SALES TRANSACTIONS FOR '. $getDayClose->day_close. '</br>',
                'credit' => $net_sales,
                'added_by' => auth()->user()->name
            ]);
        }

        session()->forget('invoice_number');
        return back()->with('status', 'account linked successfully');
    }



    public function AccountTransaction(Request $request)
    {   
        // session()->forget('sales_total');
        $getDayClose = \DB::table('close_days')->first();
        $all_invoice = \DB::table('invoices')
        ->selectRaw('agency as agency, sum(invoice_total_price) as invoice_total_price')
            ->groupBy('agency')
            ->where('invoice_status', 1)
            ->where('invoice_category', '!=', "TRANSPORT")
            ->whereDate('created_at', $getDayClose->day_close)
            ->get();

            // $purchases = \DB::table('purchases')
            // ->selectRaw('id as id, purchase_vendor as vendor, purchase_transaction_id as transaction, purchase_date as date, sum(purchase_total) as total_amount')
            // ->groupBy('vendor')
            // ->groupBy('transaction')
            // ->groupBy('date')
            // ->groupBy('id')
            // ->where('purchase_state', "C")
            // ->where('account_state', 0)
            // ->get();

            // $discounts = \DB::table('discounts')
            // ->whereDate('created_at', $getDayClose->day_close)
            // ->sum('amount_deducted');

            // $request->session()->get('sales_total', []);

            // $sales_total[1] = [
            //     'total_sales' => $all_invoice,
            //     'current_day' => $getDayClose->day_close,
            //     'discounts' => $discounts,
            //     'net_sales' => $all_invoice - $discounts
            // ];

            // $request->session()->put('sales_total', $sales_total);

            // return $request->session()->get('sales_total');

            $ca = \DB::table('control_accounts')->pluck('control_name');

        return view('accounting.account-transactions',
            [
                
                'payment_accounts' => \DB::table('accounts')->whereNotIn('account_name', $ca)
                ->orderBy('account_name', 'ASC')
                ->where('account_type', 'Income')
                ->get(),
                'all_invoice' => $all_invoice
            ]);
    }

    

    public function TrialBalance(Request $request)
    {
       session()->forget('balance');
       $all_accounts = \DB::table('accounts')->get();


       $value = explode(' - ', $request->date);
         
        $source1 = $value[0];
        $date1 = new \DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new \DateTime($source2);
        $to = $date2->format('Y-m-d');


        foreach ($all_accounts as $key => $account) {
        
        $id =  $account->id;

        $transactions_db = \DB::table('account_transactions')->where('account_id', $id)
        ->WhereDate('date','>=', $from)
        ->WhereDate('date','<=', $to)
        ->get();

        $credit = $transactions_db->sum('credit');
        $debit = $transactions_db->sum('debit');

        //    $ac [] =  $debit - $credit ;
           $balance = $request->session()->get('balance', []);
           $check = ['debit' => $debit, 'credit' => $credit];
           if ($check['debit'] > $check['credit']) {
               if ($check['debit'] == 0 && $check['credit']== 0) {
                  continue;
               }
            $balance[$id] = [
                    'id' => $id,
                    'particulars' => $account->account_name,
                    'debit' => $check['debit'] - $check['credit'],
                    'credit' => null
                ] ;
           }else {

            if ($check['debit'] == 0 && $check['credit']== 0) {
                continue;
             }

            $balance[$id] = [
                'id' => $id,
                'particulars' => $account->account_name,
                'debit' => null,
                'credit' => $check['credit'] - $check['debit']
            ] ;
           }

           $request->session()->put('balance', $balance);
        }

        if (empty(session()->get('balance')) || null) {
            return back()->with('status', 'Sorry, can not show report on trial balance');
        }
            // return array_filter(session()->get('balance'));
        return view('accounting.trial-balance', [
            'from' => $from,
            'to' => $to
        ]);

    }


    public function TrialBalancePrint(Request $request)
    {
        session()->forget('balance');
       $all_accounts = \DB::table('accounts')->get();


       $value = explode(' - ', $request->date);
         
        $source1 = $value[0];
        $date1 = new \DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new \DateTime($source2);
        $to = $date2->format('Y-m-d');


        foreach ($all_accounts as $key => $account) {
        
        $id =  $account->id;

        $transactions_db = \DB::table('account_transactions')->where('account_id', $id)
        ->WhereDate('date','>=', $from)
        ->WhereDate('date','<=', $to)
        ->get();

        $credit = $transactions_db->sum('credit');
        $debit = $transactions_db->sum('debit');

        //    $ac [] =  $debit - $credit ;
           $balance = $request->session()->get('balance', []);
           $check = ['debit' => $debit, 'credit' => $credit];
           if ($check['debit'] > $check['credit']) {
               if ($check['debit'] == 0 && $check['credit']== 0) {
                  continue;
               }
            $balance[$id] = [
                    'id' => $id,
                    'particulars' => $account->account_name,
                    'debit' => $check['debit'] - $check['credit'],
                    'credit' => null
                ] ;
           }else {

            if ($check['debit'] == 0 && $check['credit']== 0) {
                continue;
             }

            $balance[$id] = [
                'id' => $id,
                'particulars' => $account->account_name,
                'debit' => null,
                'credit' => $check['credit'] - $check['debit']
            ] ;
           }

           $request->session()->put('balance', $balance);
        }
        
        return view('accounting.print-trial-balance');
    }


    public function income()
    {
        return view('accounting.receive-payment', [
            'payment_methods' => \DB::table('payment_methods')->pluck('payment_name'),
            'payment_accounts' => \DB::table('accounts')->where('account_type', "CURRENT ASSETS")->get(),
            'customer' => \DB::table('customers')->get()
        ]);
    }


    public function paySupplier()
    {
        return view('accounting.pay-supplier', [
            'payment_methods' => \DB::table('payment_methods')->pluck('payment_name'),
            'payment_accounts' => \DB::table('accounts')->where('account_type', "CURRENT ASSETS")->get(),
            'vendors' => \DB::table('vendors')->get()
        ]);
    }

    public function  incomeReceive(Request $request)
    {
        $this->validate(request(), [
            'income_date' => 'required|max:300',
            'income_payment_method' => 'required|max:300',
            'income_payment_account' => 'required|max:300',
            'income_amount' => 'required|max:300',
            'income_customer' => 'required|max:300',
            'trans_number' => 'required|max:300'

        ]);

        $customer_name = explode(' - ', request('income_customer'));
        $cust_id = \DB::table('customers')->where('customer_phone', $customer_name[1])->first();

        try {
            // Perform DB Transaction
            \DB::beginTransaction();
        Income::create([
            'user_id' => auth()->id(),
            'income_date' => request('income_date'),
            'income_payment_method' => request('income_payment_method'),
            'income_payment_account' => request('income_payment_account'),
            'income_amount' => request('income_amount'),
            'income_message' => request('income_message'),
            'income_category' => request('income_category'),
            'income_customer' =>$customer_name[0] . " - " . $customer_name[0],
            'trans_number' =>  request('trans_number'),
            'income_reference' => request('income_reference')
        ]);


        CustomerStatement::create([
            'customer_id' => $cust_id->id, 
            'user_id' => auth()->id(), 
            'statement_date' => request('income_date'), 
            'statement_type' => "Payment", 
            'statement_number' => request('trans_number'), 
            'statement_due_date' => "", 
            'statement_amount_paid' => request('income_amount'), 
            'statement_total' => 0, 
            'statement_balance' => \DB::raw('statement_total - statement_amount_paid'),
            'statement_note' => request('income_message'),
            'payment_mode' => request('income_payment_method'),
            'transaction_id' => request('trans_number')
        ]);

        // CREDIT ACCOUNT
        $paying_account = \DB::table('accounts')->where('account_number', request('income_payment_account'))->first();
        if (!empty($paying_account) || null) {
            $balance_paying_account = \DB::table('account_transactions')->where('account_id', $paying_account->id)->sum('debit') - \DB::table('account_transactions')->where('account_id', $paying_account->id)->sum('credit');
            AccountTransaction::create([
                'user_id' => auth()->id(), 
                'account_code' => $paying_account->account_code, 
                'account_id' => $paying_account->id,
                'transaction_code' => request('trans_number'), 
                'date' => request('income_date'), 
                'description' => 'INCOME RECIEVED ( FROM:' . request('income_customer') . ' )<br><strong>Payment Method: </strong>' . request('income_payment_method') . '</br>' . 'CATEGORY: ' .request('income_category'),
                'note' => request('income_message'),
                'added_by' => auth()->user()->name,
                'debit' => request('income_amount'),
                'transaction_type' => 1,
            ]);
        }

        // CREDIT SALES ACCOUNT
        $sales_account = \DB::table('accounts')->where('account_number', 101)->first();
        if (!empty($paying_account) || null) {
            $balance_paying_account = \DB::table('account_transactions')->where('account_id', $sales_account->id)->sum('debit') - \DB::table('account_transactions')->where('account_id', $sales_account->id)->sum('credit');
            AccountTransaction::create([
                'user_id' => auth()->id(), 
                'account_code' => $sales_account->account_code, 
                'account_id' => $sales_account->id,
                'transaction_code' => request('trans_number'), 
                'date' => request('income_date'), 
                'description' => 'INCOME RECIEVED ( FROM:' . request('income_customer') . ' )<br><strong>Payment Method: </strong>' . request('income_payment_method') . '</br>' . 'CATEGORY: ' .request('income_category'),
                'note' => request('income_message'),
                'added_by' => auth()->user()->name,
                'credit' => request('income_amount'),
            ]);
        }
        \DB::commit();
        return back()->with('status', 'New Income Added Successfully');
            } catch (\Throwable $th) {
                \DB::rollback();
                return response([
                    'status' => 501,
                    "Message" => $th
                ]);
            }
    }


    public function destroy(Account $account)
    {
        if ($account->account_name == "Cash") {
                abort(419, "This account cannot be deleted");
            }else {
                if ($account->transactions->count() <= 0) {
                    $account->delete();
                    return back()->with('status', "Account removed successfully");
                }else{
                    $account -> account_state = 0;
                    $account -> save();
                    return back()->with('status', "Account removed successfully");
                }
        }
    }

    public function Update(Account $account)
    {
        $this->validate(request(), [
            'account_name' => 'required|max:300',
            'account_number' => 'required|max:300'
        ]);

        $sub_account = \DB::table('account_types')->where('account_type_name', request('account_type'))->first();
        $account->update([
            'user_id' => auth()->id(), 
            'account_name' => request('account_name'),
            'added_by' => auth()->user()->name,
            'account_number' => request('account_number'),
            'account_type' => request('account_type'), 
            'account_sub_type' => request('account_sub_type'), 
            'sub_account' => request('sub_account'), 
            'account_details' => request('account_details'), 
            'account_note' => request('account_note'), 
            'control_account_id' => request('control_account')
        ]);

        return back()->with('status', 'Account updated successfully');

    }



    public function linkSalesToAccount()
    {
        $time = date('H:i:s'); // current time 
        $getDayClose = \DB::table('close_days')->first();



        \DB::table('account_transactions')
        ->where('transaction_mode', request('sales_channel'))
        ->whereDate('date', $getDayClose->day_close)
        ->delete();

        CostOfSaleDump::query()->truncate();

        session()->put('invoice_number', md5(rand(12347,898634)));

    $items_cost = \DB::table('invoices')
     ->selectRaw('invoice_product_name as name,branch as branch, invoice_category as invoice_category, product_id as product_id, sum(invoice_total_price) as total, sum(invoice_quantity) as quantity, invoice_unit_price as price')
             ->where('invoice_category', '!=', "TRANSPORT")
     ->groupBy('invoice_product_name')
     ->groupBy('invoice_category')
     ->groupBy('branch')
     ->groupBy('invoice_unit_price')
     ->groupBy('product_id')
     ->whereIn('invoice_status', [1,2])
     ->where('agency', request('sales_channel'))
     ->whereDate('created_at', $getDayClose->day_close)
     ->get();

     $mTax = \DB::table('taxes')->first();
     $gTax = $mTax->covid+$mTax->nhil+$mTax->getfund+$mTax->tourism;
    
     try {
        // Perform DB Transaction
        \DB::beginTransaction();
 
      foreach ($items_cost as $key => $validateProduct) {

        $bom_cost = \DB::table('material_product_compositons')->where('product_id', $validateProduct->product_id)->get();

                    if (empty( $bom_cost )) {
                        continue;
                    }

                    foreach ($bom_cost as $key => $bom_cost) {
                        CostOfSaleDump::Insert([
                            'product_id' => $bom_cost->product_id,
                            'composition_id' => $bom_cost->composition_id,
                            'category' => $bom_cost->product_category,
                            'quantity' => $validateProduct->quantity,
                            'branch' => $validateProduct->branch,
                            'unit_cost' => $bom_cost->cost,
                            'cost' => $bom_cost->cost * $validateProduct->quantity 
                        ]);
                    }

                 $vat_exclusive = (($validateProduct->total)/(1+ ($gTax) + ($mTax->vat) + ($gTax*$mTax->vat)) );
                 $NHIL_ =  $vat_exclusive * $mTax->nhil ;
                 $COVID_ = $vat_exclusive*$mTax->covid;
                 $GETFUND_ = $vat_exclusive*$mTax->getfund;
                 $TOURISM_ = $vat_exclusive*$mTax->tourism;
                 $VAT_ = ($vat_exclusive+$NHIL_+$COVID_+ $GETFUND_+$TOURISM_) * $mTax->vat;
                 $Levies_pay = $NHIL_+$COVID_+ $GETFUND_+$TOURISM_;
                 $total_tax = $VAT_+$NHIL_+$COVID_+ $GETFUND_+$TOURISM_;
                
           
        $paying_account = \DB::table('accounts')->where('account_number',  request('transfer_to'))->first();
         if (!empty($paying_account) || null) {
             AccountTransaction::create([
                 'user_id' => auth()->id(), 
                 'account_code' => $paying_account->account_code, 
                 'account_id' => $paying_account->id,
                 'transaction_code' => session()->get('invoice_number'), 
                 'date' => date('Y-m-d H:i:s', strtotime("$getDayClose->day_close $time")), 
                 'note' => request('sales_channel') . ' - Sales Invoice - '. $validateProduct->branch,
                 'description' => $validateProduct->quantity . " Packs/Pcs of " . $validateProduct->name,
                 'debit' => $validateProduct->total,
                 'transaction_type' => 1,
                 'added_by' => auth()->user()->name,
                 'transaction_mode' => request('sales_channel')
             ]);
         }

        // CREDIT SALES ACCOUNT
        $outing = \DB::table('accounts')->where('account_name', "Sales Account" )->first();
        if (!empty($outing) || null) {
            AccountTransaction::create([
                'user_id' => auth()->id(), 
                'account_code' => $outing->account_code, 
                'account_id' => $outing->id,
                'transaction_code' => session()->get('invoice_number'), 
                'date' => date('Y-m-d H:i:s', strtotime("$getDayClose->day_close $time")), 
                'note' =>request('sales_channel') . ' - Sales Invoice - '. $validateProduct->branch,
                'description' => $validateProduct->quantity . " Packs/Pcs of " . $validateProduct->name,
                'credit' => $vat_exclusive,
                'added_by' => auth()->user()->name,
                'transaction_mode' => request('sales_channel')
            ]);
        }

        $Vat_payable = \DB::table('accounts')->where('account_name',  "VAT Payable" )->first();
        if (!empty($Vat_payable) || null) {
            AccountTransaction::create([
                'user_id' => auth()->id(), 
                'account_code' => $Vat_payable->account_code, 
                'account_id' => $Vat_payable->id,
                'transaction_code' => session()->get('invoice_number'), 
                'date' => date('Y-m-d H:i:s', strtotime("$getDayClose->day_close $time")), 
                'note' => 'Taxes - VAT of '. $mTax->vat*100 . "% -" . $validateProduct->branch,
                'description' => $validateProduct->quantity . " Packs/Pcs of " . $validateProduct->name,
                'credit' => $VAT_,
                'added_by' => auth()->user()->name,
                'transaction_mode' => request('sales_channel')
            ]);
        }

        $Levies_payable = \DB::table('accounts')->where('account_name',  "Levies Payable" )->first();
        if (!empty($Levies_payable) || null) {
            AccountTransaction::create([
                'user_id' => auth()->id(), 
                'account_code' => $Levies_payable->account_code, 
                'account_id' => $Levies_payable->id,
                'transaction_code' => session()->get('invoice_number'), 
                'date' => date('Y-m-d H:i:s', strtotime("$getDayClose->day_close $time")), 
                'note' => 'Levies - '. $validateProduct->branch,
                'description' => $validateProduct->quantity . " Packs/Pcs of " . $validateProduct->name,
                'credit' => $Levies_pay,
                'added_by' => auth()->user()->name,
                'transaction_mode' => request('sales_channel')
            ]);
        }

      }

      

      $getCategory = \DB::table('cost_of_sale_dumps')
      ->selectRaw('category as category, sum(cost) as cost')
      ->groupBy('category')
      ->get();

      foreach ($getCategory as $key => $getCategorys) {
          
      $inventory = \DB::table('accounts')->where('account_name',  "inventory" )->first();
      if (!empty($inventory) || null) {
          AccountTransaction::create([
              'user_id' => auth()->id(), 
              'account_code' => $inventory->account_code, 
              'account_id' => $inventory->id,
              'transaction_code' => session()->get('invoice_number'), 
              'date' => date('Y-m-d H:i:s', strtotime("$getDayClose->day_close $time")), 
              'note' => $getCategorys->category, 
              'description' => "Inventory - " . '<a href="#">' . "view" .'</a>',
              'credit' => $getCategorys->cost,
              'added_by' => auth()->user()->name,
              'transaction_mode' => request('sales_channel')
          ]);
      }

      $cos = \DB::table('accounts')->where('account_name',  "Cost of Sales" )->first();
      if (!empty($cos) || null) {
          AccountTransaction::create([
              'user_id' => auth()->id(), 
              'account_code' => $cos->account_code, 
              'account_id' => $cos->id,
              'transaction_code' => session()->get('invoice_number'), 
              'date' => date('Y-m-d H:i:s', strtotime("$getDayClose->day_close $time")), 
              'note' => 'Cost of Sales -' . $getCategorys->category,
              'description' => "Cost of Sales - " . '<a href="#">' . "view" .'</a>',
              'debit' => $getCategorys->cost,
              'added_by' => auth()->user()->name,
              'transaction_mode' => request('sales_channel')
          ]);
      }
    }


            // DEBIT CASH ACCOUNT
         

        session()->forget('invoice_number');
        \DB::commit();
        
        return back()->with('status', 'Sales linked to account');

            } catch (\Throwable $th) {
                \DB::rollback();
                return response([
                    'status' => 501,
                    "Message" => $th
                ]);
            }
    }


    public function VendorAccount()
    {
        $vendor = \DB::table('vendors')->get();

        $ac_payable = \DB::table('accounts')->where('account_name', "Account Payable")->first();
        if (empty($ac_payable)) {
            $account = Account::create([
                'user_id' => auth()->id(), 
                'account_name' => "Account Payable",
                'added_by' => auth()->user()->name,
                'account_code' => rand(50,200) . "-" .rand(1,100), 
                'account_number' => rand(90,500).date('Yd'),
                'account_type' => "Current Liabilities",
                'account_opening_balance' => 0, 
            ]);

            $control = \App\Models\ControlAccount::updateOrcreate(['control_name' =>$account->account_name],[
                'control_name' =>$account->account_name,
                'control_code' => $account->account_code."-".rand(1,10),
                'control_group' => "Current Liabilities",
            ]);

            $control = $control->id;
        }else {
            $ca_ = \DB::table('control_accounts')->where('control_name', "Account Payable")->first();
            $control = $ca_->id;
        }
        
        foreach ($vendor as $key => $new_vendor) {
            $ac_payable = \DB::table('accounts')->where('account_name', $new_vendor->vendor_name)->first();

            if(!empty($ac_payable)){
                continue;
            }


            $account = Account::create([
                'user_id' => auth()->id(), 
                'account_name' => $new_vendor->vendor_name,
                'added_by' => auth()->user()->name,
                'account_code' => rand(9,50) . "-" .rand(1,100), 
                'account_number' => rand(90,500).date('Yd'),
                'account_type' => "Current Liabilities", 
                'account_opening_balance' => 0, 
                'control_account_id' => $control

            ]);
        }

    }



    public function BookkeepingRe()
    {

        $dayClose = \DB::table('close_days')->first();
        $expenses_total = \DB::table('expenses')
            ->WhereDate('e_date', $dayClose->day_close)
            ->sum('e_amount');


        $discount = Discount::whereDate('created_at', $dayClose->day_close)
            ->where('is_held', 0)
            ->sum('amount_deducted');

        return view('accounting.bookkeeping-report', [
            'total_exp' => $expenses_total,
            'discount' => $discount
        ]);
    }


    
}
