<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Http\Requests\Auth\LoginRequest;
use App\Providers\RouteServiceProvider;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AuthenticatedSessionController extends Controller
{
    /**
     * Display the login view.
     *
     * @return \Illuminate\View\View
     */
    public function create()
    {
        return view('auth.login');
    }

    /**
     * Handle an incoming authentication request.
     *
     * @param  \App\Http\Requests\Auth\LoginRequest  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(LoginRequest $request)
    {
        
      $us = \DB::table('users')->where('email', request('email'))->first();
      
      if ($us !== null) {
        if ($us->role == "Sales Person" || $us->role == "Dispatch Manager" || $us->role == "Call Center" ||  $us->role == "Retention Officer") {
            return back()->with('statuspass', 'Failed to authenticate your account');
        }
      }
    

        $request->authenticate();

        $request->session()->regenerate();

        \App\Models\UserActivity::create([
            'changed_date' => \Carbon\carbon::now(),
            'user_id'=>auth()->id(),
            'event' => "Signed In!",
        ]);

        return redirect()->intended(RouteServiceProvider::HOME);
    }

    /**
     * Destroy an authenticated session.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function destroy(Request $request)
    {
        \App\Models\UserActivity::create([
            'changed_date' => \Carbon\carbon::now(),
            'user_id'=>auth()->id(),
            'event' => "Signed Out!",
        ]);
        
        Auth::guard('web')->logout();

        $request->session()->invalidate();

        $request->session()->regenerateToken();

        

        return redirect('/');
    }
}
