<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class BranchController extends Controller
{
    
    public function branchSale(Request $request)
    {   
        $this->validate(request(), [
            'branch' => 'required'
        ]);
        $getDayClose = \DB::table('close_days')->first();
        
        $branch = decrypt($request->branch);
        if (auth()->user()->role == "Sales Person" || auth()->user()->role == "Dispatch Manager") {
            abort(403, 'Unauthorized action.');  
        }else{
        $sales_today_branch = \DB::table('invoices')
        ->where('branch', $branch)
        ->where('invoice_status', 1)
        ->whereDate('created_at', $getDayClose->day_close)
        ->get();

            
        $total_cash = \DB::table('invoices')
            ->where('branch', $branch)
            ->where('invoice_status', 1)
            ->whereDate('created_at', $getDayClose->day_close)
            ->sum('invoice_total_price');

        $deliveryfee = \DB::table('dispatches')
            ->whereDate('created_at', $getDayClose->day_close)
            ->where('dispatch_branch', $branch)
            ->where('dispatch_status', 1)
            ->sum('deliveryamount');

        $rejected = \DB::table('invoices')
        ->where('invoice_status', 0)
        ->whereDate('created_at', $getDayClose->day_close)
        ->where('branch', $branch)
        ->sum('invoice_total_price');

        $onthehouse = \DB::table('invoices')
        ->where('invoice_status', 2)
        ->where('branch', $branch)
        ->whereDate('created_at', $getDayClose->day_close)
        ->sum('invoice_total_price');

        $discounts = \DB::table('discounts')
        ->whereDate('created_at', $getDayClose->day_close)
        ->where('branch', $branch)
        ->sum('amount_deducted');

        // general Sales
        $branch_total_general = $total_cash-($discounts);
        
        // On the House
        $branch_total_house = \DB::table('invoices')
        ->where('branch', $branch)
        ->where('invoice_status', 2)
        ->whereDate('created_at', $getDayClose->day_close)
        ->sum('invoice_total_price');

        $branch_total_house_list = \DB::table('invoices')
        ->where('branch', $branch)
        ->where('invoice_status', 2)
        ->whereDate('created_at', $getDayClose->day_close)
        ->get();

        // Rejected Orders
        $branch_total_reject = \DB::table('invoices')
        ->where('branch', $branch)
        ->where('invoice_status', 0)
        ->whereDate('created_at', $getDayClose->day_close)
        ->sum('invoice_total_price');

        $branch_total_reject_list = \DB::table('invoices')
        ->where('branch', $branch)
        ->where('invoice_status', 0)
        ->whereDate('created_at', $getDayClose->day_close)
        ->get();

        $ordersfromBranch = \DB::table('orders')
        ->where('branch', $branch)
        ->where('status', "!=", 5)
        ->whereDate('created_at', $getDayClose->day_close)
        ->get();

         $ordersfromBranchcost = \DB::table('invoices')
         ->where('branch', $branch)
         ->where('invoice_status', 1)
         ->whereDate('created_at', $getDayClose->day_close)
         ->sum('invoice_total_price');


        $orderDiscounted =  \DB::table('discounts')
        ->whereDate('created_at', $getDayClose->day_close)
        ->where('branch', $branch)
        ->get();


        $deliveriesToday = \DB::table('invoices')
        ->where('invoice_status', 1)
        ->where('branch', $branch)
        ->where('invoice_category', "TRANSPORT")
        ->whereDate('created_at', $getDayClose->day_close)
        ->sum('invoice_total_price');

        $discounts = \DB::table('discounts')
            ->whereDate('created_at', $getDayClose->day_close)
            ->where('branch', $branch)
            ->sum('amount_deducted');


            \App\Models\UserActivity::create([
                'changed_date' => \Carbon\carbon::now(),
                'user_id'=>auth()->id(),
                'event' => "Preview end of day for " . $branch,
            ]);


        return view('sales.view-branch-sales', [
            'sales_today_branch' => $sales_today_branch,
            'branch' => $branch,
            'branch_total_general' => $branch_total_general,
            'branch_total_house' => $branch_total_house,
            'branch_total_reject' => $branch_total_reject,
            'branch_total_reject_list' => $branch_total_reject_list,
            'branch_total_house_list' => $branch_total_house_list,
            'ordersfromBranch' => $ordersfromBranch,
            'discounted_coupon' => $orderDiscounted,
            'discounts' => $discounts,
            'orders' => $ordersfromBranchcost,
            'deliveries'=> $deliveriesToday 

        ]);
    }
    }

}
