<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Brand;

class BrandController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }



    public function index()
    {
       return view('brand', [
           'brands' => Brand::all()
       ]);
    }


    public function create()
    {
        $this->validate_request();
        $data = [
            'user_id' => auth()->user()->id,
            'brand_name' => request('brand_name'),
            'brand_description' => request('brand_description'),
        ];
        
        Brand::create($data);
        return back()->with('status', "Product Brand Saved Successfully");
    }


    public function update(Brand $brand)
    {   
       $this->validate_request();
       $brand->update([
            'brand_name' => request('brand_name'),
            'brand_description' => request('brand_description'),
       ]);
       return back()->with('status', 'Brand Updated Successfully');
    }

    public function destroy(Brand $brand_name)
    {   
       $brand_name->delete();
       return back()->with('status', 'Brand Updated Successfully');
    }



    public function validate_request()
    {
        $this->validate(request(), [
            'brand_name' => ['required']
        ]);
    }
}
