<?php

namespace App\Http\Controllers;

use App\Models\CloseDay;
use Illuminate\Http\Request;

class CloseDayController extends Controller
{
    
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        return view('day-close-status');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'station' => 'required',
            'date' => 'required'
        ]);

        $data = new CloseDay;
        $data -> user_id = auth()->user()->id;
        $data -> station = $request -> station;
        $data -> day_close = $request -> date;
        $data -> save();
        return back()->with('status', 'New Day Close assigned to a Station');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\CloseDay  $closeDay
     * @return \Illuminate\Http\Response
     */
    public function show(CloseDay $closeDay)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\CloseDay  $closeDay
     * @return \Illuminate\Http\Response
     */
    public function edit(CloseDay $closeDay)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\CloseDay  $closeDay
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, CloseDay $closeDay)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\CloseDay  $closeDay
     * @return \Illuminate\Http\Response
     */
    public function destroy(CloseDay $closeDay)
    {
        //
    }
}
