<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class CompositionRecordController extends Controller
{
    public function addCompositionToProduct($id)
    {   
        if (auth()->user()->role !== "Administrator") {
            abort(419, "unauthorized access");
        }
        $Allitems = \DB::table('items')->get();

        $p_comp = \DB::table('material_product_compositons')->where('product_id', $id)->get();
        
        // check for Product Code
        $product = \DB::table('final_productions')->where('FinalProductionID', $id)->first();

        if ($product->product_code == null) {
            $product_code = "PD-".substr(str_shuffle("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, 6) . date("hi");
        }else {
            $product_code = $product->product_code;
        }

       $estimated_cost = \DB::table('material_product_compositons')->where('product_id',$id)->pluck('cost')->sum();


        return view('add-material-product',[
            'id' => $id,
            'name' => request('item_name'),
            'p_comp' => $p_comp,
            'product_code' => $product_code,
            'products' => $product,
            'estimated_cost' => $estimated_cost,
            'Allitems' => $Allitems
        ]);
    }
}
