<?php

namespace App\Http\Controllers;

use App\Models\ControlAccount;
use Illuminate\Http\Request;

class ControlAccountController extends Controller
{

    public function __contruct()
    {
        return $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate(request(), [
            'control_name' =>'required',
            'control_group' => 'required'
        ]);
        
        ControlAccount::create([
            'control_name' =>request('control_name'),
            'control_code' => request('control_code'),
            'control_group' => request('control_group'),
        ]);

        return back()->with('status', 'Control account created succesffully');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\ControlAccount  $controlAccount
     * @return \Illuminate\Http\Response
     */
    public function show(ControlAccount $controlAccount, $id)
    {

        $bal = \DB::table('accounts')->where('account_state', 1)
        ->where('control_account_id', $id)
        ->orderBy('account_name', 'ASC')
        ->get();

        return view('accounting.list-account-control', [
            'account_type' => \App\Models\AccountType::All(),
            'accounts' => $bal,
            'funds' => \DB::table('accounts')->where('account_state', 1)
            ->orderBy('account_name', 'ASC')
            ->get(),
            'payment_methods' => \DB::table('payment_methods')->pluck('payment_name'),
            'control_acount' => ControlAccount::where('id', $id)->first(),
            'total_bal' => $bal->sum('debit') - $bal->sum('credit')
        ]);
    }

    public function CashBanking()
    {

        $control = ControlAccount::where('control_name', "Cash and Bank Account")->first();

        $bal = \DB::table('accounts')->where('account_state', 1)
            ->where('control_account_id', $control->id)
            ->orderBy('account_name', 'ASC')
            ->get();
            
        return view('accounting.list-account-control', [
            'account_type' => \App\Models\AccountType::All(),
            'accounts' => $bal,
            'funds' => \DB::table('accounts')->where('account_state', 1)
            ->orderBy('account_name', 'ASC')
            ->get(),
            'payment_methods' => \DB::table('payment_methods')->pluck('payment_name'),
            'control_acount' => ControlAccount::where('id', $control->id)->first(),
            'total_bal' => $bal->sum('debit') - $bal->sum('credit')
        ]);
    }

    public function PettyCash()
    {
        $control = ControlAccount::where('control_name', "Cash and Bank Account")->first();

        $bal = \DB::table('accounts')->where('account_state', 1)
        ->where('account_name', 'LIKE', '%' . auth()->user()->station . '%')
        ->orderBy('account_name', 'ASC')
        ->get();
            
            
        return view('accounting.list-account-control', [
            'account_type' => \App\Models\AccountType::All(),
            'accounts' => $bal,
            'funds' => \DB::table('accounts')->where('account_state', 1)
            ->where('account_name', 'LIKE', '%' . auth()->user()->station . '%')
            ->orderBy('account_name', 'ASC')
            ->get(),
            'payment_methods' => \DB::table('payment_methods')->pluck('payment_name'),
            'control_acount' => ControlAccount::where('id', $control->id)->first(),
            'total_bal' => $bal->sum('debit') - $bal->sum('credit')
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\ControlAccount  $controlAccount
     * @return \Illuminate\Http\Response
     */
    public function edit(ControlAccount $controlAccount)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\ControlAccount  $controlAccount
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, ControlAccount $controlAccount)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\ControlAccount  $controlAccount
     * @return \Illuminate\Http\Response
     */
    public function destroy(ControlAccount $controlAccount)
    {
        //
    }
}
