<?php

namespace App\Http\Controllers;

use App\Models\CostOfSaleAnalysis;
use Illuminate\Http\Request;
use DateTime;

class CostOfSaleAnalysisController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }


    public function index()
    {   
        $dayClose = \DB::table('close_days')->first();


        $cos = \DB::table('cost_of_sale_analyses')->where('date', $dayClose->day_close)->delete();
        $items_cost = \DB::table('invoices')
         ->selectRaw('invoice_product_name as name,branch as branch, invoice_category as invoice_category, product_id as product_id, sum(invoice_total_price) as total, sum(invoice_quantity) as quantity, invoice_unit_price as price')
                 ->where('invoice_category', '!=', "TRANSPORT")
         ->groupBy('invoice_product_name')
         ->groupBy('invoice_category')
         ->groupBy('branch')
         ->groupBy('invoice_unit_price')
         ->groupBy('product_id')
         ->whereIn('invoice_status', [1,2])
         ->whereDate('created_at', $dayClose->day_close)
         ->get();


        $mTax = \DB::table('taxes')->first();
        $gTax = $mTax->covid+$mTax->nhil+$mTax->getfund+$mTax->tourism;

        foreach ($items_cost as $key => $validateProduct) {
            // Records for Cost of Salels
            CostOfSaleAnalysis::create([
                'item_name' => $validateProduct->name,
                'item_id' => $validateProduct->product_id,
                'branch' => $validateProduct->branch,
                'user_id' => auth()->id(),
                'category' =>  $validateProduct->invoice_category,
                'quantity' => $validateProduct->quantity,
                'gross_amount' => $validateProduct->total,
                'net_amount' => (($validateProduct->total)/(1+ ($gTax) + ($mTax->vat) + ($gTax*$mTax->vat)) ),
                'cost' => \DB::table('material_product_compositons')->where('product_id', $validateProduct->product_id)->pluck('cost')->sum() *  $validateProduct->quantity,
                'adjusted_cost' => \DB::table('material_product_compositons')->where('product_id', $validateProduct->product_id)->pluck('adjusted_cost')->sum() *  $validateProduct->quantity,
                'date' =>  $dayClose->day_close
            ]);
        }
       
         $cos = \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")
        ->selectRaw('date as date, item_name as item_name, category as category,sum(quantity) as quantity, sum(net_amount) as net_amount, sum(gross_amount) as gross_amount, sum(cost) as cost')
        ->groupBy('item_name')
        ->groupBy('date')
        ->groupBy('category')
        ->whereDate('date', $dayClose->day_close)
        ->get();

        \App\Models\UserActivity::create([
            'changed_date' => \Carbon\carbon::now(),
            'user_id'=>auth()->id(),
            'event' => "Previewed Cost of Sales analysis",
        ]);


        return view('sales.cost-of-sales-analysis', [
            'cos' => $cos
        ]);
    }



    public function PrintSalesAnalysis(Request $request)
    {   
        $value = explode(' - ', $request->date);
         

        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        if ($from == $to) {
       
         $cos = \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")
        ->selectRaw('date as date, item_name as item_name, category as category,sum(quantity) as quantity, sum(net_amount) as net_amount, sum(gross_amount) as gross_amount, sum(cost) as cost')
        ->groupBy('item_name')
        ->groupBy('date')
        ->groupBy('category')
        ->whereDate('date', $to)
        ->get();

        if ($cos ->isEmpty()) {
            return back()->with('status',"No search Result for Date Range");
        }

            return view('sales.print-sales-analysis', [
                'cos' => $cos,
                'qty' => \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")->whereDate('date', $to)->sum('quantity'),
                'net_amount' => \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")->whereDate('date', $to)->sum('net_amount'),
                'gross_amount' => \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")->whereDate('date', $to)->sum('gross_amount'),
                'cost' => \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")->whereDate('date', $to)->sum('cost'),
            ]);
        }else {


            $cos = \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")
                ->selectRaw('item_name as item_name, category as category,sum(quantity) as quantity, sum(net_amount) as net_amount, sum(gross_amount) as gross_amount, sum(cost) as cost')
                ->groupBy('item_name')
                ->groupBy('category')
                ->WhereDate('date','>=', $from)
                ->WhereDate('date','<=', $to)
                ->get();

                if ($cos ->isEmpty()) {
                    return back()->with('status', 'No search Result for Date Range');
                }


                \App\Models\UserActivity::create([
                    'changed_date' => \Carbon\carbon::now(),
                    'user_id'=>auth()->id(),
                    'event' => "Printed cost of sales analysis",
                ]);


            return view('sales.print-sales-analysis', [
                'cos' => $cos,
                'qty' => \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")->whereBetween('date', [$from, $to])->sum('quantity'),
                'net_amount' => \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")->whereBetween('date', [$from, $to])->sum('net_amount'),
                'gross_amount' => \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")->whereBetween('date', [$from, $to])->sum('gross_amount'),
                'cost' => \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")->whereBetween('date', [$from, $to])->sum('cost'),
            ]);
        }

    }



    public function PrintSalesAnalysisBranch(Request $request)
    {   
        $value = explode(' - ', $request->date);
         

        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        if ($from == $to) {
            if ($request->type == "summary") {
                $cos = \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")
                ->selectRaw('date as date, item_name as item_name, category as category,sum(quantity) as quantity, sum(net_amount) as net_amount, sum(gross_amount) as gross_amount, sum(cost) as cost')
                ->groupBy('item_name')
                ->groupBy('date')
                ->groupBy('category')
                ->whereDate('date', $from)
                ->where('branch', $request->branch)
                ->get();


                if ($cos ->isEmpty()) {
                    return back()->with('status', 'No search Result for Date Range');
                }

                return view('sales.print-sales-analysis', [
                    'cos' => $cos,
                    'qty' => \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")->whereDate('date', $from)->where('branch', $request->branch)->sum('quantity'),
                    'net_amount' => \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")->whereDate('date', $from)->where('branch', $request->branch)->sum('net_amount'),
                    'gross_amount' => \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")->whereDate('date', $from)->where('branch', $request->branch)->sum('gross_amount'),
                    'cost' => \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")->whereDate('date', $from)->where('branch', $request->branch)->sum('cost'),
                ]);

            }elseif ($request->type == "detailed") {
                $cos = \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")
                ->where('date', $from)
                ->where('branch', $request->branch)
                ->get();

                if ($cos ->isEmpty()) {
                    return back()->with('status', 'No search Result for Date Range');
                }

                return view('sales.print-sales-analysis', [
                    'cos' => $cos,
                    'qty' => \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")->whereDate('date', $from)->where('branch', $request->branch)->sum('quantity'),
                    'net_amount' => \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")->whereDate('date', $from)->where('branch', $request->branch)->sum('net_amount'),
                    'gross_amount' => \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")->whereDate('date', $from)->where('branch', $request->branch)->sum('gross_amount'),
                    'cost' => \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")->whereDate('date', $from)->where('branch', $request->branch)->sum('cost'),
                ]);
                
            }else {
                $month = \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")
                ->selectRaw('date as date, sum(quantity) as quantity, sum(net_amount) as net_amount, sum(gross_amount) as gross_amount, sum(cost) as cost')
                ->groupBy('date')
                ->whereDate('date', $from)
                ->where('branch', $request->branch)
                ->get();

                if ($month ->isEmpty()) {
                    return back()->with('status', 'No search Result for Date Range');
                }

                 return view('sales.print-sales-analysis-aggregate', [
                    'cos' => $month,
                    'qty' => \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")->whereDate('date', $from)->where('branch', $request->branch)->sum('quantity'),
                    'net_amount' => \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")->whereDate('date', $from)->where('branch', $request->branch)->sum('net_amount'),
                    'gross_amount' => \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")->whereDate('date', $from)->where('branch', $request->branch)->sum('gross_amount'),
                    'cost' => \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")->whereDate('date', $from)->where('branch', $request->branch)->sum('cost'),
                ]);
            }
        }else {
            if ($request->type == "summary") {
                $cos = \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")
                ->selectRaw('item_name as item_name, category as category,sum(quantity) as quantity, sum(net_amount) as net_amount, sum(gross_amount) as gross_amount, sum(cost) as cost')
                ->groupBy('item_name')
                ->groupBy('category')
                ->whereBetween('date', [$from, $to])
                ->where('branch', $request->branch)
                ->get();

                if ($cos ->isEmpty()) {
                    return back()->with('status', 'No search Result for Date Range');
                }

                return view('sales.print-sales-analysis-date-range', [
                    'cos' => $cos,
                    'qty' => \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")->whereBetween('date', [$from, $to])->where('branch', $request->branch)->sum('quantity'),
                    'net_amount' => \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")->whereBetween('date', [$from, $to])->where('branch', $request->branch)->sum('net_amount'),
                    'gross_amount' => \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")->whereBetween('date', [$from, $to])->where('branch', $request->branch)->sum('gross_amount'),
                    'cost' => \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")->whereBetween('date', [$from, $to])->where('branch', $request->branch)->sum('cost'),
                ]);

            }elseif ($request->type == "detailed") {
                $cos = \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")
                ->selectRaw('date as date,invoice_number as invoice_number, item_name as item_name, category as category,sum(quantity) as quantity, sum(net_amount) as net_amount, sum(gross_amount) as gross_amount, sum(cost) as cost')
                ->groupBy('item_name')
                ->groupBy('date')
                ->groupBy('category')
                ->groupBy('invoice_number')
                ->whereBetween('date', [$from, $to])
                ->where('branch', $request->branch)
                ->get();

                if ($cos ->isEmpty()) {
                    return back()->with('status', 'No search Result for Date Range');
                }

                return view('sales.print-sales-analysis', [
                    'cos' => $cos,
                    'qty' => \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")->whereBetween('date', [$from, $to])->where('branch', $request->branch)->sum('quantity'),
                    'net_amount' => \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")->whereBetween('date', [$from, $to])->where('branch', $request->branch)->sum('net_amount'),
                    'gross_amount' => \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")->whereBetween('date', [$from, $to])->where('branch', $request->branch)->sum('gross_amount'),
                    'cost' => \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")->whereBetween('date', [$from, $to])->where('branch', $request->branch)->sum('cost'),
                ]);
            }else {
                $month = \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")
                ->selectRaw('date as date, sum(quantity) as quantity, sum(net_amount) as net_amount, sum(gross_amount) as gross_amount, sum(cost) as cost')
                ->groupBy('date')
                ->whereBetween('date', [$from, $to])  
                ->where('branch', $request->branch)
                ->get();

                if ($month ->isEmpty()) {
                    return back()->with('status', 'No search Result for Date Range');
                }

                \App\Models\UserActivity::create([
                    'changed_date' => \Carbon\carbon::now(),
                    'user_id'=>auth()->id(),
                    'event' => "viewed cost of sales for " . $request->branch,
                ]);

                return view('sales.print-sales-analysis-aggregate', [
                    'cos' => $month,
                    'qty' => \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")->whereBetween('date', [$from, $to])->where('branch', $request->branch)->sum('quantity'),
                    'net_amount' => \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")->whereBetween('date', [$from, $to])->where('branch', $request->branch)->sum('net_amount'),
                    'gross_amount' => \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")->whereBetween('date', [$from, $to])->where('branch', $request->branch)->sum('gross_amount'),
                    'cost' => \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")->whereBetween('date', [$from, $to])->where('branch', $request->branch)->sum('cost'),
                ]);
            }
        }


    }



    public function costOfSalesAnalysis(Request $request)
    {
        $value = explode(' - ', $request->date);
         

        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        if ($from == $to) {
            
            $cos = \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")
                ->selectRaw('date as date, item_name as item_name, category as category,sum(quantity) as quantity, sum(net_amount) as net_amount, sum(gross_amount) as gross_amount, sum(cost) as cost')
                ->groupBy('item_name')
                ->groupBy('date')
                ->groupBy('category')
                ->whereDate('date', $from)
                ->get();
        }else {
            $cos = \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")
                ->selectRaw('item_name as item_name, category as category,sum(quantity) as quantity, sum(net_amount) as net_amount, sum(gross_amount) as gross_amount, sum(cost) as cost')
                ->groupBy('item_name')
                ->groupBy('category')
                ->WhereDate('date','>=', $from)
                ->WhereDate('date','<=', $to)
                ->get();
        }

        \App\Models\UserActivity::create([
            'changed_date' => \Carbon\carbon::now(),
            'user_id'=>auth()->id(),
            'event' => "viewed cost of sales",
        ]);


        return view('sales.cost-of-sales-analysis', [
            'cos' => $cos,
            'from' =>$from,
            'to' => $to
        ]);
    }



    public function costOfSalesAnalysisDetailed(Request $request)
    {
        $dayClose = \DB::table('close_days')->first();
       
         $cos = \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")
                ->where('date', $dayClose->day_close)
                ->get();


                \App\Models\UserActivity::create([
                    'changed_date' => \Carbon\carbon::now(),
                    'user_id'=>auth()->id(),
                    'event' => "viewed detailed cost of sales",
                ]);

        return view('sales.cost-of-sales-analysis-detailed', [
            'cos' => $cos
        ]);
    }



    public function costOfSalesAnalysisDetailedSort(Request $request)
    {
        $value = explode(' - ', $request->date);
         

        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        if ($from == $to) {
            $cos = \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")
            ->where('date', $from)
            ->get();
        }else {
            $cos = \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")
            ->WhereDate('date','>=', $from)
            ->WhereDate('date','<=', $to)
            ->get();
        }

        return view('sales.cost-of-sales-analysis-detailed', [
            'cos' => $cos
        ]);
    }

    public function costOfSalesAnalysisDetailedSortBranchOfficer(Request $request)
    {

        $saleliite = \DB::table('kitchens')->where('kitchen_name', $request->station)->first();

        if ($saleliite==null) {
            return back()->with('status', "Your Station Isn't assisgned to a Branch, Kindly Contact Administrator");
        }else {
            $branch = \DB::table('branches')->where('branch_code', $saleliite->kitchen_code)->first();
        }


        $value = explode(' - ', $request->date);
         

        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        if ($from == $to) {
            if ($request->type == "summary") {
                $cos = \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")
                ->selectRaw('date as date, item_name as item_name, category as category,sum(quantity) as quantity, sum(net_amount) as net_amount, sum(gross_amount) as gross_amount, sum(cost) as cost')
                ->groupBy('item_name')
                ->groupBy('date')
                ->groupBy('category')
                ->whereDate('date', $from)
                ->where('branch', $branch->branch_name)
                ->get();
            }elseif ($request->type == "detailed") {
                $cos = \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")
                ->where('date', $from)
                ->where('branch', $branch->branch_name)
                ->get();
            }else {
                $month = \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")
                ->selectRaw('date as date, sum(quantity) as quantity, sum(net_amount) as net_amount, sum(gross_amount) as gross_amount, sum(cost) as cost')
                ->groupBy('date')
                ->whereDate('date', $from)
                ->where('branch', $branch->branch_name)
                ->get();

                return view('sales.cost-of-sales-analysis-month-satellite', [
                    'cos' => $month,
                    'branch' => $branch->branch_name
                ]);
            }
        }else {
            if ($request->type == "summary") {
             $cos = \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")
                ->selectRaw('item_name as item_name, category as category,sum(quantity) as quantity, sum(net_amount) as net_amount, sum(gross_amount) as gross_amount, sum(cost) as cost')
                ->groupBy('item_name')
                ->groupBy('category')
                ->WhereDate('date','>=', $from)
                ->WhereDate('date','<=', $to)
                ->where('branch', $branch->branch_name)
                ->get();

                return view('sales.cost-of-sales-analysis-date-range-satellite', [
                    'cos' => $cos,
                    'branch' => $branch->branch_name
                ]);
            }elseif ($request->type == "detailed") {
                $cos = \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")
                ->selectRaw('date as date,invoice_number as invoice_number, item_name as item_name, category as category,sum(quantity) as quantity, sum(net_amount) as net_amount, sum(gross_amount) as gross_amount, sum(cost) as cost')
                ->groupBy('item_name')
                ->groupBy('date')
                ->groupBy('category')
                ->groupBy('invoice_number')
                ->WhereDate('date','>=', $from)
                ->WhereDate('date','<=', $to)
                ->where('branch', $branch->branch_name)
                ->get();
            }else {
                $month = \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")
                ->selectRaw('date as date, sum(quantity) as quantity, sum(net_amount) as net_amount, sum(gross_amount) as gross_amount, sum(cost) as cost')
                ->groupBy('date')
                ->WhereDate('date','>=', $from)
                ->WhereDate('date','<=', $to)
                ->where('branch', $branch->branch_name)
                ->get();

                \App\Models\UserActivity::create([
                    'changed_date' => \Carbon\carbon::now(),
                    'user_id'=>auth()->id(),
                    'event' => "viewed cost of sales for " . $request->branch,
                ]);

                return view('sales.cost-of-sales-analysis-month-satellite', [
                    'cos' => $month,
                    'branch' => $branch->branch_name
                ]);
            }
        }


        return view('sales.cost-of-sales-analysis-satellite', [
            'cos' => $cos,
            'branch' => $branch->branch_name
        ]);
    }



    public function AdjsutCostOfSales()
    {

    $cos = \DB::table('cost_of_sale_analyses')->where('date', request('date'))->delete();
    $items_cost = \DB::table('invoices')
     ->selectRaw('invoice_product_name as name,branch as branch, invoice_category as invoice_category, product_id as product_id, sum(invoice_total_price) as total, sum(invoice_quantity) as quantity, invoice_unit_price as price')
             ->where('invoice_category', '!=', "TRANSPORT")
     ->groupBy('invoice_product_name')
     ->groupBy('invoice_category')
     ->groupBy('branch')
     ->groupBy('invoice_unit_price')
     ->groupBy('product_id')
     ->where('invoice_status', '!=', 0)
     ->whereDate('created_at', request('date'))
     ->get();

    $mTax = \DB::table('taxes')->first();
    $gTax = $mTax->covid+$mTax->nhil+$mTax->getfund+$mTax->tourism;

     foreach ($items_cost as $key => $validateProduct) {
          // Records for Cost of Salels
          CostOfSaleAnalysis::create([
             'item_name' => $validateProduct->name,
             'item_id' => $validateProduct->product_id,
             'branch' => $validateProduct->branch,
             'user_id' => auth()->id(),
             'category' =>  $validateProduct->invoice_category,
             'quantity' => $validateProduct->quantity,
             'gross_amount' => $validateProduct->total,
             'net_amount' => (($validateProduct->total)/(1+ ($gTax) + ($mTax->vat) + ($gTax*$mTax->vat)) ),
             'cost' => \DB::table('material_product_compositons')->where('product_id', $validateProduct->product_id)->pluck('cost')->sum() *  $validateProduct->quantity,
             'adjusted_cost' => \DB::table('material_product_compositons')->where('product_id', $validateProduct->product_id)->pluck('adjusted_cost')->sum() *  $validateProduct->quantity,
             'date' => request('date')
         ]);
     }

     \App\Models\UserActivity::create([
        'changed_date' => \Carbon\carbon::now(),
        'user_id'=>auth()->id(),
        'event' => "Adjusted cost of sales analysis",
    ]);

     return back()->with('status', "cost of sales adjusted successfully");

    }

    public function costOfSalesAnalysisDetailedSortBranch(Request $request)
    {
        
        $value = explode(' - ', $request->date);
         

        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        if ($from == $to) {
            if ($request->type == "summary") {
                $cos = \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")
                ->selectRaw('date as date, item_name as item_name, category as category,sum(quantity) as quantity, sum(net_amount) as net_amount, sum(gross_amount) as gross_amount, sum(cost) as cost')
                ->groupBy('item_name')
                ->groupBy('date')
                ->groupBy('category')
                ->whereDate('date', $from)
                ->where('branch', $request->branch)
                ->get();
            }elseif ($request->type == "detailed") {
                $cos = \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")
                ->where('date', $from)
                ->where('branch', $request->branch)
                ->get();
            }else {
                $month = \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")
                ->selectRaw('date as date, sum(quantity) as quantity, sum(net_amount) as net_amount, sum(gross_amount) as gross_amount, sum(cost) as cost')
                ->groupBy('date')
                ->whereDate('date', $from)
                ->where('branch', $request->branch)
                ->get();

                return view('sales.cost-of-sales-analysis-month', [
                    'cos' => $month
                ]);
            }
        }else {
            if ($request->type == "summary") {
             $cos = \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")
                ->selectRaw('item_name as item_name, category as category,sum(quantity) as quantity, sum(net_amount) as net_amount, sum(gross_amount) as gross_amount, sum(cost) as cost')
                ->groupBy('item_name')
                ->groupBy('category')
                ->WhereDate('date','>=', $from)
                ->WhereDate('date','<=', $to)
                ->where('branch', $request->branch)
                ->get();

                return view('sales.cost-of-sales-analysis-date-range', [
                    'cos' => $cos
                ]);
            }elseif ($request->type == "detailed") {
                 $cos = \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")
                ->selectRaw('date as date, item_name as item_name, category as category, sum(quantity) as quantity, sum(net_amount) as net_amount, sum(gross_amount) as gross_amount, sum(cost) as cost')
                ->groupBy('item_name')
                ->groupBy('date')
                ->groupBy('category')
                ->WhereDate('date','>=', $from)
                ->WhereDate('date','<=', $to)
                ->where('branch', $request->branch)
                ->get();
            }else {
                $month = \DB::table('cost_of_sale_analyses')->where('category', '!=', "TRANSPORT")
                ->selectRaw('date as date, sum(quantity) as quantity, sum(net_amount) as net_amount, sum(gross_amount) as gross_amount, sum(cost) as cost')
                ->groupBy('date')
                ->WhereDate('date','>=', $from)
                ->WhereDate('date','<=', $to)
                ->where('branch', $request->branch)
                ->get();

                return view('sales.cost-of-sales-analysis-month', [
                    'cos' => $month
                ]);
            }
        }


        \App\Models\UserActivity::create([
            'changed_date' => \Carbon\carbon::now(),
            'user_id'=>auth()->id(),
            'event' => "viewed cost of sales analysis",
        ]);


        return view('sales.cost-of-sales-analysis', [
            'cos' => $cos
        ]);
    }


}
