<?php

namespace App\Http\Controllers;

use App\Models\Customer;
use Illuminate\Http\Request;
use App\Models\Invoice;
use App\Models\LoyaltyPoint;
use App\Models\InvoiceDump;
use Carbon\carbon;
use DateTime;
use Illuminate\Support\Facades\Cache;
use App\Models\CustomerStatement;


class CustomerController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(Customer $customer_id)
    {   

        $top_customers = \DB::table('orders')
        ->where('customer_id', $customer_id->id)
        ->pluck('order_id');

        $transactions = \DB::table('invoices')
        ->whereIn('invoice_number', $top_customers)
        ->Where('invoice_status', 1)
        ->get();

        return view('accounting.print-customer-statement', [
            'customer_statement' => $customer_id,
            'transactions' => $transactions
        ]);
        
    }

    public function customerReportDate(Request $request)
    {
        $value = explode(' - ', $request->date);
         
        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        if ($from == $to) {
            if (auth()->user()->role == "Administrator") {
                $customer_data = \DB::table('customers')
                    ->whereDate('created_at', $from)
                    ->orWhereDate('updated_at', $from)
                    ->get();
            }else {
                $customer_data = \DB::table('customers')
                    ->whereDate('created_at', $from)
                    ->orWhereDate('updated_at', $from)
                    ->where('customer_branch', auth()->user()->branch)
                    ->get();
            }
        }else{
           if (auth()->user()->role == "Administrator") {
            $customer_data = \DB::table('customers')
                ->whereBetween('created_at', [$from, $to])
                ->whereBetween('updated_at', [$from, $to])
                ->get();
           }else {
            $customer_data = \DB::table('customers')
                ->whereBetween('created_at', [$from, $to])
                ->whereBetween('updated_at', [$from, $to])
                ->where('customer_branch', auth()->user()->branch)
                ->get();
           }
        }

        return view('customer.customer-transactions-today', [
            'customer_data' => $customer_data
        ]);
    }


    public function transactionsDetails($id)
    {
        $id = decrypt($id);
        
        $orders = \DB::table('orders')
            ->where('customer_id', $id)
            ->paginate(100);

        $invoices = \DB::table('invoices')
        ->where('customer_id', $id)
        ->where('invoice_status', 1)
        ->where('invoice_category', '!=', "TRANSPORT")
        ->paginate(100);


        $remarks = \DB::table('remarks')
                ->where('customer_id', $id)
                ->get();

        $ordersRevenue = \DB::table('invoices')
        ->where('customer_id', $id)
        ->where('invoice_status', 1)
        ->where('invoice_category', '!=', "TRANSPORT")
        ->sum('invoice_total_price');

        $customer = Customer::findOrfail($id);

        return view('customer.customer-orders', [
            'invoices' => $invoices,
            'ordering' => $orders,
            'customer' => $customer,
            'ordercount' =>  $orders->count(),
            'invoicecount' =>  $invoices->count(),
            'ordersRevenue' => $ordersRevenue,
            'remarking' => $remarks
        ]);
    }

    

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function newSale()
    {   
         // load Products
         if (empty(Cache::get('products'))) {
            Cache::put('products', \DB::table('final_productions')
            ->where('store_category', 0)
            ->get());
        }

       
            return view('accounting.new-sale', [
                'products' => Cache::get('products')
            ]);

        
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {   
        $this->validate($request, [
            'customer_name'=> ['required', 'string', 'max:255'],
            'customer_phone'=> ['required', 'string', 'min:10'],
        ]);

       
            $customer = Customer::updateOrCreate(
                [ 'customer_phone' => $request->customer_phone ],
                     [ 'customer_name' => $request->customer_name,
                    'customer_address' => $request->customer_address,
                    'customer_date' => $request->customer_date,
                    'customer_enteredby' => auth()->user()->name,
                    'customer_branch' =>  auth()->user()->branch,
                    'customer_note' =>  $request->customer_note,
                    'customer_code' => $request->customer_name . "-". rand(100,50000)
                ]);

            return back()->with('status','New Customer Added Suucessfully');
      

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Customer  $customer
     * @return \Illuminate\Http\Response
     */
    public function show(Customer $customer)
    {
        return view('customer-statement', [
            'customers' => \DB::table('customers')->paginate('200')
        ]);
    }



    public function showCustomer()
    {    
        if (auth()->user()->role == "Retention Officer") {
           $customer = \DB::table('customers')
           ->where('customer_name', '!=', "WALK-IN CUSTOMER")
           ->where('customer_branch', auth()->user()->branch) -> paginate(100);
        }else {
            $customer = \DB::table('customers')
            ->where('customer_name', '!=', "WALK-IN CUSTOMER")
            ->paginate(100);
        }
        return view('customer.customer-list', [
            'customers' => $customer
        ]);
    }


    public function showNewAndTransactions()
    {   
        if (auth()->user()->role == "Administrator") {
            $customer_data = \DB::table('customers')
                ->whereDate('created_at', Carbon::today())
                ->orWhereDate('updated_at', Carbon::today())
                ->get();
        }elseif (auth()->user()->role == "Retention Officer") {
            $customer_data = \DB::table('customers')
                ->whereDate('created_at', Carbon::today())
                ->orWhereDate('updated_at', Carbon::today())
                ->where('customer_branch', auth()->user()->branch)
                ->get();
        }else {
            $customer_data = \DB::table('customers')
                ->whereDate('created_at', Carbon::today())
                ->orWhereDate('updated_at', Carbon::today())
                ->get();
        }
       
        return view('customer.customer-transactions-today', [
            'customer_data' => $customer_data
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Customer  $customer
     * @return \Illuminate\Http\Response
     */
    public function edit(Customer $customer)
    {
        //
    }

    

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Customer  $customer
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Customer $customer)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Customer  $customer
     * @return \Illuminate\Http\Response
     */
    public function destroy(Customer $customer)
    {
        //
    }
}
