<?php

namespace App\Http\Controllers;

use App\Models\DispatchItem;
use App\Models\FinalProduction;
use Illuminate\Http\Request;

class DispatchItemController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function __construct()
    {
        return $this->middleware('auth');
    }

    public function index()
    {   
        if (auth()->user()->role == "Sales Person") {
            abort(403,"UNAUTHORIZED");
        }
        $dispatch_details = \DB::table('dispatch_items')->get();
        return view('dispatch.dispatch-item', [
           'dispatch_details' => $dispatch_details
        ]);
    }

   
    public function store(Request $request)
    {   
        $item = new DispatchItem;
        $item -> user_id = auth()->user()->id;
        $item -> location_name = $request->location_name;
        $item-> location_price = $request->location_price;
        $item-> location_branch = $request->location_branch;
        $item-> category = "Transport";
        $item -> save();
    
        return 123;

    }



    public function loadLocations(Request $request)
    {
        $this->validate($request,[
            'file' => 'required'
          ]);

           $upload = $request->file('file');
           $filePath = $upload->getRealPath();

           $file = fopen($filePath, 'r');

           $header = fgetcsv($file);

           $escapedHeader=[];

           // data validation
           
           foreach ($header as $key => $value) {
             $escapedItem = strtolower($value) ;
             array_push($escapedHeader, $escapedItem);

           }

           //looping through colums to get data

           while ($columns=fgetcsv($file)) {
             
             if ($columns[0] =="") {
              continue;
             }
	
	   try{
           //trim data
           foreach ($columns as $key => &$value) {
             $value = ucwords($value);
           }
           
	   $data = array_combine($escapedHeader, $columns);
           
            $location_name = $data['location_name'];
            $location_branch= $data['location_branch'];
            $location_price = $data['location_price'];
            $category = $data['category'];
            

            $appdata = new DispatchItem;
            $appdata -> user_id = 109;
            $appdata -> location_name = $location_name;
            $appdata -> location_branch = $location_branch;
            $appdata -> location_price = $location_price;
            $appdata -> category = $category;
            $appdata -> save();
            
            }catch(\Exception $ex){
            	return back()->with('status','something is wrong, kindly download the csv file ' . '<a href="/uploads/dispatch_items.csv">Here</a>' . ' as a guide'. $ex);
            	}

        }
        return back()->with('status', 'File Data Loaded Successfully');
 
    
    }


    public function DeleteDispatchItem()
    {      
        $this->validate(request(), [
            'dispatchitem' => 'required'
        ]);
       \DB::table('dispatch_items')->whereIn('id', request('dispatchitem'))->delete();
       return back()->with('status', 'Selected Items Deleted Successfully');
    }



    public function deliveryPricing()
    {   
        $dispatch_details = \DB::table('dispatch_items')->get();
        return view('dispatch.delivery-prices', [
            'dispatch_details' => $dispatch_details
        ]);
    }


    public function updateDispatch(DispatchItem $dispatachtem, Request $request)
    {
        $dispatachtem -> user_id = auth()->user()->id;
        $dispatachtem -> location_name = $request->location_name;
        $dispatachtem -> location_price = $request->location_price;
        $dispatachtem -> location_branch = $request->location_branch;
        $dispatachtem -> category = "Transport";
        $dispatachtem -> save();

        return back()->with('status', "Delivery Price Updated Successfully");
    }


    public function destroy($dispatchItem)
    {   

        $removeItem = DispatchItem::findOrfail($dispatchItem);
        $removeItem->delete();
        return 123;
    }
}
