<?php

namespace App\Http\Controllers;

use App\Models\Expense;
use Illuminate\Http\Request;
use App\Models\ExpenseType;
use App\Models\AccountTransaction;
use DateTime;

class ExpenseController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        $dayClose = \DB::table('close_days')->first();

        if (auth()->user()->role == "Administrator") {
            $expenses = \DB::table('expenses')->where('e_date', $dayClose->day_close)->get();
        }else {
            $expenses = \DB::table('expenses')->where('e_date', $dayClose->day_close)->where('station', auth()->user()->station)->get();
        }
        if (auth()->user()->role == "Administrator") {
            $accounts =\DB::table('accounts')->get();
        }else {
            $accounts =\DB::table('accounts')->where('account_name','LIKE', '%' . auth()->user()->station .'%')->get();
        }
        // Expenses Type Here means Expenses Category
        return view('expenses', [
            'e_type' => \DB::table('expense_types')->get(),
            'expenses_list' => $expenses,
            'payment_accounts' => $accounts,
            'expenses' => \DB::table('accounts')->where('account_type', 'Expenses')->get(),
            'payment_methods' => \DB::table('payment_methods')->pluck('payment_name'),
            'expense_category' => \DB::table('expense_types')->get(),
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        $this->validate(request(), [
            'e_name' => 'required|max:300',
            'e_paid_to' => 'required|max:300',
            'e_type' => 'required|max:300',
            'e_amount' => 'required|max:300',
        ]);

        if($file = $request->hasFile('image')) {
            $request->session()->put('file_rename', rand(100,1300));
            $file = $request->file('image') ;
            $fileName = session()->get('file_rename').$file->getClientOriginalName() ;
            $destinationPath = 'uploads/' ;
            $file->move($destinationPath,$fileName);
            $document = ''.$fileName ;
         }else {
             $document = null;
         }
         try {
            // Perform DB Transaction
            \DB::beginTransaction();

            $paying_account = \DB::table('accounts')->where('account_number', request('payment_account'))->first();
            $expenses_account = \DB::table('accounts')->where('account_number', request('e_type'))->first();
        Expense::Create( [
            'e_name' => request('e_name'),
            'user_id' => auth()->id(), 
            'e_paid_to' => request('e_paid_to'),
            'e_type' =>  $expenses_account->account_name,
            'expenses_category'  => request('expenses_category'),
            'e_reference' => request('e_reference'), 
            'e_amount' => request('e_amount'),
            'e_payment' => request('e_payment'),
            'payment_account' => $paying_account->account_name,
            'e_date' => request('e_date'),
            'e_document' => $document,
            'e_note' => request('e_note'),
        ]);

        // GENERATE TRANSCTION CODE
        $trans_code = "EXP".rand(90,500).date('Yd');

        // CREDIT ACCOUNT
        $paying_account = \DB::table('accounts')->where('account_number', request('payment_account'))->first();
        if (!empty($paying_account) || null) {
            $ac = AccountTransaction::create([
                'station' => auth()->user()->station,
                'user_id' => auth()->id(), 
                'account_code' => $paying_account->account_code, 
                'account_id' => $paying_account->id,
                'transaction_code' => $trans_code, 
                'date' => request('e_date') . "T" . date('H:i'),
                'description' => 'Expenses [ <strong>' . $expenses_account->account_name  . '</strong> ]<br>Payment Method: ' . request('e_payment'), 
                'note' => request('e_note'). ' - ' .  request('expenses_category'),
                'added_by' => auth()->user()->name,
                'credit' => request('e_amount'),
                'transaction_type' => 0,
            ]);
        }

        $purchases = \DB::table('accounts')->where('account_number', request('e_type'))->first();
        if (!empty($purchases) || null) {
            AccountTransaction::create([
                'user_id' => auth()->id(), 
                'station' => auth()->user()->station,
                'account_code' => $purchases->account_code, 
                'account_id' => $purchases->id,
                'transaction_code' => $trans_code, 
                'date' => request('e_date') . "T" . date('H:i'), 
                'description' => 'Petty Cash[ ' . $paying_account->account_name . ' ]<br>Payment Method: ' . request('e_payment'),
                'note' => request('e_note') . ' - ' .  request('expenses_category'),
                'added_by' => auth()->user()->name,
                'debit' => request('e_amount'),
            ]);
        }
        

        \DB::commit();
        return back()->with('status', "Bill created successfully");
        } catch (\Throwable $th) {
            \DB::rollback();
            return response([
                'status' => 501,
                "Message" => $th
            ]);
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }


    public function ExpenseType()
    {
        $this->validate(request(), [
            'expense_type_name' => 'required'
        ]);

        ExpenseType::create([
            'user_id' => auth()->id(),
            'expense_type_name' => request('expense_type_name'),
            'expense_type_description' => request('expense_type_name')
        ]);

        return back()->with('status', "New bill added successfully");
    }
 

    public function ExpenseTypeRemove(ExpenseType $ExpenseType)
    {
        $ExpenseType->delete();
        return response([
            'status'=> 1000,
            'message' => "Deleted Successfully"
        ]);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Expense  $expense
     * @return \Illuminate\Http\Response
     */
    public function show(Expense $expense)
    {
        $dayClose = \DB::table('close_days')->first();

        if (auth()->user()->role == "Administrator") {
            $expenses = \DB::table('expenses')
                ->whereDate('e_date', $dayClose->day_close)
                ->get();
        }else {
            $expenses = \DB::table('expenses')
                ->where('e_name', auth()->user()->station)
                ->whereDate('e_date', $dayClose->day_close)
                ->get();
        }

        return view('expenses-report', [
            'expenses_today' => $expenses
        ]);
    }



    public function ExpensesReportDate(Request $request)
    {
        $this->validate(request(), [
            'start_date' => 'required',
            'end_date' => 'required'
        ]);

        $from = request('start_date');
        $to = request('end_date');

        if (auth()->user()->role == "Administrator") {
            $expenses_today = \DB::table('expenses')
                ->WhereDate('e_date','>=', $from)
                ->WhereDate('e_date','<=', $to)
                ->get();
        }else {
            $expenses_today = \DB::table('expenses')
                ->where('e_name', auth()->user()->station)
                ->WhereDate('e_date','>=', $from)
                ->WhereDate('e_date','<=', $to)
                ->get();
        }

        return view('expenses-report', [
            'expenses_today' => $expenses_today 
        ]);
    }

    public function PrintExpenses()
    {
        $this->validate(request(), [
            'start_date' => 'required',
            'end_date' => 'required'
        ]);

        if (auth()->user()->role == "Administrator") {
            $expenses_today = \DB::table('expenses')
                ->WhereDate('e_date','>=', request('start_date'))
                ->WhereDate('e_date','<=', request('end_date'))
                ->get();

            $total = $expenses_today->sum('e_amount');

        }else {
            $expenses_today = \DB::table('expenses')
                ->where('e_name', auth()->user()->station)
                ->WhereDate('e_date','>=', request('start_date'))
                ->WhereDate('e_date','<=', request('end_date'))
                ->get();

            $total = $expenses_today->sum('e_amount');
                
        }

        return view('expenses-report-print', [
            'expenses_today' => $expenses_today,
            'total' => $total

        ]);

    }


    public function ExpensesReportMain(Request $request)
    {
        $this->validate(request(), [
            'start_date' => 'required',
            'end_date' => 'required'
        ]);

        $from = request('start_date');
        $to = request('end_date');

        if (request('branch') == "All Stations") {
            $expenses_today = \DB::table('expenses')
                ->WhereDate('e_date','>=', $from)
                ->WhereDate('e_date','<=', $to)
                ->get();

        }else {

            $expenses_today = \DB::table('expenses')
                ->where('e_name', request('branch'))
                ->WhereDate('e_date','>=', $from)
                ->WhereDate('e_date','<=', $to)
                ->get();
        }

        return view('expenses-report', [
            'expenses_today' => $expenses_today 
        ]);
    }


    public function PrintExpensesMain()
    {
        $this->validate(request(), [
            'start_date' => 'required',
            'end_date' => 'required'
        ]);

        $from = request('start_date');
        $to = request('end_date');

        if (request('branch') == "All Stations") {
            $expenses_today = \DB::table('expenses')
                ->WhereDate('e_date','>=', $from)
                ->WhereDate('e_date','<=', $to)
                ->get();

            $total = $expenses_today->sum('e_amount');

        }else {

            $expenses_today = \DB::table('expenses')
                ->where('e_name', request('branch'))
                ->WhereDate('e_date','>=', $from)
                ->WhereDate('e_date','<=', $to)
                ->get();

                $total = $expenses_today->sum('e_amount');
        }

        return view('expenses-report-print', [
            'expenses_today' => $expenses_today,
            'total' => $total

        ]);

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Expense  $expense
     * @return \Illuminate\Http\Response
     */
    public function edit(Expense $expense)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Expense  $expense
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Expense $expense)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Expense  $expense
     * @return \Illuminate\Http\Response
     */
    public function destroy(Expense $expense)
    {
        //
    }
}
