<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Branch;
use App\Models\Order;
use App\Models\Invoice;
use App\Models\FinalProduction;
use Carbon\carbon;
use DateTime;
use App\Models\HeldTransaction;

class GeneralController extends Controller
{


    public function index()
    {
        return view('branch', [
            'brancheslet' => \DB::table('branches')->get()
        ]);
    }


    public function destroy(Branch $branch)
    {
        $branch->delete();
        return 123;
    }


    public function edit(Branch $branch)
    {   
        // $this->authorize('viewAny' , Branch::class);

        return view('edit-branch', [
            'branching' => $branch,
            'branchesN' => Branch::all()
        ]);
    }



    public function SearchProduct() {
        $search = request('query');

        if($search == ""){
            $pd = FinalProduction::OrderBy('FinalProductionID', 'ASC')
            ->limit(10)
            ->get(['Name', 'FinalProductionID', 'description']);
        }else{
            $pd = FinalProduction::OrderBy('FinalProductionID', 'ASC')
            ->where('Name', 'LIKE', '%' . $search . '%' )
            ->where('barcode', 'LIKE', '%' . $search . '%' )
            ->limit(10)
            ->get(['Name','FinalProductionID', 'description']);
        }

        return view('search-page', [
            'product_search' => $pd
        ]);
    }


    public function update(Request $request, Branch $branch)
    {   
        $app = \DB::table('settings')->first();
        if($file = $request->hasFile('image')) {
            $file = $request->file('image') ;
            $fileName = $file->getClientOriginalName() ;
            $destinationPath = 'uploads/' ;
            $file->move($destinationPath,$fileName);
            $branch -> branch_image = ''.$fileName ;
         }

        $branch->branch_name = $request->branch_name;
        $branch->branch_location = $request->branch_location;
        $branch->branch_contact = $request->branch_contact;
        $branch->branch_code = $request->branch_code;
        $branch->branch_momo = $request->branch_momo;
        $branch->store_type = empty($request->store_type) ? 0 : 1;
        $branch->tin_number = !empty($app->app_tin) ? $app->app_tin : "";
        $branch->save();
        return back()->with('status', 'Branch profile updated Successfully');
    }


    public function PrintLite(Request $request, $inv , $id)
    {   
        
        $salesperson = Order::where('order_id', $inv)->first();
        if (empty($salesperson) || null) {
            abort(419, "Unauthorized Access");
        }
        
        $name = $salesperson->user->name;
        $branch = $salesperson->user->branch;
        $role = $salesperson->user->role;
        


        return view('print-lite', [
            'customer' => \DB::table('customers')->where('id', $id)->first(),
            'invoice_generate' => Invoice::where('invoice_number', $inv)->get(),
            'number' => $inv,
            'total' => Invoice::where('invoice_number', $inv)->sum('invoice_total_price'),
            'branch_details' => \DB::table('branches')->where('branch_name',$salesperson->branch)->first(),
            'discount' => \DB::table('discounts')->where('order_id', $inv)->first(),
            'sales_person_name' => $name,
            'sales_person_branch' => $branch,
            'time' => $salesperson -> created_at,
            'agency_' => Invoice::where('invoice_number', $inv)->first(),
            'amount_paid' => $salesperson,
            'user_role_' => $role,
         
        ]);
    }




    public function PrintLiteInvoice(Request $request, $inv , $id)
    {   
        
        $salesperson = Order::where('order_id', $inv)->first();
        if (empty($salesperson) || null) {
            abort(419, "Unauthorized Access");
        }
        
        $name = $salesperson->user->name;
        $branch = $salesperson->user->branch;
        $role = $salesperson->user->role;
        


        return view('print-main-invoice', [
            'customer' => \DB::table('customers')->where('id', $id)->first(),
            'invoice_generate' => Invoice::where('invoice_number', $inv)->get(),
            'number' => $inv,
            'total' => Invoice::where('invoice_number', $inv)->sum('invoice_total_price'),
            'branch_details' => \DB::table('branches')->where('branch_name',$salesperson->branch)->first(),
            'discount' => \DB::table('discounts')->where('order_id', $inv)->first(),
            'sales_person_name' => $name,
            'sales_person_branch' => $branch,
            'time' => $salesperson -> created_at,
            'agency_' => Invoice::where('invoice_number', $inv)->first(),
            'amount_paid' => $salesperson,
            'user_role_' => $role,
         
        ]);
    }


    public function clearSystemCache()
    {
        \Artisan::call('route:clear');
        \Artisan::call('cache:clear');
        \Artisan::call('config:clear');
        \Artisan::call('view:clear');
        return back()->with('status', 'All cached files removed successfully');

    }


    public function store(Request $request)
    {   
        // $this->authorize('create' , Branch::class);
        
        $this->validate($request, [
            'branch_name' => ['required', 'string', 'max:255'],
            'branch_location' => ['required', 'string', 'max:255'],
            'branch_contact' => ['required', 'string', 'max:255'],
        ]);
        $app = \DB::table('settings')->first();
        $branch = new Branch;
        if($file = $request->hasFile('image')) {
            $file = $request->file('image') ;
            $fileName = $file->getClientOriginalName() ;
            $destinationPath = 'uploads/' ;
            $file->move($destinationPath,$fileName);
            $branch-> branch_image = ''.$fileName ;
         }

        
        $branch->user_id = auth()->user()->id;
        $branch->branch_name = $request->branch_name;
        $branch->branch_location = $request->branch_location;
        $branch->branch_contact = $request->branch_contact;
        $branch->branch_code = $request->branch_code;
        $branch->branch_momo = $request->branch_momo;
        $branch->tin_number = !empty($app->app_tin) ? $app->app_tin : "";
        $branch->store_type = empty($request->store_type) ? 0 : 1;
        $branch->save();
        return back()->with('status', 'Branch Saved SUccessfully');

    }



    public function departmentSummaryBranch($branch)
    {
        // getDay close
        $getDayClose = \DB::table('close_days')->first();

        $items = \DB::table('invoices')
        ->selectRaw('invoice_category as name, sum(invoice_total_price) as total, sum(invoice_quantity) as quantity')
                ->where('branch', $branch)
        ->where('invoice_category', '!=', "TRANSPORT")
        ->groupBy('invoice_category')
        ->where('invoice_status', 1)
        ->whereDate('created_at', $getDayClose->day_close)
        ->get();


        $itemsQuantity = \DB::table('invoices')
                ->where('branch', $branch)
        ->where('invoice_category', '!=', "TRANSPORT")
        ->whereDate('created_at', $getDayClose->day_close)
        ->where('invoice_status', 1)
        ->sum('invoice_quantity');

        $itemsPrice = \DB::table('invoices')
                ->where('branch', $branch)
        ->where('invoice_category', '!=', "TRANSPORT")
        ->whereDate('created_at', $getDayClose->day_close)
        ->where('invoice_status', 1)
        ->sum('invoice_total_price');


        $dicount = \DB::table('discounts')
        ->where('branch', $branch)
        ->whereDate('created_at', $getDayClose->day_close)
        ->where('is_held', 0)
        ->sum('amount_deducted');

        return view('department-summary-branch', [
            'items' => $items,
            'itemsQuantity' => $itemsQuantity,
            'itemsPrice' => $itemsPrice,
            'branch' => $branch,
            'discount' => $dicount
        ]);
    }


    public function itemSummaryBranch($branch)
    {
        // getDay close
        $getDayClose = \DB::table('close_days')->first();

        $items = \DB::table('invoices')
        ->selectRaw('invoice_product_name as name, sum(invoice_total_price) as total, sum(invoice_quantity) as quantity, invoice_unit_price as price')
                ->where('invoice_category', '!=', "TRANSPORT")
        ->where('branch', $branch)
        ->groupBy('invoice_product_name')
        ->groupBy('invoice_unit_price')
        ->where('invoice_status', 1)
        ->whereDate('created_at', $getDayClose->day_close)
        ->get();

        $itemsQuantity = \DB::table('invoices')
                ->where('invoice_category', '!=', "TRANSPORT")
        ->whereDate('created_at', $getDayClose->day_close)
        ->where('branch', $branch)
        ->where('invoice_status', 1)
        ->sum('invoice_quantity');

        $itemsPrice = \DB::table('invoices')
                ->where('invoice_category', '!=', "TRANSPORT")
        ->whereDate('created_at', $getDayClose->day_close)
        ->where('branch', $branch)
        ->where('invoice_status', 1)
        ->sum('invoice_total_price');

        $dicount = \DB::table('discounts')
        ->where('branch', $branch)
        ->whereDate('created_at', $getDayClose->day_close)
        ->where('is_held', 0)
        ->sum('amount_deducted');

        return view('item-summary-branch', [
            'items' => $items,
            'itemsQuantity' => $itemsQuantity,
            'itemsPrice' => $itemsPrice,
            'branch' => $branch,
            'discount' => $dicount
        ]);
    }


    public function PrintSummaryBranch(Request $request)
    {
        $this->validate(request(), [
            'branch' => 'required'
        ]);

        $getDayClose = \DB::table('close_days')->first();
        
        $branch = decrypt($request->branch);

        $request->merge([
            'branch' => $branch
        ]);

        if (auth()->user()->role == "Sales Person" || auth()->user()->role == "Dispatch Manager") {
            abort(403, 'Unauthorized action.');  
        }else{

       $agency_orders = \DB::table('invoices')
        ->selectRaw('agency as agency, sum(invoice_total_price) as total')
        ->groupBy('agency')
        ->where('invoice_category', '!=', "TRANSPORT")
        ->where('branch', $branch)
        ->where('invoice_status', 1)
        ->whereDate('created_at', $getDayClose->day_close)
        ->get();

     
        }
        
        return view('sales.print-sales-summary', [
            'agency_orders'=> $agency_orders,
            
        ]);
    }


    public function PrintSummaryBranchUser(Request $request, $id) {
        $source1 = request('from');
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = request('to');
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        
        $branch = decrypt($request->branch);

        $request->merge([
            'branch' => $branch
        ]);

        if (auth()->user()->role == "Sales Person" || auth()->user()->role == "Dispatch Manager") {
            abort(403, 'Unauthorized action.');  
        }else{

       $agency_orders = \DB::table('invoices')
        ->selectRaw('agency as agency, sum(invoice_total_price) as total')
        ->groupBy('agency')
        ->where('invoice_category', '!=', "TRANSPORT")
        ->where('user_id', $id)
        ->where('invoice_status', 1)
        ->WhereDate('created_at','>=', $from)
        ->WhereDate('created_at','<=', $to)
        ->get();

     
        }
        
        return view('sales.print-sales-summary-user', [
            'agency_orders'=> $agency_orders,
            'user' => User::findOrfail($id),
            'from' => request('from'),
            'to' => request('to')
        ]);
    }


    public function PrintSummaryBranchDate(Request $request)
    {
        $this->validate(request(), [
            'branch' => 'required'
        ]);

        $value = explode(' - ', $request->date);
         
        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        $branch = $request->branch;

        
        if (auth()->user()->role == "Sales Person" || auth()->user()->role == "Dispatch Manager") {
            abort(403, 'Unauthorized action.');  
        }else{

       $agency_orders = \DB::table('invoices')
        ->selectRaw('agency as agency, sum(invoice_total_price) as total')
                    ->where('invoice_category', '!=', "TRANSPORT")
        ->groupBy('agency')
        ->where('branch', $branch)
        ->where('invoice_status', 1)
        ->WhereDate('created_at','>=', $from)
        ->WhereDate('created_at','<=', $to)
        ->get();

     
        }

   
        return view('sales.print-sales-summary', [
            'agency_orders'=> $agency_orders,
            'from' => $from, 
            'to' => $to
        ]);
    }



    public function HeldTransaction()
    {
        if (auth()->user()->role == "Administrator") {
            $order = Order::where('status', 5)->get();
        }else{
            $order = Order::where('status', 5)->where('branch', auth()->user()->branch)->get();
        }
        return view('held', [
            'heldTransaction' => $order
        ]);
    }



    public function HeldTransactionComplete()
    {
        if (auth()->user()->role == "Administrator") {
            $order = Order::where('was_held', 1)->where('completed_at','!=', NULL)->get();
        }else{
            $order = Order::where('was_held', 1)->where('completed_at','!=', NULL)->where('branch',auth()->user()->branch)->get();
        }

        return view('completed-held', [
            'heldTransaction' => $order
        ]);
    }


    public function ConfirmHeldPay()
    {

        HeldTransaction::create([
            'user_id' => auth()->id(),
            'order_id' => request('order_id'),
            'pay_type' => request('payment_met'),
            'description' => request('comment'),
            'increase' => null,
            'decrease' => request('amount')
        ]);


        return back()->with('status', 'Payment saved successfully');


    }


    public function CompletePay($order_id)
    {

        $getDayClose = \DB::table('close_days')->first(); // getDay close
        $time = date('H:i:s'); // current time 

        $held = HeldTransaction::where('order_id', $order_id)->orderBy('id', 'DESC')->first();
        Order::where('order_id', request('order_id'))->update([
            'status' => 1,
            'payment_accepted_by' => auth()->id(),
            'amount_paid'  => $held->sum('decrease'),
            'payment_method'  => $held->pay_type,
            'completed_at' => Carbon::now(),
            'was_held' => 1,
            'created_at' => date('Y-m-d H:i:s', strtotime("$getDayClose->day_close $time")),
        ]);


            Invoice::where('invoice_number', $order_id)->where('invoice_status', '!=', 0)->update([
                'invoice_status' => 1,
                'agency'  => $held->pay_type,
                'created_at' => date('Y-m-d H:i:s', strtotime("$getDayClose->day_close $time")),
            ]);
       

        return back()->with('status', 'Order completed and cleared');
    }




    public function Cashout()
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://coldserver-v6.herokuapp.com/graphql',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS =>'{"query":"query Query($id: ID) {\\n  getCashoutRequests(ID: $id) {\\n    amount\\n    approved\\n    approvedAt\\n    approvedBy\\n    balance\\n    createdAt\\n    network_code\\n    id\\n    refNumber\\n    rejected\\n    riderId\\n    riderName\\n    riderNumber\\n  }\\n}","variables":{}}',
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json'
        ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        $data = json_decode($response);
        
         return view('cashout', [
             'rider' => $data->data->getCashoutRequests
         ]);
    }



    public function salesReport()
    {   
        
        // $this->authorize('create', App\Models\User::class);
         // general Sales
           
        if(auth()->user()->role == "Administrator"){
                $delivery = \DB::table('orders')
                ->where( 'created_at', '>', Carbon::now()->subDays(30))
                ->where('status', 1)
                ->where('dispatch_status', 1)
                ->where('category', "Delivery")
                ->sum('total_cost_order');
        

                $counter = \DB::table('orders')
                ->where( 'created_at', '>', Carbon::now()->subDays(30))
                ->where('category', "Counter")
                ->sum('total_cost_order');

                $deliveryfee = \DB::table('dispatches')
                    ->where( 'created_at', '>', Carbon::now()->subDays(30))
                    ->where('dispatch_status', 1)
                    ->sum('deliveryamount');

                // Rejected Orders
                $general_total_reject = \DB::table('invoices')
                ->where('invoice_status', 0)
                ->where( 'created_at', '>', Carbon::now()->subDays(30))
                ->sum('invoice_total_price');

                // On the House
                $general_total_house = \DB::table('invoices')
                ->where('invoice_status', 2)
                ->where( 'created_at', '>=', Carbon::now()->subDays(30))
                ->sum('invoice_total_price');

                $discounts = \DB::table('discounts')
                        ->where( 'created_at', '>=', Carbon::now()->subDays(30))
                        ->where('is_held', 0)
        ->sum('amount_deducted');

                $all_sales = ($delivery + $counter) - ($discounts+$general_total_reject+$general_total_house);

                $all_orders = \DB::table('orders')->get();

                $all_product = \DB::table('final_productions')->get();

                $users = \DB::table('users')
                ->get();


                $branch = \DB::table('branches')->get();

        }else {
            $delivery = \DB::table('orders')
                ->where( 'created_at', '>', Carbon::now()->subDays(30))
                ->where('status', 1)
                ->where('dispatch_status', 1)
                ->where('category', "Delivery")
                ->where('branch', auth()->user()->branch)
                ->sum('total_cost_order');
        

                $counter = \DB::table('orders')
                ->where( 'created_at', '>', Carbon::now()->subDays(30))
                ->where('category', "Counter")
                ->where('branch', auth()->user()->branch)
                ->sum('total_cost_order');

                $deliveryfee = \DB::table('dispatches')
                    ->where( 'created_at', '>', Carbon::now()->subDays(30))
                    ->where('dispatch_status', 1)
                    ->where('dispatch_branch', auth()->user()->branch)
                    ->sum('deliveryamount');

                // Rejected Orders
                $general_total_reject = \DB::table('invoices')
                ->where('invoice_status', 0)
                ->where( 'created_at', '>', Carbon::now()->subDays(30))
                ->where('branch', auth()->user()->branch)
                ->sum('invoice_total_price');

                // On the House
                $general_total_house = \DB::table('invoices')
                ->where('invoice_status', 2)
                ->where( 'created_at', '>', Carbon::now()->subDays(30))
                ->where('branch', auth()->user()->branch)
                ->sum('invoice_total_price');

                $discounts = \DB::table('discounts')
                        ->where( 'created_at', '>', Carbon::now()->subDays(30))
                        ->where('branch', auth()->user()->branch)
                        ->where('is_held', 0)
        ->sum('amount_deducted');

                $all_sales = ($delivery + $counter) - ($discounts+$general_total_reject+$general_total_house);

                $all_orders = \DB::table('orders')->where('branch', auth()->user()->branch)
                ->get();

                $all_product = \DB::table('final_productions')->get();

                $users = \DB::table('users')->where('branch', auth()->user()->branch)
                ->get();


                $branch = \DB::table('branches')->where('branch_name', auth()->user()->branch)->get();

                return view('sales.sales-report', [
                    'all_sales' => $all_sales,
                    'all_orders' => $all_orders->count(),
                    'all_product' => $all_product->count(),
                    'all_user_show' => $users,
                    'branches' => $branch
                ]);
        }

        \App\Models\UserActivity::create([
            'changed_date' => \Carbon\carbon::now(),
            'user_id'=>auth()->id(),
            'event' => "viewed Sales Report",
        ]);


        return view('sales.sales-report', [
            'all_sales' => $all_sales,
            'all_orders' => $all_orders->count(),
            'all_product' => $all_product->count(),
            'all_user_show' => $users,
            'branches' => $branch
        ]);
    }





    public function branchSalesReport(Request $request)
    {

        $value = explode(' - ', $request->date);
         

        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        if ($from == $to) {
        $sales_today_branch = \DB::table('invoices')
        ->where('branch', $request->branch)
        ->where('invoice_status', 1)
        ->whereDate('created_at', $from)
        ->get();

        $total_cash = \DB::table('invoices')
        ->where('branch', $request->branch)
        ->where('invoice_status', 1)
        ->whereDate('created_at', $from)
        ->sum('invoice_total_price');

        
        $discounts = \DB::table('discounts')
            ->whereDate('created_at', $from)
            ->where('branch', $request->branch)
            ->where('is_held', 0)
        ->sum('amount_deducted');
        
       $branch_total_general = $total_cash - $discounts;

        // On the House
        $branch_total_house = \DB::table('invoices')
        ->where('branch', $request->branch)
        ->where('invoice_status', 2)
        ->whereDate('created_at', $from)
        ->sum('invoice_total_price');

        $branch_total_house_list = \DB::table('invoices')
        ->where('branch', $request->branch)
        ->where('invoice_status', 2)
        ->whereDate('created_at', $from)
        ->get();

        // Rejected Orders
        $branch_total_reject = \DB::table('invoices')
        ->where('branch', $request->branch)
        ->where('invoice_status', 0)
        ->whereDate('created_at', $from)
        ->sum('invoice_total_price');

        $branch_total_reject_list = \DB::table('invoices')
        ->where('branch', $request->branch)
        ->where('invoice_status', 0)
        ->whereDate('created_at', $from)
        ->get();

        $orders = \DB::table('orders')
        ->select('*')
        ->join('users','users.id', 'orders.user_id')
        ->where('orders.branch', $request->branch)
        ->whereDate('orders.created_at', $from)
        ->get();
        
        $users_all = \DB::table('users')
        ->where('branch', $request->branch)
        ->get();


        $total_deliveries = \DB::table('invoices')
            ->where('invoice_status', 1)
            ->where('invoice_category', "TRANSPORT")
            ->whereDate('created_at', $from)
            ->where('branch', $request->branch)
            ->sum('invoice_total_price');


        return view('sales.general-sales-report-branch', [
            'sales_today_branch' => $sales_today_branch,
            'from' => $from,
            'branch_total_general' => $branch_total_general,
            'branch_total_house' => $branch_total_house,
            'branch_total_reject' => $branch_total_reject,
            'branch_total_reject_list' => $branch_total_reject_list,
            'branch_total_house_list' => $branch_total_house_list,
            'all_orders' => $orders,
            'users_all' => $users_all,
            'total_deliveries' => $total_deliveries
            
        ]);
     }else {
        $sales_today_branch = \DB::table('invoices')
        ->where('branch', $request->branch)
        ->where('invoice_status', 1)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->get();


        $total_cash = \DB::table('invoices')
        ->where('branch', $request->branch)
        ->where('invoice_status', 1)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->sum('invoice_total_price');



        $branch_total_general = $total_cash;
                    
        // On the House
        $branch_total_house = \DB::table('invoices')
        ->where('branch', $request->branch)
        ->where('invoice_status', 2)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->sum('invoice_total_price');

        $branch_total_house_list = \DB::table('invoices')
        ->where('branch', $request->branch)
        ->where('invoice_status', 2)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->get();

        // Rejected Orders
        $branch_total_reject = \DB::table('invoices')
        ->where('branch', $request->branch)
        ->where('invoice_status', 0)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->sum('invoice_total_price');

        $branch_total_reject_list = \DB::table('invoices')
        ->where('branch', $request->branch)
        ->where('invoice_status', 0)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->get();

        $orders = \DB::table('orders')
        ->select('*')
        ->join('users','users.id', 'orders.user_id')
        ->where('orders.branch', $request->branch)
        ->WhereDate('orders.created_at','>=', $from)
            ->WhereDate('orders.created_at','<=', $to)
        ->get();

        $users_all = \DB::table('users')
        ->where('branch', $request->branch)
        ->get();

        $discounts = \DB::table('discounts')
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->where('branch', $request->branch)
            ->where('is_held', 0)
        ->sum('amount_deducted');
        
       $branch_total_general = $total_cash - $discounts;

       $total_deliveries = \DB::table('invoices')
       ->where('invoice_status', 1)
       ->where('invoice_category', "TRANSPORT")
       ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
       ->where('branch', $request->branch)
       ->sum('invoice_total_price');

       
        return view('sales.general-sales-report-branch', [
            'sales_today_branch' => $sales_today_branch,
            'branch_total_general' => $branch_total_general,
            'branch_total_house' => $branch_total_house,
            'branch_total_reject' => $branch_total_reject,
            'branch_total_reject_list' => $branch_total_reject_list,
            'branch_total_house_list' => $branch_total_house_list,
            'all_orders' => $orders,
            'users_all' => $users_all,
            'total_deliveries' => $total_deliveries
        ]);
     }
    }


    public function dateReportByUser(Request $request)
    {
         // getDay close
       $getDayClose = \DB::table('close_days')->first();

        // find user
        $user_data = User::findOrfail($request->user_id);
        $value = explode(' - ', $request->date);
         
        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        if ($from == $to) {
        $sales_today_general = \DB::table('invoices')
        ->where('invoice_status', 1)
        ->where('user_id', $request->user_id)
        ->whereDate('created_at', $from)
        ->get();
        
        $user = User::findOrfail($request->user_id);
        // general Sales
        if ($user->sales_person_category == "Delivery") {
            $inv = \DB::table('invoices')
            ->where('invoice_status', 1)
            ->where('user_id', $request->user_id)
            ->whereDate('created_at', $from)
            ->sum('invoice_total_price');

                
        }elseif($user->sales_person_category == "Counter") {
           $inv = \DB::table('invoices')
                ->where('invoice_status', 1)
                ->where('user_id', $request->user_id)
                ->whereDate('created_at', $from)
                ->sum('invoice_total_price');
        }elseif ($user->sales_person_category == "Drive Thru") {
            $inv = \DB::table('invoices')
                ->where('invoice_status', 1)
                ->where('user_id', $request->user_id)
                ->whereDate('created_at', $from)
                ->sum('invoice_total_price');
        }

        $deliveryAmount = \DB::table('invoices')
        ->where('invoice_status', 1)
        ->where('invoice_category', "TRANSPORT")
        ->where('user_id', $request->user_id)
        ->whereDate('created_at', $from)
        ->sum('invoice_total_price');
        

        // On the House
        $general_total_house = \DB::table('invoices')
        ->where('invoice_status', 2)
        ->where('user_id', $request->user_id)
        ->whereDate('created_at', $from)
        ->sum('invoice_total_price');

        $general_total_house_list = \DB::table('invoices')
        ->where('invoice_status', 2)
        ->where('user_id', $request->user_id)
        ->whereDate('created_at', $from)
        ->get();

        // Rejected Orders
        $general_total_reject = \DB::table('invoices')
        ->where('invoice_status', 0)
        ->where('user_id', $request->user_id)
        ->whereDate('created_at', $from)
        ->sum('invoice_total_price');

        $general_total_reject_list = \DB::table('invoices')
        ->where('invoice_status', 0)
        ->where('user_id', $request->user_id)
        ->whereDate('created_at', $from)
        ->get();

        $order =  \DB::table('orders')
        ->where('user_id', $request->user_id)
        ->whereDate('created_at', $from)
        ->get();

        $orders = \DB::table('invoices')
        ->where('user_id', $request->user_id)
        ->where('invoice_status', 1)
        ->whereDate('created_at', $getDayClose->day_close)
        ->sum('invoice_total_price');

        $discounts = \DB::table('discounts')
                ->where('user_id', $request->user_id)
                ->whereDate('created_at', $from)
                ->where('is_held', 0)
        ->sum('amount_deducted');

        $general_total_general = $inv - $discounts;



        return view('sales.general-sales-report-byuser', 
        [
            'sales_today_general' => $sales_today_general,
            'general_total_general' => $general_total_general,
            'general_total_house' => $general_total_house,
            'general_total_reject' => $general_total_reject,
            'general_total_reject_list' => $general_total_reject_list,
            'general_total_house_list' => $general_total_house_list,
            'user_data' => $user_data,
            'order' => $order,
            'discounts' => $discounts,
            'orders' => $orders,
            'inv' => $inv,
            'deliveryAmount' => $deliveryAmount
        ]);
    }else {
        $sales_today_general = \DB::table('invoices')
        ->where('invoice_status', 1)
        ->where('user_id', $request->user_id)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->get();


        $user = User::findOrfail($request->user_id);
        // general Sales
        if ($user->sales_person_category == "Delivery") {
            $inv = \DB::table('invoices')
            ->where('invoice_status', 1)
            ->where('user_id', $request->user_id)
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->sum('invoice_total_price');

        }else {
            $inv = \DB::table('invoices')
                ->where('invoice_status', 1)
                ->where('user_id', $request->user_id)
                ->WhereDate('created_at','>=', $from)
                ->WhereDate('created_at','<=', $to)
                ->sum('invoice_total_price');
        }

        $discounts = \DB::table('discounts')
                ->where('user_id', $request->user_id)
                ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
                ->where('is_held', 0)
        ->sum('amount_deducted');

        $deliveryAmount = \DB::table('invoices')
            ->where('invoice_status', 1)
            ->where('invoice_category', "TRANSPORT")
            ->where('user_id', $request->user_id)
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->sum('invoice_total_price');

        $general_total_general = $inv - $discounts;

        // On the House
        $general_total_house = \DB::table('invoices')
        ->where('invoice_status', 2)
        ->where('user_id', $request->user_id)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->sum('invoice_total_price');

        $general_total_house_list = \DB::table('invoices')
        ->where('invoice_status', 2)
        ->where('user_id', $request->user_id)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->get();

        // Rejected Orders
        $general_total_reject = \DB::table('invoices')
        ->where('invoice_status', 0)
        ->where('user_id', $request->user_id)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->sum('invoice_total_price');

        $general_total_reject_list = \DB::table('invoices')
        ->where('invoice_status', 0)
        ->where('user_id', $request->user_id)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->get();

        $order =  \DB::table('orders')
        ->where('user_id', $request->user_id)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->get();

        $orders = \DB::table('invoices')
        ->where('user_id', $request->user_id)
        ->where('invoice_status', 1)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->sum('invoice_total_price');

        $discounts = \DB::table('discounts')
            ->where('user_id', $request->user_id)
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->where('is_held', 0)
        ->sum('amount_deducted');

        

        $general_total_general = $inv - $discounts;
       

        return view('sales.general-sales-report-byuser', 
        [
            'sales_today_general' => $sales_today_general,
            'general_total_general' => $general_total_general,
            'general_total_house' => $general_total_house,
            'general_total_reject' => $general_total_reject,
            'general_total_reject_list' => $general_total_reject_list,
            'general_total_house_list' => $general_total_house_list,
            'user_data' => $user_data,
            'order' => $order,
            'discounts' => $discounts,
            'orders' => $orders,
            'deliveryAmount' => $deliveryAmount
        ]);
        }

    }



    public function departmentSummarybyDate(Request $request)
    {   
        $value = explode(' - ', $request->date);
         
        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        $user_details = User::findOrfail($request->user_id);

        if ($from == $to) {
            $items = \DB::table('invoices')
            ->selectRaw('invoice_category as name, sum(invoice_total_price) as total, sum(invoice_quantity) as quantity')
            ->where('user_id', $request->user_id)
                        ->where('invoice_category', '!=', "TRANSPORT")
            ->groupBy('invoice_category')
            ->where('invoice_status', 1)
            ->whereDate('created_at', $from)
            ->get();
    
    
            $itemsQuantity = \DB::table('invoices')
            ->where('user_id', $request->user_id)
                        ->where('invoice_category', '!=', "TRANSPORT")
            ->whereDate('created_at', $from)
            ->where('invoice_status', 1)
            ->sum('invoice_quantity');
    
            $itemsPrice = \DB::table('invoices')
            ->where('user_id', $request->user_id)
                        ->where('invoice_category', '!=', "TRANSPORT")
            ->whereDate('created_at', $from)
            ->where('invoice_status', 1)
            ->sum('invoice_total_price');
    
            return view('sales.department-summary-admin', [
                'items' => $items,
                'itemsQuantity' => $itemsQuantity,
                'itemsPrice' => $itemsPrice,
                'user_details' => $user_details
            ]);
        }else {
            $items = \DB::table('invoices')
                ->selectRaw('invoice_category as name, sum(invoice_total_price) as total, sum(invoice_quantity) as quantity')
                ->where('user_id', $request->user_id)
                                ->groupBy('invoice_category')
                ->where('invoice_category', '!=', "TRANSPORT")
                ->where('invoice_status', 1)
                ->WhereDate('created_at','>=', $from)
                ->WhereDate('created_at','<=', $to)
                ->get();
    
    
            $itemsQuantity = \DB::table('invoices')
                ->where('user_id', $request->user_id)
                                ->where('invoice_category', '!=', "TRANSPORT")
                                ->WhereDate('created_at','>=', $from)
                                ->WhereDate('created_at','<=', $to)
                                ->where('invoice_status', 1)
                ->sum('invoice_quantity');
        
            $itemsPrice = \DB::table('invoices')
                ->where('user_id', $request->user_id)
                                ->where('invoice_category', '!=', "TRANSPORT")
                                ->where('invoice_status', 1)
                                ->WhereDate('created_at','>=', $from)
                                ->WhereDate('created_at','<=', $to)
                ->sum('invoice_total_price');
        
            return view('sales.department-summary-admin', [
                'items' => $items,
                'itemsQuantity' => $itemsQuantity,
                'itemsPrice' => $itemsPrice,
                'user_details' => $user_details
            ]);
        }

    }



    public function itemSummarybyDate(Request $request)
    {
        $value = explode(' - ', $request->date);
         

        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        $user_details = User::findOrfail($request->user_id);

        if ($from == $to) {
            $items = \DB::table('invoices')
            ->selectRaw('invoice_product_name as name, sum(invoice_total_price) as total, sum(invoice_quantity) as quantity, invoice_unit_price as price')
            ->where('user_id', $request->user_id)
                        ->groupBy('invoice_product_name')
            ->where('invoice_category', '!=', "TRANSPORT")
            ->where('invoice_status', 1)
            ->groupBy('invoice_unit_price')
            ->whereDate('created_at', $from)
            ->get();
    
    
            $itemsQuantity = \DB::table('invoices')
            ->where('user_id', $request->user_id)
                        ->where('invoice_category', '!=', "TRANSPORT")
            ->whereDate('created_at', $from)
            ->where('invoice_status', 1)
            ->sum('invoice_quantity');
    
            $itemsPrice = \DB::table('invoices')
            ->where('user_id', $request->user_id)
                        ->where('invoice_category', '!=', "TRANSPORT")
            ->whereDate('created_at', $from)
            ->where('invoice_status', 1)
            ->sum('invoice_total_price');
    
            return view('item-summary', [
                'items' => $items,
                'itemsQuantity' => $itemsQuantity,
                'itemsPrice' => $itemsPrice
            ]);
        }else {
            $items = \DB::table('invoices')
                ->selectRaw('invoice_product_name as name, sum(invoice_total_price) as total, sum(invoice_quantity) as quantity, invoice_unit_price as price')
                ->where('user_id', $request->user_id)
                                ->groupBy('invoice_product_name')
                ->where('invoice_category', '!=', "TRANSPORT")
                ->groupBy('invoice_unit_price')
                ->WhereDate('created_at','>=', $from)
                ->WhereDate('created_at','<=', $to)
                ->where('invoice_status', 1)
                ->get();
    
    
            $itemsQuantity = \DB::table('invoices')
                ->where('user_id', $request->user_id)
                                ->where('invoice_category', '!=', "TRANSPORT")
                ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->where('invoice_status', 1)
                ->sum('invoice_quantity');
        
            $itemsPrice = \DB::table('invoices')
                ->where('user_id', $request->user_id)
                                ->where('invoice_category', '!=', "TRANSPORT")
                ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->where('invoice_status', 1)
                ->sum('invoice_total_price');
        
            return view('item-summary', [
                'items' => $items,
                'itemsQuantity' => $itemsQuantity,
                'itemsPrice' => $itemsPrice
            ]);
        }

    }



    public function reportByDate(Request $request)
    {
        $value = explode(' - ', $request->date);
         

        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        if ($from == $to) {
        $sales_today_general = \DB::table('invoices')
        ->where('invoice_status', 1)
        ->whereDate('created_at', $from)
        ->get();


        $total_sales = \DB::table('invoices')
        ->where('invoice_status', 1)
        ->whereDate('created_at', $from)
        ->sum('invoice_total_price');

        
            // On the House
        $general_total_house = \DB::table('invoices')
        ->where('invoice_status', 2)
        ->whereDate('created_at', $from)
        ->sum('invoice_total_price');

        $general_total_house_list = \DB::table('invoices')
        ->where('invoice_status', 2)
        ->whereDate('created_at', $from)
        ->get();

        // Rejected Orders
        $general_total_reject = \DB::table('invoices')
        ->where('invoice_status', 0)
        ->whereDate('created_at', $from)
        ->sum('invoice_total_price');

        $general_total_reject_list = \DB::table('invoices')
        ->where('invoice_status', 0)
        ->whereDate('created_at', $from)
        ->get();
        
        $discounts = \DB::table('discounts')
                ->whereDate('created_at', $from)
                ->where('is_held', 0)
        ->sum('amount_deducted');

        $total_deliveries = \DB::table('invoices')
            ->where('invoice_status', 1)
            ->where('invoice_category', "TRANSPORT")
            ->whereDate('created_at', $from)
            ->sum('invoice_total_price');

        $general_total_general = ($total_sales)-($discounts);


        return view('sales.general-sales-report', 
        [
            'sales_today_general' => $sales_today_general,
            'general_total_general' => $general_total_general,
            'general_total_house' => $general_total_house,
            'general_total_reject' => $general_total_reject,
            'general_total_reject_list' => $general_total_reject_list,
            'general_total_house_list' => $general_total_house_list,
            'total_deliveries' => $total_deliveries
            
        ]);
    }else {
        $sales_today_general = \DB::table('invoices')
        ->where('invoice_status', 1)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->get();

        $total_sales = \DB::table('invoices')
        ->where('invoice_status', 1)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->sum('invoice_total_price');


        // On the House
        $general_total_house = \DB::table('invoices')
        ->where('invoice_status', 2)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->sum('invoice_total_price');

        $general_total_house_list = \DB::table('invoices')
        ->where('invoice_status', 2)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->get();

        // Rejected Orders
        $general_total_reject = \DB::table('invoices')
        ->where('invoice_status', 0)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->sum('invoice_total_price');

        $general_total_reject_list = \DB::table('invoices')
        ->where('invoice_status', 0)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->get();

        $deliveryfee = \DB::table('dispatches')
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->where('dispatch_status', 1)
        ->where('status', 1)
        ->sum('deliveryamount');

        $discounts = \DB::table('discounts')
                ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
                ->where('is_held', 0)
        ->sum('amount_deducted');

        $total_deliveries = \DB::table('invoices')
            ->where('invoice_status', 1)
            ->where('invoice_category', "TRANSPORT")
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->sum('invoice_total_price');

        $general_total_general = $total_sales-($discounts);


        return view('sales.general-sales-report', 
        [
            'sales_today_general' => $sales_today_general,
            'general_total_general' => $general_total_general,
            'general_total_house' => $general_total_house,
            'general_total_reject' => $general_total_reject,
            'general_total_reject_list' => $general_total_reject_list,
            'general_total_house_list' => $general_total_house_list,
            'total_deliveries' => $total_deliveries
            
        ]);
        }

    }



    public function getDeliveryReportDate(Request $request)
    {
        
        $value = explode(' - ', $request->date);
         
        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

    if ($from == $to) {
        if ($request->category == "Delivery") {
            $ordersum = \DB::table('invoices')
            ->where('invoice_status', 1)
            ->where('invoice_sales_person_category', $request->category)
            ->whereDate('created_at', $from)
            ->sum('invoice_total_price');
                
            }elseif ($request->category == "Counter") {
                $ordersum = \DB::table('invoices')
                    ->where('invoice_status', 1)
                    ->where('invoice_sales_person_category', $request->category)
                    ->whereDate('created_at', $from)
                    ->sum('invoice_total_price');
            }

            $discounts = \DB::table('discounts')
                ->whereDate('created_at', $from)
                ->where('category', $request->category)
                ->where('is_held', 0)
        ->sum('amount_deducted');

            $sales_today_branch = \DB::table('invoices')
                ->where('invoice_status', 1)
                ->where('invoice_sales_person_category', $request->category)
                ->whereDate('created_at', $from)
                ->get();

                    // On the House
            $branch_total_house = \DB::table('invoices')
                ->where('invoice_status', 2)
                ->where('invoice_sales_person_category', $request->category)
                ->whereDate('created_at', $from)
                ->sum('invoice_total_price');

            $branch_total_house_list = \DB::table('invoices')
                ->where('invoice_status', 2)
                ->where('invoice_sales_person_category', $request->category)
                ->whereDate('created_at', $from)
                ->get();

            // Rejected Orders
            $branch_total_reject = \DB::table('invoices')
                ->where('invoice_status', 0)
                ->where('invoice_sales_person_category', $request->category)
                ->whereDate('created_at', $from)
                ->sum('invoice_total_price');

            $branch_total_reject_list = \DB::table('invoices')
                ->where('invoice_status', 0)
                ->where('invoice_sales_person_category', $request->category)
                ->whereDate('created_at', $from)
                ->get();

            $order =  \DB::table('orders')
                ->select('*')
                ->where('category', $request->category)
                ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
                ->get();

            $deliveriestoday = \DB::table('invoices')
                ->where('invoice_status', 1)
                ->where('invoice_category', "TRANSPORT")
                ->whereDate('created_at', $from)
                ->where('invoice_sales_person_category', $request->category)
                ->sum('invoice_total_price');


            $branch_total_general = $ordersum - $discounts;

            return view('sales.sales-person-category-bydate', [
                'sales_today_branch' => $sales_today_branch,
                'branch_total_general' => $branch_total_general,
                'branch_total_house' => $branch_total_house,
                'branch_total_reject' => $branch_total_reject,
                'branch_total_reject_list' => $branch_total_reject_list,
                'branch_total_house_list' => $branch_total_house_list,
                'order' => $order,
                'deliveriesToday' => $deliveriestoday,
                'discounts' => $discounts
            ]);

        }else {
            if ($request->category == "Delivery") {
                if ($request->category == "Delivery") {
                    $ordersum = \DB::table('invoices')
                    ->where('invoice_status', 1)
                    ->where('invoice_sales_person_category', $request->category)
                    ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
                    ->sum('invoice_total_price');
                        
                    }elseif ($request->category == "Counter") {
                        $ordersum = \DB::table('invoices')
                            ->where('invoice_status', 1)
                            ->where('invoice_sales_person_category', $request->category)
                            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
                            ->sum('invoice_total_price');
                    }
        
                    $discounts = \DB::table('discounts')
                        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
                        ->where('category', $request->category)
                        ->where('is_held', 0)
        ->sum('amount_deducted');
        
                    $sales_today_branch = \DB::table('invoices')
                        ->where('invoice_status', 1)
                        ->where('invoice_sales_person_category', $request->category)
                        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
                        ->get();
        
                            // On the House
                    $branch_total_house = \DB::table('invoices')
                        ->where('invoice_status', 2)
                        ->where('invoice_sales_person_category', $request->category)
                        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
                        ->sum('invoice_total_price');
        
                    $branch_total_house_list = \DB::table('invoices')
                        ->where('invoice_status', 2)
                        ->where('invoice_sales_person_category', $request->category)
                        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
                        ->get();
        
                    // Rejected Orders
                    $branch_total_reject = \DB::table('invoices')
                        ->where('invoice_status', 0)
                        ->where('invoice_sales_person_category', $request->category)
                        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
                        ->sum('invoice_total_price');
        
                    $branch_total_reject_list = \DB::table('invoices')
                        ->where('invoice_status', 0)
                        ->where('invoice_sales_person_category', $request->category)
                        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
                        ->get();
        
                    $order =  \DB::table('orders')
                        ->select('*')
                        ->where('category', $request->category)
                        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
                        ->get();
        
                    $deliveriestoday = \DB::table('invoices')
                        ->where('invoice_status', 1)
                        ->where('invoice_category', "TRANSPORT")
                        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
                        ->where('invoice_sales_person_category', $request->category)
                        ->sum('invoice_total_price');
        
        
                    $branch_total_general = $ordersum - $discounts;
        
                    return view('sales.sales-person-category-bydate', [
                        'sales_today_branch' => $sales_today_branch,
                        'branch_total_general' => $branch_total_general,
                        'branch_total_house' => $branch_total_house,
                        'branch_total_reject' => $branch_total_reject,
                        'branch_total_reject_list' => $branch_total_reject_list,
                        'branch_total_house_list' => $branch_total_house_list,
                        'order' => $order,
                        'deliveriesToday' => $deliveriestoday,
                        'discounts' => $discounts
                    ]);
        
            }

        }
    }


    public function allDepartmentSummary(Request $request)
    {
        $value = explode(' - ', $request->date);
        
        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        if ($from == $to) {
            $items = \DB::table('invoices')
            ->selectRaw('invoice_category as name, sum(invoice_total_price) as total, sum(invoice_quantity) as quantity')
                        ->where('invoice_category', '!=', "TRANSPORT")
            ->groupBy('invoice_category')
            ->whereIn('invoice_status', [1,2])
            ->whereDate('created_at', $from)
            ->get();
    
    
            $itemsQuantity = \DB::table('invoices')
                        ->where('invoice_category', '!=', "TRANSPORT")
            ->whereDate('created_at', $from)
            ->whereIn('invoice_status', [1,2])
            ->sum('invoice_quantity');
    
            $itemsPrice = \DB::table('invoices')
                        ->where('invoice_category', '!=', "TRANSPORT")
            ->whereDate('created_at', $from)
            ->whereIn('invoice_status', [1,2])
            ->sum('invoice_total_price');


            $dicount = \DB::table('discounts')
                    ->whereDate('created_at', $from)
                    ->where('is_held', 0)
        ->sum('amount_deducted');
    
            return view('department-summary-all-using-date', [
                'items' => $items,
                'itemsQuantity' => $itemsQuantity,
                'itemsPrice' => $itemsPrice,
                'discount'=> $dicount,
            ]);
        }else {
            $items = \DB::table('invoices')
                ->selectRaw('invoice_category as name, sum(invoice_total_price) as total, sum(invoice_quantity) as quantity')
                                ->groupBy('invoice_category')
                ->where('invoice_category', '!=', "TRANSPORT")
                ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->whereIn('invoice_status', [1,2])
                ->get();
    
    
            $itemsQuantity = \DB::table('invoices')
                                ->where('invoice_category', '!=', "TRANSPORT")
                ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->whereIn('invoice_status', [1,2])
                ->sum('invoice_quantity');
        
            $itemsPrice = \DB::table('invoices')
                                ->where('invoice_category', '!=', "TRANSPORT")
                ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->whereIn('invoice_status', [1,2])
                ->sum('invoice_total_price');


                $discount = \DB::table('discounts')
                ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
                ->where('is_held', 0)
        ->sum('amount_deducted');
        
            return view('department-summary-all-using-date', [
                'items' => $items,
                'itemsQuantity' => $itemsQuantity,
                'itemsPrice' => $itemsPrice,
                'discount' => $discount,
            ]);
        }
        
    }


    public function getDeliveryReportDating(Request $request)
    {   
        $value = explode(' - ', $request->date);
         
        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        if ($from == $to) {

        $sales_today_branch = \DB::table('invoices')
            ->where('invoice_status', 1)
            ->where('invoice_sales_person_category', $request->category)
            ->where('branch', $request->branch)
            ->whereDate('created_at', $from)
            ->get();

        $rejected = \DB::table('invoices')
        ->where('invoice_status', 0)
        ->where('branch', $request->branch)
        ->whereDate('created_at', $from)
        ->where('invoice_sales_person_category', $request->category)
        ->sum('invoice_total_price');
        
        $onthehouse = \DB::table('invoices')
            ->where('invoice_status', 2)
            ->where('branch', $request->branch)
            ->where('invoice_sales_person_category', $request->category)
            ->whereDate('created_at', $from)
            ->sum('invoice_total_price');

        $discounts = \DB::table('discounts')
            ->whereDate('created_at', $from)
            ->where('branch', $request->branch)
            ->where('category', $request->category)
            ->where('is_held', 0)
            ->sum('amount_deducted');

        $deliveriestoday = \DB::table('invoices')
        ->where('invoice_status', 1)
        ->where('invoice_category', "TRANSPORT")
        ->whereDate('created_at', $from)
        ->where('branch', $request->branch)
        ->where('invoice_sales_person_category', $request->category)
        ->sum('invoice_total_price');
    


        if ($request->category == "Delivery") {

            $confirmed = \DB::table('invoices')
            ->where('invoice_status', 1)
            ->where('invoice_sales_person_category', $request->category)
            ->where('branch', $request->branch)
            ->whereDate('created_at', $from)
            ->sum('invoice_total_price');

            $unconfirmed = \DB::table('orders')
                ->where('status', 0)
                ->orWhere('dispatch_status', 0)
                ->whereDate('created_at', $from)
                ->where('category',  $request->category)
                ->where('branch', $request->branch)
                ->sum('total_cost_order');
                        
        $branch_total_general = $confirmed - ($discounts);

        }elseif ($request->category == "Counter") {
            $confirmed = \DB::table('invoices')
            ->where('invoice_status', 1)
            ->where('branch', $request->branch)
            ->whereDate('created_at', $from)
            ->where('invoice_sales_person_category', $request->category)
            ->sum('invoice_total_price');

            $unconfirmed = 0;

            $branch_total_general = $confirmed - $discounts;

        }elseif ($request->category == "Drive Thru") {
            $confirmed = \DB::table('invoices')
            ->where('invoice_status', 1)
            ->where('branch', $request->branch)
            ->whereDate('created_at', $from)
            ->where('invoice_sales_person_category', $request->category)
            ->sum('invoice_total_price');

            $unconfirmed = 0;

            $branch_total_general = $confirmed - $discounts;
        }

        // On the House
        $branch_total_house = \DB::table('invoices')
        ->where('invoice_status', 2)
        ->where('invoice_sales_person_category', $request->category)
        ->where('branch', $request->branch)
        ->whereDate('created_at', $from)
        ->sum('invoice_total_price');

        $branch_total_house_list = \DB::table('invoices')
        ->where('invoice_status', 2)
        ->where('invoice_sales_person_category', $request->category)
        ->where('branch', $request->branch)
        ->whereDate('created_at', $from)
        ->get();

        // Rejected Orders
        $branch_total_reject = \DB::table('invoices')
        ->where('invoice_status', 0)
        ->where('invoice_sales_person_category', $request->category)
        ->where('branch', $request->branch)
        ->whereDate('created_at', $from)
        ->sum('invoice_total_price');

        $branch_total_reject_list = \DB::table('invoices')
        ->where('invoice_status', 0)
        ->where('invoice_sales_person_category', $request->category)
        ->where('branch', $request->branch)
        ->whereDate('created_at', $from)
        ->get();

       $order =  \DB::table('orders')
        ->where('category', $request->category)
        ->where('branch', $request->branch)
        ->whereDate('created_at', $from)
        ->get();


        $orders =  \DB::table('invoices')
        ->where('branch', $request->branch)
        ->where('invoice_sales_person_category', $request->category)
        ->where('invoice_status', 1)
        ->whereDate('created_at', $from)
        ->sum('invoice_total_price');

        $orderDiscounted =  \DB::table('orders')
        ->join('discounts', 'orders.id','discounts.order_number')
        ->where('discounts.branch', $request->branch)
        ->where('orders.category', $request->category)
        ->whereDate('orders.created_at',  $from)
        ->get();
        


        return view('sales.sales-person-category-with-item', [
            'sales_today_branch' => $sales_today_branch,
            'branch_total_general' => $branch_total_general,
            'branch_total_house' => $branch_total_house,
            'branch_total_reject' => $branch_total_reject,
            'branch_total_reject_list' => $branch_total_reject_list,
            'branch_total_house_list' => $branch_total_house_list,
            'order' => $order,
            'deliveriesToday' => $deliveriestoday,
            'orders' => $orders,
            'discounts' => $discounts,
            'confirmed' => $confirmed,
            'unconfirmed' => $unconfirmed,
            'discounted_coupon' => $orderDiscounted
        ]);

    }else {

        $sales_today_branch = \DB::table('invoices')
        ->where('invoice_status', 1)
        ->where('invoice_sales_person_category', $request->category)
        ->where('branch', $request->branch)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->get();

        $rejected = \DB::table('invoices')
        ->where('invoice_status', 0)
        ->where('branch', $request->branch)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->where('invoice_sales_person_category', $request->category)
        ->sum('invoice_total_price');
        
        $onthehouse = \DB::table('invoices')
            ->where('invoice_status', 2)
            ->where('branch', $request->branch)
            ->where('invoice_sales_person_category', $request->category)
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->sum('invoice_total_price');

        $discounts = \DB::table('discounts')
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->where('branch', $request->branch)
            ->where('category', $request->category)
            ->where('is_held', 0)
        ->sum('amount_deducted');

        $deliveriestoday = \DB::table('invoices')
        ->where('invoice_status', 1)
        ->where('invoice_category', "TRANSPORT")
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->where('branch', $request->branch)
        ->where('invoice_sales_person_category', $request->category)
        ->sum('invoice_total_price');
    


        if ($request->category == "Delivery") {
            $confirmed = \DB::table('invoices')
                ->where('invoice_status', 1)
                ->where('branch', $request->branch)
                ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
                ->where('invoice_sales_person_category', $request->category)
                ->sum('invoice_total_price');

                $unconfirmed = \DB::table('orders')
                ->where('status', 0)
                ->orWhere('dispatch_status', 0)
                ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
                ->where('category',  $request->category)
                ->where('branch', $request->branch)
                ->sum('total_cost_order');
                    
        $branch_total_general = $confirmed - ($discounts);
        }elseif ($request->category == "Counter") {

            $unconfirmed = 0;

            $confirmed = \DB::table('invoices')
                ->where('invoice_status', 1)
                ->where('branch', $request->branch)
                ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
                ->where('invoice_sales_person_category', $request->category)
                ->sum('invoice_total_price');

            $branch_total_general = $confirmed - $discounts;
        }

        // On the House
        $branch_total_house = \DB::table('invoices')
        ->where('invoice_status', 2)
        ->where('invoice_sales_person_category', $request->category)
        ->where('branch', $request->branch)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->sum('invoice_total_price');

        $branch_total_house_list = \DB::table('invoices')
        ->where('invoice_status', 2)
        ->where('invoice_sales_person_category', $request->category)
        ->where('branch', $request->branch)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->get();

        // Rejected Orders
        $branch_total_reject = \DB::table('invoices')
        ->where('invoice_status', 0)
        ->where('invoice_sales_person_category', $request->category)
        ->where('branch', $request->branch)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->sum('invoice_total_price');

        $branch_total_reject_list = \DB::table('invoices')
        ->where('invoice_status', 0)
        ->where('invoice_sales_person_category', $request->category)
        ->where('branch', $request->branch)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->get();

       $order =  \DB::table('orders')
        ->where('category', $request->category)
        ->where('branch', $request->branch)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->get();


        $orders =  \DB::table('invoices')
        ->where('branch', $request->branch)
        ->where('invoice_sales_person_category', $request->category)
        ->where('invoice_status', 1)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->sum('invoice_total_price');

        $orderDiscounted =  \DB::table('orders')
        ->join('discounts', 'orders.id','discounts.order_number')
        ->where('discounts.branch', $request->branch)
        ->where('orders.category', $request->category)
        ->WhereDate('orders.created_at','>=', $from)
            ->WhereDate('orders.created_at','<=', $to)
        ->get();
        

        return view('sales.sales-person-category-with-item', [
            'sales_today_branch' => $sales_today_branch,
            'branch_total_general' => $branch_total_general,
            'branch_total_house' => $branch_total_house,
            'branch_total_reject' => $branch_total_reject,
            'branch_total_reject_list' => $branch_total_reject_list,
            'branch_total_house_list' => $branch_total_house_list,
            'order' => $order,
            'deliveriesToday' => $deliveriestoday,
            'orders' => $orders,
            'discounts' => $discounts,
            'confirmed' => $confirmed,
            'unconfirmed' => $unconfirmed,
            'discounted_coupon' => $orderDiscounted
        ]);

    }

    }



    public function itemSummaryDate(Request $request)
    {
        $value = explode(' - ', $request->date);
         

        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');


        if ($from == $to) {
            $items = \DB::table('invoices')
            ->selectRaw('invoice_product_name as name, sum(invoice_total_price) as total, sum(invoice_quantity) as quantity, invoice_unit_price as price')
                        ->where('invoice_category', '!=', "TRANSPORT")
            ->where('invoice_sales_person_category',$request -> category)
            ->where('branch', $request -> branch)
            ->groupBy('invoice_product_name')
            ->groupBy('invoice_unit_price')
            ->where('invoice_status', 1)
            ->whereDate('created_at', $from)
            ->get();
    
    
            $itemsQuantity = \DB::table('invoices')
            ->where('invoice_sales_person_category', $request -> category)
            ->where('branch', $request -> branch)
                        ->where('invoice_category', '!=', "TRANSPORT")
            ->whereDate('created_at', $from)
            ->where('invoice_status', 1)
            ->sum('invoice_quantity');
    
            $itemsPrice = \DB::table('invoices')
            ->where('invoice_sales_person_category', $request -> category)
            ->where('branch', $request -> branch)
                        ->where('invoice_category', '!=', "TRANSPORT")
            ->whereDate('created_at', $from)
            ->where('invoice_status', 1)
            ->sum('invoice_total_price');
    
            return view('item-summary-branch-sales-person', [
                'items' => $items,
                'itemsQuantity' => $itemsQuantity,
                'itemsPrice' => $itemsPrice,
                'branch' => $request -> branch,
                'category' => $request -> category
            ]);
        }else {
           $items = \DB::table('invoices')
            ->selectRaw('invoice_product_name as name, sum(invoice_total_price) as total, sum(invoice_quantity) as quantity, invoice_unit_price as price')
                        ->where('invoice_category', '!=', "TRANSPORT")
            ->where('invoice_sales_person_category', $request -> category)
            ->where('branch', $request -> branch)
            ->groupBy('invoice_product_name')
            ->groupBy('invoice_unit_price')
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->where('invoice_status', 1)
            ->get();
    
    
            $itemsQuantity = \DB::table('invoices')
            ->where('invoice_sales_person_category', $request -> category)
            ->where('branch', $request -> branch)
                        ->where('invoice_category', '!=', "TRANSPORT")
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->where('invoice_status', 1)
            ->sum('invoice_quantity');
    
            $itemsPrice = \DB::table('invoices')
            ->where('invoice_sales_person_category', $request -> category)
            ->where('branch', $request -> branch)
                        ->where('invoice_category', '!=', "TRANSPORT")
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->where('invoice_status', 1)
            ->sum('invoice_total_price');
    
            return view('item-summary-branch-sales-person', [
                'items' => $items,
                'itemsQuantity' => $itemsQuantity,
                'itemsPrice' => $itemsPrice,
                'branch' => $request->branch,
                'category' => $request->category
            ]);
        }
    }


    public function showDepartmentItemWithDate()
    {   
        $value = explode(' - ', request('date'));
        
        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        if ($from == $to) {
        $items_category = \DB::table('invoices')
            ->selectRaw('invoice_product_name as name, sum(invoice_total_price) as total, sum(invoice_quantity) as quantity, invoice_unit_price as price')
                        ->where('invoice_category', '!=', "TRANSPORT")
            ->where('invoice_category', request('category'))
            ->groupBy('invoice_product_name')
            ->groupBy('invoice_unit_price')
            ->whereDate('created_at', $from)
            ->where('invoice_status', 1)
            ->where('user_id', request('userID'))
            ->get();
        }else {
            $items_category = \DB::table('invoices')
            ->selectRaw('invoice_product_name as name, sum(invoice_total_price) as total, sum(invoice_quantity) as quantity, invoice_unit_price as price')
                        ->where('invoice_category', '!=', "TRANSPORT")
            ->where('invoice_category', request('category'))
            ->groupBy('invoice_product_name')
            ->groupBy('invoice_unit_price')
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->where('invoice_status', 1)
            ->where('user_id', request('userID'))
            ->get();
        }

        return view('inc/show-items', [
            'department' => request('category'),
            'items_category' => $items_category,
            'date' => request('date')
        ]);
    }



    public function showDepartmentItem($department)
    {   
        // getDay close
        $getDayClose = \DB::table('close_days')->first();

        $items_category = \DB::table('invoices')
            ->selectRaw('invoice_product_name as name, sum(invoice_total_price) as total, sum(invoice_quantity) as quantity, invoice_unit_price as price')
                        ->where('invoice_category', '!=', "TRANSPORT")
            ->where('invoice_category', $department)
            ->groupBy('invoice_product_name')
            ->groupBy('invoice_unit_price')
            ->where('invoice_status', 1)
            ->whereDate('created_at', $getDayClose->day_close)
            ->get();

        return view('inc/show-items', [
            'department' => $department,
            'items_category' => $items_category,
            'date' => $getDayClose->day_close
        ]);
    }



    public function departmentSummaryDate(Request $request)
    {
        $value = explode(' - ', $request->date);
         

        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');


        if ($from == $to) {
            $items = \DB::table('invoices')
            ->selectRaw('invoice_category as name, sum(invoice_total_price) as total, sum(invoice_quantity) as quantity')
            ->where('invoice_sales_person_category', $request -> category)
            ->where('branch', $request -> branch)
                        ->where('invoice_category', '!=', "TRANSPORT")
                        ->where('invoice_status', 1)
            ->groupBy('invoice_category')
            ->whereDate('created_at', $from)
            ->get();
    
    
            $itemsQuantity = \DB::table('invoices')
            ->where('invoice_sales_person_category', $request -> category)
            ->where('branch', $request -> branch)
                        ->where('invoice_category', '!=', "TRANSPORT")
            ->whereDate('created_at', $from)
            ->where('invoice_status', 1)
            ->sum('invoice_quantity');
    
            $itemsPrice = \DB::table('invoices')
            ->where('invoice_sales_person_category', $request -> category)
            ->where('branch', $request -> branch)
                        ->where('invoice_category', '!=', "TRANSPORT")
            ->whereDate('created_at', $from)
            ->where('invoice_status', 1)
            ->sum('invoice_total_price');
    
            return view('department-summary-admin', [
                'items' => $items,
                'itemsQuantity' => $itemsQuantity,
                'itemsPrice' => $itemsPrice,
            ]);
        }else {
            $items = \DB::table('invoices')
                ->selectRaw('invoice_category as name, sum(invoice_total_price) as total, sum(invoice_quantity) as quantity')
                ->where('invoice_sales_person_category', $request -> category)
                ->where('branch', $request -> branch)
                                ->groupBy('invoice_category')
                ->where('invoice_category', '!=', "TRANSPORT")
                ->WhereDate('created_at','>=', $from)
                ->WhereDate('created_at','<=', $to)
                ->where('invoice_status', 1)
                ->get();
    
    
            $itemsQuantity = \DB::table('invoices')
                ->where('invoice_sales_person_category', $request -> category)
                ->where('branch', $request -> branch)
                                ->where('invoice_category', '!=', "TRANSPORT")
                                ->WhereDate('created_at','>=', $from)
                                ->WhereDate('created_at','<=', $to)
                                ->where('invoice_status', 1)
                ->sum('invoice_quantity');
        
            $itemsPrice = \DB::table('invoices')
                ->where('invoice_sales_person_category', $request -> category)
                ->where('branch', $request -> branch)
                                ->where('invoice_category', '!=', "TRANSPORT")
                                ->WhereDate('created_at','>=', $from)
                                ->WhereDate('created_at','<=', $to)
                                ->where('invoice_status', 1)
                ->sum('invoice_total_price');
        
            return view('department-summary-admin', [
                'items' => $items,
                'itemsQuantity' => $itemsQuantity,
                'itemsPrice' => $itemsPrice,
            ]);
        }
    }



    public function showDepartmentItemDate(Request $request)
    {   

        $value = explode(' - ', $request->date);
         

        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');
        
    if ($request->branch == null) {
    
        if ($from == $to) {

        $itemlist = \DB::table('invoices')
        ->where('invoice_category', $request->name)
                ->whereDate('created_at', $from)
                ->where('invoice_status', 1)
        ->get();

        $cash = \DB::table('invoices')
            ->where('invoice_category', $request->name)
                        ->whereDate('created_at', $from)
                        ->where('invoice_status', 1)
            ->sum('invoice_total_price');

        $items_category = \DB::table('invoices')
            ->selectRaw('invoice_product_name as name, sum(invoice_total_price) as total, sum(invoice_quantity) as quantity, invoice_unit_price as price')
                        ->where('invoice_category', '!=', "TRANSPORT")
            ->where('invoice_category', $request->name)
            ->where('invoice_status', 1)
            ->groupBy('invoice_product_name')
            ->groupBy('invoice_unit_price')
            ->whereDate('created_at', $from)
            ->get();


            

        return view('inc/show-items', [
            'items' => $itemlist,
            'department' => $request->name,
            'cash' => $cash,
            'items_category' => $items_category 
        ]);
    }else {
        $itemlist = \DB::table('invoices')
        ->where('invoice_category', $request->name)
                ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->get();

        $cash = \DB::table('invoices')
            ->where('invoice_category', $request->name)
                        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->where('invoice_status', 1)
            ->sum('invoice_total_price');

        $items_category = \DB::table('invoices')
            ->selectRaw('invoice_product_name as name, sum(invoice_total_price) as total, sum(invoice_quantity) as quantity, invoice_unit_price as price')
                        ->where('invoice_category', '!=', "TRANSPORT")
            ->where('invoice_category', $request->name)
            ->groupBy('invoice_product_name')
            ->groupBy('invoice_unit_price')
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->where('invoice_status', 1)
            ->get();

        return view('inc/show-items', [
            'items' => $itemlist,
            'department' => $request->name,
            'cash' => $cash,
            'items_category' => $items_category 
        ]);
    }
}

else {
    if ($from == $to) {

        $itemlist = \DB::table('invoices')
        ->where('invoice_category', $request->name)
        ->where('branch', $request->branch)
                ->whereDate('created_at', $from)
                ->where('invoice_status', 1)
        ->get();

        $cash = \DB::table('invoices')
            ->where('invoice_category', $request->name)
            ->where('branch', $request->branch)
                        ->whereDate('created_at', $from)
                        ->where('invoice_status', 1)
            ->sum('invoice_total_price');

        $items_category = \DB::table('invoices')
            ->selectRaw('invoice_product_name as name, sum(invoice_total_price) as total, sum(invoice_quantity) as quantity, invoice_unit_price as price')
                        ->where('branch', $request->branch)
            ->where('invoice_category', '!=', "TRANSPORT")
            ->where('invoice_status', 1)
            ->where('invoice_category', $request->name)
            ->groupBy('invoice_product_name')
            ->groupBy('invoice_unit_price')
            ->whereDate('created_at', $from)
            ->get();

        return view('inc/show-items', [
            'items' => $itemlist,
            'department' => $request->name,
            'cash' => $cash,
            'items_category' => $items_category 
        ]);
    }else {
                $itemlist = \DB::table('invoices')
                ->where('invoice_category', $request->name)
                        ->where('branch', $request->branch)
                ->WhereDate('created_at','>=', $from)
                    ->WhereDate('created_at','<=', $to)
                    ->where('invoice_status', 1)
                ->get();

                $cash = \DB::table('invoices')
                    ->where('invoice_category', $request->name)
                                ->where('branch', $request->branch)
                    ->WhereDate('created_at','>=', $from)
                    ->WhereDate('created_at','<=', $to)
                    ->where('invoice_status', 1)
                    ->sum('invoice_total_price');

                $items_category = \DB::table('invoices')
                    ->selectRaw('invoice_product_name as name, sum(invoice_total_price) as total, sum(invoice_quantity) as quantity, invoice_unit_price as price')
                                ->where('branch', $request->branch)
                    ->where('invoice_category', '!=', "TRANSPORT")
                    ->where('invoice_category', $request->name)
                    ->groupBy('invoice_product_name')
                    ->groupBy('invoice_unit_price')
                    ->WhereDate('created_at','>=', $from)
                    ->WhereDate('created_at','<=', $to)
                    ->where('invoice_status', 1)
                    ->get();


                    

                return view('inc/show-items', [
                    'items' => $itemlist,
                    'department' => $request->name,
                    'cash' => $cash,
                    'items_category' => $items_category, 
                ]);
            }
        }
    }



    public function allItemSummary(Request $request)
    {
        $value = explode(' - ', $request->date);
         

        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');


        if ($from == $to) {
            $items = \DB::table('invoices')
            ->selectRaw('invoice_product_name as name, sum(invoice_total_price) as total, sum(invoice_quantity) as quantity, invoice_unit_price as price')
                        ->where('invoice_category', '!=', "TRANSPORT")
            ->groupBy('invoice_product_name')
            ->groupBy('invoice_unit_price')
            ->whereDate('created_at', $from)
            ->where('invoice_status', 1)
            ->get();
    
    
            $itemsQuantity = \DB::table('invoices')
                        ->where('invoice_category', '!=', "TRANSPORT")
            ->whereDate('created_at', $from)
            ->where('invoice_status', 1)
            ->sum('invoice_quantity');
    
            $itemsPrice = \DB::table('invoices')
                        ->where('invoice_category', '!=', "TRANSPORT")
            ->whereDate('created_at', $from)
            ->where('invoice_status', 1)
            ->sum('invoice_total_price');


            $dicount = \DB::table('discounts')
            ->whereDate('created_at',$from)
            ->where('is_held', 0)
        ->sum('amount_deducted');
    
            return view('item-summary-all', [
                'items' => $items,
                'itemsQuantity' => $itemsQuantity,
                'itemsPrice' => $itemsPrice,
                'discount' => $dicount,
            ]);
        }else {
           $items = \DB::table('invoices')
            ->selectRaw('invoice_product_name as name, sum(invoice_total_price) as total, sum(invoice_quantity) as quantity, invoice_unit_price as price')
                        ->where('invoice_category', '!=', "TRANSPORT")
            ->groupBy('invoice_product_name')
            ->groupBy('invoice_unit_price')
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->where('invoice_status', 1)
            ->get();
    
    
            $itemsQuantity = \DB::table('invoices')
                        ->where('invoice_category', '!=', "TRANSPORT")
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->where('invoice_status', 1)
            ->sum('invoice_quantity');
    
            $itemsPrice = \DB::table('invoices')
                        ->where('invoice_category', '!=', "TRANSPORT")
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->where('invoice_status', 1)
            ->sum('invoice_total_price');


            $dicount = \DB::table('discounts')
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->where('is_held', 0)
        ->sum('amount_deducted');
    
            return view('item-summary-all', [
                'items' => $items,
                'itemsQuantity' => $itemsQuantity,
                'itemsPrice' => $itemsPrice,
                'discount' => $dicount,
            ]);
        }
    }




    public function getDeliveryReport(Request $request)
    {   
        $value = explode(' - ', $request->date);
         
        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        $request->merge([
            'branch' => decrypt($request->branch)
        ]);

        if ($from == $to) {
        $sales_today_branch = \DB::table('invoices')
        ->where('invoice_status', 1)
        ->where('invoice_sales_person_category', $request->category)
        ->where('branch', $request->branch)
        ->whereDate('created_at', $from)
        ->get();

        $rejected = \DB::table('invoices')
        ->where('invoice_status', 0)
        ->where('branch', $request->branch)
        ->whereDate('created_at', $from)
        ->where('invoice_sales_person_category', $request->category)
        ->sum('invoice_total_price');
        
        $onthehouse = \DB::table('invoices')
            ->where('invoice_status', 2)
            ->where('branch', $request->branch)
            ->where('invoice_sales_person_category', $request->category)
            ->whereDate('created_at', $from)
            ->sum('invoice_total_price');

        $discounts = \DB::table('discounts')
            ->whereDate('created_at', $from)
            ->where('branch', $request->branch)
            ->where('category', $request->category)
            ->where('is_held', 0)
        ->sum('amount_deducted');

        $deliveriestoday = \DB::table('invoices')
        ->where('invoice_status', 1)
        ->where('invoice_category', "TRANSPORT")
        ->whereDate('created_at', $from)
        ->where('branch', $request->branch)
        ->where('invoice_sales_person_category', $request->category)
        ->sum('invoice_total_price');
    


        if ($request->category == "Delivery") {
        $confirmed = \DB::table('invoices')
            ->where('invoice_status', 1)
            ->where('invoice_sales_person_category', $request->category)
            ->where('branch', $request->branch)
            ->whereDate('created_at', $from)
            ->sum('invoice_total_price');


        $unconfirmed = \DB::table('orders')
                ->where('status', 1)
                ->where('dispatch_status', 0)
                ->whereDate('created_at', $from)
                ->where('category',  $request->category)
                ->where('branch', $request->branch)
                ->sum('total_cost_order');
                    
        $branch_total_general = $confirmed - ($discounts);
        }elseif ($request->category == "Counter") {
            $confirmed = \DB::table('invoices')
            ->where('invoice_status', 1)
            ->where('branch', $request->branch)
            ->whereDate('created_at', $from)
            ->where('invoice_sales_person_category', $request->category)
            ->sum('invoice_total_price');

            $branch_total_general = $confirmed - $discounts;

            $unconfirmed = 0;
        }else{
            $confirmed = \DB::table('invoices')
            ->where('invoice_status', 1)
            ->where('branch', $request->branch)
            ->whereDate('created_at', $from)
            ->where('invoice_sales_person_category', $request->category)
            ->sum('invoice_total_price');

            $branch_total_general = $confirmed - $discounts;

            $unconfirmed = 0;
        }

        // On the House
        $branch_total_house = \DB::table('invoices')
        ->where('invoice_status', 2)
        ->where('invoice_sales_person_category', $request->category)
        ->where('branch', $request->branch)
        ->whereDate('created_at', $from)
        ->sum('invoice_total_price');

        $branch_total_house_list = \DB::table('invoices')
        ->where('invoice_status', 2)
        ->where('invoice_sales_person_category', $request->category)
        ->where('branch', $request->branch)
        ->whereDate('created_at', $from)
        ->get();

        // Rejected Orders
        $branch_total_reject = \DB::table('invoices')
        ->where('invoice_status', 0)
        ->where('invoice_sales_person_category', $request->category)
        ->where('branch', $request->branch)
        ->whereDate('created_at', $from)
        ->sum('invoice_total_price');

        $branch_total_reject_list = \DB::table('invoices')
        ->where('invoice_status', 0)
        ->where('invoice_sales_person_category', $request->category)
        ->where('branch', $request->branch)
        ->whereDate('created_at', $from)
        ->get();

       $order =  \DB::table('orders')
        ->where('category', $request->category)
        ->where('branch', $request->branch)
        ->whereDate('created_at', $from)
        ->get();


        $orders =  \DB::table('invoices')
        ->where('branch', $request->branch)
        ->where('invoice_sales_person_category', $request->category)
        ->where('invoice_status', 1)
        ->whereDate('created_at', $from)
        ->sum('invoice_total_price');

        $orderDiscounted = \DB::table('discounts')
            ->whereDate('created_at', $from)
            ->where('branch', $request->branch)
            ->where('category', $request->category)
            ->get();
        


        return view('sales.sales-person-category', [
            'sales_today_branch' => $sales_today_branch,
            'branch_total_general' => $branch_total_general,
            'branch_total_house' => $branch_total_house,
            'branch_total_reject' => $branch_total_reject,
            'branch_total_reject_list' => $branch_total_reject_list,
            'branch_total_house_list' => $branch_total_house_list,
            'order' => $order,
            'deliveriesToday' => $deliveriestoday,
            'orders' => $orders,
            'discounts' => $discounts,
            'confirmed' => $confirmed,
            'unconfirmed' => $unconfirmed,
            'discounted_coupon' => $orderDiscounted
        ]);

    }else {
        $sales_today_branch = \DB::table('invoices')
        ->where('invoice_status', 1)
        ->where('invoice_sales_person_category', $request->category)
        ->where('branch', $request->branch)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->get();

        $rejected = \DB::table('invoices')
        ->where('invoice_status', 0)
        ->where('branch', $request->branch)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->where('invoice_sales_person_category', $request->category)
        ->sum('invoice_total_price');
        
        $onthehouse = \DB::table('invoices')
            ->where('invoice_status', 2)
            ->where('branch', $request->branch)
            ->where('invoice_sales_person_category', $request->category)
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->sum('invoice_total_price');

        $discounts = \DB::table('discounts')
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->where('branch', $request->branch)
            ->where('category', $request->category)
            ->where('is_held', 0)
        ->sum('amount_deducted');

        $deliveriestoday = \DB::table('invoices')
        ->where('invoice_status', 1)
        ->where('invoice_category', "TRANSPORT")
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->where('branch', $request->branch)
        ->where('invoice_sales_person_category', $request->category)
        ->sum('invoice_total_price');
    


        if ($request->category == "Delivery") {
            $confirmed = \DB::table('invoices')
                ->where('invoice_status', 1)
                ->where('branch', $request->branch)
                ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
                ->where('invoice_sales_person_category', $request->category)
                ->sum('invoice_total_price');
                    
        $branch_total_general = $confirmed - ($discounts);
        }elseif ($request->category == "Counter") {
            $confirmed = \DB::table('invoices')
                ->where('invoice_status', 1)
                ->where('branch', $request->branch)
                ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
                ->where('invoice_sales_person_category', $request->category)
                ->sum('invoice_total_price');

            $branch_total_general = $confirmed - $discounts;
        }else {
            $confirmed = \DB::table('invoices')
                ->where('invoice_status', 1)
                ->where('branch', $request->branch)
                ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
                ->where('invoice_sales_person_category', $request->category)
                ->sum('invoice_total_price');

            $branch_total_general = $confirmed - $discounts;
        }

        // On the House
        $branch_total_house = \DB::table('invoices')
        ->where('invoice_status', 2)
        ->where('invoice_sales_person_category', $request->category)
        ->where('branch', $request->branch)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->sum('invoice_total_price');

        $branch_total_house_list = \DB::table('invoices')
        ->where('invoice_status', 2)
        ->where('invoice_sales_person_category', $request->category)
        ->where('branch', $request->branch)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->get();

        // Rejected Orders
        $branch_total_reject = \DB::table('invoices')
        ->where('invoice_status', 0)
        ->where('invoice_sales_person_category', $request->category)
        ->where('branch', $request->branch)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->sum('invoice_total_price');

        $branch_total_reject_list = \DB::table('invoices')
        ->where('invoice_status', 0)
        ->where('invoice_sales_person_category', $request->category)
        ->where('branch', $request->branch)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->get();

       $order =  \DB::table('orders')
        ->where('category', $request->category)
        ->where('branch', $request->branch)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->get();


        $orders =  \DB::table('invoices')
        ->where('branch', $request->branch)
        ->where('invoice_sales_person_category', $request->category)
        ->where('invoice_status', 1)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->sum('invoice_total_price');

        $orderDiscounted =  \DB::table('orders')
        ->join('discounts', 'orders.id','discounts.order_number')
        ->where('discounts.branch', $request->branch)
        ->where('orders.category', $request->category)
        ->WhereDate('orders.created_at','>=', $from)
            ->WhereDate('orders.created_at','<=', $to)
        ->get();
        
        

        return view('sales.sales-person-category', [
            'sales_today_branch' => $sales_today_branch,
            'branch_total_general' => $branch_total_general,
            'branch_total_house' => $branch_total_house,
            'branch_total_reject' => $branch_total_reject,
            'branch_total_reject_list' => $branch_total_reject_list,
            'branch_total_house_list' => $branch_total_house_list,
            'order' => $order,
            'deliveriesToday' => $deliveriestoday,
            'orders' => $orders,
            'discounts' => $discounts,
            'confirmed' => $confirmed,
            'discounted_coupon' => $orderDiscounted
        ]);

    }

    }



    public function allDepartmentSummaryBranch(Request $request)
    {
        $value = explode(' - ', $request->date);
        
        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        if ($from == $to) {
            $items = \DB::table('invoices')
            ->selectRaw('invoice_category as name, sum(invoice_total_price) as total, sum(invoice_quantity) as quantity')
                        ->where('branch', $request->branch)
            ->where('invoice_category', '!=', "TRANSPORT")
            ->groupBy('invoice_category')
            ->whereDate('created_at', $from)
            ->where('invoice_status', 1)
            ->get();
    
    
            $itemsQuantity = \DB::table('invoices')
                        ->where('invoice_category', '!=', "TRANSPORT")
            ->where('branch', $request->branch)
            ->whereDate('created_at', $from)
            ->where('invoice_status', 1)
            ->sum('invoice_quantity');
    
            $itemsPrice = \DB::table('invoices')
                        ->where('branch', $request->branch)
            ->where('invoice_category', '!=', "TRANSPORT")
            ->whereDate('created_at', $from)
            ->where('invoice_status', 1)
            ->sum('invoice_total_price');

            $dicount = \DB::table('discounts')
            ->where('branch', $request->branch)
            ->whereDate('created_at', $from)
            ->where('is_held', 0)
        ->sum('amount_deducted');
    
            return view('department-summary-all-using-date', [
                'items' => $items,
                'itemsQuantity' => $itemsQuantity,
                'itemsPrice' => $itemsPrice,
                'discount' => $dicount
            ]);
        }else {
            $items = \DB::table('invoices')
                ->selectRaw('invoice_category as name, sum(invoice_total_price) as total, sum(invoice_quantity) as quantity')
                                ->where('branch', $request->branch)
                ->groupBy('invoice_category')
                ->where('invoice_category', '!=', "TRANSPORT")
                ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->where('invoice_status', 1)
                ->get();
    
    
            $itemsQuantity = \DB::table('invoices')
                                ->where('branch', $request->branch)
                ->where('invoice_category', '!=', "TRANSPORT")
                ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->where('invoice_status', 1)
                ->sum('invoice_quantity');
        
            $itemsPrice = \DB::table('invoices')
                ->where('branch', $request->branch)
                                ->where('invoice_category', '!=', "TRANSPORT")
                ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->where('invoice_status', 1)
                ->sum('invoice_total_price');


                $dicount = \DB::table('discounts')
                ->where('branch', $request->branch)
                ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
                ->where('is_held', 0)
        ->sum('amount_deducted');
        
            return view('department-summary-all-using-date', [
                'items' => $items,
                'itemsQuantity' => $itemsQuantity,
                'itemsPrice' => $itemsPrice,
                'discount' => $dicount
            ]);
        }
    }



    
    
public function allItemSummaryBranches(Request $request)
{
    $value = explode(' - ', $request->date);
     

    $source1 = $value[0];
    $date1 = new DateTime($source1);
    $from = $date1->format('Y-m-d');

    $source2 = $value[1];
    $date2 = new DateTime($source2);
    $to = $date2->format('Y-m-d');


    if ($from == $to) {
        $items = \DB::table('invoices')
        ->selectRaw('invoice_product_name as name, sum(invoice_total_price) as total, sum(invoice_quantity) as quantity, invoice_unit_price as price')
                ->where('branch', $request->branch)
        ->where('invoice_category', '!=', "TRANSPORT")
        ->groupBy('invoice_product_name')
        ->groupBy('invoice_unit_price')
        ->whereDate('created_at', $from)
        ->whereIn('invoice_status', [1,2])
        ->get();


        $itemsQuantity = \DB::table('invoices')
                ->where('branch', $request->branch)
        ->where('invoice_category', '!=', "TRANSPORT")
        ->whereDate('created_at', $from)
        ->whereIn('invoice_status', [1,2])
        ->sum('invoice_quantity');

        $itemsPrice = \DB::table('invoices')
                ->where('branch', $request->branch)
        ->where('invoice_category', '!=', "TRANSPORT")
        ->whereDate('created_at', $from)
        ->whereIn('invoice_status', [1,2])
        ->sum('invoice_total_price');

        $dicount = \DB::table('discounts')
        ->where('branch', $request->branch)
        ->whereDate('created_at', $from)
        ->where('is_held', 0)
        ->sum('amount_deducted');


        return view('item-summary-all', [
            'items' => $items,
            'itemsQuantity' => $itemsQuantity,
            'itemsPrice' => $itemsPrice,
            'discount'=> $dicount,
        ]);
    }else {
       $items = \DB::table('invoices')
        ->selectRaw('invoice_product_name as name, sum(invoice_total_price) as total, sum(invoice_quantity) as quantity, invoice_unit_price as price')
                ->where('branch', $request->branch)
        ->where('invoice_category', '!=', "TRANSPORT")
        ->whereIn('invoice_status', [1,2])
        ->groupBy('invoice_product_name')
        ->groupBy('invoice_unit_price')
        ->WhereDate('created_at','>=', $from)
        ->WhereDate('created_at','<=', $to)
        ->get();


        $itemsQuantity = \DB::table('invoices')
                ->where('branch', $request->branch)
        ->where('invoice_category', '!=', "TRANSPORT")
        ->whereIn('invoice_status', [1,2])
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->sum('invoice_quantity');

        $itemsPrice = \DB::table('invoices')
                ->where('branch', $request->branch)
        ->where('invoice_category', '!=', "TRANSPORT")
        ->whereIn('invoice_status', [1,2])
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->sum('invoice_total_price');


        $dicount = \DB::table('discounts')
        ->where('branch', $request->branch)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->where('is_held', 0)
        ->sum('amount_deducted');

        return view('item-summary-all', [
            'items' => $items,
            'itemsQuantity' => $itemsQuantity,
            'itemsPrice' => $itemsPrice,
            'discount'=> $dicount,
        ]);
        }
    }



    

}
