<?php

namespace App\Http\Controllers;

use App\Models\GoodReceipt;
use App\Models\ManufactureBOM;
use Illuminate\Http\Request;
use Carbon\Carbon;
use App\Models\ItemStockLedger;
use App\Models\InventoryReport;
use DateTime;

class GoodReceiptController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }


    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {   
        
        $this->validate($request, [
            'g_r_vendor' => 'required',
            'g_r_item' => 'required',
            'g_r_quantity' => 'required',
            'g_r_rate' => 'required'
        ]);

        $dayClose = \DB::table('close_days')->first();

        $item_unit = \DB::table('items')->where('id', $request->g_r_item)->first();
        $vendor = \DB::table('vendors')->where('vendor_name', request('g_r_vendor'))->first();
        // search Unit
    
         if ($request -> g_r_unit !== null) {
            
            $getUnit = \DB::table('unit_conversions')
            ->where('item_id', $item_unit -> id)
            ->where('conversion_unit', $request -> g_r_unit)
            ->first();

            if ($getUnit == null) {
                $convertQty = $request -> g_r_quantity;
                $unit_measure = $item_unit->item_unit;
            }else {
                $convertQty = ((float)$getUnit->base_unit_figure*(float)$request -> g_r_quantity)/(float)$getUnit->conversion_unit_figure;
                $unit_measure = $item_unit->item_unit;
            }

        
        }else{
            $convertQty = $request -> g_r_quantity ;
        }

       $checkItem = \DB::table('good_receipts')->where('g_r_transaction_id', request('g_r_transaction_id'))
        ->where('g_r_item_id', $item_unit->id)
        ->where('user_id', auth()->user()->id)
        ->first();

        if (!empty($checkItem)) {
            abort();
        }

        

        $data = new GoodReceipt;
        $data ->user_id = auth()->user()->id;
        $data ->station = auth()->user()->station;
        $data ->g_r_transaction_id = $request->g_r_transaction_id;
        $data->g_r_vendor = $request->g_r_vendor;
        $data -> vendor_id = $vendor->id;
        $data->g_r_date = $dayClose->day_close;
        $data->g_r_note = $request -> g_r_note ;
        $data->g_r_category = $item_unit-> item_category;
        $data->g_r_item =  $item_unit->item_name ;
        $data->g_r_item_id =  $item_unit->id ;
        $data->g_r_quantity = $convertQty ;
        $data->g_r_rate = $request -> g_r_rate ;
        $data->g_r_unit =  empty($request -> g_r_unit) ? $item_unit->item_unit : $request -> g_r_unit;
        $data->g_r_state = "P" ;
        $data->g_r_grn =  empty($request ->g_r_grn) ? "GNR-" . rand(3,300) . date('Ymd')  : "M-GRN" . $request ->g_r_grn;
        $data->g_r_total = $request -> g_r_quantity * $request -> g_r_rate ;
        $data->save();
        return 123;
    }


    public function saveGoodsReceipt()
    {   

        try {
            // Perform DB Transaction
            \DB::beginTransaction();

        $dayClose = \DB::table('close_days')->first();
        // Save or Update to stock Ledger during Comfirmation
        $item = \DB::table('good_receipts')
        ->where('g_r_state', "P")
        ->where('user_id', auth()->user()->id)
        ->get();


        foreach ($item as $item) {

           $it =  \DB::table('items')->where('id', $item->g_r_item_id)->first();

            $to =  $item->g_r_date;
            $from =  $item->g_r_date;


            $balance_b_f =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $item->g_r_item_id)->whereDate('date', '<', $item->g_r_date)->sum('stock_in') - 
            \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $item->g_r_item_id)->whereDate('date', '<', $item->g_r_date)->sum('stock_out');
            

           $stock_in =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $item->g_r_item_id)
                                       ->WhereDate('date', $from)
                                       ->WhereDate('date', $to)
                                       ->sum('stock_in');
                                       
           $stock_out =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $item->g_r_item_id)
           ->WhereDate('date', $from)
           ->WhereDate('date', $to)
           ->sum('stock_out');

           $costing = \DB::table('average_costs')->where('item_id', $item->g_r_item_id)
           ->orderBy('id', "DESC")
           ->first();

           $Current_balance = ($stock_in - $stock_out) + $balance_b_f;

           if ($Current_balance < 0) {
               $Current_balance = 0;
           }else {
               $Current_balance = $Current_balance;
           }


          $avg = (($item->g_r_rate * $item->g_r_quantity) + ($Current_balance * (empty($costing) ? 0 : $costing->weighted_average))) / ($item->g_r_quantity +  $Current_balance);


            \App\Models\AverageCost::create([
               'item_id' => $item->g_r_item_id,
               'date' => $item->g_r_date,
               'weighted_average' => $avg,
           ]);

           \App\Models\StockTransaction::create([
               'user_id' => auth()->id(),
               'item_id' => $item->g_r_item_id,
               'description' => 'Receipts',
               'unit' =>  $it->item_unit,
               'station' => auth()->user()->station,
               'date' => $item->g_r_date,
               'stock_in' => $item->g_r_quantity,
               'cost' => $item->g_r_rate
            ]);



            }

        

            $existing = \DB::table('item_b_o_m_s')->where('bom_id', $item->g_r_item_id)->get();

            foreach ($existing as $key => $existing) {

               $item_self = \DB::table('item_b_o_m_s')->where('bom_id', $item->g_r_item_id)->update([
                   'item_bom_unit_rate' => $avg*($existing->item_bom_unit)
               ]);

               $manufacturing = \DB::table('items')->where('item_manufacturing', 1)->get();
               foreach ($manufacturing as $key => $stock) {

                $estimated_cost = \DB::table('item_b_o_m_s')->where('item_id', $stock->id)
                    ->selectRaw('item_id as item_id, sum(item_bom_unit_rate) as cost')
                    ->groupBy('item_id')
                    ->get();

                    foreach ($estimated_cost as $key => $estimated_costing) {
                        
                        \DB::table('manufacture_b_o_m_s')
                        ->where('item_id', $estimated_costing->item_id)
                        ->update([
                            'estimated_cost' => $estimated_costing->cost
                        ]);

                        $checkComing = \DB::table('material_product_compositons')
                        ->where('composition_id',  $estimated_costing->item_id)
                        ->update([
                            'cost' => \DB::raw('unit_measure * ' . $estimated_costing->cost)
                        ]);
                    }

                    
                   
               }
   

            }

            \DB::commit(); 
                    
            return back()->with('status', 'Goods Receipt Note Saved Successfully');
   
           } catch (\Throwable $th) {
               \DB::rollback();
               return response([
                   'status' => 501,
                   "Message" => $th
               ]);
           }
   

    }   

    public function saveGoodsReceiptPrint($transaction)
    {

        $dayClose = \DB::table('close_days')->first();
         // Save or Update to stock Ledger during Comfirmation
         $items = \DB::table('good_receipts')
         ->where('g_r_state', "P")
         ->where('user_id', auth()->user()->id)
         ->get();
 

         try {
            // Perform DB Transaction
            \DB::beginTransaction();

         foreach ($items as $item) {

            $it =  \DB::table('items')->where('id', $item->g_r_item_id)->first();

             
            $vendor = \DB::table('good_receipts')
            ->where('g_r_state', "P")
            ->where('user_id', auth()->user()->id)->first();
            

            \App\Models\StockTransaction::create([
                'user_id' => auth()->id(),
                'item_id' => $item->g_r_item_id,
                'description' => 'Receipts',
                'note' => '<a href=' . '/dashboard/goods-receipt-note/' . $transaction .'>' . $transaction .'</a>' ,
                'unit' =>  $it->item_unit,
                'station' => auth()->user()->station,
                'date' => $item->g_r_date,
                'stock_in' => $item->g_r_quantity,
                'cost' => $item->g_r_rate,
                'transactions_id' => $transaction
        ]);


        \App\Models\VendorTransaction::create([
                'user_id' => auth()->id(),
                'item_id' => $item->g_r_item_id,
                'vendor_id' => $item->vendor_id,
                'description' => 'Issue',
                'note' => '<a href=' . '/dashboard/goods-receipt-note/' . $transaction .'>' . $transaction .'</a>' ,
                'station' => auth()->user()->station,
                'date' => $item->g_r_date,
                'issue' => $item->g_r_quantity,
                'cost' => $item->g_r_rate,
                'transaction_id' => $transaction
        ]);


        $checkISL = \DB::table('item_stock_ledger_summaries')->where('item_id', $item->g_r_item_id)
        ->where('date', $item->g_r_date)->where('station', auth()->user()->station)->first();

        if (empty($checkISL)) {
            \App\Models\ItemStockLedgerSummary::create([
                'opening_stock' => 0,
                'date' => $item->g_r_date,
                'station' => auth()->user()->station,
                'item_id' => $item->g_r_item_id,
                'item_unit' => $it->item_unit,
                'item_name' => $it->item_name,
                'item_category' => $it->item_category,
                'item_code' => $it->item_code,
                'inactive_station' => $it->inactive_station
            ]);
        }

        

 
             }


             foreach ($items as $item) {
                $item_check =  \DB::table('items')->where('id', $item->g_r_item_id)->first();
                

                $to =  $item->g_r_date;
                $from =  $item->g_r_date;


                $balance_b_f =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $item->g_r_item_id)->whereDate('date', '<', $item->g_r_date)->sum('stock_in') - 
                \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $item->g_r_item_id)->whereDate('date', '<', $item->g_r_date)->sum('stock_out');
                

                $stock_in =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $item->g_r_item_id)
                                            ->WhereDate('date', $from)
                                            ->WhereDate('date', $to)
                                            ->sum('stock_in');
                                            
                $stock_out =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $item->g_r_item_id)
                ->WhereDate('date', $from)
                ->WhereDate('date', $to)
                ->sum('stock_out');


            $closing = ($stock_in - $stock_out) + $balance_b_f;



            $getAllCOst =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $item->g_r_item_id)->get();

            if (empty($getAllCOst)) {
               $total_cost = 0;
            }else {

            $sumReCost = 0 ;
            $sumIssueCost = 0 ;

                foreach ($getAllCOst as $key => $cost) {

                    $sumIssueCost += round($cost->stock_out, 2) * round($cost->cost, 2);
                    $sumReCost += round($cost->stock_in, 2) * round($cost->cost, 2);

                }

                $avg =  (round($sumReCost, 2) - round($sumIssueCost, 2)) / ($closing == 0 ? 1 :  round($closing, 2));
                // $avg = ($avg < 0 ? 0 : $avg);

            }


            


                \DB::table('item_b_o_m_s')->where('bom_id', $item->g_r_item_id)->update([
                    'item_bom_unit_rate' => \DB::raw($avg . '* item_bom_unit')
                ]);


                \DB::table('material_product_compositons')
                    ->where('composition_id', $item->g_r_item_id)
                    ->update([
                        'adjusted_cost' => \DB::raw('unit_measure * ' . $avg),
                        'cost' => \DB::raw('adjusted_cost')
                    ]);

                

                   $checkInventory = \DB::table('item_b_o_m_s')->where('item_id', $item->g_r_item_id)->first();

                   if (empty($checkInventory)) {
                        \App\Models\ItemBOM::Create([
                            'item_id' => $item->g_r_item_id,
                            'bom_id' => $item->g_r_item_id,
                            'user_id' => auth()->id(),
                            'item_bom_name' => $item->g_r_item,
                            'item_unit_measure' => $item->g_r_unit,
                            'item_bom_unit' => 1,
                            'item_bom_unit_rate' => $avg,
                            'chain_id' => $item->g_r_item_id
                        ]);
                   }

                    
             }


            $manfacturing_products = \DB::table('items')->where('item_manufacturing', 1)->get();

                foreach ($manfacturing_products as $key => $manfacturing_product) {

                    $inv_cost_ = \DB::table('item_b_o_m_s')
                    ->where('item_id', $manfacturing_product->id)
                    ->sum('item_bom_unit_rate');


                    \DB::table('material_product_compositons')
                    ->where('composition_id', $manfacturing_product->id)
                    ->update([
                        'adjusted_cost' => \DB::raw('unit_measure * ' . $inv_cost_),
                        'cost' => \DB::raw('adjusted_cost')
                    ]);
                }

         
 
         $complete = \DB::table('good_receipts')
         ->where('g_r_state', "P")
         ->where('user_id', auth()->user()->id)
         ->update([
             'g_r_state' => "C"
         ]);

         $saveGRN = \DB::table('good_receipts')
         ->where('g_r_transaction_id', $transaction)->first();


         \App\Models\GoodReceiptList::create([
                'user_id'=>auth()->id(),
                'transaction_id' => $saveGRN->g_r_transaction_id,
                'grn_id' => $saveGRN->g_r_grn,
                'note' => session()->get('purchase_note')
         ]);


         \DB::commit(); 

         session()->forget(['purchase_note']);
                 
        return redirect()->to('/dashboard/goods-receipt-note/' . $transaction);

    } catch (\Throwable $th) {
        \DB::rollback();
        return response([
            'status' => 501,
            "Message" => $th
        ]);
    }

       

    }



    public function RunWac(Type $var = null)
    {
        return $allcost = \DB::table('b_o_m_categories')->selectRaw('item_id as item_id, sum(cost) as cost')
        ->groupBy('item_id')
        ->pluck('item_id');

        return \DB::table('item_b_o_m_s')->whereIn('bom_id', $allcost)->get();
    }
    
    



    public function clearGoodsReceipt()
    {
        $clear = \DB::table('good_receipts')
        ->where('g_r_state', "P")
        ->where('user_id', auth()->user()->id)
        ->delete();
        return back()->with('status', 'Transactions Cleared SUccessfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\GoodReceipt  $goodReceipt
     * @return \Illuminate\Http\Response
     */
    public function show($transaction)
    {   
        // find Vendor
        $vfind = \DB::table('good_receipts')->where('g_r_transaction_id',$transaction)->first();
        $vendor = \DB::table('vendors')->where('vendor_name', $vfind->g_r_vendor)->first();
        // end find


        $reciepts = \DB::table('good_receipts')->where('g_r_transaction_id', $transaction)->get();
        $sum_re =  $reciepts->sum('g_r_total');
        return view('good-receipt.view-receipt-note', [
            'reciept_goods' => $reciepts,
            'sum_re' => $sum_re,
            'vendor' => $vendor,
            'trans_data' => $vfind
        ]);
    }


    public function downloadPrint($transaction)
    {   
        // find Vendor
        $vfind = \DB::table('good_receipts')->where('g_r_transaction_id',$transaction)->first();
        $vendor = \DB::table('vendors')->where('vendor_name', $vfind->g_r_vendor)->first();
        // end find


        $reciepts = \DB::table('good_receipts')->where('g_r_transaction_id',$transaction)->get();
        $sum_re =  $reciepts->sum('g_r_total');
        return view('good-receipt.print-good-receipt', [
            'reciept_goods' => $reciepts,
            'sum_re' => $sum_re,
            'vendor' => $vendor,
            'trans_data' => $vfind

        ]);
    }


    public function returnGoods($transaction)
    {
        $reciepts = \DB::table('good_receipts')->where('g_r_transaction_id',$transaction)->get();

        try {
            // Perform DB Transaction
            \DB::beginTransaction();


        foreach ($reciepts as $key => $reciept) {
            \App\Models\StockTransaction::create([
                'user_id' => auth()->id(),
                'item_id' => $reciept->g_r_item_id,
                'description' => 'Issues',
                'note' => "Goods Return" . '<a href=' . '/dashboard/goods-receipt-note/' . $transaction .'>' . $transaction .'</a>' ,
                'unit' =>  $reciept->g_r_unit,
                'station' => auth()->user()->station,
                'date' => $reciept->g_r_date,
                'stock_out' => $reciept->g_r_quantity,
                'cost' => $reciept->g_r_rate,
                'transactions_id' => $transaction
             ]);


             \App\Models\VendorTransaction::create([
                'user_id' => auth()->id(),
                'item_id' => $reciept->g_r_item_id,
                'vendor_id' => $reciept->vendor_id,
                'description' => 'Receipt',
                'note' => "Goods Return " . '<a href=' . '/dashboard/goods-receipt-note/' . $transaction .'>' . $transaction .'</a>' ,
                'station' => auth()->user()->station,
                'date' => $reciept->g_r_date,
                'receipt' => $reciept->g_r_quantity,
                'cost' => $reciept->g_r_rate,
                'transaction_id' => $transaction
        ]);


        }


        \App\Models\GoodReceiptList::where('transaction_id', $transaction)->update([
            'return_state' => true
        ]);


        \DB::table('good_receipts')->where('g_r_transaction_id',$transaction)->update([
            'return_status' => true
        ]);

        \DB::commit(); 
                    
        return back()->with('status', "Good Returned Successfully");

       } catch (\Throwable $th) {
           \DB::rollback();
           return response([
               'status' => 501,
               "Message" => $th
           ]);
       }
    }



    public function GRNListDate(Request $request)
    {
        $this->validate($request, [
            'vendor' => 'required'
        ]);


        $value = explode(' - ', $request->date);
         

        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        if ($from == $to) {
                if ($request->vendor == "All Vendors") {
                    $lists = \DB::table('good_receipts')
                    ->selectRaw('g_r_vendor as vendor, g_r_transaction_id as transaction, g_r_date as date, sum(g_r_rate * g_r_quantity) as total_amount')
                    ->where('g_r_state', "C")
                    ->whereDate('g_r_date', $from)
                    ->groupBy('vendor')
                    ->groupBy('transaction')
                    ->groupBy('date')
                    ->get();

                    return view('good-receipt.goods-receipt-list', [
                        'lists'=>$lists
                    ]);

                }else{
                    
                    $vendor = \DB::table('vendors')->where('vendor_name', $request->vendor)->first();

                    if ($from == $to) {

                        \DB::table('vendor_transactions')
                        ->where('vendor_id', $vendor->id)->get();
    
                        $balance_b_f =  \DB::table('vendor_transactions')
                        ->where('vendor_id', $vendor->id)
                        ->WhereDate('date', '<', $to)
                        ->sum('receipt') - 
            
                        \DB::table('vendor_transactions')
                        ->where('vendor_id', $vendor->id)
                        ->WhereDate('date', '<', $to)
                        ->sum('issue');
            
                                  
                    $transactions_db = \DB::table('vendor_transactions')->where('vendor_id', $vendor->id)
                        ->WhereDate('date','>=', $from)
                        ->WhereDate('date','<=', $to)
                        ->OrderBy('id', 'DESC')
                        ->get();
                        
                        $ending_b_f = null;
                    }else {
                        
                        $balance_b_f =  \DB::table('vendor_transactions')->where('vendor_id', $vendor->id)->whereDate('date', '<', $from)->sum('receipt') - 
                        \DB::table('vendor_transactions')->where('vendor_id', $vendor->id)->whereDate('date', '<', $from)->sum('issue');
            
                        $ending_b_f =  \DB::table('vendor_transactions')->where('vendor_id', $vendor->id)
                        ->WhereDate('date','>=', $from)
                        ->WhereDate('date','<=', $to)
                        ->OrderBy('id', 'DESC')->first();
            
                       $transactions_db = \DB::table('vendor_transactions')->where('vendor_id', $vendor->id)
                        ->WhereDate('date','>=', $from)
                        ->WhereDate('date','<=', $to)
                        ->get();
                    }
                        

                    return view('good-receipt.vendor_transactions', [
                            'transactions_db' => $transactions_db,
                            'balance_b_f_' => $balance_b_f,
                            'from' => $from,
                            'to' => $to,
                            'ending_b_f' => $ending_b_f,
                            'main_balance' => $transactions_db->first(),
                            'vendor' => $vendor
                    ]);
                    
                }
               

        }else{

            if ($request->vendor == "All Vendors") {
                $lists = \DB::table('good_receipts')
                ->selectRaw('g_r_vendor as vendor, g_r_transaction_id as transaction, g_r_date as date, sum(g_r_rate * g_r_quantity) as total_amount')
                ->where('g_r_state', "C")
                ->WhereDate('g_r_date','>=', $from)
                ->WhereDate('g_r_date','<=', $to)
                ->groupBy('vendor')
                ->groupBy('transaction')
                ->groupBy('date')
                ->get();

                return view('good-receipt.goods-receipt-list', [
                    'lists'=>$lists
                ]);

            }else {

                $vendor = \DB::table('vendors')->where('vendor_name', $request->vendor)->first();

                if ($from == $to) {

                    $balance_b_f =  \DB::table('vendor_transactions')
                    ->where('vendor_id', $vendor->id)
                    ->WhereDate('date', '<', $to)
                    ->sum('receipt') - 
        
                    \DB::table('stock_transactions')
                    ->where('vendor_id', $vendor->id)
                    ->WhereDate('date', '<', $to)
                    ->sum('issue');
        
                              
                    $transactions_db = \DB::table('vendor_transactions')->where('vendor_id', $vendor->id)
                    ->WhereDate('date','>=', $from)
                    ->WhereDate('date','<=', $to)
                    ->OrderBy('id', 'DESC')
                    ->get();
                    
                    $ending_b_f = null;
                }else {
                    $balance_b_f =  \DB::table('vendor_transactions')->where('vendor_id', $vendor->id)->whereDate('date', '<', $from)->sum('receipt') - 
                    \DB::table('vendor_transactions')->where('vendor_id', $vendor->id)->whereDate('date', '<', $from)->sum('issue');
        
                    $ending_b_f =  \DB::table('vendor_transactions')->where('vendor_id', $vendor->id)
                    ->WhereDate('date','>=', $from)
                    ->WhereDate('date','<=', $to)
                    ->OrderBy('id', 'DESC')->first();
        
                   $transactions_db = \DB::table('vendor_transactions')->where('vendor_id', $vendor->id)
                    ->WhereDate('date','>=', $from)
                    ->WhereDate('date','<=', $to)
                    ->get();
                }
                return view('good-receipt.vendor_transactions', [
                        'transactions_db' => $transactions_db,
                        'balance_b_f_' => $balance_b_f,
                        'from' => $from,
                        'to' => $to,
                        'ending_b_f' => $ending_b_f,
                        'main_balance' => $transactions_db->first(),
                        'vendor' => $vendor
                ]);
            }
                
        }
    }




    public function GRNListDateFiler(Request $request)
    {
        $this->validate($request, [
            'vendor' => 'required',
            'start_date' => 'required',
            'end_date' => 'required'
        ]);


        $from = request('start_date');
        $to = request('end_date');
        

        if ($from == $to) {
                if ($request->vendor == "All Vendors") {
                    $lists = \DB::table('good_receipts')
                    ->selectRaw('g_r_vendor as vendor, g_r_transaction_id as transaction, g_r_date as date, sum(g_r_total) as total_amount')
                    ->where('g_r_state', "C")
                    ->whereDate('g_r_date', $from)
                    ->groupBy('vendor')
                    ->groupBy('transaction')
                    ->groupBy('date')
                    ->get();

                    return view('good-receipt.goods-receipt-list', [
                        'lists'=>$lists
                    ]);

                }else{
                    
                    $vendor = \DB::table('vendors')->where('vendor_name', $request->vendor)->first();

                    if ($from == $to) {

                        \DB::table('vendor_transactions')
                        ->where('vendor_id', $vendor->id)->get();
    
                        $balance_b_f =  \DB::table('vendor_transactions')
                        ->where('vendor_id', $vendor->id)
                        ->WhereDate('date', '<', $to)
                        ->sum('receipt') - 
            
                        \DB::table('vendor_transactions')
                        ->where('vendor_id', $vendor->id)
                        ->WhereDate('date', '<', $to)
                        ->sum('issue');
            
                                  
                    $transactions_db = \DB::table('vendor_transactions')->where('vendor_id', $vendor->id)
                        ->WhereDate('date','>=', $from)
                        ->WhereDate('date','<=', $to)
                        ->OrderBy('id', 'DESC')
                        ->get();
                        
                        $ending_b_f = null;
                    }else {
                        
                        $balance_b_f =  \DB::table('vendor_transactions')->where('vendor_id', $vendor->id)->whereDate('date', '<', $from)->sum('receipt') - 
                        \DB::table('vendor_transactions')->where('vendor_id', $vendor->id)->whereDate('date', '<', $from)->sum('issue');
            
                        $ending_b_f =  \DB::table('vendor_transactions')->where('vendor_id', $vendor->id)
                        ->WhereDate('date','>=', $from)
                        ->WhereDate('date','<=', $to)
                        ->OrderBy('id', 'DESC')->first();
            
                       $transactions_db = \DB::table('vendor_transactions')->where('vendor_id', $vendor->id)
                        ->WhereDate('date','>=', $from)
                        ->WhereDate('date','<=', $to)
                        ->get();
                    }
                        

                    return view('good-receipt.vendor_transactions', [
                            'transactions_db' => $transactions_db,
                            'balance_b_f_' => $balance_b_f,
                            'from' => $from,
                            'to' => $to,
                            'ending_b_f' => $ending_b_f,
                            'main_balance' => $transactions_db->first(),
                            'vendor' => $vendor
                    ]);
                    
                }
               

        }else{

            if ($request->vendor == "All Vendors") {
                $lists = \DB::table('good_receipts')
                ->selectRaw('g_r_vendor as vendor, g_r_transaction_id as transaction, g_r_date as date, sum(g_r_total) as total_amount')
                ->where('g_r_state', "C")
                ->WhereDate('g_r_date','>=', $from)
                ->WhereDate('g_r_date','<=', $to)
                ->groupBy('vendor')
                ->groupBy('transaction')
                ->groupBy('date')
                ->get();

                return view('good-receipt.goods-receipt-list', [
                    'lists'=>$lists
                ]);

            }else {

                $vendor = \DB::table('vendors')->where('vendor_name', $request->vendor)->first();

                if ($from == $to) {

                    $balance_b_f =  \DB::table('vendor_transactions')
                    ->where('vendor_id', $vendor->id)
                    ->WhereDate('date', '<', $to)
                    ->sum('receipt') - 
        
                    \DB::table('stock_transactions')
                    ->where('vendor_id', $vendor->id)
                    ->WhereDate('date', '<', $to)
                    ->sum('issue');
        
                              
                    $transactions_db = \DB::table('vendor_transactions')->where('vendor_id', $vendor->id)
                    ->WhereDate('date','>=', $from)
                    ->WhereDate('date','<=', $to)
                    ->OrderBy('id', 'DESC')
                    ->get();
                    
                    $ending_b_f = null;
                }else {
                    $balance_b_f =  \DB::table('vendor_transactions')->where('vendor_id', $vendor->id)->whereDate('date', '<', $from)->sum('receipt') - 
                    \DB::table('vendor_transactions')->where('vendor_id', $vendor->id)->whereDate('date', '<', $from)->sum('issue');
        
                    $ending_b_f =  \DB::table('vendor_transactions')->where('vendor_id', $vendor->id)
                    ->WhereDate('date','>=', $from)
                    ->WhereDate('date','<=', $to)
                    ->OrderBy('id', 'DESC')->first();
        
                   $transactions_db = \DB::table('vendor_transactions')->where('vendor_id', $vendor->id)
                    ->WhereDate('date','>=', $from)
                    ->WhereDate('date','<=', $to)
                    ->get();
                }
                return view('good-receipt.vendor_transactions', [
                        'transactions_db' => $transactions_db,
                        'balance_b_f_' => $balance_b_f,
                        'from' => $from,
                        'to' => $to,
                        'ending_b_f' => $ending_b_f,
                        'main_balance' => $transactions_db->first(),
                        'vendor' => $vendor
                ]);
            }
                
        }
    }



    public function GRNListDatePrint(Request $request)
    {
        $this->validate($request, [
            'vendor' => 'required'
        ]);


        $value = explode(' - ', $request->date);
         

        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        if ($from == $to) {
                if ($request->vendor == "All Vendors") {
                    $lists = \DB::table('good_receipts')
                    ->selectRaw('g_r_vendor as vendor, g_r_transaction_id as transaction, g_r_date as date, sum(round(round(g_r_rate,2) * round(g_r_quantity,2),2)) as total_amount')
                    ->where('g_r_state', "C")
                    ->whereDate('g_r_date', $from)
                    ->groupBy('vendor')
                    ->groupBy('transaction')
                    ->groupBy('date')
                    ->get();
                }else{
                    $lists = \DB::table('good_receipts')
                    ->selectRaw('g_r_vendor as vendor, g_r_transaction_id as transaction, g_r_date as date, sum(round(round(g_r_rate,2) * round(g_r_quantity,2),2)) as total_amount')
                    ->where('g_r_state', "C")
                    ->whereDate('g_r_date', $from)
                    ->groupBy('vendor')
                    ->groupBy('transaction')
                    ->groupBy('date')
                    ->where('g_r_vendor', $request->vendor)
                    ->get();
                    }
                return view('good-receipt.print-goods-receipt-list', [
                    'lists'=>$lists
                ]);

        }else{

            if ($request->vendor == "All Vendors") {
                $lists = \DB::table('good_receipts')
                ->selectRaw('g_r_vendor as vendor, g_r_transaction_id as transaction, g_r_date as date, sum(g_r_rate * g_r_quantity) as total_amount')
                ->where('g_r_state', "C")
                ->WhereDate('g_r_date','>=', $from)
                ->WhereDate('g_r_date','<=', $to)
                ->groupBy('vendor')
                ->groupBy('transaction')
                ->groupBy('date')
                ->get();
            }else {
            $lists = \DB::table('good_receipts')
                ->selectRaw('g_r_vendor as vendor, g_r_transaction_id as transaction, g_r_date as date, sum(g_r_rate * g_r_quantity) as total_amount')
                ->where('g_r_state', "C")
                ->WhereDate('g_r_date','>=', $from)
                ->WhereDate('g_r_date','<=', $to)
                ->groupBy('vendor')
                ->groupBy('transaction')
                ->groupBy('date')
                ->where('g_r_vendor', $request->vendor)
                ->get();
            }
                return view('good-receipt.print-goods-receipt-list', [
                    'lists'=>$lists
                ]);
        }
    }





    public function showAll()
    {   
         $dayClose = \DB::table('close_days')->first();
         $lists = \DB::table('good_receipts')
        ->selectRaw('g_r_vendor as vendor, g_r_transaction_id as transaction, g_r_date as date, sum(round(round(g_r_rate,2) * round(g_r_quantity,2),2)) as total_amount')
        ->groupBy('vendor')
        ->groupBy('transaction')
        ->groupBy('date')
        ->where('g_r_state', "C")
        ->whereDate('g_r_date', $dayClose->day_close)
        ->get();
        return view('good-receipt.goods-receipt-list', [
            'lists'=>$lists
        ]);
    }


    public function showAllPrint()
    {   
         $dayClose = \DB::table('close_days')->first();
         $lists = \DB::table('good_receipts')
        ->selectRaw('g_r_vendor as vendor, g_r_transaction_id as transaction, g_r_date as date, sum(round(round(g_r_rate,2) * round(g_r_quantity,2),2)) as total_amount')
        ->groupBy('vendor')
        ->groupBy('transaction')
        ->groupBy('date')
        ->where('g_r_state', "C")
        ->whereDate('g_r_date', $dayClose->day_close)
        ->get();
        return view('good-receipt.goods-receipt-list', [
            'lists'=>$lists
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\GoodReceipt  $goodReceipt
     * @return \Illuminate\Http\Response
     */
    public function edit(GoodReceipt $goodReceipt)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\GoodReceipt  $goodReceipt
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, GoodReceipt $goodReceipt)
    {
        //
    }

    
    public function DeleteDock(GoodReceipt $goodReceipt)
    {
        $goodReceipt->delete();
        return 123;
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\GoodReceipt  $goodReceipt
     * @return \Illuminate\Http\Response
     */
    public function destroy(GoodReceipt $goodReceipt)
    {
        //
    }
}
