<?php

namespace App\Http\Controllers;

use App\Models\InventoryReport;
use Illuminate\Http\Request;
use DateTime;
use Carbon\Carbon;

class InventoryReportController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    

    public function issueRegister()
    {   
        $dayClose = \DB::table('close_days')->first();
        $inventory = \DB::table('issue_vouchers')
                ->selectRaw('issue_item as name, issue_unit as unit, issue_store as issue_store,sum(issue_total_cost) as cost_of_sales, sum(issue_rate) as rate, sum(issue_qty) as quantity')
                ->groupBy('name')
                ->groupBy('unit')
                ->groupBy('issue_store')
                ->where('issue_status', 1)
                ->whereDate('issue_date', $dayClose->day_close)
                ->where('station', auth()->user()->station)
                ->get();

                \App\Models\UserActivity::create([
                    'changed_date' => \Carbon\carbon::now(),
                    'user_id'=>auth()->id(),
                    'event' => "viewed issues register report",
                ]);

        return view('inventory.issue-register-report', [
            'inventory' => $inventory
        ]);
    }



    public function issueRegisterDate(Request $request)
    {
        $value = explode(' - ', $request->date);
         
        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        if ($from == $to) {
            $inventory = \DB::table('issue_vouchers')
            ->selectRaw('issue_item as name, issue_unit as unit, issue_store as issue_store, sum(issue_total_cost) as cost_of_sales, sum(issue_rate) as rate, sum(issue_qty) as quantity')
            ->groupBy('name')
            ->groupBy('unit')
            ->groupBy('issue_store')
            ->where('issue_status', 1)
            ->whereDate('issue_date', $from)
            ->where('station', auth()->user()->station)
            ->get();

            return view('inventory.issue-register-report', [
                'inventory' => $inventory
            ]);
        }else {
            $inventory = \DB::table('issue_vouchers')
            ->selectRaw('issue_item as name, issue_unit as unit,  issue_store as issue_store, sum(issue_total_cost) as cost_of_sales, sum(issue_rate) as rate, sum(issue_qty) as quantity')
            ->groupBy('name')
            ->groupBy('unit')
            ->groupBy('issue_store')
            ->where('issue_status', 1)
            ->WhereDate('issue_date','>=', $from)
            ->WhereDate('issue_date','<=', $to)
            ->where('station', auth()->user()->station)
            ->get();


            \App\Models\UserActivity::create([
                'changed_date' => \Carbon\carbon::now(),
                'user_id'=>auth()->id(),
                'event' => "viewed issues register report",
            ]);

        return view('inventory.issue-register-report', [
            'inventory' => $inventory
        ]);
        }
    }


    public function IssueRegisterPrint(Request $request)
    {
        $value = explode(' - ', $request->date);
         
        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        if ($from == $to) {
            $inventory = \DB::table('issue_vouchers')
            ->selectRaw('issue_item as name, issue_unit as unit,  issue_store as issue_store, sum(issue_total_cost) as cost_of_sales, sum(issue_rate) as rate, sum(issue_qty) as quantity')
            ->groupBy('name')
            ->groupBy('unit')
            ->groupBy('issue_store')
            ->where('issue_status', 1)
            ->whereDate('issue_date', $from)
            ->where('station', auth()->user()->station)
            ->get();

            return view('inventory.print-issue-register', [
                'inventory' => $inventory
            ]);
        }else {
            $inventory = \DB::table('issue_vouchers')
            ->selectRaw('issue_item as name, issue_unit as unit, issue_store as issue_store, sum(issue_total_cost) as cost_of_sales, sum(issue_rate) as rate, sum(issue_qty) as quantity')
            ->groupBy('name')
            ->groupBy('unit')
            ->groupBy('issue_store')
            ->where('issue_status', 1)
            ->WhereDate('issue_date','>=', $from)
            ->WhereDate('issue_date','<=', $to)
            ->where('station', auth()->user()->station)
            ->get();

            \App\Models\UserActivity::create([
                'changed_date' => \Carbon\carbon::now(),
                'user_id'=>auth()->id(),
                'event' => "printed issues register",
            ]);

            return view('inventory.print-issue-register', [
                'inventory' => $inventory
            ]);
        }
    }


    public function issueRecieved()
    {   
       $dayClose = \DB::table('close_days')->first();
       $inventory = \DB::table('issue_vouchers')
            ->selectRaw('issue_item as name, issue_unit as unit, issue_rate as rate, issue_store as issue_store, station as station, sum(issue_total_cost) as cost_of_sales, sum(issue_qty) as quantity')
            ->groupBy('name')
            ->groupBy('unit')
            ->groupBy('station')
            ->groupBy('rate')
            ->groupBy('issue_store')
            ->where('issue_status', 1)
            ->whereDate('issue_date',$dayClose->day_close)
            ->where('issue_store', auth()->user()->station)
            ->get();


            \App\Models\UserActivity::create([
                'changed_date' => \Carbon\carbon::now(),
                'user_id'=>auth()->id(),
                'event' => "viewed issue received report",
            ]);

        return view('inventory.issue-received-report', [
            'inventory' => $inventory
        ]);
    }


    public function IssueReceiveDate(Request $request)
    {   

        $value = explode(' - ', $request->date);
         

        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        if ($from == $to) {
            $inventory = \DB::table('issue_vouchers')
            ->selectRaw('issue_item as name, issue_unit as unit, issue_rate as rate, issue_store as issue_store, station as station, sum(issue_total_cost) as cost_of_sales, sum(issue_qty) as quantity')
            ->groupBy('name')
            ->groupBy('unit')
            ->groupBy('station')
            ->groupBy('rate')
            ->groupBy('issue_store')
            ->where('issue_status', 1)
            ->WhereDate('issue_date','>=', $from)
            ->WhereDate('issue_date','<=', $to)
            ->where('issue_store', auth()->user()->station)
            ->get();

        }else {
            $inventory = \DB::table('issue_vouchers')
            ->selectRaw('issue_item as name, issue_unit as unit, issue_rate as rate, issue_store as issue_store, station as station, sum(issue_total_cost) as cost_of_sales, sum(issue_qty) as quantity')
            ->groupBy('name')
            ->groupBy('unit')
            ->groupBy('station')
            ->groupBy('rate')
            ->groupBy('issue_store')
            ->where('issue_status', 1)
            ->WhereDate('issue_date','>=', $from)
            ->WhereDate('issue_date','<=', $to)
            ->where('issue_store', auth()->user()->station)
            ->get();
        }


        \App\Models\UserActivity::create([
            'changed_date' => \Carbon\carbon::now(),
            'user_id'=>auth()->id(),
            'event' => "viewed issues received report",
        ]);


        return view('inventory.issue-received-report', [
            'inventory' => $inventory
        ]);
    }


    public function IssueRecievedPrint(Request $request)
    {
        $value = explode(' - ', $request->date);
         

        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        if ($from == $to) {
            
            $inventory = \DB::table('issue_vouchers')
                ->selectRaw('issue_item as name, issue_unit as unit,issue_store as issue_store, station as station, sum(issue_total_cost) as cost_of_sales, sum(issue_rate) as rate, sum(issue_qty) as quantity')
                ->groupBy('name')
                ->groupBy('unit')
                ->groupBy('station')
                ->groupBy('issue_store')
                ->where('issue_status', 1)
                ->whereDate('issue_date', $from)
                ->where('issue_store', auth()->user()->station)
                ->get();

        }else {
            $inventory =  \DB::table('issue_vouchers')
                ->selectRaw('issue_item as name, issue_unit as unit,issue_store as issue_store, station as station, sum(issue_total_cost) as cost_of_sales, sum(issue_rate) as rate, sum(issue_qty) as quantity')
                ->groupBy('name')
                ->groupBy('unit')
                ->groupBy('station')
                ->groupBy('issue_store')
                ->where('issue_status', 1)
                ->WhereDate('issue_date','>=', $from)
                ->WhereDate('issue_date','<=', $to)
                ->where('issue_store', auth()->user()->station)
                ->get();
        }


        \App\Models\UserActivity::create([
            'changed_date' => \Carbon\carbon::now(),
            'user_id'=>auth()->id(),
            'event' => "Printed issues received report",
        ]);

        return view('inventory.print-issue-recieved', [
            'inventory' => $inventory
        ]);
    }

    public function StoreWiseIssueRegister()
    {   
        $dayClose = \DB::table('close_days')->first();

        if (auth()->user()->role == "Administrator") {
            $lists = \DB::table('issue_vouchers')
                ->whereDate('issue_date', $dayClose->day_close)
                ->where('issue_status', 1)
                ->get();
        }else {
            
         $lists = \DB::table('issue_vouchers')
        ->where('station', auth()->user()->station)
        ->whereDate('issue_date', $dayClose->day_close)
        ->where('issue_status', 1)
        ->get();
        }

        \App\Models\UserActivity::create([
            'changed_date' => \Carbon\carbon::now(),
            'user_id'=>auth()->id(),
            'event' => "viewed issue register store wise report",
        ]);


        return view('inventory.issue-register-storewise', [
            'report' => $lists->groupBy('station')->all()
        ]);
       

    }

    public function storewiseDate(Request $request)
    {
        $value = explode(' - ', $request->date);

        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');


        if (auth()->user()->role == "Administrator") {
            $lists = \DB::table('issue_vouchers')
                ->where('issue_status', 1)
                ->WhereDate('issue_date','>=', $from)
                ->WhereDate('issue_date','<=', $to)
                ->get();
        }else {
            
            $lists = \DB::table('issue_vouchers')
            ->where('station', auth()->user()->station)
            ->where('issue_status', 1)
            ->WhereDate('issue_date','>=', $from)
            ->WhereDate('issue_date','<=', $to)
            ->get();
            }

            \App\Models\UserActivity::create([
                'changed_date' => \Carbon\carbon::now(),
                'user_id'=>auth()->id(),
                'event' => "viewed issue register store wise report",
            ]);

        return view('inventory.issue-register-storewise', [
            'report' => $lists->groupBy('station')->all()
        ]);
            
            
           
    }


    public function IssueRegisterStoreWise(Request $request)
    {
        $value = explode(' - ', $request->date);

        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        if (request('item') == "All Issues") {
                if (auth()->user()->role == "Administrator") {
                $inventory = \DB::table('issue_vouchers')
                ->selectRaw('issue_item as name, issue_unit as unit, station as station, issue_store as issue_store, issue_date as issue_date, sum(issue_total_cost) as cost_of_sales, sum(issue_rate) as rate, sum(issue_qty) as quantity')
                ->groupBy('name')
                ->groupBy('unit')
                ->groupBy('issue_store')
                ->groupBy('issue_date')
                ->groupBy('station')
                ->where('issue_status', 1)
                ->WhereDate('issue_date','>=', $from)
                ->WhereDate('issue_date','<=', $to)
                ->get();
                }else {
                    $inventory = \DB::table('issue_vouchers')
                    ->selectRaw('issue_item as name, issue_unit as unit, station as station, issue_store as issue_store, issue_date as issue_date, sum(issue_total_cost) as cost_of_sales, sum(issue_rate) as rate, sum(issue_qty) as quantity')
                    ->groupBy('name')
                    ->groupBy('unit')
                    ->groupBy('issue_store')
                    ->groupBy('issue_date')
                    ->groupBy('station')
                    ->where('issue_status', 1)
                    ->WhereDate('issue_date','>=', $from)
                    ->WhereDate('issue_date','<=', $to)
                    ->where('station', auth()->user()->station)
                    ->get();
                }
                
            }else {

                if (auth()->user()->role == "Administrator") {
                    $inventory = \DB::table('issue_vouchers')
                    ->selectRaw('issue_item as name, issue_unit as unit, station as station, issue_store as issue_store, issue_date as issue_date, sum(issue_total_cost) as cost_of_sales, sum(issue_rate) as rate, sum(issue_qty) as quantity')
                    ->groupBy('name')
                    ->groupBy('unit')
                    ->groupBy('issue_store')
                    ->groupBy('issue_date')
                    ->groupBy('station')
                    ->where('issue_status', 1)
                    ->where('issue_item_id', $request->item)
                    ->WhereDate('issue_date','>=', $from)
                    ->WhereDate('issue_date','<=', $to)
                    ->get();
                    }else {
                        $inventory = \DB::table('issue_vouchers')
                        ->selectRaw('issue_item as name, issue_unit as unit, station as station, issue_store as issue_store, issue_date as issue_date, sum(issue_total_cost) as cost_of_sales, sum(issue_rate) as rate, sum(issue_qty) as quantity')
                        ->groupBy('name')
                        ->groupBy('unit')
                        ->groupBy('issue_store')
                        ->groupBy('issue_date')
                        ->groupBy('station')
                        ->where('issue_status', 1)
                        ->where('issue_item_id', $request->item)
                        ->WhereDate('issue_date','>=', $from)
                        ->WhereDate('issue_date','<=', $to)
                        ->where('station', auth()->user()->station)
                        ->get();
                    }
        }


        \App\Models\UserActivity::create([
            'changed_date' => \Carbon\carbon::now(),
            'user_id'=>auth()->id(),
            'event' => "viewed issue register store wise report",
        ]);
    
        return view('inventory.item-wise-issues-report', [
            'inventory' => $inventory
        ]);
    }


    public function manufacturingCost()
    {   
        $dayClose = \DB::table('close_days')->first();

        $report_ledger = \DB::table('stock_transactions')->where('description', "Consumptions")
        ->where('station', auth()->user()->station)
        ->whereDate('date', $dayClose->day_close)
        ->get();

        \App\Models\UserActivity::create([
            'changed_date' => \Carbon\carbon::now(),
            'user_id'=>auth()->id(),
            'event' => "viewed manufacturing cost report",
        ]);

        return view('inventory.manufacturing-cost', [
            'reports' =>$report_ledger
        ]);
    }


    public function ManufacturingCostDate(Request $request)
    {
        $value = explode(' - ', $request->date);
         

        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        $report_ledger = \DB::table('stock_transactions')->where('description', "Consumptions")
        ->where('station', auth()->user()->station)
        ->WhereDate('date','>=', $from)
        ->WhereDate('date','<=', $to)
        ->get();

        \App\Models\UserActivity::create([
            'changed_date' => \Carbon\carbon::now(),
            'user_id'=>auth()->id(),
            'event' => "viewed manufacturing cost report",
        ]);

        return view('inventory.manufacturing-cost', [
            'reports' =>$report_ledger
        ]);


    }
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\InventoryReport  $inventoryReport
     * @return \Illuminate\Http\Response
     */
    public function show(InventoryReport $inventoryReport)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\InventoryReport  $inventoryReport
     * @return \Illuminate\Http\Response
     */
    public function edit(InventoryReport $inventoryReport)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\InventoryReport  $inventoryReport
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, InventoryReport $inventoryReport)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\InventoryReport  $inventoryReport
     * @return \Illuminate\Http\Response
     */
    public function destroy(InventoryReport $inventoryReport)
    {
        //
    }
}
