<?php

namespace App\Http\Controllers;

use App\Models\IssueVoucher;
use Illuminate\Http\Request;
use Carbon\Carbon;
use App\Models\ItemStockLedger;
use App\Models\IssueList;
use DateTime;
use App\Models\InventoryReport;

class IssueVoucherController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {   
        $this->validate( request(), [
            'issue_to' => 'required|max:300'
        ]);

        session()->put('issue_to', request('issue_to'));
        session()->put('issue_date', request('issue_date'));
        session()->put('transaction_number', "VOU-".rand(5034,10034580)+rand(4580,10034580) . date("Yd") . date('Hi'));

        $item_issues = \DB::table('items')
                ->where('transfer_status', 1)
                ->OrderBy('item_name', 'ASC')
                ->get();

        return view('transfers.new-voucher',[
            'item_issues' => $item_issues,
            'units' => \DB::table('units')->get()
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {   
        
        $this->validate($request, [
            'r_store' => 'required',
            'r_item' => 'required',
            'r_item' => ' required',
        ]);

        $app = \DB::table('settings')->first();
        
        try {
            // Perform DB Transaction
            \DB::beginTransaction();

         $item_unit = \DB::table('items')->where('id', explode(" - ",$request -> r_item)[1])->first();
        // search Unit

        $id = $item_unit->id;
    
        if ($request -> r_unit !== null) {
            
            $getUnit = \DB::table('unit_conversions')
            ->where('item_id', $item_unit -> id)
            ->where('conversion_unit', $request -> r_unit)
            ->first();

            if ($getUnit == null) {
                $convertQty = $request -> r_quantity;
                $unit_measure = $item_unit->item_unit;
            }else {
                $convertQty = ((float)$getUnit->base_unit_figure*(float)$request -> r_quantity)/(float)$getUnit->conversion_unit_figure;
                $unit_measure = $item_unit->item_unit;
            }

        
        }else{
            $convertQty = $request -> r_quantity ;
        }

        $dayClose = \DB::table('close_days')->first();    
       

             $to =    $dayClose->day_close;
             $from =  $dayClose->day_close;


             $balance_b_f =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $id)->whereDate('date', '<', $to)->sum('stock_in') - 
             \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $id)->whereDate('date', '<', $to)->sum('stock_out');
             

            $stock_in =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $id)
                                        ->WhereDate('date', $from)
                                        ->WhereDate('date', $to)
                                        ->sum('stock_in');
                                        
            $stock_out =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $id)
            ->WhereDate('date', $from)
            ->WhereDate('date', $to)
            ->sum('stock_out');



            $closing = ($stock_in - $stock_out) + $balance_b_f;


            $getAllCOst =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $id)->get();

            if (empty($getAllCOst)) {
               $total_cost = 0;
            }else {

            $sumReCost = 0 ;
            $sumIssueCost = 0 ;

                foreach ($getAllCOst as $key => $cost) {

                    $sumIssueCost += round($cost->stock_out, 2) * round($cost->cost, 2);
                    $sumReCost += round($cost->stock_in, 2) * round($cost->cost, 2);

                }

                $total_cost =  (round($sumReCost, 2) - round($sumIssueCost, 2)) / ($closing == 0 ? 1 :  round($closing, 2));
            }



        if ($app->issue_check == 1) {
               if ($closing < 0 || $closing < $convertQty) {
                   return [1];
            }
        }


        $cart_voucher = $request->session()->get('cart_voucher', []);
         if(isset($cart_voucher[$id])) {
        $cart_voucher[$id]['issue_quantity'] = $cart_voucher[$id]['issue_quantity'] +  $convertQty;
            $cart_voucher[$id]['issue_total_cost'] = ($cart_voucher[$id]['issue_quantity'])*$cart_voucher[$id]['issue_rate'];
         } else {
            $cart_voucher[$id] = [
                'id' => $id,
                'user_id' => auth()->user()->id,
                'issue_item_id' => explode(" - ",$request -> r_item)[1],
                'station' => auth()->user()->station,
                'issue_store' => $request->r_store,
                'issue_date' =>  $request -> r_date,
                'issue_note' => $request -> r_note,
                'issue_category' => $item_unit->item_category,
                'issue_item' => explode(" - ", $request -> r_item)[0],
                'issue_quantity' => $convertQty,
                'authorize_qty' => $convertQty,
                'issue_rate' => (empty($total_cost) ? 0 : ($total_cost < 0 ? 0 : $total_cost)) ,
                'issue_total_cost' => (empty($total_cost) ? 0 : ($total_cost < 0 ? 0 : $total_cost))*$convertQty,
                'issue_unit' => $request -> r_unit == null ? $item_unit->item_unit : $unit_measure,
                 ];
         }
           
         $request->session()->put('cart_voucher', $cart_voucher);
         return response([
            'status'=> 1000,
            'Message'=> 'Item Added Successfully'
        ]);

        \DB::commit();  
        return ['success'];
        } catch (\Throwable $th) {
            \DB::rollback();
            return response([
                'status' => 501,
                "Message" => $th
            ]);
        }
    }



    public function confirmIssue(Request $request)
    {   
        
        $voucher = session()->get('cart_voucher');

        if (empty($voucher) || $voucher==null) {
            return back()->with('statuspass', "Cart is Empty, Please add Item to proceed");
        }

        try {
            // Perform DB Transaction
            \DB::beginTransaction();
        if(empty(session()->get('transaction_number'))){
            session()->put('transaction_number', "VOU-".rand(5034,10034580)+rand(4580,10034580) . date("Yd") . date('Hi'));
        }

        $request->merge([
            'transaction' => session()->get('transaction_number')
        ]);
        
        $check_validate = \DB::table('issue_lists')->where('transaction_no', request('transaction'))->first();

        if (!empty($check_validate)) {
            return back()->with('status', "Voucher Already exist");
        }

        $data = new IssueList;
        $data -> user_id = auth()->user()->id;
        $data -> transaction_no = request('transaction');
        $data -> issue_date = session()->get('issue_date');
        $data -> issue_to =  session()->get('issue_to');
        $data -> issue_from =  auth()->user()->station;
        $data -> comment = session()->get('purchase_note');
        $data -> issue_status =  2;
        $data -> authorize_status =  2;
        $data -> save();

        foreach (session()->get('cart_voucher') as $key => $issue) {
            $data = new IssueVoucher;
            $data ->user_id = auth()->user()->id;
            $data ->issue_item_id = $issue['issue_item_id'];
            $data ->station = auth()->user()->station;
            $data ->issue_transaction_id = request('transaction');
            $data->issue_store = session()->get('issue_to');
            $data->issue_date =  session()->get('issue_date') ;
            $data->issue_note = $issue['issue_note'] ;
            $data->issue_category = $issue['issue_category'] ;
            $data->issue_item = $issue['issue_item'] ;
            $data->issue_quantity = $issue['issue_quantity'] ;
            $data->authorize_qty = $issue['authorize_qty'] ;
            $data->issue_rate = $issue['issue_rate'];
            $data->issue_total_cost =$issue['issue_rate']*$issue['authorize_qty'];
            $data->issue_unit = $issue['issue_unit'];
            $data->issue_state = "C";
            $data->issue_status = 2;
            $data->authorize_state = 2;
            $data->save();
        }

        // $url = 'http://inventory.ceqalimited.com/dashboard/voucher/transaction-authorize/' . $data ->issue_transaction_id;
       
        // $sender= 'CQVoucher';
        //    $numbers =  '233542401240, 233202424220, 233206562819, 233552818283';  
        //    $msg = auth()->user()->name . ' has successfully transfered stock from ' . $data->station . ' to ' .  $data->issue_store . '. Preview & authorize voucher here ' . $url;     
           
        //    $message= rawurlencode($msg);                   
        //    $numbers= rawurlencode($numbers);                   
        //    $sender= rawurlencode($sender);                   
   
   
        //    $url= 'https://api.msmpusher.net/v1/send?privatekey=2020070761000216&publickey=890d6cb37ef1a425&sender=' . $sender . '&numbers=' . $numbers . '&message=' . $message;
        //    $result = file_get_contents($url);


        $request->session()->forget(['cart_voucher','transaction_number','purchase_note']);

        \DB::commit();  
        return back()->with('status', 'New Transfer Made Successfully, Waiting Approval');


        } catch (\Throwable $th) {
            \DB::rollback();
            return response([
                'status' => 501,
                "Message" => $th
            ]);
        }
    }


    public function SavePrintVoucher(Request $request)
    {
        
        $voucher = session()->get('cart_voucher');

        if (empty($voucher) || $voucher==null) {
            return back()->with('statuspass', "Cart is Empty, Please add Item to proceed");
        }
        try {
            // Perform DB Transaction
            \DB::beginTransaction();

        if(empty(session()->get('transaction_number'))){
            session()->put('transaction_number', "VOU-".rand(5034,10034580)+rand(4580,10034580) . date("Yd") . date('Hi'));
        }

        $request->merge([
            'transaction' => session()->get('transaction_number')
        ]);
        
        $check_validate = \DB::table('issue_lists')->where('transaction_no', request('transaction'))->first();

        if (!empty($check_validate)) {
            return back()->with('status', "Voucher Already exist");
        }

        $data = new IssueList;
        $data -> user_id = auth()->user()->id;
        $data -> transaction_no = request('transaction');
        $data -> issue_date = session()->get('issue_date');
        $data -> issue_to =  session()->get('issue_to');
        $data -> issue_from =  auth()->user()->station;
        $data -> comment = session()->get('purchase_note');
        $data -> issue_status =  2;
        $data -> authorize_status =  2;
        $data -> save();

        foreach (session()->get('cart_voucher') as $key => $issue) {
            $data = new IssueVoucher;
            $data ->user_id = auth()->user()->id;
            $data ->issue_item_id = $issue['issue_item_id'];
            $data ->station = auth()->user()->station;
            $data ->issue_transaction_id = request('transaction');
            $data->issue_store = session()->get('issue_to');
            $data->issue_date =  session()->get('issue_date') ;
            $data->issue_note = $issue['issue_note'] ;
            $data->issue_category = $issue['issue_category'] ;
            $data->issue_item = $issue['issue_item'] ;
            $data->issue_quantity = $issue['issue_quantity'] ;
            $data->authorize_qty = $issue['authorize_qty'] ;
            $data->issue_rate = $issue['issue_rate'];
            $data->issue_total_cost = $issue['issue_rate']*$issue['authorize_qty'] ;
            $data->issue_unit = $issue['issue_unit'];
            $data->issue_state = "C";
            $data->issue_status = 2;
            $data->authorize_state = 2;
            $data->save();


            \App\Models\StockTransaction::create([
                    'user_id' => auth()->id(),
                    'item_id' =>  $issue['issue_item_id'],
                    'description' => 'Issues',
                    'note' => 'Transfer to ' . session()->get('issue_to')  . '<br>' . '<a href=' . '/dashboard/voucher/transaction/' . request('transaction') .'>' . request('transaction') .'</a>' ,
                    'unit' =>  $issue['issue_unit'],
                    'station' => auth()->user()->station,
                    'date' => session()->get('issue_date'),
                    'stock_out' => $issue['issue_quantity'],
                    'cost' => $issue['issue_rate'],
                    'transactions_id' => request('transaction')
            ]);

        }

        // $url = 'http://inventory.ceqalimited.com/dashboard/voucher/transaction-authorize/' . $data ->issue_transaction_id;
       
        // $sender= 'CQVoucher';
        //    $numbers =  '233542401240, 233202424220, 233206562819, 233552818283';  
        //    $msg = auth()->user()->name . ' has successfully transfered stock from ' . $data->station . ' to ' .  $data->issue_store . '. Preview & authorize voucher here ' . $url;     
           
        //    $message= rawurlencode($msg);                   
        //    $numbers= rawurlencode($numbers);                   
        //    $sender= rawurlencode($sender);                   
   
   
        //    $url= 'https://api.msmpusher.net/v1/send?privatekey=2020070761000216&publickey=890d6cb37ef1a425&sender=' . $sender . '&numbers=' . $numbers . '&message=' . $message;
        //    $result = file_get_contents($url);


        $request->session()->forget(['cart_voucher','transaction_number','purchase_note']);

        \App\Models\UserActivity::create([
            'changed_date' => \Carbon\carbon::now(),
            'user_id'=>auth()->id(),
            'event' => "created a new voucher",
        ]);

        \DB::commit(); 
        return redirect()->to('/dashboard/print-voucher-new/' . $data ->issue_transaction_id);

        } catch (\Throwable $th) {
            \DB::rollback();
            return response([
                'status' => 501,
                "Message" => $th
            ]);
        }

        
    }


    public function PrintV($transaction)
    {   
       
        $details = \DB::table('issue_vouchers')
                    ->join('users', 'issue_vouchers.user_id','users.id')
                    ->where('issue_vouchers.issue_transaction_id',$transaction)
                    ->first();

        $voucher = \DB::table('issue_vouchers')->where('issue_transaction_id',$transaction)->get();

        $accepted = \DB::table('issue_lists')->where('transaction_no',$transaction)->first();
        $username = \DB::table('users')->where('id', $accepted->accepted_by)->first();

        if ($username == null) {
            $username = null;
        }else{
            $username = $username->name;
        }

        $rejected = \DB::table('issue_vouchers')->where('issue_transaction_id',$transaction)->where('rejected_status', 0)->sum('issue_total_cost');

        $t_cost = \DB::table('issue_vouchers')->where('issue_transaction_id',$transaction)->sum('issue_total_cost');
        return view('makerequest.print-voucher', [
            'vouchering' => $voucher,
            'details' => $details,
            't_costing'=> $t_cost,
            'username' => $username,
            'rejected' => $rejected
        ]);
    }


    public function voucherList()
    {   
        $dayClose = \DB::table('close_days')->first();

         $lists = \DB::table('issue_lists')
         ->join('users', 'issue_lists.user_id','users.id')
         ->where('issue_lists.issue_from', auth()->user()->station)
         ->whereDate('issue_lists.issue_date', $dayClose->day_close)
         ->get();

        return view('transfers.voucher-list', [
            'lists'=>$lists
        ]);
    }


    public function VoucherIncoming()
    {   
        $dayClose = \DB::table('close_days')->first();
        $lists = \DB::table('issue_lists')
        ->join('users', 'issue_lists.user_id','users.id')
        ->where('issue_lists.issue_to', auth()->user()->station)
        ->whereDate('issue_lists.issue_date', $dayClose->day_close)
        ->get();

        return view('transfers.voucher-list', [
            'lists'=>$lists
        ]);
    }


    public function AcceptVoucher(Request $request)
    {   
        
        $check = \DB::table('issue_lists')
                ->where('transaction_no', $request->transaction_no) 
                ->where('accepted_by', '!=', null)
                ->first();

        if (!empty($check)) {
            return back()->with('statuspass',"Item already accepted");
        }

        try {
            // Perform DB Transaction
        \DB::beginTransaction();


        $data = $request->all();
        
        if (request('status') == 1) {
          

        if (array_key_exists('items', $data)) {

            foreach ($data['items'] as $key => $item) {
                
                \App\Models\StockTransaction::create([
                    'user_id' => auth()->id(),
                    'item_id' =>  $item['issue_item_id'],
                    'description' => 'Receipts',
                    'note' => 'Transfer from ' . $item['issue_recieved_station'] . '<br>' . '<a href=' . '/dashboard/voucher/transaction/' . $request->transaction_no .'>' . $request->transaction_no .'</a>' ,
                    'unit' =>  $item['issue_unit'],
                    'station' => $item['issue_station'],
                    'date' => request('date'),
                    'stock_in' => $item['issue_qty'],
                    'cost' => $item['issue_rate'],
                    'transactions_id' => $request->transaction_no
            ]);


    
            }
        }

        \DB::table('issue_lists')
        ->where('transaction_no', $request->transaction_no)
        ->update([
            'issue_status' => 1,
            'accepted_by' => auth()->user()->id,
        ]);


        $changeStatus = \DB::table('issue_vouchers')
                ->where('issue_transaction_id', $request->transaction_no)
                ->update([
                    'issue_status' => 1,
                ]);

        $details = \DB::table('issue_vouchers')
                    ->join('users', 'issue_vouchers.user_id','users.id')
                    ->where('issue_vouchers.issue_transaction_id',$request->transaction_no)
                    ->first();

        $voucher = \DB::table('issue_vouchers')->where('issue_transaction_id',$request->transaction_no)->get();
        
        $accepted = \DB::table('issue_lists')->where('transaction_no',$request->transaction_no)->first();
        $username = \DB::table('users')->where('id', $accepted->accepted_by)->first();
        if ($username == null) {
            $username = null;
        }else{
            $username = $username->name;
        }

        \DB::commit();

        $rejected = \DB::table('issue_vouchers')->where('issue_transaction_id',$request->transaction_no)->where('rejected_status', 0)->sum('issue_total_cost');

        
        return view('makerequest.print-voucher', [
            'vouchering' => $voucher,
            'details' => $details,
            'username' => $username,
            'rejected' => $rejected
        ]);
    }else {

        if (array_key_exists('items', $data)) {

            foreach ($data['items'] as $key => $item) {
                
                \App\Models\StockTransaction::create([
                    'user_id' => auth()->id(),
                    'item_id' =>  $item['issue_item_id'],
                    'description' => 'Receipts',
                    'note' => 'Rejected Voucher, by ' . auth()->user()->name . '<br>' . '<a href=' . '/dashboard/voucher/transaction/' . $request->transaction_no .'>' . $request->transaction_no .'</a>' ,
                    'unit' =>  $item['issue_unit'],
                    'station' =>  $item['issue_recieved_station'],
                    'date' => request('date'),
                    'stock_in' => $item['issue_qty'],
                    'cost' => $item['issue_rate'],
                    'transactions_id' => $request->transaction_no
                ]);


    
            }
        }

        \DB::table('issue_lists')
        ->where('transaction_no', $request->transaction_no)
        ->update([
            'issue_status' => 0,
            'rejected_by' => auth()->user()->id,
        ]);



        $changeStatus = \DB::table('issue_vouchers')
                ->where('issue_transaction_id', $request->transaction_no)
                ->update([
                    'issue_status' => 0,
                    'rejected_status' => 0
                ]);

        $details = \DB::table('issue_vouchers')
                    ->join('users', 'issue_vouchers.user_id','users.id')
                    ->where('issue_vouchers.issue_transaction_id',$request->transaction_no)
                    ->first();

        $voucher = \DB::table('issue_vouchers')->where('issue_transaction_id',$request->transaction_no)->get();
        
        $accepted = \DB::table('issue_lists')->where('transaction_no',$request->transaction_no)->first();
        $username = \DB::table('users')->where('id', $accepted->accepted_by)->first();
        if ($username == null) {
            $username = null;
        }else{
            $username = $username->name;
        }

        \DB::table('issue_vouchers')->where('issue_transaction_id',$request->transaction_no)->where('rejected_status', 0)->update([
            'rejected_status' => 0
        ]);

        \DB::commit();
        
        $rejected = \DB::table('issue_vouchers')->where('issue_transaction_id',$request->transaction_no)->where('rejected_status', 0)->sum('issue_total_cost');

        
        return view('makerequest.print-voucher', [
            'vouchering' => $voucher,
            'details' => $details,
            'username' => $username,
            'rejected' => $rejected
        ]);
        


    }
        }catch(\Throwable $th){
            \DB::rollback();
            return response([
                'status' => 500,
                'Message' => $th
            ]);
        }
    }





    public function AcceptRejected(Request $request)
    {
        $results = \DB::table('item_stock_ledgers')
                    ->where('item_id' ,$request->issue_item_id)
                    ->where('date', $request->issue_date)
                    ->where('station', $request->issue_station)
                    ->first();

        
                // Check if Voucher Exist
                if ($results == null) {
                    ItemStockLedger::Insert([
                        'user_id' => auth()->user()->id,
                        'station' => $request->issue_station,
                        'item_name' => $request->issue_item,
                        'item_id' => $request->issue_item_id,
                        'item_unit' => $request->issue_unit,
                        'item_recieved' => $request->issue_qty,
                        'date' => $request->issue_date,
                    ]);
                }else {
                    \DB::table('item_stock_ledgers')
                    ->where('item_id' , $request->issue_item_id)
                    ->where('date', $request->issue_date)
                    ->where('station', $request->issue_station)
                    ->update([
                        'user_id' => auth()->user()->id,
                        'item_recieved' => $results->item_recieved + $request->issue_qty,
                    ]);
                }


            // Recieving Ledger

             $exiting_new = \DB::table('item_stock_ledgers')
             ->where('item_id', $request->issue_item_id)
             ->where('date', $request->issue_date)
             ->where('station', $request->issue_recieved_station)
             ->first();

            
                $ledger = \DB::table('item_stock_ledgers')
                ->where('item_id' , $request->issue_item_id)
                ->where('date', $request->issue_date)
                ->where('station', $request->issue_recieved_station)
                ->update([
                    'user_id' => auth()->user()->id,
                    'item_issue' => $exiting_new->item_issue + $request->issue_qty,
                ]);
            
            

            \DB::table('issue_lists')
            ->where('transaction_no', $request->transaction_no)
            ->update([
                'issue_status' => 1,
                'accepted_by' => auth()->user()->id,
            ]);


            $changeStatus = \DB::table('issue_vouchers')
                    ->where('issue_transaction_id', $request->transaction_no)
                    ->where('issue_item_id', $request->issue_item_id)
                    ->update([
                        'issue_status' => 1,
                        'rejected_status' => 1
                    ]);

            $details = \DB::table('issue_vouchers')
                        ->join('users', 'issue_vouchers.user_id','users.id')
                        ->where('issue_vouchers.issue_transaction_id',$request->transaction_no)
                        ->first();

            $voucher = \DB::table('issue_vouchers')->where('issue_transaction_id',$request->transaction_no)->get();
            
            $accepted = \DB::table('issue_lists')->where('transaction_no',$request->transaction_no)->first();
            $username = \DB::table('users')->where('id', $accepted->accepted_by)->first();
            if ($username == null) {
                $username = null;
            }else{
                $username = $username->name;
            }

            $rejected = \DB::table('issue_vouchers')->where('issue_transaction_id',$request->transaction_no)->where('rejected_status', 0)->sum('issue_total_cost');

            $t_cost = \DB::table('issue_vouchers')->where('issue_transaction_id',$request->transaction_no)->sum('issue_total_cost');
            return 123;
        
    }


    public function AcceptVoucherAdmin(Request $request)
    {

        try {
            // Perform DB Transaction
            \DB::beginTransaction();
        if (request('reject') == "Reject Voucher") {
            return request();
            \DB::table('issue_lists')->where('transaction_no', request('trans_id'))->update([
                'authorize_status' => 0
            ]);


            
            \App\Models\UserActivity::create([
                'changed_date' => \Carbon\carbon::now(),
                'user_id'=>auth()->id(),
                'event' => "Reject Voucher" ,
                'history' => '<a href=' . '/dashboard/voucher/transaction/' . $request->transaction_no .'>' . "view" . '</a>'
            ]);

        }else {
    
        $data = $request->all();
        
        //  update Voucher status after accepting
        if (array_key_exists('items', $data)) {
            foreach ($data['items'] as $key => $item) {
                $req = \DB::table('issue_vouchers')
                ->where('issue_transaction_id', request('trans_id'))
                ->where('issue_item_id', $item['issue_item_id'])
                ->update([
                    'authorize_qty' => $item['issue_qty'],
                    'authorize_state' => 1,
                    'issue_total_cost' => $item['issue_qty'] * $item['issue_rate'],
                    'issue_qty' => $item['issue_qty'],
                    'issue_quantity' => $item['issue_qty']
                ]); 
                
            }

        }

        \DB::table('issue_lists')->where('transaction_no', request('trans_id'))->update([
            'authorize_status' => 1,
            'authorised_by' => auth()->id()
        ]);

        $rep = \DB::table('issue_lists')->where('transaction_no', request('trans_id'))->first();
        
        \App\Models\UserActivity::create([
            'changed_date' => \Carbon\carbon::now(),
            'user_id'=>auth()->id(),
            'event' => "Approved voucher issued from ". $rep->issue_from . " to " . $rep->issue_to,
            'history' => '<a href=' . '/dashboard/voucher/transaction/' . request('trans_id') .'>' . "view" . '</a>' 
        ]);
        
    } 
        \DB::commit();
        return redirect()->to('/dashboard/voucher/list/authorised-pending-transactions')->with('status', "Voucher Approved Successfully");
        } catch (\Throwable $th) {
            \DB::rollback();
            return response([
                'status' => 501,
                "Message" => $th
            ]);
        } 

    }



    public function IssueRecieveRun()
    {
       $dayClose = \DB::table('close_days')->first();
       $inventory = \DB::table('issue_vouchers')
            ->selectRaw('issue_item_id as issue_item_id, issue_item as name, sum(issue_qty) as quantity')
            ->groupBy('name')
            ->groupBy('issue_item_id')
            ->where('issue_status', 1)
            ->where('issue_store', auth()->user()->station)
            ->whereDate('issue_date',$dayClose->day_close)
            ->get();

        foreach ($inventory as $key => $inventory_item) {
           
                    ItemStockLedger::updateOrCreate([
                    'item_id' => $inventory_item->issue_item_id,
                    'date' => $dayClose->day_close,
                    'station' => auth()->user()->station,
                    ], [
                        'user_id' => auth()->user()->id,
                        'station' => auth()->user()->station,
                        'item_id' => $inventory_item->issue_item_id,
                        'item_recieved' => $inventory_item->quantity
                    ]); 
        }

        \App\Models\UserActivity::create([
            'changed_date' => \Carbon\carbon::now(),
            'user_id'=>auth()->id(),
            'event' => "Re running of issues received",
        ]);

        return back()->with('status', 'Issues Received reloaded successfully');
    }



    public function voucherAuthorize()
    {
        return view('approvals.voucher-approval-admin');
    }


    public function approvedVoucherAdmin()
    {   
        $getDayClose = \DB::table('close_days')->first();
        $authorizeStatus = \DB::table('issue_lists')
                    ->join('users', 'issue_lists.user_id','users.id')
                    ->whereDate('issue_lists.issue_date', $getDayClose->day_close)
                    ->where('issue_lists.authorize_status', 1)
                    ->get();
        
        \App\Models\UserActivity::create([
            'changed_date' => \Carbon\carbon::now(),
            'user_id'=>auth()->id(),
            'event' => "visited voucher Approval page",
        ]);

        return view('voucher-approval-admin-page',
            ['authorizeStatus_' => $authorizeStatus]
        );
    }

    public function Apporvedbydate(Request $request)
    {
        $value = explode(' - ', $request->date);
        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        $authorizeStatus = \DB::table('users')
                    ->select('*')
                    ->join('issue_list', 'issue_lists.user_id','users.id')
                    ->WhereDate('issue_lists.issue_date','>=', $from)
                    ->WhereDate('issue_lists.issue_date','<=', $to)
                    ->where('issue_lists.authorize_status', 1)
                    ->get();
        return view('voucher-approval-admin-page',
            ['authorizeStatus_' => $authorizeStatus]
        );
    }

    public function AdminApproveDate(Request $request)
    {   
        $value = explode(' - ', $request->date);
        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        if ($from == $to) {
            $authorizeStatus = \DB::table('issue_lists')
                    ->join('users', 'issue_lists.user_id','users.id')
                    ->whereDate('issue_lists.issue_date', $to)
                    ->where('authorize_status', 2)
                    ->get();
        }else {
            $authorizeStatus = \DB::table('issue_lists')
                    ->join('users', 'issue_lists.user_id','users.id')
                    ->WhereDate('issue_lists.issue_date','>=', $from)
                    ->WhereDate('issue_lists.issue_date','<=', $to)
                    ->where('authorize_status', 2)
                    ->get();
        }

        return view('approvals.approval-date', [
            'authorizeStatus_' => $authorizeStatus
        ]);
    }



    public function getIncomingVoucherReport(Request $request)
    {
        $value = explode(' - ', $request->date);
        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        if ($from == $to) {
            $lists = \DB::table('issue_lists')
                ->join('users', 'issue_lists.user_id','users.id')
                ->where('issue_lists.issue_to', auth()->user()->station)
                ->whereDate('issue_lists.issue_date', $from)
                ->get();
        }else {
            $lists = \DB::table('issue_lists')
                ->join('users', 'issue_lists.user_id','users.id')
                ->where('issue_lists.issue_to', auth()->user()->station)
                ->whereBetween('issue_lists.issue_date',  [$from, $to])
                ->get();
        }

        return view('transfers.voucher-report-incoming', [
            'lists'=>$lists
        ]);
    }



    public function getOutgoingVoucherReport(Request $request)
    {
        $value = explode(' - ', $request->date);
    
        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        if ($from == $to) {
            $lists = \DB::table('issue_lists')
            ->join('users', 'issue_lists.user_id','users.id')
            ->where('issue_lists.issue_from',auth()->user()->station)
            ->whereDate('issue_lists.issue_date', $from)
            ->get();
        }else {
            $lists = \DB::table('issue_lists')
            ->join('users', 'issue_lists.user_id','users.id')
            ->where('issue_lists.issue_from', auth()->user()->station)
            ->whereBetween('issue_lists.issue_date', [$from, $to])
            ->get();
        }

        return view('transfers.voucher-report-outgoing', [
            'lists'=>$lists
        ]);
    }




    public function viewVoucher($transaction)
    {   
        
        $authorize = \DB::table('issue_lists')->where('transaction_no', $transaction)->first();
        if ($authorize->authorize_status == 0 || $authorize->authorize_status == 2) {
            return back()->with('status', 'Voucher Needs Approval, Kindly Contact Admin or Manager');
        }
        $details = \DB::table('issue_vouchers')
                    ->join('users', 'issue_vouchers.user_id','users.id')
                    ->where('issue_vouchers.issue_transaction_id',$transaction)
                    ->first();


        $voucher = \DB::table('issue_vouchers')
        ->where('issue_transaction_id',$transaction)
        ->where('rejected_status',1)
        ->get();

        $voucher_rejected = \DB::table('issue_vouchers')
        ->where('issue_transaction_id',$transaction)
        ->where('rejected_status',0)
        ->get();

        return view('transfers.view-voucher', [
            'details' => $details,
            'voucher' => $voucher,
            'v_list' =>  \DB::table('issue_lists')->where('transaction_no', $transaction)->first(),
            'voucher_rejected' => $voucher_rejected 

        ]);
    }



    public function ReverseVoucher(Request $request, $invoice_number)
    {
        

        \DB::table('issue_lists')
        ->where('transaction_no', $invoice_number)
        ->update([
            'issue_status' => 2,
            'accepted_by' => NULL,
        ]);

        \DB::table('stock_transactions')->where('transactions_id', $invoice_number)->delete();


        $changeStatus = \DB::table('issue_vouchers')
                ->where('issue_transaction_id', $invoice_number)
                ->update([
                    'issue_status' => 1,
                ]);


        return back()->with('status', "Transfer Reversed Successfully");
        
        
    }

    

    public function RejectVoucherItem($item)
    {

        try {
            // Perform DB Transaction
            \DB::beginTransaction();
            
         \DB::table('issue_vouchers')
         ->where('id', $item)
         ->update([
            'rejected_status' => 0
         ]);


         $getItem = \DB::table('issue_vouchers')->where('id', $item)->first();

         \DB::table('item_stock_ledgers')
         ->where('item_id', $getItem->issue_item_id)
         ->where('station', $getItem->station)
         ->whereDate('date', $getItem->issue_date)
         ->update([
            'item_issue' => \DB::raw('item_issue - ' . $getItem->issue_quantity),
        ]);


        \App\Models\StockTransaction::create([
            'user_id' => auth()->id(),
            'item_id' =>   $getItem->issue_item_id,
            'description' => 'Receipts',
            'note' => "Rejected Item - Issue# "   . '<a href=' . '/dashboard/voucher/transaction/' . $getItem->issue_transaction_id .'>' . $getItem->issue_transaction_id .'</a>' ,
            'unit' =>  $getItem->issue_unit,
            'station' =>  $getItem->station,
            'date' => $getItem->issue_date,
            'stock_in' => $getItem->issue_quantity,
            'cost' => $getItem->issue_quantity * $getItem->issue_rate
        ]);


    \DB::commit();

         return back()->with('status', "Item Rejected Successfully");

        } catch (\Throwable $th) {
            \DB::rollback();
            return response([
                'status' => 501,
                "Message" => $th
            ]);
        }

    }


    public function viewVoucherAuthorize($transaction)
    {

        if (auth()->user()->role !== "Administrator") {
            return abort(419, "unauthorised user");
        }

        $details = \DB::table('issue_vouchers')
        ->join('users', 'issue_vouchers.user_id','users.id')
        ->where('issue_vouchers.issue_transaction_id',$transaction)
        ->first();

            $voucher = \DB::table('issue_vouchers')
            ->where('issue_transaction_id',$transaction)
            ->get();
            
            return view('transfers.authorize-voucher-admin', [
            'details' => $details,
            'voucher' => $voucher
            ]);
    }



    public function makeChanges($transaction)
    {
        // first Remove Existing Transaction
        $deleExisting = \DB::table('issue_vouchers')
        ->where('issue_state', "P")
        ->where('user_id', auth()->user()->id)
        ->delete();

        // Then Update and Make Changes
        $makechanges = \DB::table('issue_vouchers')
        ->where('issue_state', "C")
        ->where('user_id', auth()->user()->id)
        ->where('issue_transaction_id', $transaction)
        ->update([
            'issue_state' => "P"
        ]);

        $lists = \DB::table('issue_lists')
        ->where('transaction_no', $transaction)->delete();

        return redirect()->to('/dashboard/voucher/new-voucher');
    }


    /**
     * Display the specified resource.
     *
     * @param  \App\Models\IssueVoucher  $issueVoucher
     * @return \Illuminate\Http\Response
     */
    public function show(IssueVoucher $issueVoucher)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\IssueVoucher  $issueVoucher
     * @return \Illuminate\Http\Response
     */
    public function edit(IssueVoucher $issueVoucher)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\IssueVoucher  $issueVoucher
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, IssueVoucher $issueVoucher)
    {
        //
    }


    public function clearVoucher()
    {
        session()->forget(['cart_voucher','transaction_number']);
        return back()->with('status', 'Transactions Cleared Successfully');
    }


    public function destroyVoucher($id)
    {
        $cart_voucher = session()->get('cart_voucher');
        unset($cart_voucher[$id]);
        session()->put('cart_voucher', $cart_voucher);
        return response([
            'status' => 200,
            'Message' => "Successfully Removed from Cart"
        ]);
    }





    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\IssueVoucher  $issueVoucher
     * @return \Illuminate\Http\Response
     */
    public function transfer_deduction()
    {

        foreach (session()->get('cart_voucher') as $key => $issue) {
        
        // Recieving Ledger
                $ledger = \DB::table('item_stock_ledgers')
                ->where('item_id' , $issue['issue_item_id'])
                ->where('date',  session()->get('issue_date'))
                ->where('station', auth()->user()->station)
                ->update([
                    'item_issue' => \DB::raw('item_issue + ' . (float)$issue['issue_quantity']),
                ]);
            
        }   
    }
}
