<?php

namespace App\Http\Controllers;

use App\Models\ItemBOM;
use Illuminate\Http\Request;
use App\Models\ManufactureBOM;
use App\Models\ItemStockLedger;
use App\Models\MaterialProductCompositon;

class ItemBOMController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {   
        $this->validate($request, [
            'item_bom_name' => 'required'
        ]);


        $dayClose = \DB::table('close_days')->first();    
       

        $to =    $dayClose->day_close;
        $from =  $dayClose->day_close;


        $balance_b_f =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id',  explode(' - ', $request -> item_bom_name)[1])->whereDate('date', '<', $to)->sum('stock_in') - 
        \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', explode(' - ', $request -> item_bom_name)[1])->whereDate('date', '<',  $to)->sum('stock_out');
        

       $stock_in =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id',  explode(' - ', $request -> item_bom_name)[1])
                                   ->WhereDate('date', $from)
                                   ->WhereDate('date', $to)
                                   ->sum('stock_in');
                                   
       $stock_out =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id',  explode(' - ', $request -> item_bom_name)[1])
       ->WhereDate('date', $from)
       ->WhereDate('date', $to)
       ->sum('stock_out');



       $closing = ($stock_in - $stock_out) + $balance_b_f;


       $getAllCOst =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id',  explode(' - ', $request -> item_bom_name)[1])->get();

       if (empty($getAllCOst)) {
          $total_cost = 0;
       }else {

       $sumReCost = 0 ;
       $sumIssueCost = 0 ;

           foreach ($getAllCOst as $key => $cost) {

               $sumIssueCost += round($cost->stock_out, 2) * round($cost->cost, 2);
               $sumReCost += round($cost->stock_in, 2) * round($cost->cost, 2);

           }

           $GetOldRateRE =  (round($sumReCost, 2) - round($sumIssueCost, 2)) / ($closing == 0 ? 1 :  round($closing, 2));
       }


        $itemdata = \DB::table('items')->where('id', $request->item_id)->first();

        $itemdataCheck = \DB::table('items')->where('id',  explode(' - ', $request -> item_bom_name)[1])->first();

        ManufactureBOM::create([
            'item_id' => $request->item_id,
            'bom_id' => explode(' - ', $request -> item_bom_name)[1],
            'bom_qty' => $request -> item_bom_unit
        ]);

        if ($itemdataCheck -> item_manufacturing ==  1) {
            
                $getBoM = \DB::table('item_b_o_m_s')->where('item_id', $itemdataCheck->id)->get();
                foreach ($getBoM as $key => $getBoM) {
                    $item =  \DB::table('items')->where('id', $itemdataCheck->id)->first();

                    ItemBOM::Create([
                        'item_id' => $request->item_id,
                        'bom_id' => $getBoM->bom_id,
                        'is_manufactured' => $getBoM->is_manufactured,
                        'user_id' => auth()->id(),
                        'item_bom_name' => $getBoM -> item_bom_name,
                        'item_unit_measure' => $getBoM->item_unit_measure,
                        'item_bom_unit' => $request -> item_bom_unit * $getBoM-> item_bom_unit,
                        'item_bom_unit_rate' => ($getBoM->is_manufactured == 1 ?  0 : ($request -> item_bom_unit * $getBoM->item_bom_unit_rate)),
                        'chain_id' => $itemdataCheck->id
                    ]);
                }
        }else{
        
            $item =  \DB::table('items')->where('id', explode(' - ', $request -> item_bom_name)[1])->first();

            ItemBOM::updateOrcreate([
                'item_id' => $request->item_id,
                'bom_id' => explode(' - ', $request -> item_bom_name)[1],
                'is_manufactured' => $item->item_manufacturing == 1 ? 1 : 0 ,
                'user_id' => auth()->id(),
                'item_bom_name' => explode(' - ', $request -> item_bom_name)[0],
                'item_unit_measure' => $item->item_unit,
                'item_bom_unit' => $request -> item_bom_unit,
                'item_bom_unit_rate' => ($item->item_manufacturing == 1 ?  0 : ($GetOldRateRE * $request -> item_bom_unit)),
                'chain_id' => explode(' - ', $request -> item_bom_name)[1]
            ]);

        }

            $estimated_cost = \DB::table('item_b_o_m_s')->where('item_id',$itemdata->id)->pluck('item_bom_unit_rate')->sum();


            $checkCom = \DB::table('material_product_compositons')->where('composition_id', $itemdata->id)->get();
            if ($checkCom == null) {
                return response([
                    'Message' => 'success',
                    'Status' => 200
                ]);
            }else {
                $checkComing = \DB::table('material_product_compositons')
                ->where('composition_id',$itemdata->id)
                ->update([
                    'cost' => \DB::raw('unit_measure * ' . $estimated_cost)
                ]);
            
            
            }

    
        return response([
            'Message' => 'success',
            'Status' => 200
        ]);
        

       
        
    }


    public function changeBOM()
    {
        if (empty(request('unit_measure'))) {
            \DB::table('material_product_compositons')
            ->where('composition_id', explode( " - " , request('item'))[0])
            ->update([
                'composition_id' => explode( " - " , request('replace_with'))[0],
                'product_name' => explode( " - " , request('replace_with'))[1],
                'raw_material_code' => explode( " - " , request('replace_with'))[2],
                'cost' => \DB::raw('unit_measure * ' . request('cost'))
            ]);
        }
        return back()->with('status', "Changes Successfully Made");
    }
    

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\ItemBOM  $itemBOM
     * @return \Illuminate\Http\Response
     */
    public function destroy(ItemBOM $itemBOM)
    {
        $dayClose = \DB::table('close_days')->first();

        $itemBOM->delete();

        $estimated_cost = \DB::table('item_b_o_m_s')->where('item_id', $itemBOM->item_id)->pluck('item_bom_unit_rate')->sum();

        $checkComing = \DB::table('material_product_compositons')
            ->where('composition_id',$itemBOM->bom_id)
            ->update([
                'cost' => \DB::raw('unit_measure * ' . $estimated_cost)
            ]);


              $itemBOM->delete();
            
        return back()->with('status', "BOM removed successfully");
    }



    public function itemBomReport()
    {
        $this->validate(request(), [
            'date' => 'required'
        ]);

        $kitchens = \DB::table('kitchens')->where('kitchen_name', auth()->user()->station)->first();

        if (empty($kitchens)) {
            return back()->with('statuspass', "Station not assigned to an outlet");
        }

        $branch = \DB::table('branches')->where('branch_code', $kitchens->kitchen_code)->first();

        


        $item_bom_cons = \DB::table('invoices')
         ->selectRaw('invoice_product_name as name,branch as branch, invoice_category as invoice_category, product_id as product_id, sum(invoice_total_price) as total, sum(invoice_quantity) as quantity, invoice_unit_price as price')
                 ->where('invoice_category', '!=', "TRANSPORT")
         ->groupBy('invoice_product_name')
         ->groupBy('invoice_category')
         ->groupBy('branch')
         ->groupBy('invoice_unit_price')
         ->groupBy('product_id')
         ->whereIn('invoice_status', [1,2])
         ->where('branch', $branch->branch_name)
         ->whereDate('created_at', request('date'))
         ->get();

        return view('inventory.print-itemboncons', [
            'bomcon' => $item_bom_cons
        ]);
    }
}
