<?php

namespace App\Http\Controllers;

use App\Models\Item;
use Illuminate\Http\Request;
use App\Models\InventoryReport;
use App\Models\ItemBOM;
use App\Models\ManufactureBOM;
use DateTime;
use App\Models\Purchase;
use App\Models\User;
use App\Models\ManufacturingHistory;
use App\Models\ManufacturingHistoryCost;
use App\Models\ItemStockLedger;
use App\Models\Customer;
use App\Models\MaterialProductCompositon;
use Illuminate\Support\Facades\Cache;


class ItemController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    public function index()
    {   
        $items = \DB::table('items')
            ->orderBy('item_name', 'ASC')
            ->paginate(100);

        $units = \DB::table('units')->get();
        return view('items.item-main', [
            'items' => $items,
            'units' => $units

        ]);
    }


    public function EditMenu()
    {

       
        $products = \DB::table('final_productions')
            ->where('store_category', 0)
            ->paginate(150);

        return view('items.menu-main', [
            'items' => $products,
            'units' => \DB::table('units')->get()
        ]);
    }


    public function makechangesMenu(Request $request)
    {
        $data = $request->all();
        if (array_key_exists('items', $data)) {
            foreach ($data['items'] as $key => $item) {

                \DB::table('final_productions')
                ->where('FinalProductionID', $item['menu_id'])
                ->update([
                    'UnitPrice' => $item['price']
                ]);
            }

        }

        return back()->with('status', 'Product prices updated successfully');
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $appdata = new Item;
        $appdata -> user_id = auth()->user()->id;
        $appdata -> item_name = $request->p_name;
        $appdata -> item_unit = $request->item_unit;
        $appdata -> item_category = $request->p_category;
        $appdata -> item_description = $request->p_description;
        $appdata -> item_code = $request->product_code;
        $appdata -> item_manufacturing = $request->item_manufacturing;
        $appdata -> transfer_status = $request->transfer_status;
        $appdata -> save();

        if ($request->item_manufacturing == 0) {

            \App\Models\ItemBOM::Create([
                'item_id' => $appdata->id,
                'bom_id' => $appdata->id,
                'user_id' => auth()->id(),
                'item_bom_name' => $request->p_name,
                'item_unit_measure' => $request->item_unit,
                'item_bom_unit' => 1,
                'item_bom_unit_rate' => 0,
                'chain_id' => $appdata->id
                
            ] );


        }

        return redirect()->to('/dashboard/item-add-composing/' . $appdata->id ."/". $request->p_name);

    }



    public function ActivateItems()
    {

        $dayClose = \DB::table('close_days')->first();
        $getItems = \DB::table('items')->get();

        foreach ($getItems as $key => $report) {
            

            \App\Models\ItemStockLedgerSummary::updateOrCreate([
                'station' => auth()->user()->station,
                'date' => $dayClose->day_close,
                'item_id' => $report->id],
                [
                'item_name' => $report-> item_name,
                'item_unit' => $report-> item_unit,
                'item_code' => $report-> item_code,
                'item_category' => $report-> item_category,
                'inactive_station' => $report-> inactive_station,
                'opening_stock' => 0,
                'stock_in' => 0,
                'stock_out' => 0,
                ]);
        }

        return back()->with('status', 'Items Activated Successfuly');
    }


    public function reverseManufacturing(ManufacturingHistory $ManufacturingHistory, Request $request)
    {
       

    \DB::table('stock_transactions')->where('transactions_id', $ManufacturingHistory->transactions_id)
    ->where('item_id',  $ManufacturingHistory->item_id)
    ->delete();
    

    $deleBOM = ManufactureBOM::where('item_id', $ManufacturingHistory->item_id)->pluck('bom_id');

    \DB::table('stock_transactions')->where('transactions_id', $ManufacturingHistory->transactions_id)
    ->whereIn('item_id',  $deleBOM)
    ->delete();

    $ManufacturingHistory->delete();

    \DB::table('manufacturing_history_costs')->where('manufacturing_history_id', $ManufacturingHistory->id)->delete();
   

       return back()->with('status', "Manufactured Item Reversed Successfully");
    }




    public function manufacturing()
    {  
        $dayClose = \DB::table('close_days')->first();
        $manufacturing =\DB::table('items')
            ->where('item_manufacturing', 1)
            ->get();



        return view('items.manufacturing', [
            'manufacturing' => $manufacturing,
            'manufacturingHistory' => \DB::table('manufacturing_histories')->where('station', auth()->user()->station)->whereDate('date', $dayClose->day_close)->get()
        ]);
    }


    public function ManCorrectDate()
    {

            $manufacturing =\DB::table('items')
                ->where('item_manufacturing', 1)
                ->get();
        
        return view('items.manufacture-correction-date', [
            'manufacturing' => $manufacturing,
            'manufacturingHistory' => \DB::table('manufacturing_histories')->where('station', auth()->user()->station)->whereDate('date', request('date'))->get()
        ]);

    }


    public function ManufacturingDatePrint(Request $request)
    {
        $value = explode(' - ', $request->date);
         

        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        $report_ledger = \DB::table('stock_transactions')->where('description', "Consumptions")
        ->where('station', auth()->user()->station)
        ->WhereDate('date','>=', $from)
        ->WhereDate('date','<=', $to)
        ->get();

        \App\Models\UserActivity::create([
            'changed_date' => \Carbon\carbon::now(),
            'user_id'=>auth()->id(),
            'event' => "viewed manufacturing cost report",
        ]);

        

        return view('inventory.print-manufacturing-cost', [
            'reports' =>$report_ledger
        ]);

    }


    public function ManufacturingPrepare(Request $request)
    {   
        $this->validate(request(), [ 
            'date'=>'required'
        ]);

        $app = \DB::table('settings')->first();

        try {
            \DB::beginTransaction();

        $transactions_id = "MANU".rand(5034,10034580)+rand(4580,10034580) . date("Yd") . date('Hi');


        $data = $request->all();
        if (array_key_exists('items', $data)) {
            foreach ($data['items'] as $key => $item) {

                $it =  \DB::table('items')->where('id', $item['item_code'])->first();
                    
                if (empty($item['item_qty'])) {
                    continue;
                }


                // Save BOM Quantities
                $item_bom = \DB::table('item_b_o_m_s')->where('item_id', $item['item_code'])->get();

                // MAnufacturing History
                $his = ManufacturingHistory::create([
                    'item_id' => $item['item_code'],
                    'item_name' => $item['item_name'],
                    'manufacturing_qty'=> $item['item_qty'],
                    'item_unit' => $item['item_unit'],
                    'manufacturing_comment' => $item['item_comment'],
                    'date' => request('date'),
                    'station'=> auth()->user()->station,
                    'rate' =>  $item_bom->sum('item_bom_unit_rate'),
                    'transactions_id' => $transactions_id
                ]);

                // ITEM STOCK LEDGER
                \App\Models\StockTransaction::create([
                    'user_id' => auth()->id(),
                    'item_id' =>  $item['item_code'],
                    'description' => 'Manufacture',
                    'unit' =>  $it->item_unit,
                    'station' => auth()->user()->station,
                    'date' => request('date'),
                    'stock_in' =>$item['item_qty'] ,
                    'cost' => $item_bom->sum('item_bom_unit_rate'),
                    'transactions_id' => $transactions_id
            ]);


            $stockCheck =  \DB::table('item_stock_ledger_summaries')->where('station', auth()->user()->station)->where('item_id', $item['item_code'])->whereDate('date', request('date'))->first();
            if (empty($stockCheck)) {

                $stock_qty =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $item['item_code'])
                                    ->WhereDate('date', '<' , request('date'))
                                    ->sum('stock_in') - \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $item['item_code'])
                        ->WhereDate('date', '<', request('date'))
                        ->sum('stock_out');

                

                \App\Models\ItemStockLedgerSummary::updateOrCreate([
                    'station' => auth()->user()->station,
                    'date' => request('date'),
                    'item_id' => $item['item_code']],
                    [
                    'item_name' => $it-> item_name,
                    'item_unit' => $it-> item_unit,
                    'item_code' => $it-> item_code,
                    'item_category' => $it-> item_category,
                    'inactive_station' => $it-> inactive_station,
                    'opening_stock' =>  $stock_qty,
                    'stock_in' => 0,
                    'stock_out' => 0,
                    ]);
            }


                
                if (empty($item_bom) || null) {
                    continue;
                }
                
                if ($app->production_check == 1) {

                $item_bom_test = \DB::table('manufacture_b_o_m_s')->where('item_id', $item['item_code'])->get();
                
                foreach ( $item_bom_test as $key => $bom ) {
                    
                    $unit = \DB::table('items')->where('id', $bom->bom_id)->first();


                    $balance_b_f =  \DB::table('item_stock_ledger_summaries')->where('station', auth()->user()->station)->where('item_id', $bom->bom_id)->whereDate('date', request('date'))->first();
    
                    $stock_in =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $bom->bom_id)->whereDate('date', request('date'))->sum('stock_in');
                    $stock_out =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $bom->bom_id)->whereDate('date', request('date'))->sum('stock_out');
    
                    $closing = ($balance_b_f->opening_stock + $stock_in) - $stock_out ;

                    if ($unit->item_stock_check == 1) {  
            
                        if ( ($closing - ( $bom->bom_qty * $item['item_qty']) < 0 )) {
        
                            \App\Models\StockTransaction::where('transactions_id',$transactions_id)->delete();
                            ManufacturingHistory::where('transactions_id',$transactions_id)->delete();
        
                            return back()->with('statuspass', 'Out of stock, ' . $unit->item_name);
                        }

                    }

                    if (empty($unit) || null) {
                        continue;
                    }

                    

                    \App\Models\StockTransaction::create([
                        'user_id' => auth()->id(),
                        'item_id' =>  $bom->bom_id,
                        'description' => 'Consumptions',
                        'note' => 'Production of ' .  $item['item_name'],
                        'unit' =>  $unit->item_unit,
                        'station' => auth()->user()->station,
                        'date' => request('date'),
                        'stock_out' => $item['item_qty'] * $bom->bom_qty,
                        'cost' =>\DB::table('item_b_o_m_s')->where('item_id', $bom->item_id )->where('chain_id', $bom->bom_id)->sum('item_bom_unit_rate')/$bom->bom_qty,
                        'transactions_id' => $transactions_id
                ]);
                   
                }
   
            }else {


                $item_bom_test = \DB::table('manufacture_b_o_m_s')->where('item_id', $item['item_code'])->get();
                                
                foreach ( $item_bom_test as $key => $bom ) {

                    $unit = \DB::table('items')->where('id', $bom->bom_id)->first();

                    if (empty($unit) || null) {
                        continue;
                    }


                    $stockCheck =  \DB::table('item_stock_ledger_summaries')->where('station', auth()->user()->station)->where('item_id', $bom->bom_id)->whereDate('date', request('date'))->first();
                    if (empty($stockCheck)) {

                        $stock_qty =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $bom->bom_id)
                                            ->WhereDate('date', '<' , request('date'))
                                            ->sum('stock_in') - \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $bom->bom_id)
                                ->WhereDate('date', '<', request('date'))
                                ->sum('stock_out');

                        

                        \App\Models\ItemStockLedgerSummary::updateOrCreate([
                            'station' => auth()->user()->station,
                            'date' => request('date'),
                            'item_id' => $bom->bom_id],
                            [
                            'item_name' => $unit-> item_name,
                            'item_unit' => $unit-> item_unit,
                            'item_code' => $unit-> item_code,
                            'item_category' => $unit-> item_category,
                            'inactive_station' => $unit-> inactive_station,
                            'opening_stock' =>  $stock_qty,
                            'stock_in' => 0,
                            'stock_out' => 0,
                            ]);
                    }


                    

                    \App\Models\StockTransaction::create([
                        'user_id' => auth()->id(),
                        'item_id' =>  $bom->bom_id,
                        'description' => 'Consumptions',
                        'note' => 'Production of ' .  $item['item_name'],
                        'unit' =>  $unit->item_unit,
                        'station' => auth()->user()->station,
                        'date' => request('date'),
                        'stock_out' => $item['item_qty'] * $bom->bom_qty,
                        'cost' =>\DB::table('item_b_o_m_s')->where('item_id', $bom->item_id )->where('chain_id', $bom->bom_id)->sum('item_bom_unit_rate')/$bom->bom_qty,
                        'transactions_id' => $transactions_id
                ]);

                   
                }
            }

        }
        

        }

        \App\Models\UserActivity::create([
            'changed_date' => \Carbon\carbon::now(),
            'user_id'=>auth()->id(),
            'event' => "Manufacturing of " . $it->item_name,
        ]);

        
        \DB::commit(); 
        return back()->with('status', "Item Manufactured Successfully");
            } catch (\Throwable $th) {
                \DB::rollback();
                return response([
                    'status' => 501,
                    "Message" => $th
                ]);
            }
    }


    public function updateItem($id)
    {
        
        \DB::table('items')->where('id', $id)->update([
                'inactive_station' =>empty(request('stations')) ? "[]" :  json_encode(request('stations'))
           ] );

           return back()->with('status', 'Deactivated for selected outlets');
    }


    public function manufactureSingle()
    {
        $this->validate(request(), [
            'stock' => 'required',
            'quantity' => 'required'
        ]);


        $dayClose = \DB::table('close_days')->first();

        try {
            \DB::beginTransaction();

        $item = \DB::table('items')->where('id',  request('stock'))->first();

         // Save BOM Quantities
         $item_bom = \DB::table('item_b_o_m_s')->where('item_id', request('stock'))->get();

         $his = ManufacturingHistory::create([
             'item_id' =>request('stock'),
             'item_name' => $item->item_name,
             'manufacturing_qty'=>  request('quantity'),
             'item_unit' => $item->item_unit,
             'manufacturing_comment' => request('comment'),
             'date' => $dayClose->day_close,
             'station'=>auth()->user()->station,
             'rate' => request('quantity')* $item_bom->sum('item_bom_unit_rate')
         ]);

        
         
         foreach ( $item_bom as $key => $bom ) {
             $unit = \DB::table('items')->where('id', $bom->bom_id)->first();

             if (empty($unit) || null) {
                 continue;
             }

             $GetOldRate = \DB::table('item_stock_ledgers')
             ->where('item_id', $unit->id)
             ->whereDate('date', $dayClose->day_close,)
             ->where('station', auth()->user()->station)
             ->first();


             if ($GetOldRate->item_stock_check == 1) {

               $closing_balance = (($GetOldRate->item_opening_stock+$GetOldRate->item_recieved+$GetOldRate->item_purchases+$GetOldRate->item_manufacturing) - ($GetOldRate->item_issue+$GetOldRate->item_sales+$GetOldRate->item_adjustment+$GetOldRate->item_wastage+$GetOldRate->item_cons_manufacturing));
                
              $stock = ($closing_balance - request('quantity')) * $bom->item_bom_unit;

              if ($stock < 1) {
                ManufacturingHistory::where('id', $his->id)->delete();
                return back()->with('statuspass', 'Manufacturing Failed ' . $unit->item_name . " is out of stock");
              }

                
            }

             if (empty($GetOldRate) || null) {
                 continue;
             }

             $GetOldRate = $GetOldRate->item_cost;

             ManufacturingHistoryCost::create([
                 'item_id' => $bom->bom_id,
                 'manufacturing_history_id' => $his->id, 
                 'item_name' => $unit->item_name,
                 'manufacturing_qty'=> request('stock') * $bom->item_bom_unit,
                 'item_unit' => $item->item_unit,
                 'date' => $dayClose->day_close,
                 'station'=>auth()->user()->station,
                 'rate' => $GetOldRate
             ]);

            //  ItemStockLedger::updateOrcreate([
            //      'item_id' => $bom->bom_id,
            //      'date' => $dayClose->day_close,
            //      'station' => auth()->user()->station
            //  ],
            //  [
            //      'item_id' => $bom->bom_id,
            //      'date' => $dayClose->day_close,
            //      'item_unit' => $unit -> item_unit,
            //      'station' => auth()->user()->station,
            //      'item_name' => $unit->item_name,
            //      'item_cons_manufacturing' => \DB::raw('item_cons_manufacturing + ' . (float)(request('quantity') * $bom->item_bom_unit)),
            //  ]
            //  );
            
         }

         \DB::table('item_stock_ledgers')
             ->where('item_id' , request('stock'))
             ->whereDate('date', $dayClose->day_close)
             ->where('station', auth()->user()->station)
             ->update([
                 'item_manufacturing' => \DB::raw('item_manufacturing +' . request('quantity')),
             ]);

        $this->manufacturingReload();

        \DB::commit(); 
        return back()->with('status', "Item Manufactured Successfully");
            } catch (\Throwable $th) {
                \DB::rollback();
                return response([
                    'status' => 501,
                    "Message" => $th
                ]);
            }

        }



        public function manufacturingReload()
    {
        $getDayClose = \DB::table('close_days')->first();

        $manufacture = \DB::table('manufacturing_histories')
        ->selectRaw('item_id as item_id, sum(manufacturing_qty) as manufacturing_qty, sum(rate) as rate')
        ->groupBy('item_id')
        ->where('date', $getDayClose->day_close)
        ->where('station', auth()->user()->station)
        ->get();

    if (!empty($manufacture)) {

        foreach ($manufacture as $key => $manufacture) {

            \DB::table('item_stock_ledgers')
                    ->where('item_id' , $manufacture->item_id)
                    ->whereDate('date', $getDayClose->day_close)
                    ->where('station', auth()->user()->station)
                    ->update([
                        'item_manufacturing' => $manufacture->manufacturing_qty,
                    ]);
                

        $item_bom = \DB::table('item_b_o_m_s')->where('item_id', $manufacture->item_id)->get();


        foreach ( $item_bom as $key => $bom ) {
            $unit = \DB::table('items')->where('id', $bom->bom_id)->first();

            if (empty($unit) || null) {
                continue;
            }

            $GetOldRate = \DB::table('item_stock_ledgers')
            ->where('item_id', $unit->id)
            ->whereDate('date',  $getDayClose->day_close)
            ->where('station', auth()->user()->station)
            ->first();

            if (empty($GetOldRate) || null) {
                continue;
            }

            $GetOldRate = $GetOldRate->item_cost;


            ItemStockLedger::updateOrcreate([
                'item_id' => $bom->bom_id,
                'date' => $getDayClose->day_close,
                'station' => auth()->user()->station
            ],
            [
                'item_id' => $bom->bom_id,
                'date' => $getDayClose->day_close,
                'item_unit' => $unit -> item_unit,
                'station' => auth()->user()->station,
                'item_name' => $unit->item_name,
                'item_cons_manufacturing' =>  $manufacture->manufacturing_qty * $bom->item_bom_unit,
            ]
            );
        }
    }
    }

    return back()->with('status', "manufacturing-reloaded successfully");
    }



    public function addCompositionToProduct($id, $name)
    {   
        
        // check for Product Code
        $item = \DB::table('items')->where('id', $id)->first();

        if ($item->item_code == null) {
            $item_code = "IT-".substr(str_shuffle("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, 6) . date("hi");
        }else {
            $item_code = $item->item_code;
        }


        $item_bom = new ItemBOM;
        
        $item_bom = $item_bom->getBOMItems($id);

        // foreach($item_bom as $result)
        // {
        //     if( $result->is_manufactured == 1 )
        //     {
        //         dd($result->composition());
        //     }
        // }
        // dd('end');
        //  return $item_bom = \DB::table('item_b_o_m_s')->where('item_id',$id)->get();

        // display Estimated Cost
         $estimated_cost = \DB::table('item_b_o_m_s')->where('item_id',$id)->pluck('item_bom_unit_rate')->sum();

         $dayClose = \DB::table('close_days')->first();
         $itemsVoucher = \DB::table('items')->where('transfer_status', 1)->pluck('id');

         

        
        return view('items.item-otherdetails', [
            'base_unit' => $item->item_unit,
            'name' => $item->item_name,
            'item_id' => $id,
            'conversion' => \DB::table('unit_conversions')->where('item_id', $id)->get(),
            'item_bom_unit' => $item_bom,
            'estimated_cost' => $estimated_cost,
            'item_details' => \DB::table('items')->where('id', $id)->first(),
            'item_issues' => \DB::table('items')->get(),
            'units' => \DB::table('units')->get()
        ]);
    }


    public function salesTransactionsCashier()
    {

        $this->validate(request(), [
            'start_date' =>'required',
            'end_date' =>'required'
        ]);
        
        $from = request('start_date');
        $to =   request('end_date');

       $user = \DB::table('users')->where('id',  request('user'))->first();
        return view('cashier-report', [
                'orders'=> \DB::table('invoices')->where('user_id', request('user'))
                ->WhereDate('created_at','>=', $from)
                ->WhereDate('created_at','<=', $to)
                ->get(),
                'user' =>  $user
        ]);
    }


    public function ImportBillOfMaterial(Request $request)
    {
        $this->validate($request,[
            'file' => 'required'
          ]);

           $upload = $request->file('file');
           $filePath = $upload->getRealPath();

           $file = fopen($filePath, 'r');

           $header = fgetcsv($file);

           $escapedHeader=[];

           // data validation
           
           foreach ($header as $key => $value) {
             $escapedItem = strtolower($value) ;
             array_push($escapedHeader, $escapedItem);

           }

           //looping through colums to get data

           while ($columns=fgetcsv($file)) {
             
             if ($columns[0] =="") {
              continue;
             }
	
	   try{
           //trim data
           foreach ($columns as $key => &$value) {
             $value = ucwords($value);
           }
           
	   $data = array_combine($escapedHeader, $columns);
           
       $item = $data['item_name'];
       $bom_name = $data['store_item'];
       $units = $data['quantity'];
       
       $itemdata = \DB::table('items')->where('item_name', $item)->first();
       $itemdataBOM = \DB::table('items')->where('item_name', $bom_name)->first();
       
       if (empty($itemdata) || null) {
           continue;
       }
    
    $getCodes = \DB::table('final_productions')->where('Name', $item)->first();

    if ($getCodes->FinalProductionID == null || empty($getCodes->FinalProductionID)) {
        continue;
    }
    
    // Get Manufacturing Price
    $checkManfactureBOM = \DB::table('item_b_o_m_s')->where('item_id', $itemdataBOM->id)->sum('item_bom_unit_rate');


    $data = new MaterialProductCompositon;
    $data -> product_id = $getCodes->FinalProductionID;
    $data -> composition_id = $itemdataBOM->id;
    $data -> unit_measure = $units;
    $data -> cost = $checkManfactureBOM * $units;
    $data -> product_name = $itemdataBOM->item_name;
    $data -> product_code = empty($getCodes->product_code) ? shuffle(0, 40) : $getCodes->product_code;
    $data -> raw_material_code = $itemdataBOM->item_code;
    $data->save();
         
            
            }catch(\Exception $ex){
            	return back()->with('status','something is wrong, kindly download the csv file ' . $ex . '<a href="/uploads/products.csv">Here</a>' . ' as a guide');
            	}

        }
        return back()->with('status', 'Data Loaded Successfully');
    }



    public function ChangeProduct(Item $appdata, Request $request)
    {   
        $dayClose = \DB::table('close_days')->first();

        if (empty(request('stations'))) {
            $stations = [];
        }else {
            $stations = json_encode(request('stations'));
        }

        $appdata -> item_name = $request->p_name;
        $appdata -> item_unit = $request->item_unit;
        $appdata -> item_category = $request->p_category;
        $appdata -> item_description = $request->p_description;
        $appdata -> item_code = $request->product_code;
        $appdata -> item_manufacturing = $request->item_manufacturing;
        $appdata -> transfer_status = $request->transfer_status;
        $appdata -> inactive_station = $stations;
        $appdata -> save();


        $kitchens = \DB::table('kitchens')->get();

        foreach ($kitchens as $key => $kitchen) {
            $items = \DB::table('items')->where('id', $appdata->id)->first();

            \App\Models\ItemStockLedgerSummary::updateOrCreate([
                'item_id' => $appdata->id,
                'station' => $kitchen->kitchen_name,
                'date' => $dayClose->day_close,
            ], [
                'item_name' => $items->item_name,
                'item_unit' => $items->item_unit,
                'item_code' => $items-> item_code,
                'item_category' => $items-> item_category,
                'inactive_station' => $items-> inactive_station,
            ]);
        }
       


        return back()->with('status', "Item Updated Successfully");
    }



    public function TopCustomer()
    {
        $this->validate(request(), [
            'date' => 'required',
            'type' => 'required',
            'branch' => 'required'
        ]);


        $value = explode(' - ', request('date'));

            $source1 = $value[0];
            $date1 = new DateTime($source1);
            $from = $date1->format('Y-m-d');

            $source2 = $value[1];
            $date2 = new DateTime($source2);
            $to = $date2->format('Y-m-d');


        if (request('type') == 1) {
            
            $walk = \DB::table('customers')->where('customer_name', "WALK-IN CUSTOMER")->pluck('id');

            $top_customers = \DB::table('orders')
            ->selectRaw('customer_id as customer_code, count(order_id) as orders, sum(total_cost_order) as total')
            ->groupBy('customer_id')
            ->whereNotIn('customer_id', $walk)
            ->where('branch', request('branch'))
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->orderBy('total', "DESC")->get();

            return view('top-customer', [
                'top_customers' => $top_customers
            ]);
            
        }else {

            $top_customers = \DB::table('orders')
            ->select('customer_id', 'order_id')
            ->where('branch', request('branch'))
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->pluck('customer_id');


            $not = \DB::table('customers')
            ->whereNotIn('id', $top_customers)
            ->paginate(100);

            return view('non-performing-customers', [
                'non_performings' => $not
            ]); 
        }
    }

    
    public function salesTransactions(Customer $customer)
    {
        
        $orders = \DB::table('invoices')->whereIn('invoice_number', \DB::table('orders')->where('customer_id', $customer->id)->pluck('order_id'))->get();
        return view('customer-transactions', [
            'orders' => $orders,
            'customer' => $customer
        ]);
    }



    public function NonPerformingCustomers(Type $var = null)
    {
        $this->validate(request(), [
            'date' => 'required',
            'type' => 'required',
            'branch' => 'required'
        ]);
    }



    public function ItemHistory(Request $request)
    {   
        $id = $request -> item_id;
        $value = explode(' - ', $request->date);
         

        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        $manufacturing = \DB::table('manufacturing_histories')
            ->where('station', auth()->user()->station)
            ->WhereDate('date','>=', $from)
            ->WhereDate('date','<=', $to)
            ->where('item_id', $id)
            ->get();

        if ($from == $to) {            
            $incomingvouchers = \DB::table('issue_vouchers')
                ->where('issue_item_id', $id)
                ->where('issue_store', auth()->user()->station)
                ->where('issue_status', 1)
                ->whereDate('issue_date', $from)
                ->get();


            $purchases = \DB::table('purchases')
                ->where('purchase_state', "C")
                ->whereDate('purchase_date', $from)
                ->where('purchase_item_id', $id)
                ->where('station', auth()->user()->station)
                ->get();

        $outgoingVoucher = \DB::table('issue_vouchers')
            ->join('users', 'issue_vouchers.user_id','users.id')
            ->where('issue_vouchers.issue_item_id', $id)
            ->where('issue_vouchers.issue_status', 1)
            ->where('issue_vouchers.station',auth()->user()->station)
            ->whereDate('issue_vouchers.issue_date', $from)
            ->get();

            $wastage = \DB::table('item_stock_ledgers')
                ->select('item_wastage', 'wastage_comment', 'date', 'item_unit')
                ->where('item_id', $id)
                ->where('item_wastage', "!=", 0)
                ->where('item_wastage', "!=", Null)
                ->whereDate('date', $from)
                ->where('station',auth()->user()->station)
                ->get();

           $good_receipt = \DB::table('good_receipts')
                ->join('users', 'good_receipts.user_id', 'users.id')
                ->where('good_receipts.g_r_state', "C")
                ->where('good_receipts.station', auth()->user()->station)
                ->where('good_receipts.g_r_item_id', $id)
                ->WhereDate('good_receipts.g_r_date', $from)
                ->get();

          
                $manufacturingConsumption = \DB::table('manufacturing_history_costs')
                ->selectRaw('item_id as item_id, date as date, item_name as item_name, item_unit as item_unit, sum(manufacturing_qty) as manufacturing_qty')
                    ->groupBy('item_id')
                    ->groupBy('item_unit')
                    ->groupBy('item_name')
                    ->groupBy('date')
                    ->where('item_id', $id)
                    ->where('station', auth()->user()->station)
                    ->whereDate('date', $from)
                ->get();
            
            $products = \DB::table('material_product_compositons')
            ->where('composition_id',$id)
            ->pluck('product_id');

            // get Assigned Branch Sales
            $saleliite = \DB::table('kitchens')->where('kitchen_name',auth()->user()->station)->first();
            

            if (!empty($saleliite)) {

                $branch = \DB::table('branches')->where('branch_code', $saleliite->kitchen_code)->first();

                $sales_today_lists = \DB::table('invoices')
                ->whereIn('product_id', $products)
                ->where('invoice_status', 1)
                ->where('branch', $branch->branch_name)
                ->whereDate('created_at', $from)
                ->get();
            }else {
                $sales_today_lists = null;
            }
        }else{
            $incomingvouchers = \DB::table('issue_vouchers')
            ->where('issue_item_id', $id)
            ->where('issue_store', auth()->user()->station)
            ->WhereDate('issue_date','>=', $from)
            ->WhereDate('issue_date','<=', $to)
            ->get();


        $purchases = \DB::table('purchases')
            ->where('purchase_state', "C")
            ->WhereDate('purchase_date','>=', $from)
            ->WhereDate('purchase_date','<=', $to)
            ->where('purchase_item_id', $id)
            ->where('station', auth()->user()->station)
            ->get();

    $outgoingVoucher = \DB::table('issue_vouchers')
        ->join('users', 'issue_vouchers.user_id','users.id')
        ->where('issue_vouchers.issue_item_id', $id)
        ->where('issue_vouchers.station',auth()->user()->station)
        ->WhereDate('issue_vouchers.issue_date','>=', $from)
        ->WhereDate('issue_vouchers.issue_date','<=', $to)
        ->get();

        $wastage = \DB::table('item_stock_ledgers')
            ->select('item_wastage', 'wastage_comment', 'date', 'item_unit')
            ->where('item_id', $id)
            ->WhereDate('date','>=', $from)
            ->WhereDate('date','<=', $to)
            ->where('station',auth()->user()->station)
            ->get();

                $manufacturingConsumption = \DB::table('manufacturing_history_costs')
                ->selectRaw('item_id as item_id, date as date, item_name as item_name, item_unit as item_unit, sum(manufacturing_qty) as manufacturing_qty')
                    ->groupBy('item_id')
                    ->groupBy('item_unit')
                    ->groupBy('item_name')
                    ->groupBy('date')
                    ->where('item_id', $id)
                    ->where('station', auth()->user()->station)
                    ->WhereDate('date','>=', $from)
                    ->WhereDate('date','<=', $to)
                    ->get();

        
        $products = \DB::table('material_product_compositons')
        ->where('composition_id',$id)
        ->pluck('product_id');

        // get Assigned Branch Sales
        $saleliite = \DB::table('kitchens')->where('kitchen_name',auth()->user()->station)->first();
        if (!empty($saleliite)) {

            $branch = \DB::table('branches')->where('branch_code', $saleliite->kitchen_code)->first();

            $sales_today_lists = \DB::table('invoices')
            ->whereIn('product_id', $products)
            ->where('invoice_status', 1)
            ->where('branch', $branch->branch_name)
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->get();
        }else {
            $sales_today_lists = null;
        }

        // $sales_today_lists = \DB::table('invoices')
        // ->whereIn('product_id', $products)
        // ->where('invoice_status', 1)
        // ->where('branch', $branch->branch_name)
        // ->WhereDate('created_at','>=', $from)
        // ->WhereDate('created_at','<=', $to)
        // ->get();

        $good_receipt = \DB::table('good_receipts')
                ->join('users', 'good_receipts.user_id', 'users.id')
                ->where('good_receipts.g_r_state', "C")
                ->where('good_receipts.station', auth()->user()->station)
                ->where('good_receipts.g_r_item_id', $id)
                ->WhereDate('good_receipts.g_r_date','>=', $from)
                ->WhereDate('good_receipts.g_r_date','<=', $to)
                ->get();

        $closing = \DB::table('item_stock_ledgers')
            ->whereDate('date', $to)
            ->where('item_id', $id)
            ->where('station', auth()->user()->station)
            ->first();

        $opening = \DB::table('item_stock_ledgers')
        ->whereDate('date', $from)
        ->where('item_id', $id)
        ->where('station', auth()->user()->station)
        ->first();
        }

       

        return view('item-history', [
            'incomingvouchers' => $incomingvouchers,
            'purchases' => $purchases,
            'outgoingVoucher' => $outgoingVoucher,
            'wastage' => $wastage,
            'manufacturingConsumption' => $manufacturingConsumption,
            'sales_today_lists' => $sales_today_lists,
            'opening' => empty($opening) ? $opening = 0 : $openin=$opening->item_opening_stock,
            'closing' => empty($closing) ?  $closing = 0 : $closing= (($closing->item_opening_stock+$closing->item_recieved+$closing->item_purchases+$closing->item_manufacturing) - ($closing->item_issue+$closing->item_sales+$closing->item_adjustment+$closing->item_wastage+$closing->item_cons_manufacturing)),
            'good_receipt' => $good_receipt,
            'item_id' => $id,
            'manufacturingHistory' => $manufacturing
        ]);
    }


    public function FItemHistoryLoad(Request $request, $item)
    {
        $getDayClose = \DB::table('close_days')->first();

        $items = \DB::table('items')->where('item_name', 'LIKE', '%' . $item . '%')->first();

        if (empty($items) || $items == null) {
            return back()->with('status', 'Item not found in ledger..check keyword');
        }

       
        $request->merge([
            'item_id' => $items->id
        ]);

        $from = $getDayClose->day_close;
        $to =  $getDayClose->day_close;
        

        if ($from == $to) {

            $balance_b_f =  \DB::table('stock_transactions')
            ->where('station', auth()->user()->station)->where('item_id', request('item_id'))
            ->WhereDate('date', '<', $to)
            ->sum('stock_in') - 

            \DB::table('stock_transactions')
            ->where('station', auth()->user()->station)->where('item_id', request('item_id'))
            ->WhereDate('date', '<', $to)
            ->sum('stock_out');

                      
            $transactions_db = \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', request('item_id'))
            ->WhereDate('date','>=', $from)
            ->WhereDate('date','<=', $to)
            ->orderBy('id', "ASC")
            ->get();
            
            $ending_b_f = null;
        }else {
            $balance_b_f =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', request('item_id'))->whereDate('date', '<', $from)->sum('stock_in') - 
            \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', request('item_id'))->whereDate('date', '<', $from)->sum('stock_out');

            $ending_b_f =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', request('item_id'))
            ->WhereDate('date','>=', $from)
            ->WhereDate('date','<=', $to)
            ->OrderBy('id', 'DESC')->first();

           $transactions_db = \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', request('item_id'))
            ->WhereDate('date','>=', $from)
            ->WhereDate('date','<=', $to)
            ->orderBy('id', "ASC")
            ->get();
        }
        return view('stock-history', [
                'item' => \DB::table('items')->where('id', request('item_id'))->first(),
                'transactions_db' => $transactions_db,
                'balance_b_f_' => empty($balance_b_f) ? 0  : $balance_b_f,
                'from' => $from,
                'to' => $to,
                'ending_b_f' => $ending_b_f,
                'main_balance' => $transactions_db->first()
        ]);
    }




    public function ItemHistoryPrint($item_id)
    {
        $date =  session()->get('item_history_date');

        if (empty($date)) {

            $getDayClose = \DB::table('close_days')->first();
            $date = $getDayClose->day_close . " - " . $getDayClose->day_close;
          
        }

        $value = explode(' - ', $date);
         
        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');


        if ($from == $to) { 
            $reporting = \DB::table('item_stock_ledgers')
            ->where('item_id', $item_id)
            ->whereDate('date', $from)
            ->where('station', auth()->user()->station)
            ->get();
        }else {
            $reporting =\DB::table('item_stock_ledgers')
            ->where('item_id', $item_id)
            ->WhereDate('date','>=', $from)
            ->WhereDate('date','<=', $to)
            ->where('station', auth()->user()->station)
            ->get();
        }

        $item = \DB::table('items')->where('id', $item_id)->first();
        return view('inventory.print-item-history', [
            'reporting' => $reporting,
            'from' => $from,
            'to' => $to,
            'item' => $item 
        ]);
    }
    
    public function getUnit($id)
    {
        return \DB::table('unit_conversions')->where('item_id', $id)->pluck('conversion_unit');
    }
    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Item  $item
     * @return \Illuminate\Http\Response
     */
    public function load(Request $request)
    {   
            $this->validate($request,[
                'file' => 'required'
            ]);

            $upload = $request->file('file');
            $filePath = $upload->getRealPath();

            $file = fopen($filePath, 'r');

            $header = fgetcsv($file);

            $escapedHeader=[];

            // data validation
            
            foreach ($header as $key => $value) {
                $escapedItem = strtolower($value) ;
                array_push($escapedHeader, $escapedItem);

            }

            //looping through colums to get data

            while ($columns=fgetcsv($file)) {
                
                if ($columns[0] =="") {
                continue;
                }
        
        try{
            //trim data
            foreach ($columns as $key => &$value) {
                $value = ucwords($value);
            }
            
        $data = array_combine($escapedHeader, $columns);
            

                $item = $data['item_name'];
                $unit = $data['unit'];
                $category = $data['category'];
                $manufacturing = $data['manufacturing'];
                $code = $data['code'];


                $appdata = new Item;
                $appdata -> item_name = $item;
                $appdata -> user_id = auth()->user()->id;
                $appdata -> item_unit = $unit;
                $appdata -> item_category = $category;
                $appdata -> item_manufacturing = $manufacturing;
                $appdata -> item_code = $code;
                $appdata -> save();
                
                }catch(\Exception $ex){
                    return back()->with('status','something is wrong, kindly download the csv file ' . '<a href="/files/importsalary.csv">Here</a>' . ' as a guide');
                    }

            }
            return back()->with('status', 'Items Imported Successfully');
    
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Item  $item
     * @return \Illuminate\Http\Response
     */
    public function edit(Item $item)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Item  $item
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Item $item)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Item  $item
     * @return \Illuminate\Http\Response
     */
    public function destroy(Item $item)
    {   
        try {
            $item->delete();
            return redirect('/dashboard/items/new-item')->with('status', 'Item Removed Successfully');
        } catch (\Throwable $th) {
            return back()->with('statuspass', "Sorry, this item cannot be deleted");
        }
    }



    public function productSettings()
    {
      return view('menu-bom', [
        'items'=> \DB::table('final_productions')->get(),
        'Allitems' => \DB::table('items')->get()
      ]);
    }


    public function exportBOM()
    {
        $materials = \DB::table('material_product_compositons')->get();
        return view('items.bom-export', [
            'materials'  => $materials
        ]);
    }



    public function manufacture_job($request, $date_range)
    {
        
        $data = $request->all();
        if (array_key_exists('items', $data)) {
            foreach ($data['items'] as $key => $item) {
                    
                if (empty($item['item_qty'])) {
                    continue;
                }

                // Save BOM Quantities
                $item_bom = \DB::table('item_b_o_m_s')->where('item_id', $item['item_code'])->get();

                $his = ManufacturingHistory::create([
                    'item_id' => $item['item_code'],
                    'item_name' => $item['item_name'],
                    'manufacturing_qty'=> $item['item_qty'],
                    'item_unit' => $item['item_unit'],
                    'manufacturing_comment' => $item['item_comment'],
                    'date' => $date_range[0],
                    'station'=>auth()->user()->station,
                    'rate' => $item['item_qty'] * $item_bom->sum('item_bom_unit_rate')
                ]);


                
                if (empty($item_bom) || null) {
                    continue;
                }
                
                \DB::table('item_stock_ledgers')
                    ->where('item_id' , $item['item_code'])
                    ->whereDate('date', $date_range[0])
                    ->where('station', auth()->user()->station)
                    ->update([
                        'item_manufacturing' => \DB::raw('item_manufacturing +' . $item['item_qty']),
                    ]);
                
                foreach ( $item_bom as $key => $bom ) {
                    $unit = \DB::table('items')->where('id', $bom->bom_id)->first();

                    if (empty($unit) || null) {
                        continue;
                    }

                    $GetOldRate = \DB::table('item_stock_ledgers')
                    ->where('item_id', $unit->id)
                    ->whereDate('date', $date_range[0])
                    ->where('station', auth()->user()->station)
                    ->first();

                    if (empty($GetOldRate) || null) {
                        continue;
                    }

                    $GetOldRate = $GetOldRate->item_cost;

                    ManufacturingHistoryCost::create([
                        'item_id' => $bom->bom_id,
                        'manufacturing_history_id' => $his->id, 
                        'item_name' => $unit->item_name,
                        'manufacturing_qty'=> $item['item_qty'] * $bom->item_bom_unit,
                        'item_unit' => $item['item_unit'],
                        'date' => $date_range[0],
                        'station'=>auth()->user()->station,
                        'rate' => $GetOldRate
                    ]);

                    ItemStockLedger::updateOrcreate([
                        'item_id' => $bom->bom_id,
                        'date' => $date_range[0],
                        'station' => auth()->user()->station
                    ],
                    [
                        'item_id' => $bom->bom_id,
                        'date' => $date_range[0],
                        'item_unit' => $unit -> item_unit,
                        'station' => auth()->user()->station,
                        'item_name' => $unit->item_name,
                        'item_cons_manufacturing' => \DB::raw('item_cons_manufacturing + ' . (float)($item['item_qty'] * $bom->item_bom_unit)),
                    ]
                    );
                   
                }
   
            }

        }
    }


    public function manufacture_end_job($request, $lastDate)
    {
        $newdate = date('Y-m-d', strtotime('-1 day', strtotime($lastDate)));

            $data = $request->all();
            if (array_key_exists('items', $data)) {
                foreach ($data['items'] as $key => $item) {
                        
                    if ($item['item_qty'] == null) {
                        continue;
                    }

                    $previous_stock = \DB::table('item_stock_ledgers')
                        ->where('item_id' , $item['item_code'])
                        ->whereDate('date', $newdate)
                        ->where('station', auth()->user()->station)
                        ->get();

                    foreach ($previous_stock as $key => $previous_stock) {

                    // Save BOM Quantities
                    $item_bom = \DB::table('item_b_o_m_s')->where('item_id', $item['item_code'])->get();
                    
                    
                    \DB::table('item_stock_ledgers')
                        ->where('item_id' , $item['item_code'])
                        ->whereDate('date', $lastDate)
                        ->where('station', auth()->user()->station)
                        ->update([
                            'item_opening_stock' => (($previous_stock->item_opening_stock+$previous_stock->item_recieved+$previous_stock->item_purchases+$previous_stock->item_manufacturing) - ($previous_stock->item_issue+$previous_stock->item_sales+$previous_stock->item_adjustment+$previous_stock->item_wastage+$previous_stock->item_cons_manufacturing)),
                        ]);
                    

                    foreach ( $item_bom as $key => $bom ) {

                        // $cost [] = \DB::table('manufacture_b_o_m_s')->where('item_id', $bom->bom_id)->first();
                        $exiting = \DB::table('item_stock_ledgers')
                            ->where('item_id' ,  $bom->bom_id)
                            ->whereDate('date', $newdate)
                            ->where('station', auth()->user()->station)
                            ->get();

                        foreach ($exiting as $key => $exiting) {

                            $unit = \DB::table('items')->where('id', $bom->bom_id)->first();

                            if (empty($unit) || null) {
                                continue;
                            }
                            ItemStockLedger::updateOrcreate([
                                'item_id' => $bom->bom_id,
                                'date' => $lastDate,
                                'station' => auth()->user()->station
                            ],
                            [
                                'item_id' => $bom->bom_id,
                                'date' => $lastDate,
                                'item_unit' => $unit -> item_unit,
                                'station' => auth()->user()->station,
                                'item_name' => $unit->item_name,
                                'item_opening_stock' => (($exiting->item_opening_stock+$exiting->item_recieved+$exiting->item_purchases+$exiting->item_manufacturing) - ($exiting->item_issue+$exiting->item_sales+$exiting->item_adjustment+$exiting->item_wastage+$exiting->item_cons_manufacturing)),
                            ]);
                            

                        }
                    }
                }
              }
            }
    }

    public function manufacture_nextday_job($request, $date_range)
    {
        $newdate = date('Y-m-d', strtotime('-1 day', strtotime($date_range)));

            $data = $request->all();
            if (array_key_exists('items', $data)) {
                foreach ($data['items'] as $key => $item) {
                        
                    if ($item['item_qty'] == null) {
                        continue;
                    }

                    $previous_stock = \DB::table('item_stock_ledgers')
                        ->where('item_id' , $item['item_code'])
                        ->whereDate('date', $newdate)
                        ->where('station', auth()->user()->station)
                        ->get();

                    foreach ($previous_stock as $key => $previous_stock) {

                    // Save BOM Quantities
                    $item_bom = \DB::table('item_b_o_m_s')->where('item_id', $item['item_code'])->get();
                    
                    
                    \DB::table('item_stock_ledgers')
                        ->where('item_id' , $item['item_code'])
                        ->whereDate('date', $date_range)
                        ->where('station', auth()->user()->station)
                        ->update([
                            'item_opening_stock' => (($previous_stock->item_opening_stock+$previous_stock->item_recieved+$previous_stock->item_purchases+$previous_stock->item_manufacturing) - ($previous_stock->item_issue+$previous_stock->item_sales+$previous_stock->item_adjustment+$previous_stock->item_wastage+$previous_stock->item_cons_manufacturing)),
                        ]);
                    

                    foreach ( $item_bom as $key => $bom ) {

                        // $cost [] = \DB::table('manufacture_b_o_m_s')->where('item_id', $bom->bom_id)->first();
                        $exiting = \DB::table('item_stock_ledgers')
                            ->where('item_id' ,  $bom->bom_id)
                            ->whereDate('date', $newdate)
                            ->where('station', auth()->user()->station)
                            ->get();

                        foreach ($exiting as $key => $exiting) {

                            $unit = \DB::table('items')->where('id', $bom->bom_id)->first();

                            if (empty($unit) || null) {
                                continue;
                            }
                            
                            ItemStockLedger::updateOrcreate([
                                'item_id' => $bom->bom_id,
                                'date' => $date_range,
                                'station' => auth()->user()->station
                            ],
                            [
                                'item_id' => $bom->bom_id,
                                'date' => $date_range,
                                'item_unit' => $unit -> item_unit,
                                'station' => auth()->user()->station,
                                'item_name' => $unit->item_name,
                                'item_opening_stock' => (($exiting->item_opening_stock+$exiting->item_recieved+$exiting->item_purchases+$exiting->item_manufacturing) - ($exiting->item_issue+$exiting->item_sales+$exiting->item_adjustment+$exiting->item_wastage+$exiting->item_cons_manufacturing)),
                            ]);
                        }
                    }
                }
              }
            }
        }
}
