<?php


namespace App\Http\Controllers;

use App\Models\ItemStockLedger;
use App\Models\ItemStockLedgerSummary;
use App\Models\ItemBOM;
use Illuminate\Http\Request;
use App\Models\InventoryReport;
use App\Models\ManufactureBOM;
use App\Models\Item;
use DateTime;
use App\Models\OpeningStock;
use App\Models\CompositionRecord;
use Illuminate\Support\Facades\Cache;

class ItemStockLedgerController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {   

        \App\Models\UserActivity::create([
            'changed_date' => \Carbon\carbon::now(),
            'user_id'=>auth()->id(),
            'event' => "Previewed Item Stock Ledger for ". auth()->user()->station,
        ]);


        $items = \DB::table('stock_transactions')
                ->where('station', auth()->user()->station)
                ->WhereDate('date','>=', request('start_date'))
                ->WhereDate('date','<=', request('end_date'))->pluck('item_id');
        
        
        
      
        return view('inventory.item-stock-ledger', [
            'reports' => \DB::table('items')->whereIn('id', $items)->get(),
            'from' => request('start_date'),
            'to' => request('end_date')
        ]);
        
        
    }


    public function generateBuiltReport() {

            $reports = \DB::table('item_stock_ledger_summaries')
            ->where('date', decrypt(request('date')))
            ->where('station', auth()->user()->station)
            ->get();


            return view('inventory.print-built-isl', [
                'reports' => $reports
            ]);
    }


    public function PhysicalStockReport(Request $request)
    {

        $this->validate(request(), [
            'start_date' => 'required',
            'end_date' => 'required'
        ]);

        $from = request('start_date');
        $to =   request('end_date');

        if ($from == $to) {

            if (request('station') == "All Station") {
                return "Working on";
            }else {
                $report_ledger = \DB::table('item_stock_ledgers')
                ->whereDate('date', $from) 
                ->where('station', request('station'))
                ->get();
            }

            return view('inventory.item-stock-ledger-allreport', [
                'reports' =>$report_ledger
            ]);

        }else {
            
            $report_ledger = \DB::table('item_stock_ledgers')
            ->selectRaw('item_name as item_name, item_id as item_id,item_unit as item_unit,sum(item_opening_stock) as item_opening_stock,sum(item_wastage) as item_wastage,sum(item_manual_closing_stock) as item_manual_closing_stock, sum(item_purchases) as item_purchases, sum(item_recieved) as item_recieved, sum(item_issue) as item_issue, sum(item_sales) as item_sales, sum(item_adjustment) as item_adjustment, sum(item_manufacturing) as item_manufacturing,sum(item_cons_manufacturing) as item_cons_manufacturing, sum(item_closing_stock) as item_closing_stock, sum(item_variance) as item_variance')
            ->groupBy('item_name')
            ->groupBy('item_unit')
            ->groupBy('item_id')
            ->WhereDate('date','>=', $from)
            ->WhereDate('date','<=', $to)
            ->where('station', request('station'))
            ->get();

            return view('inventory.item-stock-ledger-date-allreport', [
                'reports' =>$report_ledger,
                'from' => $from,
                'to' => $to
            ]);

        }

        

    }

    public function LedgerAllBranch(Request $request )
    {
        $value = explode(' - ', $request->date);
         
        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');


        $report_ledger = \DB::table('item_stock_ledgers')
            ->selectRaw('item_name as item_name, item_id as item_id,item_unit as item_unit,sum(item_opening_stock) as item_opening_stock,sum(item_wastage) as item_wastage,sum(item_manual_closing_stock) as item_manual_closing_stock, sum(item_purchases) as item_purchases, sum(item_recieved) as item_recieved, sum(item_issue) as item_issue, sum(item_sales) as item_sales, sum(item_adjustment) as item_adjustment, sum(item_manufacturing) as item_manufacturing,sum(item_cons_manufacturing) as item_cons_manufacturing, sum(item_closing_stock) as item_closing_stock, sum(item_variance) as item_variance')
            ->groupBy('item_name')
            ->groupBy('item_unit')
            ->groupBy('item_id')
            ->WhereDate('date','>=', $from)
            ->WhereDate('date','<=', $to)
            ->get();

            return view('inventory.item-stock-ledger-date-all', [
                'reports' =>$report_ledger,
                'from' => $from,
                'to' => $to
            ]);
    }


    public function stockcalculate()
    {
        $dayClose = \DB::table('close_days')->first();

        try {
            // Perform DB Transaction
            \DB::beginTransaction();

            $composition_change = \DB::table('composition_records')
            ->where('station', auth()->user()->station)
            ->where('date', $dayClose->day_close)
            ->where('status', 0)
            ->update([
                'status' => 1
            ]);

            $composition = \DB::table('composition_records')
            ->selectRaw('comp_id as composition, comp_name as comp_name, sum(unit_total) as total')
            ->groupBy('comp_id')
            ->groupBy('comp_name')
            ->where('station', auth()->user()->station)
            ->where('date', $dayClose->day_close)
            ->where('status', 1)
            ->get();

            foreach ($composition as $key => $composition) {

                 //  Deduct from Ledger based on Sales
                 if (empty($composition)) {
                    continue;
                }

            $existing = \DB::table('item_stock_ledgers')->where('item_id', $composition->composition)
            ->where('station', auth()->user()->station)
            ->where('date', $getDayClose->day_close)
            ->get();
            
            foreach ($existing as $key => $existing) {

            $item_ = \DB::table('items')->where('id', $composition->composition)->first();

            ItemStockLedger::Where('item_id', $composition->composition,)
            ->where('station', auth()->user()->station)
            ->where( 'date', $dayClose->day_close,)
            ->update(
                 [
                'item_name' => $composition->comp_name,
                'item_id' => $composition->composition,
                'date' => $dayClose->day_close,
                'item_unit' => $item_->item_unit,
                'item_category' => $item_->item_category,
                'station' => auth()->user()->station,
                'item_sales' => (float)$composition->total,
            ]);
        }


                }

                \DB::commit(); 

                // DELETE TRANSACTION AFTER COMPLETION
                \DB::table('composition_records')
                ->where('station', auth()->user()->station)
                ->where('date', $dayClose->day_close)
                ->where('status', 1)
                ->delete();


         } catch (\Throwable $th) {
            \DB::rollback();
            return response([
                'status' => 501,
                "Message" => $th
            ]);
        }
     
    }

    
    public function PrintLedger(Request $request)
    {
        $from = request('start_date');
        $to =   request('end_date');

        \App\Models\UserActivity::create([
            'changed_date' => \Carbon\carbon::now(),
            'user_id'=>auth()->id(),
            'event' => "Previewed Item Stock Ledger for ". auth()->user()->station,
        ]);

        $items = \DB::table('stock_transactions')
        ->where('station', auth()->user()->station)
                                    ->WhereDate('date','>=', request('start_date'))
                                    ->WhereDate('date','<=', request('end_date'))->pluck('item_id');
        
    

        return view('inventory.print-item-stock-ledger-adfilter', [
            'reports' => \DB::table('items')->whereIn('id', $items)->get(),
            'from' => request('start_date'),
            'to' => request('end_date')
        ]);
    }


    public function PrintLedgerDateAllreport(Request $request)
    {
        $this->validate(request(), [
            'start_date' =>'required',
            'end_date' =>'required'
        ]);
        
        $from = request('start_date');
        $to =   request('end_date');

        if ($from == $to) {
            $report_ledger = \DB::table('item_stock_ledgers')
            ->whereDate('date', $from) 
            ->where('station', request('station'))
            ->orderBy('item_name', 'ASC')
            ->get();
        
            return view('inventory.print-item-stock-ledger', [
                'reports' =>$report_ledger
            ]);
        }else{
            
            $report_ledger = \DB::table('item_stock_ledgers')
            ->selectRaw('item_name as item_name, item_id as item_id,item_unit as item_unit,sum(item_opening_stock) as item_opening_stock,sum(item_wastage) as item_wastage,sum(item_manual_closing_stock) as item_manual_closing_stock, sum(item_purchases) as item_purchases, sum(item_recieved) as item_recieved, sum(item_issue) as item_issue, sum(item_sales) as item_sales, sum(item_adjustment) as item_adjustment, sum(item_manufacturing) as item_manufacturing,sum(item_cons_manufacturing) as item_cons_manufacturing, sum(item_closing_stock) as item_closing_stock, sum(item_variance) as item_variance')
            ->groupBy('item_name')
            ->groupBy('item_unit')
            ->groupBy('item_id')
            ->WhereDate('date','>=', $from)
            ->WhereDate('date','<=', $to)
            ->where('station', request('station'))
            ->get();

            return view('inventory.print-stock-filter', [
                'reports' =>$report_ledger,
                'from' => $from,
                'to' => $to
            ]);
            
        }
    }


    public function stockLedgerSort(Request $request)
    {
        $this->validate(request(), [
            'start_date' =>'required',
            'end_date' =>'required'
        ]);

        $from = request('start_date');
        $to =   request('end_date');

        if ($from == $to) {
            $report_ledger = \DB::table('item_stock_ledgers')
            ->whereDate('date', $from)
            ->where('station', auth()->user()->station)
            ->get();

        }else {
            
            $report_ledger = \DB::table('item_stock_ledgers')
            ->selectRaw('item_name as item_name, item_id as item_id,item_unit as item_unit,sum(item_opening_stock) as item_opening_stock,sum(item_wastage) as item_wastage,sum(item_manual_closing_stock) as item_manual_closing_stock, sum(item_purchases) as item_purchases, sum(item_recieved) as item_recieved, sum(item_issue) as item_issue, sum(item_sales) as item_sales, sum(item_adjustment) as item_adjustment, sum(item_manufacturing) as item_manufacturing,sum(item_cons_manufacturing) as item_cons_manufacturing, sum(item_closing_stock) as item_closing_stock, sum(item_variance) as item_variance')
            ->groupBy('item_name')
            ->groupBy('item_unit')
            ->groupBy('item_id')
            ->WhereDate('date','>=', $from)
            ->WhereDate('date','<=', $to)
            ->where('station', auth()->user()->station)
            ->get();

            return view('inventory.item-stock-ledger-date', [
                'reports' =>$report_ledger,
                'from' => $from,
                'to' => $to
            ]);
        }

        return view('inventory.item-stock-ledger', [
            'reports' =>$report_ledger
        ]);

    }


    public function IslTemporal(Request $request)
    {
        $validated = $this->validate(request(), [
            'start_date' => 'required',
            'end_date' => 'required',
        ]);

        if (empty(request('station'))) {
            $station = auth()->user()->station;
        }else {
            $station = request('station');
        }

        $start = $validated['start_date'];

        $end = $validated['end_date'];


        // if ($start == $end) {
        //     $date = new ItemStockLedger;

        // $iteming = \DB::table('stock_transactions')
        //     ->SelectRaw('item_id as item_id, sum(stock_in) as stock_in, sum(stock_out) as stock_out')
        //     ->groupBy('item_id')
        //         ->where('station', $station)
        //         ->WhereDate('date', $start)->get();

        // foreach ($iteming as $key => $item) {
        //     \DB::table('item_stock_ledger_summaries')->where('item_id', $item->item_id)
        //     ->where('date', $start)
        //     ->where('station', $station)
        //     ->update([
        //         'stock_in' => empty($item->stock_in) ? 0 : $item->stock_in,
        //         'stock_out' => empty($item->stock_out) ? 0 : $item->stock_out,
        //         'closing_stock' => \DB::raw('opening_stock +' . ($item->stock_in - $item->stock_out))
        //     ]);
        // }


        // $summary  = new ItemStockLedgerSummary;
        // $summaries = $summary->stockToday($start, $station);

        

        // return view('stock_transactions', [
        //         'items' =>  $summaries
        //     ]);
        // }


        $products = Cache::rememberForever('iteminb', function(){
            return \DB::table('items')->get();
        });

        return view('stock-transactions-date', [
            'itemss' =>  $products
        ]);

    }


    public function stockLedgerSortSummary(Request $request)
    {
        $value = explode(' - ', $request->date);
        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        if ($from == $to) {

            $report_ledger = \DB::table('item_stock_ledgers')
            ->whereDate('date', $from)
            ->where('station', auth()->user()->station)
            ->get();

        }else {
            
            $report_ledger = \DB::table('item_stock_ledgers')
            ->selectRaw('item_name as item_name, item_id as item_id,item_unit as item_unit,sum(item_opening_stock) as item_opening_stock,sum(item_wastage) as item_wastage,sum(item_manual_closing_stock) as item_manual_closing_stock, sum(item_purchases) as item_purchases, sum(item_recieved) as item_recieved, sum(item_issue) as item_issue, sum(item_sales) as item_sales, sum(item_adjustment) as item_adjustment, sum(item_manufacturing) as item_manufacturing,sum(item_cons_manufacturing) as item_cons_manufacturing, sum(item_closing_stock) as item_closing_stock, sum(item_variance) as item_variance')
            ->groupBy('item_name')
            ->groupBy('item_unit')
            ->groupBy('item_id')
            ->WhereDate('date','>=', $from)
            ->WhereDate('date','<=', $to)
            ->where('station', auth()->user()->station)
            ->get();

            return view('inventory.item-stock-ledger-summary-date', [
                'reporting' =>$report_ledger,
                'from' => $from,
                'to' => $to
            ]);
        }
        

        return view('inventory.item-stock-ledger-summary', [
            'reports' =>$report_ledger,
        ]);
    }


    public function IssueRecieveRun()
    {
       $dayClose = \DB::table('close_days')->first();
       $inventory = \DB::table('issue_vouchers')
            ->selectRaw('issue_item_id as issue_item_id, issue_item as name, sum(issue_qty) as quantity')
            ->groupBy('name')
            ->groupBy('issue_item_id')
            ->where('issue_status', 1)
            ->where('issue_store', auth()->user()->station)
            ->whereDate('issue_date', $dayClose->day_close)
            ->get();

        foreach ($inventory as $key => $inventory_item) {
           
                    ItemStockLedger::updateOrCreate([
                    'item_id' => $inventory_item->issue_item_id,
                    'date' => $dayClose->day_close,
                    'station' => auth()->user()->station,
                    ], [
                        'user_id' => auth()->user()->id,
                        'station' => auth()->user()->station,
                        'item_id' => $inventory_item->issue_item_id,
                        'item_recieved' => $inventory_item->quantity
                    ]); 
        }

    }



    public function PrintLedgerSummaryDate(Request $request)
    {
        $value = explode(' - ', $request->date);
        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        if ($from == $to) {
            $report_ledger = \DB::table('item_stock_ledgers')
            ->whereDate('date', $from)
            ->where('station', auth()->user()->station)
            ->get();
        }else {
            
            $report_ledger = \DB::table('item_stock_ledgers')
            ->selectRaw('item_name as item_name, item_id as item_id,item_unit as item_unit,sum(item_opening_stock) as item_opening_stock,sum(item_wastage) as item_wastage,sum(item_manual_closing_stock) as item_manual_closing_stock, sum(item_purchases) as item_purchases, sum(item_recieved) as item_recieved, sum(item_issue) as item_issue, sum(item_sales) as item_sales, sum(item_adjustment) as item_adjustment, sum(item_manufacturing) as item_manufacturing,sum(item_cons_manufacturing) as item_cons_manufacturing, sum(item_closing_stock) as item_closing_stock, sum(item_variance) as item_variance')
            ->groupBy('item_name')
            ->groupBy('item_unit')
            ->groupBy('item_id')
            ->WhereDate('date','>=', $from)
            ->WhereDate('date','<=', $to)
            ->where('station', auth()->user()->station)
            ->get();

            return view('inventory.item-print-stock-ledger-summary-date', [
                'reporting' =>$report_ledger,
                'from' => $from,
                'to' => $to
            ]);
        }

        return view('inventory.item-print-stock-ledger-summary', [
            'reports' =>$report_ledger,
        ]);
    }




    public function closingStocks()
    {   
        $dayClose = \DB::table('close_days')->first();

        $report_ledger = \DB::table('item_stock_ledgers')
        ->whereDate('date', $dayClose->day_close) 
        ->where('station', auth()->user()->station)
        ->get();

        return view('inventory.closing-stocks', [
                'closing_stocks' => $report_ledger
        ]);
    }


    public function closingStocksPrint(Request $request)
    {
        $value = explode(' - ', $request->date);
        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        $report_ledger = \DB::table('item_stock_ledgers')
            ->where('station', auth()->user()->station)
            ->WhereDate('date','>=', $from)
            ->WhereDate('date','<=', $to)
            ->orderBy('item_name', "ASC")
            ->get();
            
    
            return view('inventory.print-closing-stock', [
                    'closing_stocks' => $report_ledger
            ]);
        
    }


    public function ClosingStockDate(Request $request)
    {
        $value = explode(' - ', $request->date);
        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        if ($from == $to) { 
            $report_ledger = \DB::table('item_stock_ledgers')
            ->whereDate('date', $from) 
            ->where('station', auth()->user()->station)
            ->orderBy('item_name', "ASC")
            ->get();
    
            return view('inventory.closing-stocks', [
                    'closing_stocks' => $report_ledger
            ]);
        }else{
            $report_ledger = \DB::table('item_stock_ledgers')
            ->whereDate('date', $from) 
            ->where('station', auth()->user()->station)
            ->orderBy('item_name', "ASC")
            ->get();
    
            return view('inventory.closing-stocks', [
                    'closing_stocks' => $report_ledger
            ]);
        }
    }


    public function stockLimit()
    {
        $dayClose = \DB::table('close_days')->first();
        $stock_limit = \DB::table('items')->get();
        return view('inventory.create-stock-limit', [
            'stock_limit' => $stock_limit
        ]);
    }


    public function saveStockLimt(Request $request)
    {
        $app = \DB::table('settings')->first();
        $data = $request->all();
        if (array_key_exists('items', $data)) {
            foreach ($data['items'] as $key => $item) {

                $composition = \DB::table('material_product_compositons')
                ->where('composition_id' , $item['issue_item_id'])
                ->update([
                    'item_stock_check' =>   $item['item_stock_check']
                ]);

                \DB::table('items')->where('id', $item['issue_item_id'])->update([
                    'order_level' => $item['issue_item_stock_limit'],
                    'item_stock_check' => $item['item_stock_check']
                ]);

        
            }
        }

        return back()->with('status', "Stock Limit Created for Items");
    }




    public function trash()
    {   
        $dayClose = \DB::table('close_days')->first();
        $record_trash = \DB::table('items')->get();
        return view('inventory.trash', [
            'record_trash' => $record_trash
        ]);
    }

    public function trashSort(Request $request)
    {
        $value = explode(' - ', $request->date);
         

        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        if ($from == $to) {
            $record_trash = \DB::table('item_stock_ledgers')
            ->whereDate('date', $from)
            ->where('station', auth()->user()->station)
            ->get();
        }else {
            $record_trash = \DB::table('item_stock_ledgers')
                ->whereBetween('date', [$from, $to])
                ->where('station', auth()->user()->station)
                ->get();
        }
        return view('inventory.trash', [
            'record_trash' => $record_trash
        ]);
    }


    public function physicalStock()
    {

        $ca = \DB::table('control_accounts')->pluck('control_name');

        $products = Cache::rememberForever('itemss', function(){
            return \DB::table('items')->get();
        });

        return view('inventory.physical-stock', [
            'items'=> $products,
            'payment_accounts' => \DB::table('accounts')->where('account_state', 1)
            ->whereNotIn('account_name', $ca)
            ->orderBy('account_name', 'ASC')
            ->get(),
            'units' => \DB::table('units')->get()
        ]);
       
    }




    public function AddlistAdjustment(Request $request)
    {

        $this->validate($request, [
            'date' => 'required',
            'adjusted_qty' => 'required',
            'date' => 'required',
        ]);

        
        $item_self = \DB::table('items')->where('id', explode(" - ", $request -> adjusted_item)[1])->first();
        $stock_in = \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $item_self -> id)->whereDate('date', request('date'))->sum('stock_in');
        $stock_out =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $item_self -> id)->whereDate('date', request('date'))->sum('stock_out');
        $opening_stock =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $item_self -> id)->whereDate('date', '<', request('date'))->sum('stock_in') - \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $item_self -> id)->whereDate('date', '<', request('date'))->sum('stock_out');
            ;
        // search Unit
        $id = $item_self -> id;
        
        $cart = $request->session()->get('cartAdjustment', []);
         if(isset($cart[$id])) {
             $cart[$id]['phyicat_stock']++;
         } else {
             $cart[$id] = [
                 'id' =>  $item_self -> id,
                 'date' =>  $request -> date,
                 'item_unit' =>  $item_self -> item_unit,
                 "item_name" => $item_self->item_name,
                 "item_category" => $item_self->item_category,
                 "phyicat_stock" => $request -> adjusted_qty,
                 "remark"=> $request->remark,
                 'opening_stock' => $opening_stock,
                 'remaining_stock' => ($opening_stock + $stock_in) - $stock_out,
                 ];
         }
           
         $request->session()->put('cartAdjustment', $cart);
         return $request->session()->get('cartAdjustment');

    }


    public function clearPhysical()
    {
        session()->forget('cartAdjustment');

        return back()->with('status', 'Items Cleared Successfully');
    }


    public function physicalStockDate()
    {
        
        $date = new ItemStockLedger;
        $dayClose = $date->systemDate();

        if (empty(request('station'))) {
            $station = auth()->user()->station;
        }else {
            $station = request('station');
        }

        

        

        $iteming = \DB::table('stock_transactions')
        ->SelectRaw('item_id as item_id, sum(stock_in) as stock_in, sum(stock_out) as stock_out')
        ->groupBy('item_id')
            ->where('station',  $station)
            ->WhereDate('date', request('date'))->get();

    foreach ($iteming as $key => $item) {
        \DB::table('item_stock_ledger_summaries')->where('item_id', $item->item_id)
        ->where('date', request('date'))
        ->where('station',  $station)
        ->update([
            'stock_in' => $item->stock_in,
            'stock_out' => $item->stock_out
        ]);
    }


    $summary  = new ItemStockLedgerSummary;
       $record_physical = $summary->stockToday(request('date'), $station);

        if (empty($record_physical) || $record_physical->isEmpty()) {
            
            $itemings = \DB::table('items')->get();
            foreach ($itemings as $key => $report) {

                \App\Models\ItemStockLedgerSummary::Create([
                    'station' => $station,
                    'date' => request('date'),
                    'item_id' => $report->id,
                    'item_name' => $report-> item_name,
                    'item_unit' => $report-> item_unit,
                    'item_code' => $report-> item_code,
                    'item_category' => $report-> item_category,
                    'inactive_station' => $report-> inactive_station,
                    'opening_stock' => 0,
                    'stock_in' => 0,
                    'stock_out' => 0,
                    ]);
            
               }
        }

        return view('physical-stock-date', [
            'record_physical' => $record_physical,
        ]);
    }


    public function openingStock()
    {

        $record_physical = \DB::table('items')->get();

        return view('inventory.opening-stock', [
            'record_physical' => $record_physical,
        ]);
    }

    public function updateOpening(Request $request)
    {

        $data = $request->all();

        $dayClose = \DB::table('close_days')->first();

        $newdate = date('Y-m-d', strtotime('-1 day', strtotime($dayClose->day_close)));


        try {
            // Perform DB Transaction
            \DB::beginTransaction();
        
        if (array_key_exists('items', $data)) {
            foreach ($data['items'] as $key => $item) {
               
        // Just for Today 
                \App\Models\OpeningStock::updateOrcreate([
                    'item_id' => $item['issue_item_id'],
                    'station' => auth()->user()->station,
                ], [
                    'opening_stock' => $item['issue_item_physical_stock'],
                ]);


                $getItems = \DB::table('items')->where('id', $item['issue_item_id'])->first();

                $costing = \DB::table('average_costs')->where('item_id', $item['issue_item_id'])
                ->orderBy('id', "DESC")
                ->first();


                $costing_phys = empty($costing) ? 0 : $costing->weighted_average;
           
                \App\Models\StockTransaction::updateOrCreate([ 
                    'item_id' => $item['issue_item_id'],
                    'note' => "Opening Balance",
                    'transactions_id' => auth()->user()->station,
                    'date' =>  $newdate,
                ],
                [
                    'user_id' => auth()->id(),
                    'item_id' =>  $item['issue_item_id'],
                    'description' => 'Receipts',
                    'note' => "Opening Balance",
                    'unit' =>  $getItems->item_unit,
                    'station' => auth()->user()->station,
                    'stock_in' => $item['issue_item_physical_stock'],
                    'cost' => $costing_phys,
                    'transactions_id' => auth()->user()->station
                ]);
            }
        }

        \DB::commit();

        return back()->with('status', 'Opening stock updated');

    } catch (\Throwable $th) {
        \DB::rollback();
        return response([
            'status' => 501,
            "Message" => $th
        ]);
    }

    }



    public function WastageCost()
    {
        $dayClose = \DB::table('close_days')->first();

        $report_ledger = \DB::table('stock_transactions')->where('description', "Wastages")
        ->where('station', auth()->user()->station)
        ->whereDate('date', $dayClose->day_close)
        ->get();

        return view('inventory.wastage-cost', [
            'reports' =>$report_ledger
        ]);
    }

    public function PrintLedgerSummaryWastage(Request $request)
    {
        $value = explode(' - ', $request->date);
         
        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

            $report_ledger = \DB::table('stock_transactions')->where('description', "Wastages")
            ->where('station', auth()->user()->station)
            ->WhereDate('date','>=', $from)
            ->WhereDate('date','<=', $to)
            ->get();

            return view('inventory.print-wastage-by-date', [
                'reports' =>$report_ledger,
            ]);
            
    }


    public function stockLedgerSortSummaryWastage(Request $request)
    {
        $value = explode(' - ', $request->date);
         
        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        $report_ledger = \DB::table('stock_transactions')->where('description', "Wastages")
        ->where('station', auth()->user()->station)
        ->WhereDate('date','>=', $from)
        ->WhereDate('date','<=', $to)
        ->get();

        return view('inventory.wastage-cost-date', [
            'reports' =>$report_ledger,
        ]);

        
    }


    public function adjustment()
    {
        $date = new ItemStockLedger;
        $dayClose = $date->systemDate();

        if (empty(request('station'))) {
            $station = auth()->user()->station;
        }else {
            $station = request('station');
        }


        $iteming = \DB::table('stock_transactions')
        ->SelectRaw('item_id as item_id, sum(stock_in) as stock_in, sum(stock_out) as stock_out')
        ->groupBy('item_id')
            ->where('station', $station)
            ->WhereDate('date', $dayClose->day_close)->get();

        foreach ($iteming as $key => $item) {
            \DB::table('item_stock_ledger_summaries')->where('item_id', $item->item_id)
            ->where('date', $dayClose->day_close)
            ->where('station', $station)
            ->update([
                'stock_in' => empty($item->stock_in) ? 0 : $item->stock_in,
                'stock_out' => empty($item->stock_out) ? 0 : $item->stock_out,
            ]);
        }

        $summary  = new ItemStockLedgerSummary;
        $record_physical = $summary->stockToday($dayClose->day_close, $station);
        
        return view('adjustment', [
            'record_physical' => $record_physical,
            'items'=> \DB::table('items')->get(),
            'units' => \DB::table('units')->get()
        ]);
    }
    
    

    public function saveWastage(Request $request)
    {
        
        $data = $request->all();
        if (array_key_exists('items', $data)) {
            foreach ($data['items'] as $key => $item) {
                
                if (empty( $item['issue_item_wastage']) ) {
                    continue;
                }

                $itemm = \DB::table('items')->where('id', $item['issue_item_id'])->first();
                
                $waverage = \DB::table('average_costs')->where('item_id', $item['issue_item_id'])->orderby('id', 'DESC')->first();


                \App\Models\StockTransaction::create([
                    'user_id' => auth()->id(),
                    'item_id' =>   $item['issue_item_id'],
                    'description' => 'Wastages',
                    'note' => $item['comment'],
                    'unit' =>  $itemm->item_unit,
                    'station' =>  auth()->user()->station,
                    'date' => request('date'),
                    'stock_out' => $item['issue_item_wastage'],
                    'cost' => empty($waverage) ? 0 : $waverage->weighted_average
            ]);

            }

        }

        return back()->with('status', "Wastage Recoreded Successfully");
    }


    public function savephysicalStock(Request $request)
    {
        $physical_stocks = session()->get('cartAdjustment');

        foreach ($physical_stocks as $key => $physical_stock) {
                    
                    $it = \DB::table('items')->where('id', $physical_stock['id'])->first();

                    ItemStockLedgerSummary::updateOrCreate([
                        'item_id' => $it->id,
                        'date' => $physical_stock['date'],
                        'station' =>  auth()->user()->station
                    ],[
                        'item_name' => $it->item_name,
                        'item_category'=> $it->item_category,
                        'item_unit'=> $it->item_unit,
                        'opening_stock' => $physical_stock['opening_stock'],
                        'closing_stock' => $physical_stock['remaining_stock'],
                        'physical_stock' => $physical_stock['phyicat_stock'],
                        'remark' => $physical_stock['remark'],
                        'inactive_station' => '[]'
                    ]);
        }

        session()->forget('cartAdjustment');
        return back()->with('status', "Physical Stock taken Successfully");
    }


    public function DestroyPhysical(Request $request, $id)
    {
        $cart = session()->get('cartAdjustment', []);
            if (!isset($cart[$id])) {
                return response([
                    'status' => 400,
                    'Message' => "Item not found in cart"
                ]);
            }
            unset($cart[$id]);
            session()->put('cartAdjustment', $cart);
            return response([
                'status' => 200,
                'Message' => "Successfully removed from cart"
            ]);
    }


    public function saveAdjustedStock(Request $request)
    {
        $data = $request->all();

        $dayClose = \DB::table('close_days')->first();

        if (empty(request('date'))) {
          
            $date = $dayClose->day_close;
        }else {
         
            $date = request('date');
        }

       
        if (array_key_exists('items', $data)) {
            foreach ($data['items'] as $key => $item) {
                
                if (empty( $item['issue_item_adjustment']) ) {
                    continue;
                }

            $itemm = \DB::table('items')->where('id', $item['issue_item_id'])->first();
                
            $balance_b_f =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $item['issue_item_id'])->whereDate('date', '<', $date)->sum('stock_in') - 
             \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $item['issue_item_id'])->whereDate('date', '<', $date)->sum('stock_out');
             

            $stock_in =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $item['issue_item_id'])
                                        ->WhereDate('date', $date)
                                        ->sum('stock_in');
                                        
            $stock_out =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $item['issue_item_id'])
            ->WhereDate('date', $date)
            ->sum('stock_out');



            $closing = ($stock_in - $stock_out) + $balance_b_f;


            $getAllCOst =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $item['issue_item_id'])->get();

            if (empty($getAllCOst)) {
               $total_cost = 0;
            }else {

            $sumReCost = 0 ;
            $sumIssueCost = 0 ;

                foreach ($getAllCOst as $key => $cost) {

                    $sumIssueCost += round($cost->stock_out, 2) * round($cost->cost, 2);
                    $sumReCost += round($cost->stock_in, 2) * round($cost->cost, 2);

                }

                $total_cost =  (round($sumReCost, 2) - round($sumIssueCost, 2)) / ($closing == 0 ? 1 : $closing);
            }
            

               $modal = new \App\Models\StockTransaction;
               $modal->user_id = auth()->id();
               $modal->item_id = $item['issue_item_id'];
               $modal->description = 'Adjustments';
               $modal->note = $item['comment'];
               $modal->unit =  empty($itemm->item_unit) ? "Pc" : $itemm->item_unit;
               $modal->station =  auth()->user()->station;
               $modal->date = $date;
               $modal->stock_out = $item['issue_item_adjustment'];
               $modal->cost = empty($total_cost) ? 0 : $total_cost;
               $modal->save();
           

            }

        }

        return back()->with('status', "Adjustment Made Successfully");
    }


    public function AdjustDate()
    {

        $date = new ItemStockLedger;
        
        if (empty(request('station'))) {
            $station = auth()->user()->station;
        }else {
            $station = request('station');
        }


        $iteming = \DB::table('stock_transactions')
        ->SelectRaw('item_id as item_id, sum(stock_in) as stock_in, sum(stock_out) as stock_out')
        ->groupBy('item_id')
            ->where('station', $station)
            ->WhereDate('date', request('date'))->get();

        foreach ($iteming as $key => $item) {
            \DB::table('item_stock_ledger_summaries')->where('item_id', $item->item_id)
            ->where('date', request('date'))
            ->where('station', $station)
            ->update([
                'stock_in' => empty($item->stock_in)  ? 0 : $item->stock_in,
                'stock_out' => empty($item->stock_out) ? 0 : $item->stock_out
            ]);
        }
 
        $summary  = new ItemStockLedgerSummary;
        $record_physical = $summary->stockToday(request('date'), $station);
        
        return view('adjustment-date', [
            'record_physical' => $record_physical,
        ]);
    

    }


    public function importStock(Request $request)
    {
        $this->validate($request,[
            'file' => 'required'
        ]);

        $dayClose = \DB::table('close_days')->first();

        $upload = $request->file('file');
        $filePath = $upload->getRealPath();

        $file = fopen($filePath, 'r');

        $header = fgetcsv($file);

        $escapedHeader=[];

        // data validation
        
        foreach ($header as $key => $value) {
            $escapedItem = strtolower($value) ;
            array_push($escapedHeader, $escapedItem);

        }

        //looping through colums to get data

        while ($columns=fgetcsv($file)) {
            
            if ($columns[0] =="") {
            continue;
            }
    
    // try{
        // trim data
        foreach ($columns as $key => &$value) {
            $value = ucwords($value);
        }
        
    $data = array_combine($escapedHeader, $columns);
        
            $item = $data['item_name'];
            $quantity = $data['quantity'];
            $cost_price = $data['cost_price'];
            $unit = $data['unit'];
            $category = $data['category'];
            $manufacturing = $data['manufacturing'];
            $productId = $data['product_id'];
            $description = $data['description'];


            $appdata = new Item;
            $appdata -> item_name = $item;
            $appdata -> user_id = auth()->user()->id;
            $appdata -> item_unit = $unit;
            $appdata -> item_category = $category;
            $appdata -> item_manufacturing = $manufacturing;
            $appdata -> item_description = $description;
            $appdata -> item_code = $productId;
            $appdata -> save();


             if ($appdata -> item_manufacturing == 0) {

                \App\Models\ItemBOM::Create([
                    'item_id' => $appdata->id,
                    'bom_id' => $appdata->id,
                    'user_id' => auth()->id(),
                    'item_bom_name' => $item,
                    'item_unit_measure' => $unit,
                    'item_bom_unit' => 1,
                    'item_bom_unit_rate' => $cost_price,
                    'chain_id' => $appdata->id
                ] );
    
    
            }

            
            // }catch(\Exception $ex){
            //     return back()->with('status','something is wrong, kindly download the csv file ' . '<a href="/files/importsalary.csv">Here</a>' . ' as a guide');
            //     }

        }
        return back()->with('status', 'Items Imported Successfully');
    }


    public function savephysicalStockAdjust(Request $request)
    {
       $data = $request->all();
        if (array_key_exists('items', $data)) {
            foreach ($data['items'] as $key => $item) {

                $exiting = \DB::table('item_stock_ledgers')
                    ->where('item_id', $item['issue_item_id'])
                    ->where('date', request('date'))
                    ->where('station', $item['issue_station'])
                    ->get();

                foreach ($exiting as $key => $exiting) {
                    $ledger = \DB::table('item_stock_ledgers')
                    ->where('item_id' , $item['issue_item_id'])
                    ->where('date', request('date'))
                    ->where('station', $item['issue_station'])
                    ->update([
                        'ledger_updated_by' => auth()->user()->id,
                        'item_opening_stock' => $item['issue_item_physical_stock'],
                        'item_manual_closing_stock' => 0
                       ]);


                    // Update Yesterdays Manual Closing Stock
                    $ledger_update = \DB::table('item_stock_ledgers')
                    ->where('item_id' , $item['issue_item_id'])
                    ->where('date', date('Y-m-d', strtotime('-1 day', strtotime(request('date')))))
                    ->where('station', $item['issue_station'])
                    ->update([
                        'ledger_updated_by' => auth()->user()->id,
                        'item_manual_closing_stock' => $item['issue_item_physical_stock'],
                        // 'item_variance' => $item['issue_item_physical_stock'] - (($exiting->item_opening_stock+$exiting->item_purchases+$exiting->item_manufacturing+$exiting->item_recieved)-($exiting->item_sales+$exiting->item_issue+$exiting->item_cons_manufacturing+$exiting->item_wastage)),
                        // 'item_closing_stock' => ($exiting->item_opening_stock+$exiting->item_purchases+$exiting->item_manufacturing+$exiting->item_recieved)-($exiting->item_sales+$exiting->item_issue+$exiting->item_cons_manufacturing+$exiting->item_wastage),
                    ]);
                }


                // $makeupdate = \DB::table('item_stock_ledgers')
                //     ->where('item_id', $item['issue_item_id'])
                //     ->where('date', request('date'))
                //     ->where('station', $item['issue_station'])
                //     ->update([
                //         'item_closing_stock' =>  \DB::raw('(item_opening_stock + item_purchases + item_manufacturing + item_recieved) - (item_sales + item_wastage + item_issue + item_cons_manufacturing)')
                //     ]);
                
            }

        }

        return back()->with('status', "Physical Stock taken Successfully");
    }



    public function PrintLedgerSummary(Request $request)
    {
        $value = explode(' - ', $request->date);
         
        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        if ($from == $to) {
            $report_ledger = \DB::table('item_stock_ledgers')
            ->whereDate('date', $from) 
            ->where('station', auth()->user()->station)
            ->orderBy('item_name', 'ASC')
            ->get();
            return view('inventory.print-item-stock-ledger-summary', [
                'reports' =>$report_ledger
            ]);
        }else{
            $report_ledger = \DB::table('item_stock_ledgers')
            ->selectRaw('item_name as item_name,item_id as item_id, item_unit as item_unit,sum(item_opening_stock) as item_opening_stock,sum(item_wastage) as item_wastage,sum(item_manual_closing_stock) as item_manual_closing_stock, sum(item_purchases) as item_purchases, sum(item_recieved) as item_recieved, sum(item_issue) as item_issue, sum(item_sales) as item_sales, sum(item_adjustment) as item_adjustment, sum(item_manufacturing) as item_manufacturing,sum(item_cons_manufacturing) as item_cons_manufacturing, sum(item_closing_stock) as item_closing_stock, sum(item_variance) as item_variance')
            ->groupBy('item_name')
            ->groupBy('item_unit')
            ->groupBy('item_id')
            ->WhereDate('date','>=', $from)
            ->WhereDate('date','<=', $to)
            ->where('station', auth()->user()->station)
            ->get();

            return view('inventory.print-item-stock-ledger-adfilter', [
                'reports' =>$report_ledger,
                'from' => $from,
                'to' => $to
            ]);
            
        }
    }



    public function importOpeningStock(Request $request)
    {   
        $this->validate($request,[
            'file' => 'required'
          ]);

           $upload = $request->file('file');
           $filePath = $upload->getRealPath();

           $file = fopen($filePath, 'r');

           $header = fgetcsv($file);

           $escapedHeader=[];

           // data validation
           
           foreach ($header as $key => $value) {
             $escapedItem = strtolower($value) ;
             array_push($escapedHeader, $escapedItem);

           }

           //looping through colums to get data

           while ($columns=fgetcsv($file)) {
             
             if ($columns[0] =="") {
              continue;
             }
	
	   try{
           //trim data
           foreach ($columns as $key => &$value) {
             $value = ucwords($value);
           }
           
	   $data = array_combine($escapedHeader, $columns);

        ItemStockLedger::create([
            'item_name' => $data['item_name'],
            'item_unit' => $data['item_unit'],
            'station' => auth()->user()->station,
            'date' => request('date'),
            'item_id' =>$data['item_id'],
            'item_opening_stock' => $data['opening_stock'],
            'item_closing_stock' => \DB::Raw('(item_opening_stock + item_manufacturing + item_recieved + item_purchases) - (item_sales + item_issue + item_wastage + item_cons_manufacturing)')
             
        ]);
            
            }catch(\Exception $ex){
                continue;
            	return back()->with('status','something is wrong, kindly download the csv file ' . $ex . '<a href="/uploads/products.csv">Here</a>' . ' as a guide');
            	}

        }

        OpeningStock::query()->truncate();;
        return back()->with('status', 'Stock imported successfully');
    }



    public function first_date_opening($request, $date_range)
    {
           $items = \DB::table('opening_stocks')->get();

           foreach ($items as $key => $item) {
                \DB::table('item_stock_ledgers')
                ->where('item_name' , $item->item_name)
                ->where('date',  $date_range[0])
                ->where('station', auth()->user()->station)
                ->update([
                    'item_opening_stock' => $item->opening_stock,
                ]); 
           }
    }




    public function next_nextday_job($request, $date_range)
    {
        $newdate = date('Y-m-d', strtotime('-1 day', strtotime($date_range)));
        $items = \DB::table('opening_stocks')->get();

        foreach ($items as $key => $item) {
        $previous_stock = \DB::table('item_stock_ledgers')
                        ->where('item_name' , $item->item_name)
                        ->whereDate('date', $newdate)
                        ->where('station', auth()->user()->station)
                        ->get();

                foreach ($previous_stock as $key => $previous_stock) {

                        \DB::table('item_stock_ledgers')
                            ->where('item_name' , $item->item_name)
                            ->where('date', $date_range)
                            ->where('station', auth()->user()->station)
                            ->update([
                                'item_opening_stock' => (($previous_stock->item_opening_stock+$previous_stock->item_recieved+$previous_stock->item_purchases+$previous_stock->item_manufacturing) - ($previous_stock->item_issue+$previous_stock->item_sales+$previous_stock->item_adjustment+$previous_stock->item_wastage+$previous_stock->item_cons_manufacturing)),
                            ]);
                }
            }
    
    }


    public function last_date_opening($request, $lastDate)
    {
        $newdate = date('Y-m-d', strtotime('-1 day', strtotime($lastDate)));

        $items = \DB::table('opening_stocks')->get();

        foreach ($items as $key => $item) {
        $previous_stock = \DB::table('item_stock_ledgers')
                        ->where('item_name' , $item->item_name) 
                        ->whereDate('date', $newdate)
                        ->where('station', auth()->user()->station)
                        ->get();

                foreach ($previous_stock as $key => $previous_stock) {

                        \DB::table('item_stock_ledgers')
                           ->where('item_name' , $item->item_name)
                            ->where('date', $lastDate)
                            ->where('station', auth()->user()->station)
                            ->update([
                                'item_opening_stock' => (($previous_stock->item_opening_stock+$previous_stock->item_recieved+$previous_stock->item_purchases+$previous_stock->item_manufacturing) - ($previous_stock->item_issue+$previous_stock->item_sales+$previous_stock->item_adjustment+$previous_stock->item_wastage+$previous_stock->item_cons_manufacturing)),
                            ]);
                }
            }
    }



    public function OpenStockReload()
    {
        $getDayClose = \DB::table('close_days')->first();
        $newdate = date('Y-m-d', strtotime('-1 day', strtotime($getDayClose->day_close)));


        $previous_stock = \DB::table('item_stock_ledgers')
        ->whereDate('date', $newdate)
        ->where('station', auth()->user()->station)
        ->get();

        foreach ($previous_stock as $key => $previous_stock) {

                \DB::table('item_stock_ledgers')
                    ->where('item_id' , $previous_stock->item_id)
                    ->where('date', $getDayClose->day_close)
                    ->where('station', auth()->user()->station)
                    ->update([
                        'item_opening_stock' => (($previous_stock->item_opening_stock+$previous_stock->item_recieved+$previous_stock->item_purchases+$previous_stock->item_manufacturing) - ($previous_stock->item_issue+$previous_stock->item_sales+$previous_stock->item_adjustment+$previous_stock->item_wastage+$previous_stock->item_cons_manufacturing)),
                    ]);
        }

       return back()->with('status', "Opening stock loaded successfully");

    }


    public function OpenStockReloadManual()
    {
        $getDayClose = \DB::table('close_days')->first();
        $newdate = date('Y-m-d', strtotime('-1 day', strtotime($getDayClose->day_close)));


        $previous_stock = \DB::table('item_stock_ledgers')
        ->whereDate('date', $newdate)
        ->where('station', auth()->user()->station)
        ->get();

        foreach ($previous_stock as $key => $previous_stock) {

                \DB::table('item_stock_ledgers')
                    ->where('item_id' , $previous_stock->item_id)
                    ->where('date', $getDayClose->day_close)
                    ->where('station', auth()->user()->station)
                    ->update([
                        'item_opening_stock' => $previous_stock->item_manual_closing_stock
                    ]);
        }

       return back()->with('status', "Opening stock loaded successfully");
    }


    public function manufacturingReload()
    {
        $getDayClose = \DB::table('close_days')->first();

        $manufacture = \DB::table('manufacturing_histories')
        ->selectRaw('item_id as item_id, sum(manufacturing_qty) as manufacturing_qty, sum(rate) as rate')
        ->groupBy('item_id')
        ->where('date', $getDayClose->day_close)
        ->where('station', auth()->user()->station)
        ->get();

    if (!empty($manufacture)) {

        foreach ($manufacture as $key => $manufacture) {

            \DB::table('item_stock_ledgers')
                    ->where('item_id' , $manufacture->item_id)
                    ->whereDate('date', $getDayClose->day_close)
                    ->where('station', auth()->user()->station)
                    ->update([
                        'item_manufacturing' => $manufacture->manufacturing_qty,
                    ]);
                

        $item_bom = \DB::table('item_b_o_m_s')->where('item_id', $manufacture->item_id)->get();


        foreach ( $item_bom as $key => $bom ) {
            $unit = \DB::table('items')->where('id', $bom->bom_id)->first();

            if (empty($unit) || null) {
                continue;
            }

            $GetOldRate = \DB::table('item_stock_ledgers')
            ->where('item_id', $unit->id)
            ->whereDate('date',  $getDayClose->day_close)
            ->where('station', auth()->user()->station)
            ->first();

            if (empty($GetOldRate) || null) {
                continue;
            }

            $GetOldRate = $GetOldRate->item_cost;


            ItemStockLedger::updateOrcreate([
                'item_id' => $bom->bom_id,
                'date' => $getDayClose->day_close,
                'station' => auth()->user()->station
            ],
            [
                'item_id' => $bom->bom_id,
                'date' => $getDayClose->day_close,
                'item_unit' => $unit -> item_unit,
                'station' => auth()->user()->station,
                'item_name' => $unit->item_name,
                'item_cons_manufacturing' =>  $manufacture->manufacturing_qty * $bom->item_bom_unit,
            ]
            );
        }
    }
    }

    return back()->with('status', "manufacturing-reloaded successfully");
    }


    public function showISL()
    {

        $date = new ItemStockLedger;
        $dayClose = $date->systemDate();

        if (empty(request('station'))) {
            $station = auth()->user()->station;
        }else {
            $station = request('station');
        }
        
        
        $products = Cache::rememberForever('itemss', function(){
            return \DB::table('items')->get();
        });
        

        return view('stock_transactions', [
                'items' =>  $products,
                'builtReport' => \App\Models\BuildStockLedger::where('status',1)->where('station', auth()->user()->station)->orderBy('created_at', 'Desc')->take(5)->get()
            ]);
    }



    public function BuildReport() {

    

        $items = \DB::table('items')
        ->get();

    
        foreach ($items as $key => $report) {
              
                $stock_qty =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $report->id)
                                            ->WhereDate('date', '<', request('date'))
                                            ->sum('stock_in') - \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $report->id)
                ->WhereDate('date', '<', request('date'))
                ->sum('stock_out');

         $stock_in = \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $report->id)
        ->WhereDate('date', request('date'))
        ->sum('stock_in');


        $stock_out = \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $report->id)
        ->WhereDate('date', request('date'))
        ->sum('stock_out');

        \App\Models\ItemStockLedgerSummary::updateOrCreate([
            'station' => auth()->user()->station,
            'date' => request('date'),
            'item_id' => $report->id],
            [
            'item_name' => $report-> item_name,
            'item_unit' => $report-> item_unit,
            'item_code' => $report-> item_code,
            'item_category' => $report-> item_category,
            'inactive_station' => $report-> inactive_station,
            'opening_stock' => $stock_qty,
            'stock_in' => $stock_in,
            'stock_out' => $stock_out,
            ]);
    
       }


       $buildISL = \App\Models\ItemStockLedgerSummary::where('station', auth()->user()->station)
       ->where('date', request('date'))
       ->get();

       Cache::put('build' . request('date'), $buildISL);

       \App\Models\BuildStockLedger::create([
        'user_id' => auth()->id(),
        'station' => auth()->user()->station,
        'status' => 1,
        'date' => request('date')
       ]);


       return 200;

    }

    public function HiddenItems(Type $var = null)
    {
        
        $isls = \DB::table('item_stock_ledger_summaries')->whereDate('date', request('date'))
        ->where('station', auth()->user()->station)
        ->pluck('item_id');

        $items = \DB::table('items')
        ->WhereNotIn('id', $isls)
        ->get();

    
        foreach ($items as $key => $report) {
              
                $stock_qty =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $report->id)
                                            ->WhereDate('date', '<', request('date'))
                                            ->sum('stock_in') - \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $report->id)
                ->WhereDate('date', '<', request('date'))
                ->sum('stock_out');

        

        \App\Models\ItemStockLedgerSummary::updateOrCreate([
            'station' => auth()->user()->station,
            'date' => request('date'),
            'item_id' => $report->id],
            [
            'item_name' => $report-> item_name,
            'item_unit' => $report-> item_unit,
            'item_code' => $report-> item_code,
            'item_category' => $report-> item_category,
            'inactive_station' => $report-> inactive_station,
            'opening_stock' => $stock_qty,
            'stock_in' => 0,
            'stock_out' => 0,
            ]);
    
       }


       return back()->with('status', "Hiddens Items active now");

    }


    public function PrintStockHistory()
    {
        $date = new ItemStockLedger;
        $dayClose = $date->systemDate();

        $summary =\DB::table('item_stock_ledger_summaries')
            ->where('date', $dayClose->day_close)
            ->where('station', auth()->user()->station)
            ->get();
            
        return view('stock_transaction_print', [
            'items' =>  $summary
        ]);
    }



    public function PrintStockHistoryDate()
    {
    
        if (empty(request('station'))) {
            $station = auth()->user()->station;
        }else {
            $station = request('station');
        }
        
        $summary =\DB::table('item_stock_ledger_summaries')
            ->where('date', request('start_date'))
            ->where('station', $station)
            ->get();
            
        return view('stock_transaction_print', [
            'items' =>  $summary
        ]);
    }

    public function viewStockTransaction()
    {

        $dayClose = \DB::table('close_days')->first();
        $from =  $dayClose->day_close;
        $to =  $dayClose->day_close;
        
        
        if ($from == $to) {

            $balance_b_f =  \DB::table('stock_transactions')
            ->where('station', auth()->user()->station)->where('item_id', request('item_id'))
            ->WhereDate('date', '<', $to)
            ->sum('stock_in') - 

            \DB::table('stock_transactions')
            ->where('station', auth()->user()->station)->where('item_id', request('item_id'))
            ->WhereDate('date', '<', $to)
            ->sum('stock_out');

                      
            $transactions_db = \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', request('item_id'))
            ->WhereDate('date','>=', $from)
            ->WhereDate('date','<=', $to)
            ->OrderBy('id', 'DESC')
            ->get();
            
            $ending_b_f = null;
        }else {
            $balance_b_f =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', request('item_id'))->whereDate('date', '<', $from)->sum('stock_in') - 
            \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', request('item_id'))->whereDate('date', '<', $from)->sum('stock_out');

            $ending_b_f =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', request('item_id'))
            ->WhereDate('date','>=', $from)
            ->WhereDate('date','<=', $to)
            ->OrderBy('id', 'DESC')->first();

           $transactions_db = \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', request('item_id'))
            ->WhereDate('date','>=', $from)
            ->WhereDate('date','<=', $to)
            ->get();
        }
        return view('stock-history', [
                'item' => \DB::table('items')->where('id', request('item_id'))->first(),
                'transactions_db' => $transactions_db,
                'balance_b_f_' => $balance_b_f,
                'from' => $from,
                'to' => $to,
                'ending_b_f' => $ending_b_f,
                'main_balance' => $transactions_db->first()
        ]);
    }


    public function StockFilterPrint()
    {

        $this->validate(request(), [
            'start_date' => 'required',
            'end_date' => 'required'
        ]);

        
        $from =  request('start_date');
        $to =  request('end_date');
        

        if ($from == $to) {

            $balance_b_f =  \DB::table('stock_transactions')
            ->where('station', auth()->user()->station)->where('item_id', request('item_id'))
            ->WhereDate('date', '<', $to)
            ->sum('stock_in') - 

            \DB::table('stock_transactions')
            ->where('station', auth()->user()->station)->where('item_id', request('item_id'))
            ->WhereDate('date', '<', $to)
            ->sum('stock_out');

                      
            $transactions_db = \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', request('item_id'))
            ->WhereDate('date','>=', $from)
            ->WhereDate('date','<=', $to)
            ->orderBy('id', "ASC")
            ->get();
            
            $ending_b_f = null;
        }else {
            $balance_b_f =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', request('item_id'))->whereDate('date', '<', $from)->sum('stock_in') - 
            \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', request('item_id'))->whereDate('date', '<', $from)->sum('stock_out');

            $ending_b_f =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', request('item_id'))
            ->WhereDate('date','>=', $from)
            ->WhereDate('date','<=', $to)
            ->OrderBy('id', 'DESC')->first();

           $transactions_db = \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', request('item_id'))
            ->WhereDate('date','>=', $from)
            ->WhereDate('date','<=', $to)
            ->orderBy('id', "ASC")
            ->get();
        }
        return view('stock-history-print', [
                'item' => \DB::table('items')->where('id', request('item_id'))->first(),
                'transactions_db' => $transactions_db,
                'balance_b_f_' => empty($balance_b_f) ? 0  : $balance_b_f,
                'from' => $from,
                'to' => $to,
                'ending_b_f' => $ending_b_f,
                'main_balance' => $transactions_db->first()
        ]);
    }


    public function StockFilter()
    {

        $this->validate(request(), [
            'start_date' => 'required',
            'end_date' => 'required'
        ]);
        
        $from =  request('start_date');
        $to =  request('end_date');
        

        if ($from == $to) {

            $balance_b_f =  \DB::table('stock_transactions')
            ->where('station', auth()->user()->station)->where('item_id', request('item_id'))
            ->WhereDate('date', '<', $to)
            ->sum('stock_in') - 

            \DB::table('stock_transactions')
            ->where('station', auth()->user()->station)->where('item_id', request('item_id'))
            ->WhereDate('date', '<', $to)
            ->sum('stock_out');

                      
            $transactions_db = \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', request('item_id'))
            ->WhereDate('date','>=', $from)
            ->WhereDate('date','<=', $to)
            ->orderBy('id', "ASC")
            ->get();
            
            $ending_b_f = null;
        }else {
            $balance_b_f =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', request('item_id'))->whereDate('date', '<', $from)->sum('stock_in') - 
            \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', request('item_id'))->whereDate('date', '<', $from)->sum('stock_out');

            $ending_b_f =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', request('item_id'))
            ->WhereDate('date','>=', $from)
            ->WhereDate('date','<=', $to)
            ->OrderBy('id', 'DESC')->first();

           $transactions_db = \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', request('item_id'))
            ->WhereDate('date','>=', $from)
            ->WhereDate('date','<=', $to)
            ->orderBy('id', "ASC")
            ->get();
        }
        return view('stock-history', [
                'item' => \DB::table('items')->where('id', request('item_id'))->first(),
                'transactions_db' => $transactions_db,
                'balance_b_f_' => empty($balance_b_f) ? 0  : $balance_b_f,
                'from' => $from,
                'to' => $to,
                'ending_b_f' => $ending_b_f,
                'main_balance' => $transactions_db->first()
        ]);
    }


    public function productHistoryDescription(Request $request)
    {
        $value = explode(' - ', $request->date);
         
        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        $request->merge([
            'start_date' => $from,
            'end_date' => $to
        ]);
        

        if ($from == $to) {

            $balance_b_f =  \DB::table('stock_transactions')
            ->where('station', auth()->user()->station)->where('item_id', request('item_id'))
            ->where('description', request('description'))
            ->WhereDate('date', '<', $to)
            ->sum('stock_in') - 

            \DB::table('stock_transactions')
            ->where('station', auth()->user()->station)->where('item_id', request('item_id'))
            ->where('description', request('description'))
            ->WhereDate('date', '<', $to)
            ->sum('stock_out');

                      
            $transactions_db = \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', request('item_id'))
            ->where('description', request('description'))
            ->WhereDate('date','>=', $from)
            ->WhereDate('date','<=', $to)
            ->orderBy('id', "ASC")
            ->get();
            
            $ending_b_f = null;
        }else {
            
            $balance_b_f =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', request('item_id'))->where('description', request('description'))->whereDate('date', '<', $from)->sum('stock_in') - 
            \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', request('item_id'))->where('description', request('description'))->whereDate('date', '<', $from)->sum('stock_out');

            $ending_b_f =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', request('item_id'))
            ->where('description', request('description'))
            ->WhereDate('date','>=', $from)
            ->WhereDate('date','<=', $to)
            ->OrderBy('id', 'DESC')->first();

           $transactions_db = \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', request('item_id'))
           ->where('description', request('description'))
            ->WhereDate('date','>=', $from)
            ->WhereDate('date','<=', $to)
            ->orderBy('id', "ASC")
            ->get();
        }
        return view('stock-history', [
                'item' => \DB::table('items')->where('id', request('item_id'))->first(),
                'transactions_db' => $transactions_db,
                'balance_b_f_' => empty($balance_b_f) ? 0  : $balance_b_f,
                'from' => $from,
                'to' => $to,
                'ending_b_f' => $ending_b_f,
                'main_balance' => $transactions_db->first()
        ]);
    }




    public function OpenStockReloadNewDay()
    {
        $getDayClose = \DB::table('close_days')->first();
        $newdate = date('Y-m-d', strtotime('-1 day', strtotime($getDayClose->day_close)));


        $previous_stock = \DB::table('item_stock_ledgers')
        ->whereDate('date', $newdate)
        ->where('station', auth()->user()->station)
        ->get();

        foreach ($previous_stock as $key => $previous_stock) {
            $data = new ItemStockLedger;
            $data -> item_opening_stock =  (($previous_stock->item_opening_stock+$previous_stock->item_recieved+$previous_stock->item_purchases+$previous_stock->item_manufacturing) - ($previous_stock->item_issue+$previous_stock->item_sales+$previous_stock->item_adjustment+$previous_stock->item_wastage+$previous_stock->item_cons_manufacturing));
            $data -> item_category = $previous_stock->item_category ;
            $data -> item_id = $previous_stock->item_id;
            $data -> date = $getDayClose->day_close;
            $data -> station = $previous_stock->station;
            $data -> item_name = $previous_stock->item_name;
            $data -> item_unit = $previous_stock->item_unit;
            $data -> item_manual_closing_stock = 0;
            $data -> item_stock_limit = $previous_stock->item_stock_limit;
            $data -> item_cost = $previous_stock->item_cost;
            $data -> item_stock_check = $previous_stock->item_stock_check;
            $data -> save();
        }

       return back()->with('status', "Opening stock loaded successfully");

    }



    public function reloadLedger()
    {
        $date = request('date');
        $inv_items = \DB::table('items')->get();
      
        foreach ($inv_items as $key => $report) {

            $opening = \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $report->id)->whereDate('date', '<', $date)->sum('stock_in') - 
                            \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $report->id)->whereDate('date', '<', $date)->sum('stock_out');
    
            \App\Models\ItemStockLedgerSummary::updateOrCreate([
                'station' => auth()->user()->station,
                'date' => $date,
                'item_id' => $report->id],
                [
                'item_name' => $report-> item_name,
                'item_unit' => $report-> item_unit,
                'item_code' => $report-> item_code, 
                'item_category' => $report-> item_category,
                'inactive_station' => $report-> inactive_station,
                'opening_stock' => $opening
                ]);
        
           }

            if (\Route::currentRouteName() == "reloadLedger") {
                return back()->with('status', 'BOM reloaded successfully');
            }
    }



    public function destroy(ItemStockLedger $ledger)
    {
        $ledger->delete();
        return back()->with('status', "Item Removed Successfully");
    }
}


