<?php

namespace App\Http\Controllers;

use App\Models\Kitchen;
use Illuminate\Http\Request;
use DateTime;
use App\Models\CostOfSaleDump;

class KitchenController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        return view('kitchen.central-kitchen');
    }


    public function indexSatellite()
    {
        return view('kitchen.satellite-kitchen', [
            'satellite_kitchen' => \DB::table('kitchens')->where('kitchen_category', "S")->get()
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {   
        $this->validate(request(), [
            'kitchen_name'=> 'required|max:300',
            'kitchen_location'=> 'required|max:300'
        ]);
        
            $data = new Kitchen;
        if ($request -> kitchen_category == "C") {
            $data -> user_id = auth()->user()->id;
            $data -> kitchen_code = "KTC-" . substr(str_shuffle("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, 6) . date("hi");
            $data -> kitchen_name = $request->kitchen_name;
            $data -> kitchen_category = "C";
            $data -> kitchen_location = $request->kitchen_location;
            $data->save();
                return back()->with('status',"Kitchen Created Successfully");
        }else{
            $data -> user_id = auth()->user()->id;
            $data -> kitchen_code = "KTS-" . substr(str_shuffle("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, 6) . date("hi");
            $data -> kitchen_name = $request->kitchen_name;
            $data -> kitchen_category = "S";
            $data -> kitchen_location = $request->kitchen_location;
            $data->save();
                return back();
        }

    }



    public function revenueSummary(Request $request)
    {
        $value = explode(' - ', $request->date);
        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');


        if (request('type') == "1") {
            $begin = new \DateTime($from);
            $end = new \DateTime( $to);
            $end = $end->modify( '+1 day' );

            $interval = new \DateInterval('P1D');
            $daterange = new \DatePeriod($begin, $interval ,$end);

            $date_range=[];
            foreach($daterange as $date){
                $date_range[] = $date->format("Y-m-d");
            }

            if ($request->branch == "ALL BRANCHES") {
                return view('revenue-summary-advanced', [
                    'date_range' => $date_range,
                    'date_range_' => $date_range,
                    'from' => $from,
                    'to' => $to
                ]);
            }else {
                return view('revenue-summary-advanced-branch', [
                    'date_range' => $date_range,
                    'date_range_' => $date_range,
                    'from' => $from,
                    'to' => $to
                ]);
            }

            
        }
        
        
        if ($from == $to) {
        if ($request->branch == "ALL BRANCHES") {
            $summaryRe =  \DB::table('invoices')
            ->selectRaw('branch as branch, sum(invoice_total_price) as total, sum(amount_deducted) as deducted')
                        ->where('invoice_category', '!=', "TRANSPORT")
                        ->where('invoice_status', 1)
            ->groupBy('branch')
            ->whereDate('created_at', $from)
            ->get();

            $total = \DB::table('invoices')->where('invoice_category', '!=', "TRANSPORT")
            ->where('invoice_status', 1)
            ->whereDate('created_at', $from)
            ->sum('invoice_total_price');

            $discount = \DB::table('invoices')->where('invoice_category', '!=', "TRANSPORT")
            ->where('invoice_status', 1)
            ->whereDate('created_at', $from)
            ->sum('amount_deducted');

        }else{

            $summaryRe =  \DB::table('invoices')
            ->selectRaw('branch as branch, sum(invoice_total_price) as total, sum(invoice_quantity) as quantity, sum(amount_deducted) as deducted')
                        ->where('invoice_category', '!=', "TRANSPORT")
                        ->where('invoice_status', 1)
            ->groupBy('branch')
            ->where('branch', $request->branch)
            ->whereDate('created_at', $from)
            ->get();

            $total = \DB::table('invoices')->where('invoice_category', '!=', "TRANSPORT")
            ->where('branch', $request->branch)
            ->where('invoice_status', 1)
            ->whereDate('created_at', $from)
            ->sum('invoice_total_price');
            
            $discount = \DB::table('invoices')->where('invoice_category', '!=', "TRANSPORT")
            ->where('branch', $request->branch)
            ->where('invoice_status', 1)
            ->whereDate('created_at', $from)
            ->sum('amount_deducted');
        }
    }else {
        if ($request->branch == "ALL BRANCHES") {
            $summaryRe =  \DB::table('invoices')
            ->selectRaw('branch as branch, sum(invoice_total_price) as total, sum(amount_deducted) as deducted')
                        ->where('invoice_category', '!=', "TRANSPORT")
                        ->where('invoice_status', 1)
            ->groupBy('branch')
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->get();

            $total = \DB::table('invoices')->where('invoice_category', '!=', "TRANSPORT")
            ->where('invoice_status', 1)
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->sum('invoice_total_price');

            $discount = \DB::table('invoices')->where('invoice_category', '!=', "TRANSPORT")
            ->where('invoice_status', 1)
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->sum('amount_deducted');
        }else{
            $summaryRe =  \DB::table('invoices')
            ->selectRaw('branch as branch, sum(invoice_total_price) as total, sum(invoice_quantity) as quantity, sum(amount_deducted) as deducted')
                        ->where('invoice_category', '!=', "TRANSPORT")
                        ->where('invoice_status', 1)
            ->groupBy('branch')
            ->where('branch', $request->branch)
            ->WhereDate('created_at','<=', $from)
            ->WhereDate('created_at','>=', $to)
            ->get();

            $total = \DB::table('invoices')->where('invoice_category', '!=', "TRANSPORT")
            ->where('branch', $request->branch)
            ->where('invoice_status', 1)
            ->WhereDate('created_at','<=', $from)
            ->WhereDate('created_at','>=', $to)
            ->sum('invoice_total_price');
            
            $discount = \DB::table('invoices')->where('invoice_category', '!=', "TRANSPORT")
            ->where('branch', $request->branch)
            ->where('invoice_status', 1)
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->sum('amount_deducted');
        }
    }

    \App\Models\UserActivity::create([
        'changed_date' => \Carbon\carbon::now(),
        'user_id'=>auth()->id(),
        'event' => "viewed Revenue Report Summary",
    ]);


        return view('revenue-summary', [
            'summary' => $summaryRe,
            'total' => $total,
            'discount' => $discount,
            'from' => $from,
            'to' => $to
        ]);
    }



    public function Sales(Request $request)
    {
        $this->validate($request,[
            'file' => 'required'
          ]);

           $upload = $request->file('file');
           $filePath = $upload->getRealPath();

           $file = fopen($filePath, 'r');

           $header = fgetcsv($file);

           $escapedHeader=[];

           // data validation
           
           foreach ($header as $key => $value) {
             $escapedItem = strtolower($value) ;
             array_push($escapedHeader, $escapedItem);

           }

           //looping through colums to get data

           while ($columns=fgetcsv($file)) {
             
             if ($columns[0] =="") {
              continue;
             }
	
	  
           //trim data
           foreach ($columns as $key => &$value) {
             $value = ucwords($value);
           }
           
	   $data = array_combine($escapedHeader, $columns);

       \App\Models\GraTax::create([
            'date' => $data['date'],
            'month' => $data['month'],
            'sales' => $data['sales'],
            'week_of_days' => $data['week_of_day']
        ]);
            
            

        }

        return back()->with('status', 'Stock sales successfully');
    }



    public function SalesReport()
    {
         $summary = \DB::table('gra_taxes')->selectRaw('week_of_days as week_of_days,  sum(sales) as sales')
        ->groupBy('week_of_days')
        ->where('month', "SEPTEMBER")
        ->get();

       

        // return $byWeek;

        // // return \App\Models\GraTax::all()->groupBy(\DB::raw('WEEK(date)'));
        

        

        return view('gra', [
            'summary' => $summary
        ]);
    }


    public function first_date_opening($request, $date_range)
    {
           $items = \DB::table('opening_stocks')->get();

           foreach ($items as $key => $item) {
                \DB::table('item_stock_ledgers')
                ->where('item_name' , $item->item_name)
                ->where('date',  $date_range[0])
                ->where('station', auth()->user()->station)
                ->update([
                    'item_opening_stock' => $item->opening_stock,
                ]); 
           }
    }


    public function SalesReportSummary()
    {
        $value = explode(' - ', session()->get('sales_summary_date'));
        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');


        \App\Models\UserActivity::create([
            'changed_date' => \Carbon\carbon::now(),
            'user_id'=>auth()->id(),
            'event' => "viewed sales summary report",
        ]);
        
        return view('sales-summary', [
            'branches_sales' => \DB::table('branches')->get(),
            'from' => $from,
            'to' => $to
        ]);
    }


    public function revenueSummaryTax(Request $request)
    {
        
        $value = explode(' - ', $request->date);
        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        if ($from == $to) {
        if ($request->branch == "ALL BRANCHES") {
           $summaryRe =  \DB::table('invoices')
            ->selectRaw('branch as branch, sum(invoice_total_price) as total, sum(amount_deducted) as deducted')
                        ->where('invoice_category', '!=', "TRANSPORT")
                        ->where('invoice_status', 1)
            ->groupBy('branch')
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->get();


            $total = \DB::table('invoices')->where('invoice_category', '!=', "TRANSPORT")
            ->where('invoice_status', 1)
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->sum('invoice_total_price');
            

        }else{
            $summaryRe =  \DB::table('invoices')
            ->selectRaw('branch as branch, sum(invoice_total_price) as total, sum(invoice_quantity) as quantity, sum(amount_deducted) as deducted')
                        ->where('invoice_category', '!=', "TRANSPORT")
                        ->where('invoice_status', 1)
            ->groupBy('branch')
            ->where('branch', $request->branch)
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->get();

            $total = \DB::table('invoices')->where('invoice_category', '!=', "TRANSPORT")
            ->where('branch', $request->branch)
            ->where('invoice_status', 1)
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->sum('invoice_total_price');
            
        }
    }else {
        if ($request->branch == "ALL BRANCHES") {
            
           $summaryRe =  \DB::table('invoices')
            ->selectRaw('branch as branch, sum(invoice_total_price) as total, sum(amount_deducted) as deducted')
                        ->where('invoice_category', '!=', "TRANSPORT")
                        ->where('invoice_status', 1)
            ->groupBy('branch')
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->get();

           $total = \DB::table('invoices')->where('invoice_category', '!=', "TRANSPORT")
            ->where('invoice_status', 1)
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->sum('invoice_total_price');

        }else{
            $summaryRe =  \DB::table('invoices')
            ->selectRaw('branch as branch, sum(invoice_total_price) as total, sum(invoice_quantity) as quantity, sum(amount_deducted) as deducted')
                        ->where('invoice_category', '!=', "TRANSPORT")
                        ->where('invoice_status', 1)
            ->groupBy('branch')
            ->where('branch', $request->branch)
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->get();

            $total = \DB::table('invoices')->where('invoice_category', '!=', "TRANSPORT")
            ->where('branch', $request->branch)
            ->where('invoice_status', 1)
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->sum('invoice_total_price');
        }
    }


    $mTax = \DB::table('taxes')->first();
    $gTax = $mTax->covid+$mTax->nhil+$mTax->getfund+$mTax->tourism;

    \App\Models\UserActivity::create([
        'changed_date' => \Carbon\carbon::now(),
        'user_id'=>auth()->id(),
        'event' => "Previewed Tax summary",
    ]);

        return view('tax-summary', [
            'summary' => $summaryRe,
            'total_sale' => $total,
            'gTax' => $gTax,
            'mTax' => $mTax
        ]);
    }



    public function ProfitSales(Request $request)
    {
        
        $value = explode(' - ', $request->date);
        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        if ($from == $to) {
        if ($request->branch == "ALL BRANCHES") {
           $summaryRe =  \DB::table('invoices')
            ->selectRaw('branch as branch, sum(invoice_total_price) as total, sum(amount_deducted) as deducted')
                        ->where('invoice_category', '!=', "TRANSPORT")
                        ->where('invoice_status', 1)
            ->groupBy('branch')
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->get();


            $total = \DB::table('invoices')->where('invoice_category', '!=', "TRANSPORT")
            ->where('invoice_status', 1)
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->sum('invoice_total_price');
            

        }else{
            $summaryRe =  \DB::table('invoices')
            ->selectRaw('branch as branch, sum(invoice_total_price) as total, sum(invoice_quantity) as quantity, sum(amount_deducted) as deducted')
                        ->where('invoice_category', '!=', "TRANSPORT")
                        ->where('invoice_status', 1)
            ->groupBy('branch')
            ->where('branch', $request->branch)
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->get();

            $total = \DB::table('invoices')->where('invoice_category', '!=', "TRANSPORT")
            ->where('branch', $request->branch)
            ->where('invoice_status', 1)
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->sum('invoice_total_price');
            
        }
    }else {
        if ($request->branch == "ALL BRANCHES") {
            $summaryRe =  \DB::table('invoices')
            ->selectRaw('branch as branch, sum(invoice_total_price) as total, sum(amount_deducted) as deducted')
                        ->where('invoice_category', '!=', "TRANSPORT")
                        ->where('invoice_status', 1)
            ->groupBy('branch')
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->get();

            $total = \DB::table('invoices')->where('invoice_category', '!=', "TRANSPORT")
            ->where('invoice_status', 1)
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->sum('invoice_total_price');

        }else{
            $summaryRe =  \DB::table('invoices')
            ->selectRaw('branch as branch, sum(invoice_total_price) as total, sum(invoice_quantity) as quantity, sum(amount_deducted) as deducted')
                        ->where('invoice_category', '!=', "TRANSPORT")
                        ->where('invoice_status', 1)
            ->groupBy('branch')
            ->where('branch', $request->branch)
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->get();

            $total = \DB::table('invoices')->where('invoice_category', '!=', "TRANSPORT")
            ->where('branch', $request->branch)
            ->where('invoice_status', 1)
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->sum('invoice_total_price');
        }
    }


        $mTax = \DB::table('taxes')->first();
        $gTax = $mTax->covid+$mTax->nhil+$mTax->getfund+$mTax->tourism;

        \App\Models\UserActivity::create([
            'changed_date' => \Carbon\carbon::now(),
            'user_id'=>auth()->id(),
            'event' => "viewed report for Sales and Profit Summary",
        ]);
    
    
            return view('sale-profit-summary', [
                'summary' => $summaryRe,
                'total_sale' => $total,
                'gTax' => $gTax,
                'mTax' => $mTax,
                'from' => $from,
                'to' => $to
            ]);
    }


    public function IncomeStatement(Request $request)
    {

            $value = explode(' - ', $request->date);
            $source1 = $value[0];
            $date1 = new DateTime($source1);
            $from = $date1->format('Y-m-d');

            $source2 = $value[1];
            $date2 = new DateTime($source2);
            $to = $date2->format('Y-m-d');

        session()->put('income_statement_date', $request->date );

        if (request('branch') == "ALL BRANCHES") {

                return view('accounting.income-statement', [
                    'from' => $from,
                    'to' => $to
                ]);
            
        }else {

           return "Work IN PROGRESS";
                return view('accounting.income-statement-branch', [
                    'from' => $from,
                    'to' => $to,
                    'branch' => $branch
                ]);

            }
    }


    public function IncomeStatementCategory(Request $request, $category)
    {

        $request->merge([
            'date' => session()->get('income_statement_date')
        ]);

        
       $value = explode(' - ', request('date'));
       $source1 = $value[0];
       $date1 = new DateTime($source1);
       $from = $date1->format('Y-m-d');

       $source2 = $value[1];
       $date2 = new DateTime($source2);
       $to = $date2->format('Y-m-d');

       $summaryRe =  \DB::table('invoices')
       ->selectRaw('branch as branch, sum(invoice_total_price) as total, sum(amount_deducted) as deducted')
                   ->where('invoice_category', '!=', "TRANSPORT")
                   ->where('invoice_status', 1)
                    ->groupBy('branch')
               ->where('agency', $category)
               ->WhereDate('created_at','>=', $from)
               ->WhereDate('created_at','<=', $to)
               ->get();

       return view('accounting.sales-category-incomestatement', [
           'summary' => $summaryRe,
           'to' => $to,
           'from' => $from,
           'category' => $category,
           'total' => $summaryRe->sum('total')
       ]);
       
    }


    public function invoiceTransactions(Request $request,$branch)
    {
        $request->merge([
            'date' => session()->get('invoice_transaction_date'),
            'category' => session()->get('income_category'),
            'branch' => $branch
        ]);


        $value = explode(' - ', request('date'));
        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');
 
        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');
 
        $summaryRe =  \DB::table('invoices')
                    ->where('invoice_category', '!=', "TRANSPORT")
                    ->where('invoice_status', 1)
                ->where('agency', request('category'))
                ->where('branch', request('branch'))
                ->WhereDate('created_at','>=', $from)
                ->WhereDate('created_at','<=', $to)
                ->get();


                return view('accounting.sales-transactions', [
                    'sales_today_branch' => $summaryRe,
                    'to' => $to,
                    'from' => $from,
                ]);
    }


    public function BalanceSheet(Request $request)
    {
        $value = explode(' - ', $request->date);
            $source1 = $value[0];
            $date1 = new DateTime($source1);
            $from = $date1->format('Y-m-d');

            $source2 = $value[1];
            $date2 = new DateTime($source2);
            $to = $date2->format('Y-m-d');

        $current_assets = \DB::table('accounts')->where('account_state', 1)
            ->where('account_type', "Current Assets")
            ->get();

       $non_current_assets = \DB::table('accounts')->where('account_state', 1)
        ->where('account_type', "Non-current Assets")
        ->get();

        $current_liabilites = \DB::table('accounts')->where('account_state', 1)
        ->where('account_type', "Current Liabilities")
        ->get();

        $non_current_liabilities = \DB::table('accounts')->where('account_state', 1)
        ->where('account_type', "Non-current Liabilities")
        ->get();

           

        return view('accounting.balance-sheet', [
            'current_assets' => $current_assets,
            'non_current_assets' => $non_current_assets,
            'current_liabilites' => $current_liabilites,
            'non_current_liabilities' => $non_current_liabilities,
            'from' => $from,
            'to' => $to,
        ]);
    }


    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Kitchen  $kitchen
     * @return \Illuminate\Http\Response
     */
    public function  clearSystemCache()
    {
        \Artisan::call('route:clear');
        \Artisan::call('cache:clear');
        \Artisan::call('config:clear');
        \Artisan::call('view:clear');
        return back()->with('status', 'All cached files removed successfully');

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Kitchen  $kitchen
     * @return \Illuminate\Http\Response
     */
    public function edit(Kitchen $kitchen)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Kitchen  $kitchen
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Kitchen $kitchen)
    {
        //
    }


    public function deleteKitchen(Kitchen $kitchen)
    {
        $kitchen->delete();
        return back()->with('status', "Kitchen Removed Successfully");
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Kitchen  $kitchen
     * @return \Illuminate\Http\Response
     */
    public function destroy(Kitchen $kitchen)
    {
        
    }
}
