<?php

namespace App\Http\Controllers;

use App\Models\LoyaltyRatio;
use Illuminate\Http\Request;

class LoyaltyRatioController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    
    public function index()
    {
        
        $top_customers = \DB::table('customers')->where('customer_name', 'NOT LIKE', '%' . "WALK-IN" . '%')->paginate(100);

        return view('loyalty', [
            'loyalty' => LoyaltyRatio::first(),
            'loyalty_points' => $top_customers
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate(request(), [
            'amount' => 'required',
            'loyalty_amount' => 'required'
        ]);

        if (empty(LoyaltyRatio::first())) {
            LoyaltyRatio::create([
                'amount' => request('amount'),
                'user_id' => auth()->id(),
                'point_amount' => request('loyalty_amount')
            ]);
        }else {
            $lt = LoyaltyRatio::first();
            LoyaltyRatio::Where('id', $lt->id)->update([
                'amount' => request('amount'),
                'user_id' => auth()->id(),
                'point_amount' => request('loyalty_amount')
            ]);
        }
        

        return back()->with('status', 'Loyalty Ratio Saved Successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\LoyaltyRatio  $loyaltyRatio
     * @return \Illuminate\Http\Response
     */
    public function show(LoyaltyRatio $loyaltyRatio)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\LoyaltyRatio  $loyaltyRatio
     * @return \Illuminate\Http\Response
     */
    public function edit(LoyaltyRatio $loyaltyRatio)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\LoyaltyRatio  $loyaltyRatio
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, LoyaltyRatio $loyaltyRatio)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\LoyaltyRatio  $loyaltyRatio
     * @return \Illuminate\Http\Response
     */
    public function destroy(LoyaltyRatio $loyaltyRatio)
    {
        //
    }
}
