<?php

namespace App\Http\Controllers;

use App\Models\MakeRequest;
use Illuminate\Http\Request;
use App\Models\SatelliteRequisition;
use Carbon\carbon;
use DateTime;

class MakeRequestController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        
    }

    public function indexWarehouse()
    {   
        $dayClose = \DB::table('close_days')->first();
        $this->validate(request(), [
            'r_store' => 'required'
        ]);
        
        session()->put('request_from', request('r_store'));
        session()->put('date', request('date'));
        session()->put('transaction_number', rand(5034,10034580)+rand(4580,10034580) . date("Yd") . date('Hi'));

       
            $item_issues = \DB::table('items')
                ->where('transfer_status', 1)
                ->OrderBy('item_name', 'ASC')
                ->get();

        
        $req = session()->get('requisition');

        return view('makerequest.warehouse-request', [
            'item_re' => $req,
            'items' => $item_issues
        ]);
    }


    public function RemoveRequest(SatelliteRequisition $makeRequest)
    {
        $makeRequest->delete();
        return response([
            'status' => 1000,
            'message' => "successfully removed"
        ]);
    }

// using satellite_requisitions table for both Central And Satellite Kitchen Requisition
    public function indexSatellite()
    {   
        $check_request = \DB::table('satellite_requisitions')
                        ->where('user_id', auth()->user()->id)
                        ->where('r_state', "P")
                        ->first();
        $req = \DB::table('satellite_requisitions')
        ->where('user_id', auth()->user()->id)
        ->where('r_state', "P")->get();
        return view('makerequest.satellite-request', [
            'item_re' => $req,
            'check_request' => $check_request
        ]);
    }

    public function indexCentral()
    {   
        $check_request = \DB::table('satellite_requisitions')
                        ->where('user_id', auth()->user()->id)
                        ->where('r_state', "P")
                        ->first();

        $req = \DB::table('satellite_requisitions')
        ->where('user_id', auth()->user()->id)
        ->where('r_state', "P")->get();
        return view('makerequest.central-request', [
            'item_re' => $req,
            'check_request' => $check_request
        ]);
    }


    public function IncomingRequest()
    {   
        $dayClose = \DB::table('close_days')->first();
        $lists = \DB::table('request_lists')
        ->where('request_from', auth()->user()->station)
        ->whereDate('date', $dayClose->day_close)
        ->get();
        return view('makerequest.incoming-req', [
            'lists'=>$lists
        ]);
    }


    public function OutgoingRequest()
    {
        $dayClose = \DB::table('close_days')->first();
        $lists = \DB::table('request_lists')
        ->where('station', auth()->user()->station)
        ->whereDate('date', $dayClose->day_close)
        ->get();
        return view('makerequest.incoming-req', [
            'lists'=>$lists
        ]);
    }


    public function getIncomingRequestReport(Request $request)
    {

        $value = explode(' - ', $request->date);
         

        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        if ($from == $to) {
            $lists = \DB::table('request_lists')
            ->where('request_from', auth()->user()->station)
            ->whereDate('date', $from)
            ->get();
         }else {
            $lists = \DB::table('request_lists')
            ->where('request_from', auth()->user()->station)
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->get();
         }
        return view('makerequest.outgoing-request-report', [
            'lists'=>$lists
        ]);
    }



    public function getOutgoingRequestReport(Request $request)
    {

        $value = explode(' - ', $request->date);
         

        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        if ($from == $to) {
            $lists = \DB::table('request_lists')
            ->whereDate('date', $from)
            ->where('station', auth()->user()->station)
            ->get();
         }else {
            $lists = \DB::table('request_lists')
            ->where('station', auth()->user()->station)
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->get();
         }
         
        return view('makerequest.outgoing-request-report', [
            'lists'=>$lists
        ]);
    }


    public function ViewRequest($transaction)
    {   
        $details = \DB::table('satellite_requisitions')
                    ->join('users', 'satellite_requisitions.user_id','users.id')
                    ->where('satellite_requisitions.r_transaction_id',$transaction)
                    ->first();
                    
        $requistion = \DB::table('satellite_requisitions')
        ->where('r_transaction_id',$transaction)->get();
        return view('makerequest.view-requisition', [
            'details' => $details,
            'requistion' => $requistion
        ]);
    }

    public function ViewRequestPrint($transaction)
    {   
        $details = \DB::table('satellite_requisitions')
                    ->join('users', 'satellite_requisitions.user_id','users.id')
                    ->where('satellite_requisitions.r_transaction_id',$transaction)
                    ->first();
                    
        $requistion = \DB::table('satellite_requisitions')
        ->where('r_transaction_id',$transaction)->get();
        return view('makerequest.view-request-print', [
            'details' => $details,
            'requistion' => $requistion
        ]);
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\MakeRequest  $makeRequest
     * @return \Illuminate\Http\Response
     */
    public function show(MakeRequest $makeRequest)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\MakeRequest  $makeRequest
     * @return \Illuminate\Http\Response
     */
    public function edit(MakeRequest $makeRequest)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\MakeRequest  $makeRequest
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, MakeRequest $makeRequest)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\MakeRequest  $makeRequest
     * @return \Illuminate\Http\Response
     */
    public function destroy(MakeRequest $makeRequest)
    {
        //
    }
}
