<?php

namespace App\Http\Controllers;

use App\Models\Order;
use App\Models\Discount;
use App\Models\HeldTransaction;
use Illuminate\Http\Request;

class OrderController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Order  $order
     * @return \Illuminate\Http\Response
     */
    public function show($order)
    {
        $detail_order = \DB::table('invoices')->where('invoice_number', $order)->get();
        $customer = Order::where('order_id', $order)->first();
        $discount = Discount::where('order_id', $order)->first();
        $customer_id = $customer -> customer_id;

        if (empty($discount)) {
            $discount = 0 ;
        }else {
            $discount = $discount->amount_deducted;
        }


        if ($customer->status == 5) {
            $trans = HeldTransaction::where('order_id', $order)->first();
            
            if (!$trans) {
                HeldTransaction::create([
                    'user_id' => $customer->user_id,
                    'order_id' => $order,
                    'pay_type' => $customer->payment_method,
                    'description' => 'Initial',
                    'increase' => $detail_order->sum('invoice_total_price'),
                    'decrease' => null
                ]);
            }
        }

        return view('order-transactions', [
            'orders' => $detail_order,
            'invoice_number' => $order,
            'customer_id' => $customer_id,
            'customer' => $customer,
            'payHistory'  => HeldTransaction::where('order_id',$order)->get(),
            'discount' => $discount
        ]);
    }


    public function PrintInvoice($order, $customer_id)
    {

        $salesperson = Order::where('order_id', $order)->first();

        $discount = Discount::where('order_id', $order)->first();
        $items = \DB::table('invoices')->where('invoice_number', $order)->get();
        return view('accounting.tax-invoice', [
            'products' => $items,
            'salesperson' => $salesperson,
            'number'=> $order,
            'branch_details' => \DB::table('branches')->where('branch_name',$salesperson->branch)->first(),
            'customer' => \DB::table('customers')->where('id', $salesperson->customer_id)->first(),
            'discount' => $discount
        ]);
    }



    public function RejectItem($item_id, $invoice_id)
    {
        $product = \DB::table('invoices')->where('id', $invoice_id)->first();
        $bom = \DB::table('material_product_compositons')->where('product_id', $product->product_id)->get();

        return view('inc.rejected-order-bom', [
            'p_comp'=> $bom,
            'product' => $product
        ]);
    }


    public function search()
    {
        $this->validate(request(), [
            'search' => 'required' 
        ]);

        $transactions = \DB::table('orders')
        ->where('branch', request('branch'))
        ->WhereDate('created_at','>=', request('start_date'))
        ->WhereDate('created_at','<=', request('end_date'))
        ->get();
  
    
        return view('all-orders-tr', [
            'all_sales' => $transactions
        ]);
    }



    public function changeInvoiceStatus(Request $request)
    {   
        
       $item = \App\Models\Invoice::where('id',$request->invoice_id)->first();

       if ($item -> invoice_status == 5) {
            HeldTransaction::create([
                'user_id' => auth()->id(),
                'order_id' => $item->invoice_number,
                'pay_type' => "Return Item",
                'description' => $request -> comment,
                'increase' => null,
                'decrease' => $item ->invoice_unit_price * $item ->invoice_quantity
            ]);
        }
        
        if ($request->status == "On The House") {
           $status = 2;
        }elseif ($request->status == "Rejected") {
            $status = 0;
        }else {
            $status = 1;
        }

        if ( $item->invoice_status == $status ) {
            abort(419, "Sorry this item can not be changed");
        }


        $getDayClose = \DB::table('close_days')->first(); // getDay close
        $time = date('H:i:s'); // current time 


        // check for Order and Remove discount
    $discount = \DB::table('discounts')->where('order_id', $item->invoice_number)->first();
        if ($discount != null) {
            if ($request->status == "On The House" || $request->status == 2) {
                $item -> invoice_status = 2;
                \DB::table('customer_statement')->where('statement_number',$item->invoice_number)->update([
                    'transaction_state' => 2
                ]);
                Discount::where('order_id', $item->invoice_number)->delete();
            }elseif ($request->status == "Rejected" || $request->status == 0) {
                $item -> invoice_status = 0;
                Discount::where('order_id', $item->invoice_number)->delete();
                \DB::table('customer_statement')->where('statement_number',$item->invoice_number)->update([
                    'transaction_state' => 0
                ]);
                Order::where('order_id', $item->invoice_number)->update([
                    'discount' => 0
                ]);
            }elseif ($request->status == "General" || $request->status == 1) {
                $item -> invoice_status = 1;
            }
            $item -> comment = $request -> comment;
            $item->save();
            return response([
                'status' => $item -> invoice_status,
                'item_id' => $item->product_id,
                'invoice_id' => $request->invoice_id
            ]) ;
        }else {
            if ($request->status == "On The House" || $request->status == 2) {
                $item -> invoice_status = 2;
            }elseif ($request->status == "Rejected" || $request->status == 0) {
                \DB::table('stock_transactions')->where('transactions_id', $item->invoice_number)->delete();
                $item -> invoice_status = 0;
                \DB::table('customer_statements')->where('statement_number',$item->invoice_number)->update([
                    'transaction_state' => 0
                ]);
            }elseif ($request->status == "General"  || $request->status == 1) {
                $item -> invoice_status = 1;
            }


            $item -> comment = $request -> comment;
            $item -> status_changed_by = auth()->id();
            $item -> status_change_date = \Carbon\carbon ::now();
            $item->save();
            return response([
                'status' => $item -> invoice_status,
                'item_id' => $item->product_id,
                'invoice_id' => $request->invoice_id
            ]) ;
        }
       
    }


    public function AllOrders(Request $request)
    {   
         // GET DAY CLOSE DATE
         $getDayClose = \DB::table('close_days')->first();

        if (auth()->user()->role == "Administrator") {
            $transactions = Order::whereDate('created_at', $getDayClose->day_close)->get();
        }else {
            $transactions = Order::whereDate('created_at', $getDayClose->day_close)
            ->where('user_id', auth()->id())
            ->get();
        }
        
        return view('all-ordersmain', [
            'all_sales' => $transactions
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Order  $order
     * @return \Illuminate\Http\Response
     */
    public function edit(Order $order)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Order  $order
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Order $order)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Order  $order
     * @return \Illuminate\Http\Response
     */
    public function destroy(Order $order)
    {
        //
    }
}
