<?php

namespace App\Http\Controllers;

use App\Models\PaymentAccount;
use App\Models\PaymentMethod;
use Illuminate\Http\Request;
use App\Models\AccountType;

class PaymentAccountController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }


    public function summaryAccount()
    {
        \App\Models\UserActivity::create([
            'changed_date' => \Carbon\carbon::now(),
            'user_id'=>auth()->id(),
            'event' => "visited Account summary page",
        ]);

        return view('accounting.ac-summary');
    }


    public function index()
    {
        
        \App\Models\UserActivity::create([
            'changed_date' => \Carbon\carbon::now(),
            'user_id'=>auth()->id(),
            'event' => "visited Account List page",
        ]);

        $ca = \DB::table('control_accounts')->pluck('control_name');
        $vendors = \DB::table('vendors')->pluck('vendor_name');
        return view('accounting.list-account', [
            'account_type' => AccountType::All(),
            'accounts' => \DB::table('accounts')->where('account_state', 1)
            ->whereNotIn('account_name', $ca)
            ->whereNotIn('account_name', $vendors)
            ->orderBy('account_name', 'ASC')
            ->where('account_type', '!=', 'Expenses')
            ->where('account_type', '!=', 'Income')
            ->where('account_type', '!=', 'Cost of Sales')
            ->get(),
            'funds' => \DB::table('accounts')->where('account_state', 1)
            ->orderBy('account_name', 'ASC')
            ->whereNotIn('account_name', $ca)
            ->whereNotIn('account_name', $vendors)
            ->where('account_type', '!=', 'Expenses')
            ->where('account_type', '!=', 'Income')
            ->where('account_type', '!=', 'Cost of Sales')
            ->get(),
            'payment_methods' => \DB::table('payment_methods')->pluck('payment_name')
        ]);
    }


    public function chartAccount()
    {
        \App\Models\UserActivity::create([
            'changed_date' => \Carbon\carbon::now(),
            'user_id'=>auth()->id(),
            'event' => "visited Chart of Account page",
        ]);

        return view('accounting.chart-account');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        AccountType::create([
            'user_id' => auth()->id(),
            'account_code' => rand(100,5000).date('Yd'),
            'account_type_name' => request('account_type_name'),
            'account_type_parent' => request('account_type_parent'),
            'account_type_description' => request('account_type_description')
        ]);

        \App\Models\UserActivity::create([
            'changed_date' => \Carbon\carbon::now(),
            'user_id'=>auth()->id(),
            'event' => "created a new account",
        ]);

        return back()->with('status', 'Account created successfully');
    }


    public function paymentIndex()
    {
        return view('accounting.payment-methods',[
            'payment_methods' => PaymentMethod::All()
        ]);
    }

    public function NewPaymentMethod()
    {
        $this->validate(request(), [
            'payment_name' => 'required|max:300'
        ]);
        
        PaymentMethod::create([
            'payment_name' => request('payment_name'),
            'user_id' => auth()->id()

        ]);
        return back()->with('status', "New payment method created successfully");
    }


    public function paymentDestroy(PaymentMethod $PaymentMethod)
    {
        $PaymentMethod->delete();
        return back()->with('status', 'Payment method deleted successfully');

    }

    public function destroy(AccountType $accountType)
    {

        \App\Models\UserActivity::create([
            'changed_date' => \Carbon\carbon::now(),
            'user_id'=>auth()->id(),
            'event' => "deleted account type -" . $accountType->account_type_name,
        ]);

        $accountType->delete();
        return response([
            'status'=>1000,
            'message'=>"deleted"
        ]);
    }
}
