<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\FinalProduction;
use Illuminate\Support\Facades\Http;
use App\Models\ActivateFinalProduct;
use App\Models\MaterialProductCompositon;

class ProductController extends Controller
{ 


  public function __construct()
  {
    $this->middleware('auth');
  }


  public function removeItem($id)
    {
        
       $product = \DB::table('final_productions')->where('FinalProductionID', $id)->first();

        \DB::table('final_productions')->where('FinalProductionID', $id)->delete();
        \DB::table('material_product_compositons')->where('product_id', $id)->delete();

        return redirect('/dashboard/items/product-services')->with('status', 'Item Deleted Successfully');
    }


    public function ProductAction()
    {
      if (empty(request('product'))) {
        return back()->with('statuspass', 'Kindly select a product');
      }
      if (request('action') == "Enable Online") {
        \DB::table('final_productions')->whereIn('FinalProductionID', request('product'))->update([
          'website_display' => 1,
          'store_category' => 0
        ]);
      }elseif (request('action') == "Disable Online") {
        \DB::table('final_productions')->whereIn('FinalProductionID', request('product'))->update([
          'website_display' => 0
        ]);
      }elseif (request('action') == "Bar Item"){
        \DB::table('final_productions')->whereIn('FinalProductionID', request('product'))->update([
          'website_display' => 0,
          'store_category' => 1
        ]);
      }

      return back()->with('status', "Action Performed Successfully");
    }


    public function export()
    {
      return view('inc.export-products', [
        'items_product' =>  \DB::table('final_productions')->get()
      ]);
    }

    public function productEdit($id, Request $request)
    { 

      $this->validate_fields();
      $category = \DB::table('item_categories')->where('category_name', $request->p_category)->first();

      if($file = $request->hasFile('image')) {
        $file = $request->file('image') ;
        $fileName = $file->getClientOriginalName() ;
        $destinationPath = 'uploads/' ;
        $file->move($destinationPath,$fileName);
        $newfile = ''.$fileName ;

        $imagePath = $newfile;


        FinalProduction::Where('FinalProductionID', $id)->update([
          'Name' => $request->p_name, 
          'UnitPrice' => $request->p_unit_price,
          'production_category' => $request->p_category,
          'description' => $request->p_description,
          'brand' => $request->p_brand,
          'product_code' => $request->product_code,
          'barcode' => $request->barcode,
          'product_image' => $newfile,
          'store_category' => $request->store_category == "" ? 0 : $request->store_category,
          'website_display' => $request->store_active == "" ? 0 : $request->store_category,
        ]);
      
        
     }else {
      FinalProduction::Where('FinalProductionID', $id)->update([
        'Name' => $request->p_name, 
        'UnitPrice' => $request->p_unit_price,
        'production_category' => $request->p_category,
        'description' => $request->p_description,
        'brand' => $request->p_brand,
        'product_code' => $request->product_code,
        'barcode' => $request->barcode,
        'store_category' => $request->store_category == "" ? 0 : $request->store_category,
        'website_display' => $request->store_active == "" ? 0 : $request->store_active,
      ]);
      
     
       
      }

      \Artisan::call('route:clear');
      \Artisan::call('cache:clear');
      \Artisan::call('config:clear');
      \Artisan::call('view:clear');
    
      return back()->with('status', 'Changes Made Successfully');
      
    }



  public function activateProduct()
  {
    $this->validate(request(), [
      'branch*' => 'required'
    ]);
    
    \DB::table('final_productions')->where('FinalProductionID', request('product_id'))->update([
        'activated_branches' => empty(request('branches')) ? "[]" : json_encode(request('branches'))
    ]);
    
    return response([
      'status' => 1000,
      'Message' => "Deactivation was successfull"
    ]);

  }

  public function productSettings()
  {
 
    return view('product-settings', [
      'items'=> \DB::table('final_productions')->orderBy('Name', 'ASC')->get(),
      'Allitems' => \DB::table('items')->get()
    ]);
  }


  public function barCodeSetting()
  {
    return view('barcode-setting', [
      'items'=> \DB::table('final_productions')->paginate(100),
    ]);
  }


  public function SetBomData()
  {
    $this->validate(request(), [
        'product' => 'required'
    ]);
    if (request('remove_bom') == "remove_bom") {
      $p_comp = \DB::table('material_product_compositons')
      ->whereIn('id', request('product'))
      ->delete();

      return back()->with('status',"Items deleted from product Bill of Material");

    }else {
      return;
    }
  }


  public function loadBillofMaterial(Request $request)
  {
    $this->validate($request,[
      'file' => 'required'
    ]);

        $upload = $request->file('file');
        $filePath = $upload->getRealPath();

        $file = fopen($filePath, 'r');

        $header = fgetcsv($file);

        $escapedHeader=[];
        
        foreach ($header as $key => $value) {
          $escapedItem = strtolower($value) ;
          array_push($escapedHeader, $escapedItem);

        }

        //looping through colums to get data

        while ($columns=fgetcsv($file)) {
          try {
          
          if ($columns[0] =="") {
            continue;
          }

    
        //trim data
        foreach ($columns as $key => &$value) {
          $value = ucwords($value);
        }
        
      $data = array_combine($escapedHeader, $columns);
        

          $product = $data['item_name'];
          $composition = $data['store_item'];
          $unit_measure = $data['quantity'];

          if (empty($product) || empty($composition) || empty($unit_measure)) {
            continue;
          }

          $product = \DB::table('final_productions')->where('Name', $product)->first();
          $comp = \DB::table('items')->where('item_name', $composition)->first();
          $cost = \DB::table('item_b_o_m_s')->where('item_id', $comp->id)->sum('item_bom_unit_rate');
    
          MaterialProductCompositon::updateOrCreate(
                ['product_id'=> $product->FinalProductionID, 'composition_id' => $comp->id],
                [
                'product_code' => $product->product_code,
                'product_name' => $comp->item_name,
                'unit_measure' => $unit_measure,
                'cost' => (float)$cost * (float)$unit_measure,
                'raw_material_code' => $comp->item_code
          ]);
              } catch (\Throwable $th) {
            continue;
          }
        
      }
      
   
      \Artisan::call('route:clear');
      \Artisan::call('cache:clear');
      \Artisan::call('config:clear');
      \Artisan::call('view:clear');
      return back()->with('status', "Bill of Material successfully uploaded");
  }


  public function ProductBarcodesSave(Request $request)
  {
    $data = $request->all();
    if (array_key_exists('items', $data)) {
      foreach ($data['items'] as $key => $item) {
        if (empty($item['barcode'])||null) {
          continue;
        }
          \DB::table('final_productions')->where('FinalProductionID', $item['product_id'])->update([
              'barcode' => $item['barcode']
          ]);
      }
    }
    return back()->with('status', "Barcodes Added Successfully");
  }

  public function store(Request $request)
  { 

    $this->validate_fields();

    $appdata = new FinalProduction;
    if($file = $request->hasFile('image')) {
      $file = $request->file('image') ;
      $fileName = $file->getClientOriginalName() ;
      $destinationPath = 'uploads/' ;
      $file->move($destinationPath,$fileName);
      $appdata -> product_image = ''.$fileName ;
   }
      
      $appdata -> Name = $request->p_name;
      $appdata -> UnitPrice = $request->p_unit_price;
      $appdata -> production_category = $request->p_category;
      $appdata -> description = $request->p_description;
      $appdata -> product_code = $request->product_code;
      $appdata -> brand = $request->p_brand;
      $appdata -> barcode = $request->barcode;
      $appdata -> activated_branches = "[]";
      $appdata -> store_category = $request->store_category == "" ? 0 : $request->store_category;
      $appdata -> website_display = $request->store_active == "" ? 0 : $request->store_active;
      $appdata -> save();

      $useID = \DB::table('final_productions')->where('product_code',$appdata -> product_code)->first();
      $category = \DB::table('item_categories')->where('category_name', $request->p_category)->first();

      \Artisan::call('route:clear');
      \Artisan::call('cache:clear');
      \Artisan::call('config:clear');
      \Artisan::call('view:clear');
      return redirect()->to('/dashboard/product-add-composing/' . $useID -> FinalProductionID . "?item_name=".$request->p_name);

  }

  
  public function load(Request $request)
    {
        $this->validate($request,[
            'file' => 'required'
          ]);

           $upload = $request->file('file');
           $filePath = $upload->getRealPath();

           $file = fopen($filePath, 'r');

           $header = fgetcsv($file);

           $escapedHeader=[];

           // data validation
           
           foreach ($header as $key => $value) {
             $escapedItem = strtolower($value) ;
             array_push($escapedHeader, $escapedItem);

           }

           //looping through colums to get data

           while ($columns=fgetcsv($file)) {
             
             if ($columns[0] =="") {
              continue;
             }
	
	   try{
           //trim data
           foreach ($columns as $key => &$value) {
             $value = ucwords($value);
           }
           
	   $data = array_combine($escapedHeader, $columns);
            $name = $data['item_name'];
            $price = $data['unit_price'];
            $product_code = $data['product_code'];
            $barcode_code = $data['bar_code'];
            $department= $data['category'];
            $brand= $data['brand'];
            $description = $data['description'];
            $store_category = $data['store_category'];
            

            $appdata = new FinalProduction;
            $appdata -> Name = $name;
            $appdata -> product_code = empty($product_code) ? "PD-".substr(str_shuffle("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, 7) . date("hi") : $product_code;
            $appdata -> barcode = $barcode_code;
            $appdata -> UnitPrice = $price;
            $appdata -> production_category = $department;
            $appdata -> description = $description;
            $appdata -> brand = $brand;
            $appdata -> store_category = empty($store_category) ? 0 : 1;
            $appdata -> activated_branches = "[]";
            $appdata -> save();
            
            }catch(\Exception $ex){
            	return back()->with('status','something is wrong, kindly download the csv file ' . $ex . '<a href="/uploads/products.csv">Here</a>' . ' as a guide');
            	}

        }
        return back()->with('status', 'Product data loaded successfully');
 
    }


    public function validate_fields()
    {
      $this->validate(request(), [
        'p_name' => ['required', 'string', 'max:255'],
        'p_unit_price' => ['required', 'string', 'max:255'],
        'p_category' => ['required', 'string', 'max:255'],
        'product_code' => ['required', 'string', 'max:255'],
      ]);
    }
}
