<?php

namespace App\Http\Controllers;

use App\Models\Purchase;
use Illuminate\Http\Request;
use App\Models\ManufactureBOM;
use App\Models\User;
use Carbon\Carbon;
use App\Models\ItemStockLedger;
use App\Models\InventoryReport;
use DateTime;
use App\Models\PurchaseRecord;

class PurchaseController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        $check_purchase = \DB::table('purchases')
                        ->where('user_id', auth()->user()->id)
                        ->where('purchase_state', "P")
                        ->first();

            $purchases =  \DB::table('purchases')
                        ->where('user_id', auth()->user()->id)
                        ->where('purchase_state', "P")
                        ->get();

            $ca = \DB::table('control_accounts')->pluck('control_name');

        return view('purchases', [
            'purchases' => $purchases,
            'check_purchase' => $check_purchase,
            'items'=> \DB::table('items')->get(),
            'payment_accounts' => \DB::table('accounts')->where('account_state', 1)
            ->whereNotIn('account_name', $ca)
            ->orderBy('account_name', 'ASC')
            ->get(),
            'units' => \DB::table('units')->get()
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'purchase_vendor' => 'required',
            'purchase_item' => 'required',
            'purchase_quantity' => 'required',
            'purchase_rate' => 'required'
        ]);

        $item_unit = \DB::table('items')->where('id', explode(" - ", $request -> purchase_item)[1])->first();
        // search Unit
    
        if ($request -> purchase_unit !== null) {
            $getUnit = \DB::table('unit_conversions')
            ->where('item_id', explode(" - ", $request -> purchase_item)[1])
            ->where('conversion_unit', $request -> purchase_unit)
            ->first();

            if ($getUnit == null) {
                $convertQty = (float)$request -> purchase_quantity;
                $unit_measure = $item_unit->item_unit;
            }else {
                $convertQty = ((float)$getUnit->base_unit_figure*(float)$request -> purchase_quantity)/(float)$getUnit->conversion_unit_figure;
                $unit_measure = $item_unit->item_unit;
            }
        
        }else{
            $convertQty = (float)$request -> purchase_quantity ;
        }

        $data = new Purchase;
        $data ->user_id = auth()->user()->id;
        $data ->station = auth()->user()->station;
        $data ->purchase_transaction_id = $request->purchase_transaction_id;
        $data->purchase_vendor = $request->purchase_vendor;
        $data->purchase_date =  $request -> purchase_date;
        $data->purchase_expiry = $request -> purchase_expiry;
        $data->purchase_note = $request -> purchase_note ;
        $data->purchase_category = $item_unit->item_category ;
        $data->purchase_item =  $item_unit->item_name ;
        $data->purchase_item_id =  $item_unit->id ;
        $data->purchase_quantity =  (float)$convertQty ;
        $data->purchase_rate =  (float)$request -> purchase_rate ;
        $data->purchase_unit = $request -> purchase_unit == null ? $item_unit->item_unit : $unit_measure;
        $data->purchase_state = "P" ;
        $data->purchase_total =  (float)$request -> purchase_quantity *  (float)$request -> purchase_rate ;
        $data->save();
        return response([
            'status' => 200,
            'Message' => "Purchases saves Successfully"
        ]);
    }

    public function ActivateProduct(Request $request)
    {   
        $dayClose = \DB::table('close_days')->first();
        $item_unit = \DB::table('items')->where('id', request('item_id'))->first();
        // search Unit
    
        if ($request -> purchase_unit !== null) {
            $getUnit = \DB::table('unit_conversions')
            ->where('item_id', request('item_id'))
            ->where('conversion_unit', $request -> purchase_unit)
            ->first();

            if ($getUnit == null) {
                $convertQty = 1;
                $unit_measure = $item_unit->item_unit;
            }else {
                $convertQty = (float)$getUnit->base_unit_figure*1/(float)$getUnit->conversion_unit_figure;
                $unit_measure = $item_unit->item_unit;
            }
        
        }else{
            $convertQty = 1 ;
        }

        $data = new Purchase;
        $data ->user_id = auth()->user()->id;
        $data ->station = auth()->user()->station;
        $data ->purchase_transaction_id = "ACT".substr(str_shuffle("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, 7) . date("hi");
        $data->purchase_vendor = "ACTIVATION";
        $data->purchase_date =  $dayClose->day_close;
        // $data->purchase_expiry = $request -> purchase_expiry;
        $data->purchase_note = "" ;
        $data->purchase_category = "ACTIVATED PRODUCT" ;
        $data->purchase_item =  $item_unit->item_name ;
        $data->purchase_item_id =  $item_unit->id ;
        $data->purchase_quantity =  (float)$convertQty ;
        $data->purchase_rate =  (float)$request -> estimated_cost ;
        $data->purchase_unit = $request -> purchase_unit == null ? $item_unit->item_unit : $unit_measure;
        $data->purchase_state = "P" ;
        $data->purchase_total =  1 *  (float)$request -> estimated_cost ;
        $data->save();

        return redirect()->route('savePurchase');
    }

    
    
    public function savePurchasePrint()
    {
        if (request('purchase_type') == "Purchase Invoice") {
            $this->validate(request(), [
                'amount_paid' => 'required',
                'payment_mode' => 'required'
            ]);
        }
        
        $time = date('H:i:s'); // current time 

        try {
            \DB::beginTransaction();

          $item = \DB::table('purchases')
                ->where('purchase_state', "P")
                ->where('user_id', auth()->user()->id)
                ->get();

                $purchases = \DB::table('purchases')
                ->where('purchase_state', "P")
                ->where('user_id', auth()->user()->id)
                ->first();

            if (empty($purchases) || null) {
                return back()->with('status', 'Cart is Empty');
            }

            
            $transaction = $purchases -> purchase_transaction_id;
            $dayClose = \DB::table('close_days')->first();

            $amount = empty(request('amount_paid')) ? 0 : request('amount_paid');

            $useVendor = PurchaseRecord::create([
                'user_id' => auth()->id(), 
                'station' =>auth()->user()->station,
                'date' => $dayClose->day_close,
                'vendor_name' => $purchases->purchase_vendor,
                'purchases_transaction_id' => $transaction,
                'purchase_date' => request('due_date'), 
                'purchase_pay_mode' => request('payment_mode'), 
                'purchase_amount' => $item->sum('purchase_total'), 
                'purchase_amount_paid' => $amount,
                'purchase_amount_balance' => \DB::raw('purchase_amount - ' . $amount),
                'purchase_due_date' => request('due_date'), 
                'purchase_pay_ref' => request('transaction_id'), 
                'purchase_pay_account' => request('payment_account'), 
                'purchase_pay_note' => request('payment_note'), 
                'purchase_note' => session()->get('purchase_note'),
                'purchase_type' => request('purchase_type'),
            ]);
         // Save or Update to stock Ledger during Comfirmation
         
         if (request('purchase_type') == "Purchase Invoice") {
 
        //  foreach ($item as $item) {
        //      $results = \DB::table('item_stock_ledgers')
        //      ->where('item_id' , $item->purchase_item_id)
        //      ->where('date', $item->purchase_date)
        //      ->where('station', $item->station)
        //      ->first();

        //     // update BOM Price
        //    $existingBOM = \DB::table('item_b_o_m_s')
        //    ->where('bom_id', $item->purchase_item_id)
        //    ->get();

        //      if ($results == null) {
        //          ItemStockLedger::create([
        //              'user_id' => auth()->user()->id,
        //              'item_name' => $item->purchase_item,
        //              'item_id' => $item->purchase_item_id,
        //              'item_unit' =>$item->purchase_unit,
        //              'item_purchases' => $item->purchase_quantity,
        //              'date' => $dayClose->day_close,
        //              'station' => $item->station,
        //              'item_cost' => $item->purchase_rate
        //          ]);
                
        //      }else {

        //     \DB::table('item_stock_ledgers')
        //                 ->where('item_id' , $item->purchase_item_id)
        //                 ->where('date', $dayClose->day_close)
        //                 ->where('station', auth()->user()->station)
        //                 ->update([
        //                     'user_id' => auth()->user()->id,
        //                     'item_purchases' => $results->item_purchases +  $item->purchase_quantity,
        //                     'item_cost' =>  ((((($results->item_opening_stock+$item->purchase_quantity+$results->item_recieved+$results->item_purchases+$results->item_manufacturing)-($results->item_sales+$results->item_issue+$results->item_wastage+$results->item_cons_manufacturing) ) * $results->item_cost) + ($item->purchase_quantity *  $item->purchase_rate)) / ( (($results->item_opening_stock+ $item->purchase_quantity+$results->item_recieved+$results->item_purchases+$results->item_manufacturing)-($results->item_sales+$results->item_issue+$results->item_wastage+$results->item_cons_manufacturing)) +  $item->purchase_quantity))
        //                     ]);
        //             }

        // //  search Again And Grab
          

        //     foreach ($existingBOM  as $key => $existingBOM) {
        //         $currentLg = \DB::table('item_stock_ledgers')
        //                     ->where('item_id' , $item->purchase_item_id)
        //                     ->where('date', $dayClose->day_close)
        //                     ->where('station', auth()->user()->station)
        //                     ->first();

        //         \DB::table('item_b_o_m_s')->where('bom_id', $item->purchase_item_id)
        //         ->update([
        //             'item_bom_unit_rate' => $currentLg->item_cost
        //         ]);
                

        //         // update Manufacturing Cost
        //         $estimated_cost = \DB::table('item_b_o_m_s')->where('item_id',$item->purchase_item_id)->pluck('item_bom_unit_rate')->sum();
                
        //         $checkManfactureBOM = \DB::table('manufacture_b_o_m_s')
        //             ->where('item_id', $item->purchase_item_id)->first();
        //         if ($checkManfactureBOM == null) {
        //             ManufactureBOM::Insert([
        //                 'item_id' => $item->purchase_item_id,
        //                 'estimated_cost' => 0
        //             ]);
        //         }else {
        //             \DB::table('manufacture_b_o_m_s')
        //             ->where('item_id',  $item->purchase_item_id)
        //             ->update([
        //                 'estimated_cost' => $estimated_cost
        //             ]);
        //         }



        //     }

        //  }
 
         

        $getVendorAccount = PurchaseRecord::where('id', $useVendor->id)->first();
        

        $purchaseAccount = \DB::table('accounts')->where('account_name', request('payment_account'))->first();
        if (!empty($account_payable) || null) {
            \App\Models\AccountTransaction::create([
                'user_id' => auth()->id(), 
                'account_code' => $purchaseAccount->account_code, 
                'account_id' => $purchaseAccount->id,
                'transaction_code' => session()->get('invoice_number'), 
                'date' => date('Y-m-d H:i:s', strtotime("$dayClose->day_close $time")), 
                'note' => "Invoice Number - ". $getVendorAccount->purchases_transaction_id,
                'description' =>  'Purchase Invoice - ' . "<a href=" . "/dashboard/purchases/" . $getVendorAccount->purchases_transaction_id . '/downloadandprint' . '>' . "View transaction" .'</a>',
                'credit' => $useVendor->purchase_amount,
                'added_by' => auth()->user()->name,
                'transaction_mode' => "Purchases"
            ]);
        }


        $p_vendor = \DB::table('accounts')->where('account_name',  $getVendorAccount->vendor_name)->first();
        
        if (!empty($p_vendor) || null) {
            \App\Models\AccountTransaction::create([
                'user_id' => auth()->id(), 
                'account_code' => $p_vendor->account_code, 
                'account_id' => $p_vendor->id,
                'transaction_code' => session()->get('invoice_number'), 
                'date' => date('Y-m-d H:i:s', strtotime("$dayClose->day_close $time")), 
                'note' => "Invoice Number - ". $getVendorAccount->purchases_transaction_id,
                'description' => 'Purchase Invoice - ' . "<a href=" . "/dashboard/purchases/" . $getVendorAccount->purchases_transaction_id . '/downloadandprint' . '>' . "View transaction" .'</a>',
                'credit' => $useVendor->purchase_amount,
                'added_by' => auth()->user()->name,
                'transaction_mode' => "Purchases" 
            ]);
        }
    }

        $complete = \DB::table('purchases')
         ->where('purchase_state', "P")
         ->where('user_id', auth()->user()->id)
         ->update([
             'purchase_state' => "C"
         ]);

         \App\Models\UserActivity::create([
                'changed_date' => \Carbon\carbon::now(),
                'user_id'=>auth()->id(),
                'event' => request('purchase_type') . " for " . $purchases->purchase_vendor . " for " . $useVendor->purchase_amount,
         ]);

        \DB::commit();
        session()->forget('purchase_note');


        
        return redirect()->to('/dashboard/purchase-invoice/' .$useVendor->purchases_transaction_id );
         
        } catch (\Throwable $th) {
            \DB::rollback();
            return response([
                'status' => 501,
                "Message" => $th
            ]);
        }

    }



    public function show($transaction)
    {
       // find Vendor
       $vfind = \DB::table('purchases')->where('purchase_transaction_id',$transaction)->first();
       $vendor = \DB::table('vendors')->where('vendor_name', $vfind->purchase_vendor)->first();
       // end find

       $buyer = User::findOrfail($vfind->user_id);
       $records = \DB::table('purchase_records')->where('purchases_transaction_id',$transaction)->first();


       $reciepts = \DB::table('purchases')->where('purchase_transaction_id', $transaction)->get();
       $sum_re =  $reciepts->sum('purchase_total');
       return view('view-purchase', [
           'reciept_goods' => $reciepts,
           'sum_re' => $sum_re,
           'vendor' => $vendor,
           'trans_data' => $vfind,
           'user'=> $buyer,
           'records' => $records
       ]);
    }



    public function downloadPrintPurchase($transaction)
    {
         // find Vendor
         $vfind = \DB::table('purchases')->where('purchase_transaction_id',$transaction)->first();
         $vendor = \DB::table('vendors')->where('vendor_name', $vfind->purchase_vendor)->first();
         // end find

         $buyer = User::findOrfail($vfind->user_id);
         $records = \DB::table('purchase_records')->where('purchases_transaction_id',$transaction)->first();
 
 
         $reciepts = \DB::table('purchases')->where('purchase_transaction_id', $transaction)->get();
         $sum_re =  $reciepts->sum('purchase_total');
         return view('view-purchase-print', [
             'reciept_goods' => $reciepts,
             'sum_re' => $sum_re,
             'vendor' => $vendor,
             'trans_data' => $vfind,
             'user'=> $buyer,
             'records' => $records
         ]);
    }



    public function showAll()
    {      
        $dayClose = \DB::table('close_days')->first();
        $lists = \DB::table('purchase_records')
            ->whereDate('date', $dayClose->day_close)
            ->where('station', auth()->user()->station)
            ->get();
        
        return view('purchase-list', [
            'lists'=>$lists
        ]);
    }


    public function PurchaseListDate(Request $request)
    {
        $value = explode(' - ', $request->date);
        
        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        if ($from == $to) {
                if ($request->vendor == "ALL VENDORS") {
                   
                    $lists = \DB::table('purchase_records')
                        ->whereDate('date', $from)
                        ->where('station', auth()->user()->station)
                        ->get();
                }else{
                        $lists = \DB::table('purchase_records')
                            ->whereDate('date', $from)
                            ->where('vendor_name', request('vendor'))
                            ->where('station', auth()->user()->station)
                            ->get();
                }

        }else{
            if ($request->vendor == "ALL VENDORS") {

                $lists = \DB::table('purchase_records')
                        ->WhereDate('purchase_date','>=', $from)
                        ->WhereDate('purchase_date','<=', $to)
                        ->where('station', auth()->user()->station)
                        ->get();
                }else{

                    $lists = \DB::table('purchase_records')
                        ->WhereDate('purchase_date','>=', $from)
                        ->WhereDate('purchase_date','<=', $to)
                        ->where('vendor_name', request('vendor'))
                        ->where('station', auth()->user()->station)
                        ->get();
                   
                }
                
        }

        return view('purchase-list', [
            'lists'=>$lists
        ]);
    }



    public function PurchaseListDateType(Request $request)
    {
        $this->validate(request(), [
            'start_date' => 'required',
            'end_date' => 'required'
        ]);

        $from = request('start_date');
        $to =   request('end_date');


    
                
                   
           $lists = \DB::table('purchase_records')
                ->where('purchase_type', request('purchase_type'))
                ->WhereDate('date','>=', $from)
                ->WhereDate('date','<=', $to)
                ->get();
               

        return view('purchase-list-type', [
            'lists'=>$lists
        ]);
    }


    public function PrintPurchasesType()
    {
        $this->validate(request(), [
            'start_date' => 'required',
            'end_date' => 'required'
        ]);

        $from = request('start_date');
        $to =   request('end_date');


    
                
                   
           $lists = \DB::table('purchase_records')
                ->where('purchase_type', request('purchase_type'))
                ->WhereDate('date','>=', $from)
                ->WhereDate('date','<=', $to)
                ->get();

                
               

        return view('purchase-list-type-print', [
            'lists'=>$lists,
            'total' => $lists->sum('purchase_amount')
        ]);
    }



    public function PurchaseExpiry()
    {
        $items = \DB::table('items')->pluck('id');

        $expiring = \DB::table('purchases')
        ->whereIn('purchase_item_id', $items)
        ->where('purchase_expiry', "!=" ,null)
        ->get();

        return view('expiring-purchase',[
            'expiring' => $expiring
        ]);
    }



    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Purchase  $purchase
     * @return \Illuminate\Http\Response
     */
    public function AdjustPurchase()
    {   
        $app = \DB::table('settings')->first();

        $dayClose = \DB::table('close_days')->first();
        


        $items = \DB::table('items')->get();
        
        return view('inventory.adjust-purchase-rate', [
            'rate'=> $items
        ]);
    }

    public function AdjustPurchaseSave(Request $request)
    {   
        $dayClose = \DB::table('close_days')->first();
        $app = \DB::table('settings')->first();

        $data = $request->all();
        
        if (array_key_exists('items', $data)) {
            foreach ($data['items'] as $key => $item) {

                $last_cost = \App\Models\AverageCost::Create([
                    'item_id' =>  $item['item_id'],
                    'date' => $dayClose->day_close,
                    'weighted_average' => $item['rate_amount']
                ]);

               if (empty($item['rate_amount']) || $item['rate_amount'] == null) {
                   continue;
               }


               $unit_measure = \DB::table('items')->where('id', $item['item_id'])->first();
                $all_items = \DB::table('manufacture_b_o_m_s')
                ->where('id', $item['item_id'])
                ->update([
                    'item_adjusted_price' => (float)$item['rate_amount'],
                    'item_unit' => $unit_measure->item_unit,
                    'estimated_cost' => \DB::raw('item_adjusted_price')
                ]);


                $inv_cost = \DB::table('item_b_o_m_s')
                ->where('bom_id', $item['item_id'])
                ->update(
                    ['item_bom_unit_rate' => \DB::raw('item_bom_unit * ' . $item['rate_amount'])
                    ]
                );
                

                \DB::table('material_product_compositons')
                ->where('composition_id', $item['item_id'])
                ->update([
                    'adjusted_cost' => \DB::raw('unit_measure * ' . (float)$item['rate_amount']),
                    'cost' => \DB::raw('adjusted_cost')
                ]);

                $manfacturing_product = \DB::table('items')->where('item_manufacturing', 1)->get();

                foreach ($manfacturing_product as $key => $manfacturing_product) {

                    $inv_cost_ = \DB::table('item_b_o_m_s')
                    ->where('item_id', $manfacturing_product->id)
                    ->sum('item_bom_unit_rate');


                    \DB::table('material_product_compositons')
                    ->where('composition_id', $manfacturing_product->id)
                    ->update([
                        'adjusted_cost' => \DB::raw('unit_measure * ' . $inv_cost_),
                        'cost' => \DB::raw('adjusted_cost')
                    ]);

                }

            }


            

        }


        



        return back()->with('status', 'Cost Adjusted Successfully');
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Purchase  $purchase
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Purchase $purchase)
    {
        //
    }


    public function clearPurchase()
    {
        $clear = \DB::table('purchases')
        ->where('purchase_state', "P")
        ->where('user_id', auth()->user()->id)
        ->delete();
        return back()->with('status', 'Transactions Cleared Successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Purchase  $purchase
     * @return \Illuminate\Http\Response
     */
    public function destroy(Purchase $purchase)
    {
        $purchase->delete();
        return 123;
    }
}
