<?php

namespace App\Http\Controllers;

use App\Models\SatelliteRequisition;
use Illuminate\Http\Request;
use Carbon\Carbon;
use App\Models\InventoryReport;
use App\Models\IssueVoucher;
use App\Models\IssueList;
use App\Models\RequestList;
use Session;

class SatelliteRequisitionController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {   
        $this->validate($request, [
            'r_store' => 'required',
            'r_quantity' => 'required'
        ]);
        
        $item_unit = \DB::table('items')->where('id', explode(" - ",$request -> r_item)[1])->first();
        $id = explode(" - ",$request -> r_item)[1];
        

        $cart = session()->get('requisition', []);
        if(isset($cart[$id])) {
            abort(403, "Item Added");
        } else {
            $cart[$id] = [
                'id' => $id,
                'user_id' => auth()->user()->id,
                'station' => auth()->user()->station,
                'r_note' => $request -> r_note,
                'r_category' => $item_unit->item_category ,
                'r_item' => explode(" - ", $request -> r_item)[0],
                'r_item_id' => explode(" - ", $request -> r_item)[1],
                'r_quantity' => $request -> r_quantity,
                'authorize_qty' => $request -> r_quantity,
                'r_unit' => $request -> r_unit == null ? $item_unit->item_unit : $request -> r_unit,
                'r_state' => "P" 
                ];
        }
          
        session()->put('requisition', $cart);
        return response([
            'Status' => 1000,
            'Message' => "success"
        ]);
    }

    public function makeChanges($transaction)
    {

        // first Remove Existing Transaction
        $deleExisting = \DB::table('satellite_requisitions')
        ->where('r_state', "P")
        ->where('user_id', auth()->user()->id)
        ->delete();

        // Then Update and Make Changes
        $makechanges = \DB::table('satellite_requisitions')
        ->where('r_state', "C")
        ->where('user_id', auth()->user()->id)
        ->where('r_transaction_id', $transaction)
        ->update([
            'r_state' => "P"
        ]);

        \DB::table('request_lists')->where('transaction_number', $transaction)->delete();

        return redirect()->to('/dashboard/request/warehouse');
    }


    public function authorizeRequisition(Request $request)
    {
        $data = $request->all();
        $dayClose = \DB::table('close_days')->first();


        $checkVoucher = IssueList::where('transaction_no', "INDENT".request('transaction_number'))->first();
        if (!empty($checkVoucher)) {
            return back()->with('statuspass', 'Can\'t re-issue this voucher, voucher exist');
        }
        $app = \DB::table('settings')->first();
        try {
            // Perform DB Transaction
            \DB::beginTransaction();
        if (array_key_exists('items', $data)) {
            foreach ($data['items'] as $key => $item) {

                
               // $balance_b_f =  \DB::table('item_stock_ledger_summaries')->where('station', auth()->user()->station)->where('item_id', $item['issue_item_id'])->whereDate('date', $item['issue_date'])->first();


                // $balance_b_f =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $item['issue_item_id'])->whereDate('date', '<', $item['issue_date'])->sum('stock_in') - 
                // \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $item['issue_item_id'])->whereDate('date', '<', $item['issue_date'])->sum('stock_out');

                
                // $stock_qty =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $item['issue_item_id'])
                //                             ->WhereDate('date', $item['issue_date'])
                //                             ->sum('stock_in') - \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $item['issue_item_id'])
                // ->WhereDate('date', $item['issue_date'])
                // ->sum('stock_out');


            // $closing = ($balance_b_f->stock_in - $balance_b_f->stock_out) + $balance_b_f->opening_stock;

            // if ($closing == 0 ) {
            //     $closing = 1;
            // }else {
            //     $closing = $closing;
            // }



            // $getAllCOst =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $item['issue_item_id'])->get();

            // if (empty($getAllCOst)) {
            //    $total_cost = 0;
            // }else {

            // $sumReCost = 0 ;
            // $sumIssueCost = 0 ;

            //     foreach ($getAllCOst as $key => $cost) {

            //         $sumIssueCost += round($cost->stock_out, 2) * round($cost->cost, 2);
            //         $sumReCost += round($cost->stock_in, 2) * round($cost->cost, 2);

            //     }

            //     $avg =  (round($sumReCost, 2) - round($sumIssueCost, 2)) / ($closing);
            //     $cost = $avg;

            // }

            $cost = \DB::table('average_costs')->where('item_id', $item['issue_item_id'])->orderBy('id', 'DESC')->first();

            if (empty($cost)) {
               $cost =  0;
            }else {
                $cost = $cost->weighted_average;
            }
               

                IssueVoucher::create([
                    'user_id' => auth()->user()->id,
                    'issue_item_id' => $item['issue_item_id'],
                    'station' => auth()->user()->station,
                    'issue_transaction_id' => "INDENT" . request('transaction_number'),
                    'issue_store' => $item['issue_recieved_station'],
                    'issue_date' =>  $item['issue_date'],
                    'issue_note' => $item['issue_note'],
                    'issue_category' => $item['issue_category'],
                    'issue_item' => $item['issue_item'],
                    'issue_quantity' => $item['issue_qty'],
                    'authorize_qty' => $item['issue_qty'],
                    'issue_rate' => $cost,
                    'issue_total_cost' => $cost*$item['issue_qty'],
                    'issue_unit' => $item['issue_unit'],
                    'issue_state' => "P" ,
                ]);

                $req = \DB::table('satellite_requisitions')
                ->where('id', $key)
                ->update([
                    'issue_qty' => $item['issue_qty'],
                    'r_status' => 1
                ]);



                \App\Models\StockTransaction::create([
                    'user_id' => auth()->id(),
                    'item_id' =>  $item['issue_item_id'],
                    'description' => 'Issues',
                    'note' => 'Transfer to ' . $item['issue_recieved_station']  . '<br>' . '<a href=' . '/dashboard/voucher/transaction/' . "INDENT".request('transaction_number') .'>' . "INDENT".request('transaction_number') .'</a>' ,
                    'unit' =>  $item['issue_unit'],
                    'station' => auth()->user()->station,
                    'date' => $item['issue_date'],
                    'stock_out' => $item['issue_qty'],
                    'cost' => $cost,
                    'transactions_id' => "INDENT".request('transaction_number')
            ]);

            }

            

        }

        $data = new IssueList;
        $data -> user_id = auth()->user()->id;
        $data -> transaction_no = "INDENT" . request('transaction_number');
        $data -> issue_date = request('date');
        $data -> issue_to = request('recieving_store');
        $data -> issue_from = auth()->user()->station;
        $data -> issue_status =  2;
        $data -> authorize_status =  2; 
        $data -> save();

        
        $complete = \DB::table('request_lists')
        ->where('transaction_number', request('transaction_number'))
        ->update([
            'status' => 1
        ]);

            \DB::commit();
            
            return redirect()->to('/dashboard/print-voucher-new/' . "INDENT" . request('transaction_number'));

            } catch (\Throwable $th) {
                \DB::rollback();
                return response([
                    'status' => 501,
                    "Message" => $th
                ]);
            } 

        
        // return back()->with('status', 'Item Authorized and Issued Successfully');
    }

    public function transfer_deduction()
    {
        $issuing = \DB::table('issue_vouchers')
        ->where('issue_state', "P")
        ->where('user_id', auth()->user()->id)
        ->get();


        foreach ($issuing as $key => $issue) {

            if (empty($issue) || null) {
                continue;
            }


        $exiting_new = \DB::table('item_stock_ledgers')
        ->where('item_id', $issue->issue_item_id)
        ->where('date', $issue->issue_date)
        ->where('station', auth()->user()->station)
        ->get();

        if (empty($exiting_new) || null) {
            continue;
        }

            foreach ($exiting_new as $key => $exiting_new) {
                $ledger = \DB::table('item_stock_ledgers')
                ->where('item_id' , $issue->issue_item_id)
                ->where('date',  $issue->issue_date)
                ->where('station', auth()->user()->station)
                ->update([
                    'user_id' => auth()->user()->id,
                    'item_issue' => \DB::raw('item_issue + ' . $issue->issue_quantity),
                ]);
            }
        }   
    }


    public function saveSatelliteRequestPrint()
    {   
        $requisition = session()->get('requisition');

        if (empty($requisition) || $requisition==null) {
            return back()->with('statuspass', "Cart is Empty, Please add Item to proceed");
        }

        foreach ($requisition as $key => $item) {
            SatelliteRequisition::create([
                'user_id' => auth()->user()->id,
                'station' => auth()->user()->station,
                'r_transaction_id'=> session()->get('transaction_number'),
                'r_store' => session()->get('request_from'),
                'r_date' =>  session()->get('date'),
                'r_note' => $item['r_note'],
                'r_category' => $item['r_category'],
                'r_item' => $item['r_item'],
                'r_item_id' => $item['r_item_id'],
                'r_quantity' => $item['r_quantity'],
                'authorize_qty' => $item['r_quantity'],
                'r_unit' => $item['r_unit'],
                'r_state' => "C" 
            ]);
        }

        $transaction = RequestList::create([
            'user_id'=>auth()->id(),
            'station' => auth()->user()->station,
            'date' => session()->get('date'),
            'transaction_number'=>session()->get('transaction_number'),
            'entered_by' => auth()->user()->name,
            'request_from' => session()->get('request_from'),
            'status' => 2,
            'comment' => session()->get('purchase_note')
        ]);
        
        session::forget('request_from');
        session::forget('date');
        session::forget('transaction_number');
        session::forget('requisition');
        session::forget('purchase_note');
        return redirect()->to('/dashboard/request/incoming/view-requisition/' . $transaction->transaction_number);
    }


    public function saveSatelliteRequest()
    {
        $requisition = session()->get('requisition');

        if (empty($requisition) || $requisition==null) {
            return back()->with('statuspass', "Cart is Empty, Please add Item to proceed");
        }

        foreach ($requisition as $key => $item) {
            SatelliteRequisition::create([
                'user_id' => auth()->user()->id,
                'station' => auth()->user()->station,
                'r_transaction_id'=> session()->get('transaction_number'),
                'r_store' => session()->get('request_from'),
                'r_date' =>  session()->get('date'),
                'r_note' => $item['r_note'],
                'r_category' => $item['r_category'],
                'r_item' => $item['r_item'],
                'r_item_id' => $item['r_item_id'],
                'r_quantity' => $item['r_quantity'],
                'authorize_qty' => $item['r_quantity'],
                'r_unit' => $item['r_unit'],
                'r_state' => "C" 
            ]);
        }

        $transaction = RequestList::create([
            'user_id'=>auth()->id(),
            'station' => auth()->user()->station,
            'date' => session()->get('date'),
            'transaction_number'=>session()->get('transaction_number'),
            'entered_by' => auth()->user()->name,
            'request_from' => session()->get('request_from'),
            'status' => 2,
        ]);
        
        session::forget('request_from');
        session::forget('date');
        session::forget('transaction_number');
        session::forget('requisition');
        return redirect('/dashboard')->with('status', 'Request Made Successfully');
    }



    public function deleteRequest($id)
    {
        $cart = session()->get('requisition');
        unset($cart[$id]);
        session()->put('requisition', $cart);
        return response([
            'status' => 200,
            'Message' => "Successfully Removed from Cart"
        ]);
    }
    
    public function destroy(SatelliteRequisition $satelliteRequisition)
    {
        session::forget('transaction_number');
        session::forget('date');
        session::forget('requisition');
        return back()->with('status', 'Transactions Cleared Successfully');
    }
}
