<?php

namespace App\Http\Controllers;

use App\Models\Setting;
use Illuminate\Http\Request;

class SettingController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    public function index()
    {   
        $app = \DB::table('settings')->first();
        return view('settings', [
            "app_info" => $app
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'app_name' => 'required',
            'app_receipt_footer' => 'required',
        ]);

        if($file = $request->hasFile('image')) {
            $file = $request->file('image') ;
            $fileName = $file->getClientOriginalName() ;
            $destinationPath = 'assets/img/' ;
            $file->move($destinationPath,$fileName);
            $document = ''.$fileName ;
         }else {
             $document = null;
         }

        $setting = new Setting;
        $setting -> app_name = $request->app_name;
        $setting -> app_website = $request -> app_website;
        $setting -> app_email = $request -> app_email;
        $setting -> app_description = $request -> app_description;
        $setting -> app_tin = $request -> app_tin;
        $setting -> currency = $request -> currency;
        $setting -> main_warehouse = $request -> station;
        $setting -> app_receipt_footer = $request -> app_receipt_footer;
        $setting -> app_logo = $document;
        $setting -> app_fav = $fav;
        $setting -> save();
        return back()->with('status', "Saved Successfully");
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Setting  $setting
     * @return \Illuminate\Http\Response
     */
    public function ChangeSTatus()
    {
        $check = \DB::table('settings')->first();
        if ($check->inventory_mgt ==  1) {
            \DB::table('settings')->update([
                'inventory_mgt' => 0
            ]);
        }else {
            \DB::table('settings')->update([
                'inventory_mgt' => 1
            ]);
        }
        return back()->with('status', "POS stock status changed successfully");
    }


    public function ChangeSTatusIssue()
    {
        $check = \DB::table('settings')->first();
        if ($check->issue_check ==  1) {
            \DB::table('settings')->update([
                'issue_check' => 0
            ]);
        }else {
            \DB::table('settings')->update([
                'issue_check' => 1
            ]);
        }
        return back()->with('status', "Issue checks status changed successfully");
    }


    public function ChangeSTatusProduction()
    {
        $check = \DB::table('settings')->first();
        if ($check->production_check ==  1) {
            \DB::table('settings')->update([
                'production_check' => 0
            ]);
        }else {
            \DB::table('settings')->update([
                'production_check' => 1
            ]);
        }
        return back()->with('status', "Production checks status changed successfully");
    }
    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Setting  $setting
     * @return \Illuminate\Http\Response
     */
    public function edit(Setting $setting)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Setting  $setting
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Setting $setting)
    {
        $this->validate($request, [
            'app_name' => 'required',
            'app_receipt_footer' => 'required',
        ]);

        if($file = $request->hasFile('image')) {
            $request->session()->put('file_rename', rand(100,1300));
            $file = $request->file('image') ;
            $fileName = "LOGO".session()->get('file_rename').$file->getClientOriginalName() ;
            $destinationPath = 'assets/img/' ;
            $file->move($destinationPath,$fileName);
            $document = ''.$fileName ;
         }else {
             $document = $setting->app_logo;
         }

         if($file = $request->hasFile('favicon')) {
            $request->session()->put('file_rename', rand(100,9000));
            $file = $request->file('favicon') ;
            $fileName = "fav".session()->get('file_rename') . $file->getClientOriginalName() ;
            $destinationPath = 'assets/img/' ;
            $file->move($destinationPath,$fileName);
            $fav = ''.$fileName ;
         }else {
             $fav = $setting->fav_icon;
         }

        //  /assets/img/

        $setting -> app_name = $request->app_name;
        $setting -> app_website = $request -> app_website;
        $setting -> app_email = $request -> app_email;
        $setting -> app_description = $request -> app_description;
        $setting -> main_warehouse = $request -> station;
        $setting -> currency = $request -> currency;
        $setting -> app_tin = $request -> app_tin;
        $setting -> app_receipt_footer = $request -> app_receipt_footer;
        $setting -> app_logo = $document;
        $setting -> fav_icon = $fav;
        $setting -> save();
        return back()->with('status', "updated Successfully");
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Setting  $setting
     * @return \Illuminate\Http\Response
     */
    public function destroy(Setting $setting)
    {
        //
    }
}
