<?php

namespace App\Http\Controllers;

use App\Models\Tax;
use Illuminate\Http\Request;

class TaxController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {   
        $this->validate($request, [
            'covid' => 'required',
            'nhil' => 'required',
            'getfund' => 'required',
            'vat' => 'required'
        ]);

       $data = Tax::all();
        if ($data == null) {
            $newData = new Tax;
            $newData->covid = $request -> covid/100;
            $newData->nhil = $request -> nhil/100;
            $newData->getfund = $request -> getfund/100;
            $newData->vat = $request -> vat/100;
            $newData->tourism = $request -> tourism/100;
            $newData->save();
        }else {
            \DB::table('taxes')->update([
                'covid' => $request-> covid/100,
                'nhil' => $request -> nhil/100,
                'getfund' => $request -> getfund/100,
                'vat' => $request -> vat/100,
                'tourism' => $request -> tourism/100,
            ]);
        }
        return back()->with('status', "Tax Components Created Successfully");

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Tax  $tax
     * @return \Illuminate\Http\Response
     */
    public function show(Tax $tax)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Tax  $tax
     * @return \Illuminate\Http\Response
     */
    public function edit(Tax $tax)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Tax  $tax
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Tax $tax)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Tax  $tax
     * @return \Illuminate\Http\Response
     */
    public function destroy(Tax $tax)
    {
        //
    }
}
