<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\Rules;
use App\Models\User;

class UserController extends Controller
{
    public function __contruct()
    {
        $this->middleware('auth');
    }


    public function index()
    {   
        if (auth()->user()->role == "Branch Officer") {
            abort(403, "UNAUTHORIZED USER");
         }
         $admin = User::where('role','Administrator')->get();
         $allusers = User::where('role','!=','Administrator')->get();
         return view('users', [
            'allusers' => $allusers,
            'admins'=> $admin
         ]);
    }

    public function edit(User $user)
    {
        // $this->authorize('viewAny', App\Models\User::class);
        if (auth()->user()->role == "Administrator") {
            
        $assigned_branches = \DB::table('user_multiple_branch')->where('user_id', $user->id)->first();
        return view('users-profile',[
        'userprofile' => $user,
        'assigned_branches' => empty($assigned_branches->branches) ? "NO BRANCH ASSIGNED" : $assigned_branches->branches
        ]);
        }else {
            abort(404);
        }
    }



    public function updateUserProfile(Request $request, User $user)
    {   

        $this->validate($request, [
            'name' => ['required', 'string', 'max:255'],
            'branch' => ['required', 'string', 'max:255'],
            'role' => ['required', 'string', 'max:255'],
            'sales_person_category' => ['required', 'string', 'max:255'],
        ]);

        $user->name = $request->name;
        $user->email = $request->email;
        $user->branch = $request->branch;
        $user->role = $request->role;
        $user->sales_person_category = $request->sales_person_category;
        $user->save();


        $multiple_branch = \DB::table('user_multiple_branch')->where('user_id', $user->id)->first();

        if (empty($multiple_branch)) {
            \DB::table('user_multiple_branch')->insert([
                'user_id' => $user->id,
                'branches' => implode( ",", $request->assigned)
            ]);
        }else {
            \DB::table('user_multiple_branch')->where('user_id', $user->id)->update([
                'user_id' => $user->id,
                'branches' =>implode( ",", $request->assigned)
            ]);
        }
        return back()->with('status', 'User Information Updated Successfully');
    }

    public function updateuser(User $user, Request $request)
    {
        $user->email = $request->useremail;
        $user->save();
        return back()->with('status', 'User Information Updated Successfully');
    }

    public function changePasswordUser(Request $request, User $user)
    {
        $this->validate($request, [
            'password' => ['required', 'string', 'min:8', 'confirmed'],
        ]);

        $user -> password = Hash::make($request -> password);
        $user -> save();
        return back()->with('status', 'Password Changed Successfully');

    }


    public function Newregister(Request $request)
    {
        $request->validate([
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
            'station' => ['required', 'string', 'max:255'],
            'role' => ['required', 'string', 'max:255'],
            'password' => ['required', 'confirmed', Rules\Password::defaults()],
        ]);

        $station = \DB::table('kitchens')->where('kitchen_name', $request->station)->first();
        $branch = \DB::table('branches')->where('branch_code', $station->kitchen_code)->first();

        if (!empty($station)) {

            $branch = \DB::table('branches')->where('branch_code', $station->kitchen_code)->first();

            $branch_name = empty($branch->branch_name) ? "" : $branch->branch_name;

        }else {
            $branch_name = "";
        }
        

        $user = User::create([
            'name' => $request->name,
            'email' => $request->email,
            'station' => $request->station,
            'branch' => $branch_name,
            'sales_person_category' => "Counter",
            'role' => $request->role,
            'password' => Hash::make($request->password),
        ]);

        return redirect()->route('editUser', $user->id);
    }


    public function destroy(User $user)
    {
        $user->delete();
        return 123;
    }

}
