<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Item extends Model
{
    use HasFactory;
    
    public function __construct()
    {
       
        session()->put('close_date', $this->getCloseDate());
        
    }
    
    public function getItems()
    
    {
         return $this->orderBy('item_name', 'ASC')->get(); 
    }

    private function getCloseDate()

    {

        return \DB::table('close_days')->first();

    }



    public function stock()

    {

        $dayClose = $this->getCloseDate();
        
        return $this->hasMany(StockTransaction::class, 'item_id', 'id')->whereDate('date', $dayClose->day_close);

    }



    public function stock_open_close()

    {
       
        $dayClose = $this->getCloseDate();

        return $this->hasMany(StockTransaction::class, 'item_id', 'id')->whereDate('date', '<', $dayClose->day_close);

    }
    
    


    public function filter_stock($start, $end)

    {

        return $this->hasMany(StockTransaction::class, 'item_id', 'id')->whereDate('date','>=', $start)->whereDate('date','<=', $end)->get();

    }

    
    public function filter_stock_open_close($start)

    {
    
        return $this->hasMany(StockTransaction::class, 'item_id', 'id')->whereDate('date', '<',$start)->get();

    }


}