<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Item;

class StockTransaction extends Model
{
    use HasFactory;


    protected $guarded = [];


    public function stockTransactionsBetween($start, $end)

    {
        return $this->where('station', auth()->user()->station)
                ->WhereDate('date','>=', $start)
                ->WhereDate('date','<=', $end)->get();
    }


    public function items()

    {

        return $this->belongsTo(Item::class, 'item_id', 'id');

    }

    // public function stock_in($item, $dayClose)

    // {

    //     return $this->where('station', auth()->user()->station)->
    //             where('item_id', $item->id)->
    //             whereDate('date', '<', $dayClose->day_close)->
    //             sum('stock_in');
    // }

}
