<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\Auth;
use Illuminate\Pagination\Paginator;
use View;
use DB;
use Blade;
use Carbon\Carbon;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        Paginator::useBootstrap();
        View::composer('*', function($view){

            $central_kitchen = \DB::table('kitchens')->where('kitchen_category', "C")->get();
            $view->with('central_kitchen', $central_kitchen);


            $all_branches = \DB::table('branches')->orderBy('branch_name', "ASC")->get();
            $view->with('all_branch', $all_branches->pluck('branch_name'));
            $view->with('all_branch_', $all_branches);


            $kitchens = \DB::table('kitchens')->orderBy('kitchen_name', 'ASC')->get();
            $view->with('kitchens', $kitchens);


            $warehouses = \DB::table('warehouses')->orderBy('warehouse_name', 'ASC')->get();
            $view->with('warehouses', $warehouses);


            $categories = \DB::table('categories')->get();
            $view->with('categories', $categories);

 

            $vendors = \DB::table('vendors')->get();
            $view->with('vendors', $vendors);


            // $accounts_created= \DB::table('accounts')->get();
            // $view->with('accounts_created', $accounts_created);

            

            $itemsVoucher = \DB::table('items')->where('transfer_status', 1)
            ->orderBy('item_name', 'ASC')
            ->get();
            $view->with('itemsVoucher', $itemsVoucher);


            
            $daycloses = \DB::table('day_close_records')->get();
            $view->with('daycloses', $daycloses);

            $mTaxes = \DB::table('taxes')->first();
            $view->with('mTaxes', $mTaxes);

            $currencies = \DB::table('currencies')->get();
            $view->with('currencies', $currencies);

            $app = \DB::table('settings')->first();
            $view->with('app', $app);
            

            $mTax = \DB::table('taxes')->first();
            $gTax = $mTax->covid+$mTax->nhil+$mTax->getfund+$mTax->tourism;
            $view->with('gTax', $gTax);
            $view->with('mTax', $mTax);



            $dayClose = \DB::table('close_days')->first();
            session()->put('close_date', $dayClose->day_close);
            
            $view->with('dayClose', $dayClose);
            //  Incoming Transfers
            if (Auth::check()) {

                $assigned_branches = \DB::table('user_multiple_branch')->where('user_id', auth()->id())->first();
                
                if (empty($assigned_branches-> branches)) {
                    $assigned_branches = [];
                }else {
                    $assigned_branches = explode(",", $assigned_branches-> branches);
                    $assigned_branches_code = \DB::table('branches')->whereIn('branch_name', $assigned_branches)->pluck('branch_code');
                    $assigned_branches = \DB::table('kitchens')->whereIn('kitchen_code', $assigned_branches_code)->pluck('kitchen_name');
                }

                $view->with('multi_branch', $assigned_branches);
                

                $transferCount = \DB::table('issue_lists')
                ->join('users', 'issue_lists.user_id','users.id')
                ->where('issue_lists.issue_to', auth()->user()->station)
                ->whereDate('issue_lists.issue_date', $dayClose->day_close)
                ->get();

                $view->with('transferCount', $transferCount);

                
               
                //
                // Getting Branch Code
                // $saleliite = \DB::table('kitchens')->where('kitchen_name', auth()->user()->station)->first();
                // if ($saleliite->kitchen_code == null) {
                //     return redirect()->to('dashboard');
                // }else{
                //     $branch = \DB::table('branches')->where('branch_code', $saleliite->kitchen_code)->first();
                //     }
                // $view->with('n_amount_other', \DB::table('cost_of_sale_analyses')->where('branch', $branch->branch_name)->whereDate('date', $dayClose->day_close)->sum('net_amount'));
                // $view->with('g_amount_other', \DB::table('cost_of_sale_analyses')->where('branch', $branch->branch)->whereDate('date', $dayClose->day_close)->sum('gross_amount'));
                // $view->with('costing_other', \DB::table('cost_of_sale_analyses')->where('branch', $branch->branch)->whereDate('date', $dayClose->day_close)->sum('cost'));
                    
            }


           



        

            $authorizeStatus = \DB::table('issue_lists')
                ->join('users', 'issue_lists.user_id','users.id')
                ->whereDate('issue_lists.issue_date', $dayClose->day_close)
                ->where('issue_lists.authorize_status', 2)
                ->get();


            $view->with('authorizeStatus', $authorizeStatus);

    
            // FETCH POS BRANCHES
            $branches = \DB::table('branches')->pluck('branch_name');
            $view->with('branches', $branches);


            $pizzaman_remark = ["SATISFIED","SALTY PIZZA","OILY PIZZA","LESS TOPPINGS","SPICY PIZZA","DRY
            PIZZA","SWEET AND SUGARY PIZZA","LESS CHEESE","TOO CHEESY","FLAT OR LIGHT PIZZA
            CRUST","SMALL SIZED PIZZA","INCONSISTENT TASTE","NO VEGGIES","COLD PIZZA","BURNT
            PIZZA","UNDERCOOKED","WRONG ORDER","LATE PROCESSING ORDER","OTHER"];

            $view->with('pizzaman_remark', $pizzaman_remark);

            $chickenman_remark = ["SATISFIED","HARD CHICKEN","UNCOOKED CHICKEN","SPICY CHICKEN","PEPPERY
            CHICKEN","SMALL RICE QUANTITY","GREEN CHILLI","SPOILT CHICKEN","SPOILT RICE","OILY
            RICE","COLD RICE","HARD RICE","SMALL CHICKEN","SALTY CHICKEN","SALTY RICE","SOFT
            CHICKEN","SOFT RICE","SLIMY RICE","COLD FRIES","SALTY FRIES","SOGGY FRIES","LATE
            PROCESSING ORDER","OTHER","UNDERCOOKED","WRONG ORDER"];

            $view->with('chickenman_remark', $chickenman_remark);


            $sumdebit = 0;
            $sumcredit = 0;
            $checkbalance = session()->get('balance');
                if (!empty($checkbalance) || null) {
                    foreach ($checkbalance as $item) {
                    $resultdebit = (float)$item['debit'];
                    $resultcredit = (float)$item['credit'];
                    $sumdebit+=$resultdebit;
                    $sumcredit+=$resultcredit;
                    }
                    $view->with('sumdebit', $sumdebit);
                    $view->with('sumcredit', $sumcredit);
                }

            Blade::directive('convert', function ($money) {
                return "<?php echo number_format($money, 2); ?>";
            });

        });
    }
}
