<!doctype html>
<html lang="en">
	
<head>
		<!-- Required meta tags -->
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

		<!-- Meta -->
		<meta name="description" content="Responsive Bootstrap4 Dashboard Template">
		<meta name="author" content="ParkerThemes">
		<link rel="shortcut icon" href="img/fav.png">

		<!-- Title -->
		<title>{{$app->app_name}} -{{@ucwords(@strtoupper($account_details->account_name))}} - General Ledger Report</title>

        <!-- Date Range CSS -->
        <link rel="stylesheet" href="{{asset('assets/vendor/daterange/daterange.css')}}">

                
        <!-- Uploader CSS -->
        <link rel="stylesheet" href="{{asset('assets/vendor/dropzone/dropzone.min.css')}}" />

        <!-- *************
            ************ Common Css Files *************
        ************ -->
        <!-- Bootstrap css -->
        <link rel="stylesheet" href="{{asset('assets/css/bootstrap.min.css')}}">

        <!-- Icomoon Font Icons css -->
        <link rel="stylesheet" href="{{asset('assets/fonts/style.css')}}">

        <!-- Main css -->
        <link rel="stylesheet" href="{{asset('assets/css/main.css')}}">

        <!-- fontAwesome -->
        <link href="{{asset('assets/fontawesome/css/all.css')}}" rel="stylesheet">


        <!-- Data Tables -->
        <link rel="stylesheet" href="{{asset('assets/vendor/datatables/dataTables.bs4.css')}}" />
        <link rel="stylesheet" href="{{asset('assets/vendor/datatables/dataTables.bs4-custom.css')}}" />
        <link href="{{asset('assets/vendor/datatables/buttons.bs.css')}}" rel="stylesheet" />

		<!-- Sweet Alert-->
		<link href="{{asset('assets/libs/sweetalert2/sweetalert2.min.css')}} " rel="stylesheet" type="text/css" />


        <script src="{{asset('assets/js/ajax.min.js')}}"></script>

        <!-- *************
            ************ Vendor Css Files *************
        ************ -->

        <!-- Bootstrap Select CSS -->
        <link rel="stylesheet" href="{{asset('assets/vendor/bs-select/bs-select.css')}}" />

        <!-- Mega Menu -->
        <link rel="stylesheet" href="{{asset('assets/vendor/megamenu/css/megamenu.css')}}">

        <!-- Search Filter JS -->
        <link rel="stylesheet" href="{{asset('assets/vendor/search-filter/search-filter.css')}}">
        <link rel="stylesheet" href="{{asset('assets/vendor/search-filter/custom-search-filter.css')}}">
	</head>

    <style>
         @media print {
                #back{
                    visibility: hidden;
                }
            }
    </style>

<body onload="window.print();">

<div class="card-body">
<div class="invoice-container">
    <div class="invoice-header">
        <!-- Row start -->
        <div class="row justify-content-between">
            <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-12">
            <a href="#" onclick="window.history.go(-1); return false" id="back" style="text-decoration:underline"><span class="badge bg-info">Return Back</span></a><br>
                <a href="#" class="logo">
                    <img src="/assets/img/{{$app->app_logo}}" alt="Logo" style="max-width:70px;">
                </a>
            </div>
            <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-12">
                <address class="text-right">
                    Printed by: {{auth()->user()->name}} <br>
                    Printed Date:  <?=@strtoupper(date('Y-m-d h:i:s a')) ?><br>
                </address>
            </div>
        </div>
        <!-- Row end -->
    </div>

   
    <!-- Row start -->
    <div class="row gutters">
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            <div class="invoice-details">
                                <address class="m-0">
                                <h5><strong style="font-weight:400">{{@strtoupper("GENERAL LEDGER")}}</strong><br></h5>

                                <div class="table-responsive">
											<table class="table table-sm">
												<tbody>
													<tr>
														<td><strong style="font-weight:600">Account Name</strong></td>
														<td>{{@ucwords(@strtolower($account_details->account_name))}}</td>
													</tr>
                                                
													<tr>
														<td><strong style="font-weight:600">Balance</strong></td>
                                                        <td>
                                                        {{empty($app->currency) ? "GHS" : $app->currency}}@convert(($transactions_db->sum('debit') + $balance_b_f_) - $transactions_db->sum('credit'))
                                                        </td>
													</tr>
												</tbody>
											</table>
                                        </div>
                                    </address>

                                <div class="invoice-num">
                                    <div>Report for the period from</div>
                                    <div>{{empty(request('start_date')) ? $dayClose->day_close : request('start_date') . "/" . request('end_date')}}</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Row end -->

    <div class="table-responsive">
    <div class="table-container light-blue">
									<table class="table v-middle m-0">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Date</th>
                                            <th>Narration</th>
                                            <th>Note</th>
                                            <th>Increase <br>{{empty($app->currency) ? "GHS" : $app->currency}}</th>
                                            <th>Decrease <br>{{empty($app->currency) ? "GHS" : $app->currency}}</th>
                                            <th>Balance <br>{{empty($app->currency) ? "GHS" : $app->currency}}</th>
                                           
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @if($balance_b_f_ !== 0)
                                        <tr>
                                            <td></td>
                                            <td>Balance B/F</td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td>
                                            @if($balance_b_f_ < 0)
                                            <strong style="font-weight:700">@convert(abs($balance_b_f_)) CR</strong>
                                            @else
                                            <strong style="font-weight:700">@convert(abs($balance_b_f_)) DR</strong>
                                            @endif
                                            </td>
                                            <td></td>
                                        </tr>
                                        @endif
                                        @foreach($transactions_db->chunk(100) as $rows)
                                        @foreach($rows as $transactions)
                                        @if(empty($transactions->debit) && empty($transactions->credit))
                                            @continue
                                        @endif
                                        <tr>
                                        <td>{{$transactions->id}}</td> 
                                            <td>
                                            <?php 
                                                $date = \Carbon\Carbon::parse($transactions->date, 'UTC');
                                            ?>
                                                {!!$date->isoFormat('Do MMM YYYY, h:mm:ss a')!!}

                                            </td>
                                            <td>{!!@ucwords(@strtolower($transactions->description))!!}</td>
                                            <td>{{@ucwords(@strtolower($transactions->note))}}</td>
                                            
                                            <td>
                                            @if(!empty($transactions->debit) || null)
                                                @convert($transactions->debit)
                                            @endif
                                            </td>
                                            <td>
                                                @if(!empty($transactions->credit) || null)
                                                @convert($transactions->credit)
                                                @endif
                                            </td>
                                            <td>
                                                
                                                <?php
                                                
                                                    $ac_ids = \DB::table('account_transactions')->where('account_id', $account_id)
                                                    ->WhereDate('date','>=', $from)
                                                    ->WhereDate('date','<=', $to)
                                                    ->where('id', '<=', $transactions->id)
                                                    ->pluck('id');

                                                    $debit = \DB::table('account_transactions')->where('account_id', $account_id)
                                                    ->whereIn('id', $ac_ids)
                                                    ->sum('debit');

                                                    $credit = \DB::table('account_transactions')->where('account_id', $account_id)
                                                    ->whereIn('id', $ac_ids)
                                                    ->sum('credit');
                                                ?>
                                                @if(!empty($transactions->debit) || null)
                                                <?php $tra_balance = (($debit+$balance_b_f_)-$credit)
                                                    ?>
                                                    @if($tra_balance < 0)
                                                        <span class="text-danger">@convert(abs($tra_balance)) CR</span>
                                                    @else
                                                         @convert($tra_balance) DR
                                                    @endif
                                                @else
                                                <?php $tra_balance = (($debit+$balance_b_f_)-$credit) ?>
                                                    @if($tra_balance < 0)
                                                        <span class="text-danger">@convert(abs($tra_balance)) CR</span>
                                                    @else
                                                         @convert($tra_balance) DB
                                                    @endif

                                                @endif
                                                 
                                            </td>
                                           
                                        </tr>
                                        @endforeach
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>

</div>
</div>
</div>
</div>



		<!-- *************
			************ Required JavaScript Files *************
		************* -->
		<!-- Required jQuery first, then Bootstrap Bundle JS -->
		<script src="{{asset('assets/js/jquery.min.js')}}"></script>
		<script src="{{asset('assets/js/bootstrap.bundle.min.js')}}"></script>
		<script src="{{asset('assets/js/modernizr.js')}}"></script>
		<script src="{{asset('assets/js/moment.js')}}"></script>

		<!-- *************
			************ Vendor Js Files *************
		************* -->

		<!-- Sweet Alerts js -->
		<script src="{{asset('assets/libs/sweetalert2/sweetalert2.min.js')}}"></script>
		
		<!-- Megamenu JS -->
		<script src="{{asset('assets/vendor/megamenu/js/megamenu.js')}}"></script>
		<script src="{{asset('assets/vendor/megamenu/js/custom.js')}}"></script>

		<!-- Slimscroll JS -->
		<script src="{{asset('assets/vendor/slimscroll/slimscroll.min.js')}}"></script>
		<script src="{{asset('assets/vendor/slimscroll/custom-scrollbar.js')}}"></script>

		<!-- Search Filter JS -->
		<script src="{{asset('assets/vendor/search-filter/search-filter.js')}}"></script>
		<script src="{{asset('assets/vendor/search-filter/custom-search-filter.js')}}"></script>

		<!-- Apex Charts -->
		<script src="{{asset('assets/vendor/apex/apexcharts.min.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/salesGraph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/ordersGraph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/earningsGraph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/visitorsGraph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/customersGraph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/sparkline.js')}}"></script>

		<!-- Circleful Charts -->
		<script src="{{asset('assets/vendor/circliful/circliful.min.js')}}"></script>
		<script src="{{asset('assets/vendor/circliful/circliful.custom.js')}}"></script>


		<!-- Bootstrap Select JS -->
		<script src="{{asset('assets/vendor/bs-select/bs-select.min.js')}}"></script>
		<script src="{{asset('assets/vendor/bs-select/bs-select-custom.js')}}"></script>


		<!-- Data Tables -->
		<script src="{{asset('assets/vendor/datatables/dataTables.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/dataTables.bootstrap.min.js')}}"></script>
		
		<!-- Custom Data tables -->
		<script src="{{asset('assets/vendor/datatables/custom/custom-datatables.js')}}"></script>

		<!-- Download / CSV / Copy / Print -->
		<script src="{{asset('assets/vendor/datatables/buttons.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/jszip.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/pdfmake.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/vfs_fonts.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/html5.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/buttons.print.min.js')}}"></script>

		<!-- Dropzone JS -->
		<script src="{{asset('assets/vendor/dropzone/dropzone.min.js')}}"></script>

		<!-- Date Range JS -->
		<script src="{{asset('assets/vendor/daterange/daterange.js')}}"></script>
		<script src="{{asset('assets/vendor/daterange/custom-daterange.js')}}"></script>

		<!-- Main Js Required -->
		<script src="{{asset('assets/js/main.js')}}"></script>

	</body>

</html>
