@extends('layouts.fullscreen')

@section('content')
<!-- Content wrapper start -->
<div class="content-wrapper">

<!-- Row start -->
<div class="row gutters">
    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

        <!-- Card start -->
        <div class="card">
            <div class="card-header-lg">
                <h4>Account Book & History</h4>

                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">

                <form action="{{route('AccountFilterPrint')}}" id="print-stock" method="get">
                    <input type="text" name="account_id" value="{{$account_details->id}}" hidden>
                    <input type="date" class="form-control" value="{{empty(request('start_date')) ? $dayClose->day_close   :  request('start_date')}}" hidden name="start_date">
                    <input type="date" class="form-control" value="{{empty(request('end_date')) ? $dayClose->day_close   :  request('end_date')}}" hidden name="end_date">
                </form>
                
                    

                     <form action="{{route('AccountFilter')}}" method="get">

                     <input type="text" name="account_number" value="{{$account_details->account_number}}" hidden>
                        <div class="d-flex justify-content-end">
                            <!-- Field wrapper start -->
                            <div class="field-wrapper m-0">
                                <div class="input-group">
                                <button class="btn btn-outline-info" style="margin-right:10px" type="button" onclick="PrintAccount()"><i class="icon-printer"></i>Print</button>
                                <div style="margin-right:10px"><small>From</small></div>
                                <input type="date" class="form-control" name="start_date" max="{{$dayClose->day_close}}">
                                <div style="margin-right:10px; margin-left:10px"><small>to</small></div>
                                <input type="date" class="form-control" name="end_date" max="{{$dayClose->day_close}}">
                                    <span class="input-group-text">
                                    <i class="icon-calendar1"></i>
                                    </span>
                                    <button class="btn btn-info"><i class="icon-download1"></i> Report</button>
                                </div>
                            </div>
                            <!-- Field wrapper end -->
                        </div>
                    </form>
                </div>

            </div>
            <div class="card-body">

                <div class="invoice-container">


                    <!-- Row start -->
                    <div class="row gutters">
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            <div class="invoice-details">
                                <address class="m-0">
                                <div class="table-responsive">
											<table class="table table-sm">
												<tbody>
													<tr>
														<td><strong style="font-weight:600">Account Name</strong></td>
														<td>{{@ucwords(@strtolower($account_details->account_name))}}</td>
													</tr>
													<tr>
														<td><strong style="font-weight:600">Account Type</strong></td>
														<td>{{@ucwords(@strtolower($account_details->account_type))}}</td>
													</tr>
													<tr>
														<td><strong style="font-weight:600">Account Number</strong></td>
														<td>{{$account_details->account_number}}</td>
													</tr>
													<tr>
														<td><strong style="font-weight:600">Balance</strong></td>
                                                        <td>
                                                        {{empty($app->currency) ? "GHS" : $app->currency}}@convert(($transactions_db->sum('debit') + $balance_b_f_) - $transactions_db->sum('credit'))
                                                        </td>
													</tr>
												</tbody>
											</table>
                                        </div>
                                    </address>

                                <div class="invoice-num">
                                    <div>{{empty(request('start_date')) ? $dayClose->day_close : request('start_date') . "/" . request('end_date')}}</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Row end -->

                    <!-- Row start -->
                    <div class="row gutters">
                        <div class="col-12">
                            
                            <div class="table-responsive">
                            <table id="copy-print-csv" class="table custom-table">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Date</th>
                                            <th>Narration</th>
                                            <th>Note</th>
                                            <th>Added by</th>
                                            <th>Increase <br>{{empty($app->currency) ? "GHS" : $app->currency}}</th>
                                            <th>Decrease <br>{{empty($app->currency) ? "GHS" : $app->currency}}</th>
                                            <th>Balance <br>{{empty($app->currency) ? "GHS" : $app->currency}}</th>
                                          
                                            <th>Action</th>
                                            
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @if($balance_b_f_ !== 0)
                                        <tr>
                                            <td></td>
                                            <td></td>
                                            <td>Balance B/F</td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td>@if($balance_b_f_ < 0)
                                            <strong style="font-weight:700">@convert(abs($balance_b_f_)) CR</strong>
                                            @else
                                            <strong style="font-weight:700">@convert(abs($balance_b_f_)) DB</strong>
                                            @endif</td>
                                            <td></td>
                                        </tr>
                                        @endif
                                        @foreach($transactions_db->chunk(100) as $rows)
                                        @foreach($rows as $transactions)
                                        @if(empty($transactions->debit) && empty($transactions->credit))
                                            @continue
                                        @endif
                                        <tr>
                                        <td>{{$transactions->id}}</td> 
                                            <td>
                                            <?php 
                                                $date = \Carbon\Carbon::parse($transactions->date, 'UTC');
                                            ?>
                                                {!!$date->isoFormat('Do MMM YYYY, h:mm:ss a')!!}

                                            </td>
                                            <td>{!!@ucwords(@strtolower($transactions->description))!!}</td>
                                            <td>{{@ucwords(@strtolower($transactions->note))}}</td>
                                            <td>
                                                {{@ucwords(@strtolower($transactions->added_by))}}
                                            </td>
                                            <td>
                                            @if(!empty($transactions->debit) || null)
                                                @convert($transactions->debit)
                                            @endif
                                            </td>
                                            <td>
                                                @if(!empty($transactions->credit) || null)
                                                @convert($transactions->credit)
                                                @endif
                                            </td>
                                            <td>
                                                
                                                <?php
                                                
                                                    $ac_ids = \DB::table('account_transactions')->where('account_id', $account_id)
                                                    ->WhereDate('date','>=', $from)
                                                    ->WhereDate('date','<=', $to)
                                                    ->where('id', '<=', $transactions->id)
                                                    ->pluck('id');

                                                    $debit = \DB::table('account_transactions')->where('account_id', $account_id)
                                                    ->whereIn('id', $ac_ids)
                                                    ->sum('debit');

                                                    $credit = \DB::table('account_transactions')->where('account_id', $account_id)
                                                    ->whereIn('id', $ac_ids)
                                                    ->sum('credit');
                                                ?>
                                                @if(!empty($transactions->debit) || null)
                                                <?php $tra_balance = (($debit+$balance_b_f_)-$credit)
                                                    ?>
                                                    @if($tra_balance < 0)
                                                        <span class="text-danger">@convert(abs($tra_balance))</span>
                                                    @else
                                                         @convert($tra_balance)
                                                    @endif
                                                @else
                                                <?php $tra_balance = (($debit+$balance_b_f_)-$credit) ?>
                                                    @if($tra_balance < 0)
                                                        <span class="text-danger">@convert(abs($tra_balance))</span>
                                                    @else
                                                         @convert($tra_balance) 
                                                    @endif

                                                @endif
                                                 
                                            </td>
                                           
                                            <td> 
                                                @if($transactions->description !== "Opening Balance")
                                                @if(auth()->user()->role == "Administrator")

                                                <div class="td-actions">
                                                    <a href="#" class="icon red" data-bs-toggle="tooltip" data-bs-placement="top" title="Remove Transaction" id="{{$transactions->id}}" onclick="DeleteAccount(this.id)" data-bs-original-title="Delete Row">
                                                        <i class="icon-cancel"></i>
                                                    </a>
                                                </div>
                                               
                                                @else
                                                
                                                <a href="#" data-toggle="tooltip" data-placement="top" title="Default Account" data-original-title="">
                                                    <i class="icon-lock1 text-light"></i>
                                                </a>
                                                
                                                
                                                @endif
                                                @endif
                                            </td>
                                            
                                        </tr>
                                        @endforeach
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                            
                        </div>
                    </div>
                    <!-- Row end -->

                    <!-- Row start -->
                    <!-- <div class="row gutters">

                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            <div class="text-start">
                                <button class="btn btn-info">Export</button>
                               <a href="{{route('printAccountBooks', $account_details->id)}}" class="btn btn-outline-primary ms-1"><i class="icon-print"></i> Print</a>
                            </div>
                        </div>

                    </div> -->
                    <!-- Row end -->
                
                </div>

            </div>
        </div>
        <!-- Card end -->

    </div>
</div>
						<!-- Row end -->


</div>

<script>
    function DeleteAccount(id) {
        Swal.fire({
            title: 'Are you sure?',
            text: "you are removing this transaction, you won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Remove !'
            }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = "/dashboard/account/transaction/delete/" + id;
            }
            })
    }


    function PrintAccount() {
        document.getElementById("print-stock").submit();
    }
</script>


@endsection