@extends('layouts.fullscreen')

@section('content')
<!-- Content wrapper start -->
<div class="content-wrapper">

    <!-- Row start -->
    <div class="row">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

            <!-- Card start -->
            <div class="card">
                <div class="card-body">

                    <div class="custom-tabs-container">
                        <ul class="nav nav-tabs" id="myTab" role="tablist">
                            <li class="nav-item" role="presentation">
                                <a class="nav-link active" id="first-tab" data-bs-toggle="tab" href="#first" role="tab" aria-controls="first" aria-selected="true">Sales</a>
                            </li>
                        </ul>
                        <div class="tab-content" id="myTabContent">
                            
                            <div class="tab-pane fade show active" id="first" role="tabpanel">

                            <div class="table-container light-blue">
									<table class="table v-middle m-0">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Date</th>
                                            <th>Sales Channel</th>
                                            <th>Total Sales <br><strong>{{empty($app->currency) ? GHS : $app->currency}}</strong></th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($all_invoice as $sales)
                                        <tr>
                                            <td>{{$loop->iteration}}</td>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    {{$dayClose->day_close}}
                                                </div>
                                            </td>
                                            <td>{{$sales->agency}}</td>
                                            <td>@convert($sales->invoice_total_price)</td>
                                            <td>
                                            <a href="#" data-bs-toggle="modal" data-bs-target="#salestransaction{{$loop->iteration}}" data-placement="top" title="Link to Account" data-original-title="Edit">
                                                <i class="icon-link2 text-danger"></i> Link to account
                                            </a>
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>

                            </div>
                           
                            
                        </div>
                    </div>

                    <div style="margin:15px">
                            <a href="#" onclick="confirmDayComplete()" class="btn btn-outline-info"><i class="icon-sun"></i> Open New Day</a>
                            </div>

                </div>
            </div>
            <!-- Card end -->

        </div>
    </div>
    <!-- Row end -->

    
</div>



@foreach($all_invoice as $sales)
<!--TRANSACTIONS TRANSFER Modal start -->
<div class="modal fade" id="salestransaction{{$loop->iteration}}" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLabel">Link Account: {{$sales->agency}}</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
        <!-- Card start -->
            <div class="card">
                    
                <div class="card-body">
                    <form action="{{route('linkSalesToAccount')}}" method="post" enctype="multipart/form-data">
                        @csrf

                    <input type="text" name="sales_channel" value="{{$sales->agency}}" hidden>
                    <!-- Row start -->
                    <div class="row gutters">

                <?php $transactions__ = \DB::table('accounts')->get(); ?>

                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            
                           <!-- Field wrapper start -->
                        <div class="field-wrapper">
                            <select class="select-single js-states" name="transfer_to" title="Select Product Category" data-live-search="true">
                                @foreach($transactions__ as $transaction)
                                <option value="{{$transaction->account_number}}">{{@ucwords(@strtolower($transaction->account_name))}}</option>
                                @endforeach
                            </select>
                            <div class="field-placeholder">Transfer to <span class="text-danger">*</span></div>
                        </div>
                        <!-- Field wrapper end -->

                        </div>

                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <input class="form-control" type="number" name="amount" value="{{$sales->invoice_total_price}}" readonly>
                                <div class="field-placeholder">Amount <span class="text-danger">*</span></div>
                            </div>
                            <!-- Field wrapper end -->

                        </div>
                       
                        
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            <button type="submit" class="btn btn-primary">Submit</button>
                        </div>
                    </div>
                    <!-- Row end -->
                    </form>
                </div>
            </div>
            <!-- Card end -->
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        </div>
        </div>
    </div>
</div>
<!-- Modal end -->
@endforeach


<script>
    function linkSales() {
        Swal.fire({
            title: 'Are you sure?',
            text: "You are about to link sales to account!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Link to Account!'
            }).then((result) => {
            if (result.isConfirmed) {
                window.location.href="/dashboard/account/link-sales-to-account"
            }
           })
    }



    
    function confirmDayComplete() {
            Swal.fire({
                title: 'Are you sure?',
                text: "Kindly Close Day for all outlets and Migrate transactions before you proceed to the next business day",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, complete Day Close!'
                }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = "{{route('CompletDayClose')}}";
                }
                })
            
        }
</script>



@endsection



