<!doctype html>
<html lang="en">
	
<head>
		<!-- Required meta tags -->
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

		<!-- Meta -->
		<meta name="description" content="Responsive Bootstrap4 Dashboard Template">
		<meta name="author" content="ParkerThemes">
		<link rel="shortcut icon" href="img/fav.png">

		<!-- Title -->
		<title>Statement of financial Position as on - {{request()->date == null ? $dayClose->day_close : request()->date}}</title>

        <!-- Date Range CSS -->
        <link rel="stylesheet" href="{{asset('assets/vendor/daterange/daterange.css')}}">

                
        <!-- Uploader CSS -->
        <link rel="stylesheet" href="{{asset('assets/vendor/dropzone/dropzone.min.css')}}" />

        <!-- *************
            ************ Common Css Files *************
        ************ -->
        <!-- Bootstrap css -->
        <link rel="stylesheet" href="{{asset('assets/css/bootstrap.min.css')}}">

        <!-- Icomoon Font Icons css -->
        <link rel="stylesheet" href="{{asset('assets/fonts/style.css')}}">

        <!-- Main css -->
        <link rel="stylesheet" href="{{asset('assets/css/main.css')}}">

        <!-- fontAwesome -->
        <link href="{{asset('assets/fontawesome/css/all.css')}}" rel="stylesheet">


        <!-- Data Tables -->
        <link rel="stylesheet" href="{{asset('assets/vendor/datatables/dataTables.bs4.css')}}" />
        <link rel="stylesheet" href="{{asset('assets/vendor/datatables/dataTables.bs4-custom.css')}}" />
        <link href="{{asset('assets/vendor/datatables/buttons.bs.css')}}" rel="stylesheet" />

		<!-- Sweet Alert-->
		<link href="{{asset('assets/libs/sweetalert2/sweetalert2.min.css')}} " rel="stylesheet" type="text/css" />


        <script src="{{asset('assets/js/ajax.min.js')}}"></script>

        <!-- *************
            ************ Vendor Css Files *************
        ************ -->

        <!-- Bootstrap Select CSS -->
        <link rel="stylesheet" href="{{asset('assets/vendor/bs-select/bs-select.css')}}" />

        <!-- Mega Menu -->
        <link rel="stylesheet" href="{{asset('assets/vendor/megamenu/css/megamenu.css')}}">

        <!-- Search Filter JS -->
        <link rel="stylesheet" href="{{asset('assets/vendor/search-filter/search-filter.css')}}">
        <link rel="stylesheet" href="{{asset('assets/vendor/search-filter/custom-search-filter.css')}}">
	</head>

    <style>
         @media print {
                #back{
                    visibility: hidden;
                }
            }
    </style>

<body onload="window.print();">

<div class="card-body">
<div class="invoice-container">
    <div class="invoice-header">
        <!-- Row start -->
        <div class="row justify-content-between">
            <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-12">
            <a href="#" onclick="window.history.go(-1); return false" id="back" style="text-decoration:underline"><span class="badge bg-info">Return Back</span></a><br>
                <a href="#" class="logo">
                    <img src="/assets/img/{{$app->app_logo}}" alt="logo" style="max-width:70px;">
                </a>
            </div>
            <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-12">
                <address class="text-right">
                    Printed by: {{auth()->user()->name}} <br>
                    Printed Date:  <?=@strtoupper(date('Y-m-d h:i:s a')) ?><br>
                </address>
            </div>
        </div>
        <!-- Row end -->
    </div>

    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            <div class="invoice-details">
                <address class="m-0" style="width:70%">
                    <strong>{{$app->app_name}}</strong>,<br>
                    Statement of financial position<br>
                </address>

                <div class="invoice-num">
                    <div>As on</div>
                    <div> {{request()->date == null ? $dayClose->day_close : request()->date}}</div>
                </div>
            </div>
        </div>
    </div>
    <!-- Row end -->


<div class="table-container light-blue">
		<table  class="table v-middle m-0">
        <thead>
        <tr>
            <th  colspan="2" style="font-size:15px"><center>ASSETS</center></th>
        </tr>
        <tr>
            <th><strong><h6>Current Assets</h6></strong></th>
            <th>{{empty($app->currency) ? "GHS" : $app->currency}}</th>
        </tr>
        </thead>
        <tbody>
        </tbody>
        @foreach($current_assets as $current_assets)
        <?php
                $balance_b_f =  \DB::table('account_transactions')->where('account_id', $current_assets->id)->whereDate('date', '<', $from)->OrderBy('id', 'DESC')->first();

                $ending_b_f =  \DB::table('account_transactions')->where('account_id', $current_assets->id)
                ->WhereDate('date','>=', $from)
                ->WhereDate('date','<=', $to)
                ->OrderBy('id', 'DESC')->first();


                $transactions_db = \DB::table('account_transactions')->where('account_id', $current_assets->id)
                ->WhereDate('date','>=', $from)
                ->WhereDate('date','<=', $to)
                ->get();

                $balance_b_f_ =  empty($balance_b_f) ? 0  : $balance_b_f->balance;

                $total_balance = ($transactions_db->sum('debit') + $balance_b_f_) - $transactions_db->sum('credit');

                ?>
        <tr>
            @if($total_balance == 0)
                @continue;
            @else
            <td>{{$current_assets->account_name}}</td>
            <td>@convert($total_balance)</td>
            @endif
        </tr>
        @endforeach
        <tr>
            <td><strong>Total Current Assets</strong></td>
            <td>
                
            </td>
        </tr>
        <tr>
            <td><strong class="text-primary"><h6>Non-Current Assets</h6></strong></td>
            <td></td>
        </tr>
        
        <tr>
        @foreach($non_current_assets as $non_current_assets)

        <?php
                $non_balance_b_f =  \DB::table('account_transactions')->where('account_id', $non_current_assets->id)->whereDate('date', '<', $from)->OrderBy('id', 'DESC')->first();

                $non_ending_b_f =  \DB::table('account_transactions')->where('account_id', $non_current_assets->id)
                ->WhereDate('date','>=', $from)
                ->WhereDate('date','<=', $to)
                ->OrderBy('id', 'DESC')->first();


                $non_transactions_db = \DB::table('account_transactions')->where('account_id', $non_current_assets->id)
                ->WhereDate('date','>=', $from)
                ->WhereDate('date','<=', $to)
                ->get();

                $non_balance_b_f_ =  empty($non_balance_b_f) ? 0  : $non_balance_b_f->balance;

                $non_total_balance = ($non_transactions_db->sum('debit') + $non_balance_b_f_) - $non_transactions_db->sum('credit');

                ?>

        <tr>
            @if($non_total_balance == 0)
                @continue;
            @else
            <td>{{$non_current_assets->account_name}}</td>
            <td>@convert($non_total_balance)</td>
            @endif
        </tr>
        <tr>
            <td><strong>Total Non-current Assets</strong></td>
            <td></td>
        </tr>
        <tr>
            <td><strong>Total Assets</h6></strong></td>
            <td><strong class="text-primary">68</strong></td>
        </tr>

        <tr>
            <th  colspan="2" style="font-size:15px"><center>LIABILITIES</center></th>
        </tr>

        
        <tr>
            <td><strong class="text-primary"><h6>Current Liabilities</h6></strong></td>
            <td></td>
        </tr>

        @foreach($current_liabilites as $cl_current_assets)

        <?php

        $cl_balance_b_f =  \DB::table('account_transactions')->where('account_id', $cl_current_assets->id)->whereDate('date', '<', $from)->OrderBy('id', 'DESC')->first();

        $cl_ending_b_f =  \DB::table('account_transactions')->where('account_id', $cl_current_assets->id)
        ->WhereDate('date','>=', $from)
        ->WhereDate('date','<=', $to)
        ->OrderBy('id', 'DESC')->first();


        $cl_transactions_db = \DB::table('account_transactions')->where('account_id', $cl_current_assets->id)
        ->WhereDate('date','>=', $from)
        ->WhereDate('date','<=', $to)
        ->get();

        $cl_balance_b_f_ =  empty($cl_balance_b_f) ? 0  : $cl_balance_b_f->balance;

        $cl_total_balance = ($cl_transactions_db->sum('debit') + $cl_balance_b_f_) - $cl_transactions_db->sum('credit');

        ?>

        <tr>
            @if($cl_total_balance == 0)
                @continue;
            @else
            <td>{{$cl_current_assets->account_name}}</td>
            <td>@convert($cl_total_balance)</td>
            @endif
        </tr>

        @endforeach
        <tr>
            <td><strong>Total Current Liabilities</h6></strong></td>
            <td><strong class="text-primary">68</strong></td>
        </tr>

        <tr>
            <td><strong class="text-primary"><h6>Non-Current Liabilities</h6></strong></td>
            <td></td>
        </tr>


        @foreach($non_current_liabilities as $non_cl_current_assets)

<?php
        $non_cl_balance_b_f =  \DB::table('account_transactions')->where('account_id', $non_cl_current_assets->id)->whereDate('date', '<', $from)->OrderBy('id', 'DESC')->first();

        $non_cl_ending_b_f =  \DB::table('account_transactions')->where('account_id', $non_cl_current_assets->id)
        ->WhereDate('date','>=', $from)
        ->WhereDate('date','<=', $to)
        ->OrderBy('id', 'DESC')->first();


        $non_cl_transactions_db = \DB::table('account_transactions')->where('account_id', $non_cl_current_assets->id)
        ->WhereDate('date','>=', $from)
        ->WhereDate('date','<=', $to)
        ->get();

        $non_cl_balance_b_f_ =  empty($non_cl_balance_b_f) ? 0  : $non_cl_balance_b_f->balance;

        $non_cl_total_balance = ($non_cl_transactions_db->sum('debit') + $non_cl_balance_b_f_) - $non_cl_transactions_db->sum('credit');

        ?>

        <tr>
            @if($non_cl_total_balance == 0)
                @continue;
            @else
            <td>{{$non_cl_current_assets->account_name}}</td>
            <td>@convert($non_cl_total_balance)</td>
            @endif
        </tr>
        @endforeach


        @endforeach
        </tr>
	</table>
    </div>
</div>
</div>
</div>



		<!-- *************
			************ Required JavaScript Files *************
		************* -->
		<!-- Required jQuery first, then Bootstrap Bundle JS -->
		<script src="{{asset('assets/js/jquery.min.js')}}"></script>
		<script src="{{asset('assets/js/bootstrap.bundle.min.js')}}"></script>
		<script src="{{asset('assets/js/modernizr.js')}}"></script>
		<script src="{{asset('assets/js/moment.js')}}"></script>

		<!-- *************
			************ Vendor Js Files *************
		************* -->

		<!-- Sweet Alerts js -->
		<script src="{{asset('assets/libs/sweetalert2/sweetalert2.min.js')}}"></script>
		
		<!-- Megamenu JS -->
		<script src="{{asset('assets/vendor/megamenu/js/megamenu.js')}}"></script>
		<script src="{{asset('assets/vendor/megamenu/js/custom.js')}}"></script>

		<!-- Slimscroll JS -->
		<script src="{{asset('assets/vendor/slimscroll/slimscroll.min.js')}}"></script>
		<script src="{{asset('assets/vendor/slimscroll/custom-scrollbar.js')}}"></script>

		<!-- Search Filter JS -->
		<script src="{{asset('assets/vendor/search-filter/search-filter.js')}}"></script>
		<script src="{{asset('assets/vendor/search-filter/custom-search-filter.js')}}"></script>

		<!-- Apex Charts -->
		<script src="{{asset('assets/vendor/apex/apexcharts.min.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/salesGraph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/ordersGraph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/earningsGraph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/visitorsGraph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/customersGraph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/sparkline.js')}}"></script>

		<!-- Circleful Charts -->
		<script src="{{asset('assets/vendor/circliful/circliful.min.js')}}"></script>
		<script src="{{asset('assets/vendor/circliful/circliful.custom.js')}}"></script>


		<!-- Bootstrap Select JS -->
		<script src="{{asset('assets/vendor/bs-select/bs-select.min.js')}}"></script>
		<script src="{{asset('assets/vendor/bs-select/bs-select-custom.js')}}"></script>


		<!-- Data Tables -->
		<script src="{{asset('assets/vendor/datatables/dataTables.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/dataTables.bootstrap.min.js')}}"></script>
		
		<!-- Custom Data tables -->
		<script src="{{asset('assets/vendor/datatables/custom/custom-datatables.js')}}"></script>

		<!-- Download / CSV / Copy / Print -->
		<script src="{{asset('assets/vendor/datatables/buttons.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/jszip.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/pdfmake.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/vfs_fonts.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/html5.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/buttons.print.min.js')}}"></script>

		<!-- Dropzone JS -->
		<script src="{{asset('assets/vendor/dropzone/dropzone.min.js')}}"></script>

		<!-- Date Range JS -->
		<script src="{{asset('assets/vendor/daterange/daterange.js')}}"></script>
		<script src="{{asset('assets/vendor/daterange/custom-daterange.js')}}"></script>

		<!-- Main Js Required -->
		<script src="{{asset('assets/js/main.js')}}"></script>

	</body>

</html>
