@extends('layouts.app')

@section('content')
<!-- Content wrapper start -->
<div class="content-wrapper">

<!-- Row start -->
<div class="row gutters">

<!-- Row start -->
<div class="row gutters">
    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
        <div class="stats-tile">
            <div class="sale-icon">
                <i class="icon-package"></i>
            </div>
            <div class="sale-details">
                <h2>@convert($total_exp)</h2>
                <p>Bills</p>
                <h5><span class="high"><i class="icon-trending-up"></i> </span> Expense made today</h5>
            </div>
        </div>
    </div>
    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
        <div class="stats-tile">
            <div class="sale-icon">
                <i class="icon-shopping-bag1"></i>
            </div>
            <div class="sale-details">
                <h2>@convert($orders = \DB::table('orders')->whereDate('created_at', $dayClose->day_close)->count())</h2>
                <p>Orders</p>
                <h5><span class="high"><i class="icon-trending-up"></i> 7.5%</span> since last week</h5>
            </div>
        </div>
    </div>
    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
        <div class="stats-tile">
            <div class="sale-icon">
                <i class="icon-briefcase"></i>
            </div>
            <div class="sale-details">
                <h2>@convert($sales = \DB::table('invoices')->where('invoice_category', '!=', "TRANSPORT")
                        ->where('invoice_status', 1)
                        ->whereDate('created_at', $dayClose->day_close)
                        ->sum('invoice_total_price') - $discount)
                    </h2>
                <p>Revenue</p>
                <h5><span class="low"><i class="icon-trending-down"></i> @convert($sales/($orders == 0 ? 1 : $orders))</span> Average Sales</h5>
            </div>
        </div>
    </div>							
</div>
<!-- Row end -->

<!-- Row start -->
<div class="row gutters">
    <div class="col-xl-8 col-lg-12 col-md-12 col-sm-12 col-12">
        <div class="card">
            <div class="card-header">
                <div class="card-title">Best selling outlets</div>
                <div class="graph-day-selection" role="group">
                    <button type="button" class="btn active">Today</button>
                </div>
            </div>
            <div class="card-body">
                    <div id="sales"></div>
                </div>
        </div>
    </div>
    <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col-12">
        <div class="card">
            <div class="card-header">
                <div class="card-title">Financial Statement</div>
            </div>
            <div class="card-body">
                <div class="">
                    <ul class="recent-orders">
                        <li>
                            <div class="order-details">
                                <p class="order-desc"><a href="#" data-bs-toggle="modal" class="text-primary" data-bs-target="#incomeStatement">Income Statement</a>
                                <!-- <span class="spinner-grow spinner-grow-sm text-danger" role="status">
										    <span class="badge bg-danger">
                                            Active</span>
                                    </span> -->
                                </p>
                            </div>
                        </li>
                        <li>
                            <div class="order-details">
                                <p class="order-desc"><a href="#" class="text-primary" data-bs-toggle="modal" data-bs-target="#balancesheet">Balance Sheet</a></p>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col-12">
        <div class="card h-320">
            <div class="card-header">
                <div class="card-title">Supplier</div>
            </div>
            <div class="card-body">
                <div class="todo-container">
                <ul class="statistics">
                        <li>
                            <div class="order-details">
                                <p class="order-desc"> <a href="#" class="text-primary"  data-bs-toggle="modal" data-bs-target="#purchasesInv">Purchase Invoice</a>
                               </p>
                            </div>
                        </li>
                        <li>
                            <div class="order-detail ">
                                <p class="order-desc"> <a href="#" class="text-primary"  data-bs-toggle="modal" data-bs-target="#purchasesOrder">Purchase Order</a>
                            </p>
                            </div>
                        </li>
                        <li>
                            <div class="order-details">
                                <p class="order-desc">  <a href="#" class="text-primary" class="text-primary"  data-bs-toggle="modal" data-bs-target="#purchasesQuote">Purchase Quote</a>
                              </p>
                            </div>
                        </li>
                        
                </ul>

                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col-12">
        <div class="card h-320">
            <div class="card-header">
                <div class="card-title">Tax and Bank Summary</div>
            </div>
            <div class="card-body">
                <ul class="statistics">
                        <li>
                            <div class="order-details">
                                <p class="order-desc"><a href="#" class="text-primary" data-bs-toggle="modal" data-bs-target="#Taxreport">Tax Summary</a></p>
                            </div>
                        </li>
                        <li>
                            <div class="order-details ">
                            <p class="order-desc"><a href="#" class="text-primary" data-bs-toggle="modal" data-bs-target="#BankAccount">
                                Bank Account Summary </a>

                                </p>
                            </div>
                        </li>
                </ul>
            </div>

            <div class="card-header">
                <div class="card-title">Bills</div>
            </div>
            <div class="card-body">
                <ul class="statistics">
                <li>
                            <div class="order-details">
                                <p class="order-desc"><a class="text-primary" href="#" data-bs-toggle="modal" data-bs-target="#bill">Bills Summary</a>
                               
                                </p>
                            </div>
                        </li>
                </ul>
            </div>
        </div>
    </div>
    <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col-12">
        <div class="card h-320">
            <div class="card-header">
                <div class="card-title">Sales Invoice</div>
            </div>
            <div class="card-body">

            <ul class="statistics">
            <li>
                            <div class="order-details">
                                <p class="order-desc  text-primary"><a href="{{route('salesReport')}}" class="text-primary" >Sales Report</a> </p>
                            </div>
                        </li>
                        <li>
                            <div class="order-details">
                                <p class="order-desc  text-primary"><a href="#" class="text-primary" data-bs-toggle="modal" data-bs-target="#CosofSales">Cost of Sales Analysis</a></p>
                            </div>
                        </li>
                        <li>
                            <div class="order-details ">
                                <p class="order-desc"><a href="#" class="text-primary" data-bs-toggle="modal" data-bs-target="#outletInvoice"> Invoice by Outlet</a>
  
                                </p>
                            </div>
                        </li>
                        <!-- <li>
                            <div class="order-details">
                                <p class="order-desc  text-primary">Total Invoice Totals by Customer</p>
                            </div>
                        </li> -->
                        <!-- <li>
                            <div class="order-details ">
                                <p class="order-desc  text-primary">Sales Invoice Total by Item</p>
                            </div>
                        </li> -->
                        <li>
                            <div class="order-details ">
                                <p class="order-desc"><a href="#" class="text-primary" data-bs-toggle="modal" data-bs-target="#salesPerson"> Cashier Report</a></p>
                            </div>
                        </li>
                        <li>
                            <div class="order-details ">
                                <p class="order-desc"><a href="#" class="text-primary"  data-bs-toggle="modal" data-bs-target="#exampleModalCenteredRevenue">Revenue Summary</a>
                              </p>
                            </div>
                        </li>
                        <li>
                            <div class="order-details ">
                                <p class="order-desc"><a href="#" class="text-primary" data-bs-toggle="modal" data-bs-target="#SaleProfit">Sales & Profit Summary</a>
                                 </p>
                            </div>
                        </li>
                        <!-- <li>
                            <div class="order-details ">
                                <p class="order-desc  text-primary">No Charge Report</p>
                            </div>
                        </li> -->
                </ul>

                </div>
            </div>
        </div>
    </div>

</div>
<!-- Row end -->

@include('modal.all-reports')
</div>


@endsection