@extends('layouts.fullscreen')

@section('content')
<!-- Content wrapper start -->
<div class="content-wrapper">

<!-- Row start -->
<div class="row gutters">
    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

        <!-- Card start -->
        <div class="card">
            <div class="card-header-lg">
                <h4>Cash Flow</h4>
            </div>


    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-4 col-lg-4 col-md-4 col-sm-6 col-12">
            <div class="stats-tile">
                <div class="sale-icon">
                    <i class="icon-corner-left-down"></i>
                </div>
                <div class="sale-details">
                    <h2>@convert($transactions->sum('debit'))</h2>
                    <p>Incoming</p>
                </div>
                <div class="sale-graph">
                    <div id="sparklineLine1"></div>
                </div>
            </div>
        </div>
        <div class="col-xl-4 col-lg-4 col-md-4 col-sm-6 col-12">
            <div class="stats-tile">
                <div class="sale-icon">
                    <i class="icon-corner-right-up"></i>
                </div>
                <div class="sale-details">
                    <h2>@convert($transfers->sum('credit'))</h2>
                    <p>Outgoing</p>
                </div>
                <div class="sale-graph">
                    <div id="sparklineLine2"></div>
                </div>
            </div>
        </div>
        <div class="col-xl-4 col-lg-4 col-md-4 col-sm-12 col-12">
            <div class="stats-tile">
                <div class="sale-icon">
                    <i class="icon-credit"></i>
                </div>
                <div class="sale-details">
                    <h2>@convert( $transactions->sum('debit') - $transfers->sum('credit'))</h2>
                    <p>Current Balance</p>
                </div>
                <div class="sale-graph">
                    <div id="sparklineLine3"></div>
                </div>
            </div>
        </div>
    </div>
    <!-- Row end -->
        
            <!-- Card start -->
    <div class="card">
        <div class="card-body">
            <div class="custom-tabs-container">
                <ul class="nav nav-tabs" id="myTab" role="tablist">
                    <li class="nav-item" role="presentation">
                        <a class="nav-link active" id="first-tab" data-bs-toggle="tab" href="#first" role="tab" aria-controls="first" aria-selected="true">Transactions</a>
                    </li>
                    <li class="nav-item" role="presentation">
                        <a class="nav-link" id="second-tab" data-bs-toggle="tab" href="#second" role="tab" aria-controls="second" aria-selected="false">Transfers</a>
                    </li>
                </ul>
                <div class="tab-content" id="myTabContent">
                    <div class="tab-pane fade show active" id="first" role="tabpanel">

                    <div class="table-responsive">
                    <table id="highlightRowColumn" class="table custom-table">
                                    <thead>
                                        <tr>
                                            <th>Date</th>
                                            <th>Account</th>
                                            <th>Description</th>
                                            <th>Amount</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($transactions as $transactions)
                                        <?php $account_ = \DB::table('accounts')->where('id', $transactions->account_id)->first() ?>
                                        <tr>
                                            <td>{{$transactions->date}}</td>
                                            <td>{{@strtoupper($account_->account_name)}}</td>
                                            <td>{!!@strtoupper($transactions->description)!!}</td>
                                            <td>
                                            @if(empty($transactions->credit) || null)
                                                {{empty($app->currency) ? "GHS" : $app->currency}}@convert($transactions->debit)
                                            @else
                                                ({{empty($app->currency) ? "GHS" : $app->currency}}@convert($transactions->credit))
                                            @endif
                                            </td>                     
                                        </tr>
                                        @endforeach
                                        
                                    </tbody>
                                </table>
                            </div>

                    </div>
                    <div class="tab-pane fade" id="second" role="tabpanel">
                        
                    <div class="table-responsive">
                            <table id="copy-print-csv" class="table custom-table">
                                    <thead>
                                        <tr>
                                            <th>Date</th>
                                            <th>Account</th>
                                            <th>Description</th>
                                            <th>Amount</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($transfers as $transactions)
                                        <?php $account_ = \DB::table('accounts')->where('id', $transactions->account_id)->first() ?>
                                        <tr>
                                            <td>{{$transactions->date}}</td>
                                            <td>{{@strtoupper($account_->account_name)}}</td>
                                            <td>{!!@strtoupper($transactions->description)!!}</td>
                                            <td>
                                            @if(empty($transactions->credit) || null)
                                                {{empty($app->currency) ? "GHS" : $app->currency}}@convert($transactions->debit)
                                            @else
                                                {{empty($app->currency) ? "GHS" : $app->currency}}@convert($transactions->credit)
                                            @endif
                                            </td>
                                        </tr>
                                        @endforeach
                                        
                                    </tbody>
                                </table>
                            </div>
                    </div>
                   
                </div>
            </div>
        </div>
    </div>

        
        
        </div>
        <!-- Card end -->

    </div>
</div>
						<!-- Row end -->


</div>
@endsection