@extends('layouts.fullscreen')

@section('content')
<!-- Content wrapper start -->
<div class="content-wrapper">

    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

            <!-- Card start -->
            <div class="card">
                <div class="card-header-lg">
                    <h4>Chart of Account</h4>
                </div>
                
            </div>


            <!-- Row start -->
						<div class="row gutters">
							<div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                     
                            <!-- Card start -->
                            <div class="card">
                                <div class="card-header">
                                    <div class="card-title">Balance Sheet</div>
                                   
                                </div>
                                <div class="card-body">
                                    
                                    <!-- Faq start -->
                                    <div class="accordion" id="faqAccordion">
                                        <div class="accordion-item">
                                            <h2 class="accordion-header" id="headingOne">
                                                <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapse10" aria-expanded="true" aria-controls="collapseOne">
                                                    Assets
                                                </button>
                                            </h2>
                                            <div id="collapse10" class="accordion-collapse collapse show" aria-labelledby="headingOne" data-bs-parent="#faqAccordion">
                                                <div class="accordion-body">
                                                <?php 
                                                $ca = \DB::table('control_accounts')->where('control_group', "Current Assets")->get();

                                                $current_ac = \DB::table('accounts')
                                                ->where('account_type',"Current Assets")
                                                ->orderBy('account_name', 'ASC')
                                                ->WhereNotIn('account_name', $ca->pluck('control_name'))
                                                ->where('control_account_id', Null)
                                                ->get();
                                                 ?>

                                                <div class="card-header-lg">
                                                                <h6>Current Assets</h6>
                                                            </div>

                                                        <ul class="list-group m-0">
                                                            <!-- GET CONTROL ACCOUNT AND SUB ACCOUNTS -->
                                                            @foreach($ca as $control)
                                                            <?php 
                                                                $getTransaction = \DB::table('accounts')->where('control_account_id', $control->id)->pluck('id');

                                                                $total_current = \DB::table('account_transactions')->whereIn('account_id', $getTransaction)->sum('debit') - \DB::table('account_transactions')->whereIn('account_id', $getTransaction)->sum('credit')

                                                             ?>
                                                            <li class="list-group-item d-flex justify-content-between align-items-center">{{@ucwords(@strtolower($control->control_name))}}
                                                            </li>
                                                            @endforeach
                                                        </ul>
                                                        <ul class="list-group m-0">
                                                            <!-- THESE ARE THE MAIN ACCOUNT WITHOUT ANY CONTROL ACCOUNT UNDER CURRENT ASSETS -->
                                                            @foreach($current_ac as $income_ac)
                                                            <li class="list-group-item d-flex justify-content-between align-items-center">{{@ucwords(@strtolower($income_ac->account_name))}}
                                                            <span>
                                                                <a href="{{route('AccountBooks', $income_ac->id)}}" style="text-decoration:underline" class="text-primary"  data-toggle="tooltip" title="Account Book"> 
                                                                </a>
                                                            </span>
                                                            </li>
                                                            @endforeach
                                                        </ul>

                                                        <?php 

                                                            $ca_non_c = \DB::table('control_accounts')->where('control_group', "Non-Current Assets")->get();

                                                            $non_current_ac = \DB::table('accounts')
                                                            ->where('account_type', "Non-current Assets")
                                                            ->orderBy('account_name', 'ASC')
                                                            ->WhereNotIn('account_name', $ca_non_c->pluck('control_name'))
                                                            ->where('control_account_id', Null)
                                                            ->get();
                                                    
                                                            
                                                         ?>
                                                        
                                                            <div class="card-header-lg">
                                                                <h6>Non-Current Assets</h6>
                                                            </div>
                                                            <ul class="list-group m-0">
                                                            @foreach($ca_non_c as $control_non)
                                                            <?php 
                                                                $getTransaction_non_current = \DB::table('accounts')->where('control_account_id', $control_non->id)->pluck('id');

                                                                $total_current_non_current = \DB::table('account_transactions')->whereIn('account_id', $getTransaction_non_current)->sum('debit') - \DB::table('account_transactions')->whereIn('account_id', $getTransaction_non_current)->sum('credit')

                                                             ?>
                                                                <li class="list-group-item d-flex justify-content-between align-items-center">{{@ucwords(@strtolower($control_non->control_name))}}
                                                                </li>
                                                                @endforeach
                                                            </ul>
                                                            <ul class="list-group m-0">
                                                                @foreach($non_current_ac as $income_ac)
                                                                <li class="list-group-item d-flex justify-content-between align-items-center">{{@ucwords(@strtolower($income_ac->account_name))}}<li>
                                                                
                                                                @endforeach
                                                            </ul>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="accordion-item">
                                            <h2 class="accordion-header" id="headingTwo">
                                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse11" aria-expanded="false" aria-controls="collapseTwo">
                                                    Liabilities
                                                </button>
                                            </h2>
                                            <div id="collapse11" class="accordion-collapse collapse show" aria-labelledby="headingTwo" data-bs-parent="#faqAccordion">
                                                <div class="accordion-body">

                                                <?php 

                                                            $ca_liabilties_current = \DB::table('control_accounts')->where('control_group', "Current Liabilities")->get();
                                                         
                                                            $liabilties_current = \DB::table('accounts')
                                                            ->where('account_type', "Current Liabilities")
                                                            ->orderBy('account_name', 'ASC')
                                                            ->WhereNotIn('account_name', $ca_liabilties_current->pluck('control_name'))
                                                            ->where('control_account_id', Null)
                                                            ->get();
                                                            
                                                         ?>
                                                         <div class="card-header-lg">
                                                                <h6>Current Liabilities</h6>
                                                            </div>
                                                        <ul class="list-group m-0">
                                                            @foreach($ca_liabilties_current as $ca_liabilties_currents)

                                                            <?php 
                                                                $getTransaction_cuurent_liabilities = \DB::table('accounts')->where('control_account_id', $ca_liabilties_currents->id)->pluck('id');

                                                                $total_current_non_current = \DB::table('account_transactions')->whereIn('account_id', $getTransaction_cuurent_liabilities)->sum('debit') - \DB::table('account_transactions')->whereIn('account_id', $getTransaction_cuurent_liabilities)->sum('credit')

                                                             ?>
                                                                <li class="list-group-item d-flex justify-content-between align-items-center">{{@ucwords(@strtolower($ca_liabilties_currents->control_name))}}
                                                                </li>
                                                            @endforeach
                                                        </ul>
                                                          <ul class="list-group m-0">
                                                            @foreach($liabilties_current as $income_ac)
                                                            <li class="list-group-item d-flex justify-content-between align-items-center">{{@ucwords(@strtolower($income_ac->account_name))}}<li>
                                                         
                                                            @endforeach
                                                        </ul>

                                                        <?php 
                                                        
                                                            $Non_Current_Liabilities = \DB::table('control_accounts')->where('control_group', "Non-current Liabilities")->get(); 
                                                         
                                                            $nonliabilties_current = \DB::table('accounts')
                                                            ->where('account_type', "Non-current Liabilities")
                                                            ->orderBy('account_name', 'ASC')
                                                            ->WhereNotIn('account_name', $Non_Current_Liabilities->pluck('control_name'))
                                                            ->where('control_account_id', Null)
                                                            ->get();
                                                        ?>
                         
                                                            <div class="card-header-lg">
                                                                <h6>Non-Current Liabilities</h6>
                                                            </div>

                                                            <ul class="list-group m-0">
                                                                @foreach($Non_Current_Liabilities as $nonliabilties_currents_)

                                                                <?php 
                                                                    $getTransaction_Non_Current_liabilities = \DB::table('accounts')->where('control_account_id', $nonliabilties_currents_->id)->pluck('id');

                                                                    $total_current_non_current_liabilities = \DB::table('account_transactions')->whereIn('account_id', $getTransaction_Non_Current_liabilities)->sum('debit') - \DB::table('account_transactions')->whereIn('account_id', $getTransaction_Non_Current_liabilities)->sum('credit')

                                                                ?>
                                                                    <li class="list-group-item d-flex justify-content-between align-items-center">{{@ucwords(@strtolower($nonliabilties_currents_->control_name))}}
                                                                    </li>
                                                                @endforeach
                                                            </ul>

                                                        <ul class="list-group m-0">
                                                            @foreach($nonliabilties_current as $income_ac)
                                                            <li class="list-group-item d-flex justify-content-between align-items-center">{{@ucwords(@strtolower($income_ac->account_name))}}<li>
                                                           
                                                           
                                                            @endforeach
                                                        </ul>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="accordion-item">
                                            <h2 class="accordion-header" id="headingThree">
                                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse12" aria-expanded="false" aria-controls="collapseThree">
                                                    Equity
                                                </button>
                                            </h2>
                                            <div id="collapse12" class="accordion-collapse collapse show" aria-labelledby="headingThree" data-bs-parent="#faqAccordion">
                                                <div class="accordion-body">
                                                <?php 
                                                
                                                $equity = \DB::table('control_accounts')->where('control_group', "Owner's Equity")->get();

                                                $equity_finance = \DB::table('accounts')
                                                            ->where('account_type', "Owner's Equity")
                                                            ->orderBy('account_name', 'ASC')
                                                            ->WhereNotIn('account_name', $equity->pluck('control_name'))
                                                            ->where('control_account_id', Null)
                                                            ->get();
                                                ?>

                                                            <ul class="list-group m-0">
                                                                @foreach($equity as $equity_finance_manage)
                                                                <?php 
                                                                    $getTransaction_equity = \DB::table('accounts')->where('control_account_id', $equity_finance_manage->id)->pluck('id');

                                                                    $total_equity = \DB::table('account_transactions')->whereIn('account_id', $getTransaction_equity)->sum('debit') - \DB::table('account_transactions')->whereIn('account_id', $getTransaction_equity)->sum('credit')

                                                                ?>
                                                                    
                                                                @endforeach
                                                            </ul>
                                                        <ul class="list-group m-0">
                                                            @foreach($equity_finance as $income_ac)
                                                            <li class="list-group-item d-flex justify-content-between align-items-center">{{@ucwords(@strtolower($income_ac->account_name))}}<li>
                                                           
                                                            @endforeach
                                                        </ul>
                                                </div>
                                            </div>
                                        </div>
                                        
                                    </div>
                                    <!-- Faq end -->

                                </div>
                            </div>
                            <!-- Card end -->

                            </div>
							<div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">

								<!-- Card start -->
								<div class="card">
									<div class="card-header">
										<div class="card-title">Profit & Loss Statement</div>
									</div>
									<div class="card-body">
										
										<!-- Faq start -->
                                        <div class="accordion" id="faqAccordion">
                                            <div class="accordion-item">
                                                <h2 class="accordion-header" id="headingOne">
                                                    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapse4" aria-expanded="true" aria-controls="collapseOne">
                                                        Income
                                                    </button>
                                                </h2>
                                                <div id="collapse4" class="accordion-collapse collapse show" aria-labelledby="headingOne" data-bs-parent="#faqAccordion">
                                                    <div class="accordion-body">

                                                        <?php 
                                                
                                                            $income_acimg = \DB::table('control_accounts')->where('control_group', "Income")->get();

                                                            $income_finance = \DB::table('accounts')
                                                                        ->where('account_type', "Income")
                                                                        ->orderBy('account_name', 'ASC')
                                                                        ->WhereNotIn('account_name', $income_acimg->pluck('control_name'))
                                                                        ->where('control_account_id', Null)
                                                                        ->get();
                                                            ?>

                                                            <ul class="list-group m-0">
                                                                @foreach($income_acimg as $income_finance_)
                                                                <?php 
                                                                    $getTransaction_income = \DB::table('accounts')->where('control_account_id', $income_finance_->id)->pluck('id');

                                                                    $total_income = \DB::table('account_transactions')->whereIn('account_id', $getTransaction_income)->sum('debit') - \DB::table('account_transactions')->whereIn('account_id', $getTransaction_income)->sum('credit')

                                                                ?>
                                                                    <li class="list-group-item d-flex justify-content-between align-items-center">{{@ucwords(@strtolower($income_finance_->control_name))}}
                                                                    </li>
                                                                @endforeach
                                                            </ul>

                                                        <ul class="list-group m-0">
                                                            @foreach($income_finance as $income_ac)
                                                            <li class="list-group-item d-flex justify-content-between align-items-center">{{@ucwords(@strtolower($income_ac->account_name))}}<li>
                                                            @endforeach
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <div class="accordion-item">
                                                <h2 class="accordion-header" id="headingThree">
                                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse6" aria-expanded="false" aria-controls="collapseThree">
                                                        Less Expenses
                                                    </button>
                                                </h2>
                                                <div id="collapse6" class="accordion-collapse collapse show" aria-labelledby="headingThree" data-bs-parent="#faqAccordion">
                                                    <div class="accordion-body">
                                                    <?php 
                                                    
                                                          $expensese_ac = \DB::table('control_accounts')->where('control_group', "Expenses")->get();

                                                          $expense_finance = \DB::table('accounts')
                                                                    ->where('account_type', "Expenses")
                                                                    ->orderBy('account_name', 'ASC')
                                                                    ->WhereNotIn('account_name', $expensese_ac->pluck('control_name'))
                                                                    ->where('control_account_id', Null)
                                                                    ->get();
                                                
                                                    
                                                    ?>

                                                            <ul class="list-group m-0">
                                                                @foreach($expensese_ac as $expense_finance_)
                                                                <?php 
                                                                    $getTransaction_exp = \DB::table('accounts')->where('control_account_id', $expense_finance_->id)->pluck('id');

                                                                    $total_income_ex = \DB::table('account_transactions')->whereIn('account_id', $getTransaction_exp)->sum('debit') - \DB::table('account_transactions')->whereIn('account_id', $getTransaction_exp)->sum('credit')

                                                                ?>
                                                                    <li class="list-group-item d-flex justify-content-between align-items-center">{{@ucwords(@strtolower($expense_finance_->control_name))}}
                                                                    </li>
                                                                @endforeach
                                                            </ul>

                                                        <ul class="list-group m-0">
                                                            @foreach($expense_finance as $income_ac)
                                                            <li class="list-group-item d-flex justify-content-between align-items-center">{{@ucwords(@strtolower($income_ac->account_name))}}<li>
                                                           
                                                            @endforeach
                                                        </ul>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- Faq end -->
                                        </div>
									</div>
								</div>
								<!-- Card end -->

							</div>
						</div>
						<!-- Row end -->

                


            

        </div>
    </div>
						


</div>
@endsection