<!doctype html>
<html lang="en">
	
<head>
		<!-- Required meta tags -->
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

		<!-- Meta -->
		<meta name="description" content="Responsive Bootstrap4 Dashboard Template">
		<meta name="author" content="ParkerThemes">
		<link rel="shortcut icon" href="img/fav.png">

		<!-- Title -->
		<title>Income Statement for {{$branch}} as at {{request()->date == null ? $dayClose->day_close : request()->date}}</title>

        <!-- Date Range CSS -->
        <link rel="stylesheet" href="{{asset('assets/vendor/daterange/daterange.css')}}">

                
        <!-- Uploader CSS -->
        <link rel="stylesheet" href="{{asset('assets/vendor/dropzone/dropzone.min.css')}}" />

        <!-- *************
            ************ Common Css Files *************
        ************ -->
        <!-- Bootstrap css -->
        <link rel="stylesheet" href="{{asset('assets/css/bootstrap.min.css')}}">

        <!-- Icomoon Font Icons css -->
        <link rel="stylesheet" href="{{asset('assets/fonts/style.css')}}">

        <!-- Main css -->
        <link rel="stylesheet" href="{{asset('assets/css/main.css')}}">

        <!-- fontAwesome -->
        <link href="{{asset('assets/fontawesome/css/all.css')}}" rel="stylesheet">


        <!-- Data Tables -->
        <link rel="stylesheet" href="{{asset('assets/vendor/datatables/dataTables.bs4.css')}}" />
        <link rel="stylesheet" href="{{asset('assets/vendor/datatables/dataTables.bs4-custom.css')}}" />
        <link href="{{asset('assets/vendor/datatables/buttons.bs.css')}}" rel="stylesheet" />

		<!-- Sweet Alert-->
		<link href="{{asset('assets/libs/sweetalert2/sweetalert2.min.css')}} " rel="stylesheet" type="text/css" />


        <script src="{{asset('assets/js/ajax.min.js')}}"></script>

        <!-- *************
            ************ Vendor Css Files *************
        ************ -->

        <!-- Bootstrap Select CSS -->
        <link rel="stylesheet" href="{{asset('assets/vendor/bs-select/bs-select.css')}}" />

        <!-- Mega Menu -->
        <link rel="stylesheet" href="{{asset('assets/vendor/megamenu/css/megamenu.css')}}">

        <!-- Search Filter JS -->
        <link rel="stylesheet" href="{{asset('assets/vendor/search-filter/search-filter.css')}}">
        <link rel="stylesheet" href="{{asset('assets/vendor/search-filter/custom-search-filter.css')}}">
	</head>

    <style>
         @media print {
                #back{
                    visibility: hidden;
                }
            }
    </style>

<body onload="window.print();">

<div class="card-body">
<div class="invoice-container">
    <div class="invoice-header">
        <!-- Row start -->
        <div class="row justify-content-between">
            <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-12">
            <!-- <a href="#" onclick="window.history.go(-1); return false" id="back" style="text-decoration:underline"><span class="badge bg-info">Return Back</span></a><br> -->
                <a href="#" class="logo">
                    <img src="/assets/img/{{$app->app_logo}}" alt="logo" style="max-width:70px;">
                </a>
            </div>
            <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-12">
                <address class="text-right">
                    Printed by: {{auth()->user()->name}} <br>
                    Printed Date:  <?=@strtoupper(date('Y-m-d h:i:s a')) ?><br>
                </address>
            </div>
        </div>
        <!-- Row end -->
    </div>

            <?php

                $summaryRe__ = \DB::table('invoices')
                ->where('invoice_status', 1)
                ->where('invoice_category', '!=', "TRANSPORT")
                ->where('branch', $branch)
                ->WhereDate('created_at','>=', $from)
                ->WhereDate('created_at','<=', $to)
                            ->sum('invoice_total_price');

                $all_invoice = \DB::table('invoices')
                ->selectRaw('agency as agency, sum(invoice_total_price) as invoice_total_price')
                    ->groupBy('agency')
                    ->where('invoice_status', 1)
                    ->where('branch', $branch)
                    ->WhereDate('created_at','>=', $from)
                    ->WhereDate('created_at','<=', $to)
                    ->get();

                 $nhil = $summaryRe__ * $mTaxes->nhil;
                 $covid = $summaryRe__ * $mTaxes->covid;
                 $getfund = $summaryRe__ * $mTaxes->getfund;
                 $vat = $summaryRe__ * $mTaxes->vat;
                 $total_tax = $nhil+$covid+$getfund+$vat;
            ?>

    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            <div class="invoice-details">
                <address class="m-0" style="width:70%">
                    <strong>{{$app->app_name}}</strong>,<br>
                    Income Statement for <em>{{@ucwords(@strtolower($branch))}}</em><br>
                </address>

                <div class="invoice-num">
                    <div>For the year ended</div>
                    <div> {{request()->date == null ? $dayClose->day_close : request()->date}}</div>
                </div>
            </div>
        </div>
    </div>
    <!-- Row end -->

    <?php
        $expenses = \DB::table('expenses')
        ->selectRaw('e_type as e_type, sum(e_amount) as e_amount')
        ->groupBy('e_type')
        ->WhereDate('e_date','>=', $from)
        ->WhereDate('e_date','<=', $to)
        ->where('e_name', $branch)
        ->get(); 
    ?>


<div class="table-container light-blue">
		<table  class="table v-middle m-0">
        <thead>
        <tr>
            <th>Particulars</th>
            <th>{{empty($app->currency) ? "GHS" : $app->currency}}</th>
        </tr>
        </thead>
        <tbody>
            <tr>
                <td><strong style="text-decoration:underline;">INCOME</strong></td>
                <td></td>
            </tr>
            <tr>
                <td><strong>Sales Income</strong>
                <td></td>
            </tr>
            @foreach($all_invoice as $sales)
            <tr>
                <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;{{@ucwords(@strtolower(empty($sales->agency) ? "Uncategorized" : $sales->agency))}}</td>
                <td> @convert(($sales->invoice_total_price) - ($sales->invoice_total_price*$mTaxes->vat))</td>
            </tr>
            @endforeach 
            <tr>
                <td><strong>Total Income</strong></td>
                <td>
                    <?php

                    $summaryRe = \DB::table('invoices')
                    ->where('invoice_status', 1)
                    ->where('invoice_category', '!=', "TRANSPORT")
                    ->where('branch', $branch)
                    ->WhereDate('created_at','>=', $from)
                    ->WhereDate('created_at','<=', $to)
                                ->sum('invoice_total_price');

                    ?>
                    <strong style="text-decoration:underline overline;"> @convert($total_income = $summaryRe  - $vat)</strong>
                    
                </td>
            </tr>
            <tr>
                <td><strong class="text-danger">Total Income Less VAT</strong></td>
                <td><strong class="text-danger">@convert($income_without_tax = $summaryRe - $vat)</strong></td>
            </tr>
            <tr>
                <td><strong class="text-danger">Total Sales With VAT</strong></td>
                <td><strong class="text-danger">@convert($summaryRe)</strong></td>
            </tr>
            <tr>
            <td><strong style="text-decoration:underline">COST OF GOODS SOLD</strong></td>
                <td></td>
            </tr>
                <?php 
                
                $getCategory = \DB::table('cost_of_sale_dumps')
                ->selectRaw('category as category, sum(cost) as cost')
                ->groupBy('category')
                ->get();

                ?>

            @foreach($getCategory as $getCategory)
                <tr>
                    <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;{{$getCategory->category}}</td>
                    <td> @convert($getCategory->cost)</td>
                </tr>

            @endforeach
                
            <tr>
                <td><strong>Total COGS</strong></td>
                <td>
                    <strong style="text-decoration:underline overline;">
                 @convert(
                    $cos_final = \DB::table('cost_of_sale_dumps')->sum('cost')
                    )
                    </strong>
                </td>
            </tr>
            <tr>
                <td><strong>Gross Profit</strong></td>
                <td>
                    <strong>  @convert($gross_profit = $total_income-$cos_final)</strong>
                </td>
            </tr>
            <tr>
                <td><strong class="text-danger">Gross Profit Margin</strong></td>
                <td><strong class="text-danger">@convert($gross_profit/($summaryRe == 0 ? 1 : $summaryRe) * 100)%</strong></td>
            </tr>
            <tr>
                <td><strong style="text-decoration:underline">EXPENSES</strong></td>
                <td></td>
            </tr>
            @foreach($expenses as $expenses)
            <tr>
                <td>{{@ucwords(@strtolower($expenses->e_type))}}</td>
                <td> @convert($expenses->e_amount)</td>
            </tr>
            @endforeach
            <tr>
                <td><strong>Total Operating Expenses</strong></td>
                <td> <strong style="text-decoration:underline overline;"> 
                 @convert( 
                        $expenses = \DB::table('expenses')
                        ->WhereDate('e_date','>=', $from)
                         ->WhereDate('e_date','<=', $to)
                         ->where('e_name', $branch)
                        ->sum('e_amount')
                     )
                    </strong>
                </td>
            </tr>
            <tr>
                <td>Income Before Tax</td>
                <td> @convert($income_before_tax = $gross_profit - $expenses)</td>
            </tr>
            <tr>
                <td>
                    <strong>Income Taxes</strong> <br>
                    &nbsp;&nbsp;&nbsp;&nbsp; <strong>NHIL</strong> - @convert($nhil) <br>
                    &nbsp;&nbsp;&nbsp;&nbsp; <strong>Covid</strong> - @convert($covid) <br>
                    &nbsp;&nbsp;&nbsp;&nbsp; <strong>Getfund</strong> - @convert($getfund) <br>
                   <em> <strong>Total Taxes</strong></em>
                </td>
                <td>
                <br><br><br><br>
                     @convert($total_tax)</td>
            </tr>
            <tr>
                <td><strong>Net Income(Loss)</strong></td>
                <td><strong style="text-decoration:underline overline; text-decoration-style:double;"> @convert($net_income = $income_before_tax - $total_tax)</strong></td>
            </tr>
            <tr>
                <td><strong class="text-danger">Net Margin</strong></td>
                <td><strong class="text-danger">@convert($net_income/($income_without_tax == 0 ? 1 : $income_without_tax)  * 100)%</strong></td>
            </tr>

        </tbody>
	</table>
    </div>
</div>
</div>
</div>



		<!-- *************
			************ Required JavaScript Files *************
		************* -->
		<!-- Required jQuery first, then Bootstrap Bundle JS -->
		<script src="{{asset('assets/js/jquery.min.js')}}"></script>
		<script src="{{asset('assets/js/bootstrap.bundle.min.js')}}"></script>
		<script src="{{asset('assets/js/modernizr.js')}}"></script>
		<script src="{{asset('assets/js/moment.js')}}"></script>

		<!-- *************
			************ Vendor Js Files *************
		************* -->

		<!-- Sweet Alerts js -->
		<script src="{{asset('assets/libs/sweetalert2/sweetalert2.min.js')}}"></script>
		
		<!-- Megamenu JS -->
		<script src="{{asset('assets/vendor/megamenu/js/megamenu.js')}}"></script>
		<script src="{{asset('assets/vendor/megamenu/js/custom.js')}}"></script>

		<!-- Slimscroll JS -->
		<script src="{{asset('assets/vendor/slimscroll/slimscroll.min.js')}}"></script>
		<script src="{{asset('assets/vendor/slimscroll/custom-scrollbar.js')}}"></script>

		<!-- Search Filter JS -->
		<script src="{{asset('assets/vendor/search-filter/search-filter.js')}}"></script>
		<script src="{{asset('assets/vendor/search-filter/custom-search-filter.js')}}"></script>

		<!-- Apex Charts -->
		<script src="{{asset('assets/vendor/apex/apexcharts.min.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/salesGraph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/ordersGraph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/earningsGraph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/visitorsGraph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/customersGraph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/sparkline.js')}}"></script>

		<!-- Circleful Charts -->
		<script src="{{asset('assets/vendor/circliful/circliful.min.js')}}"></script>
		<script src="{{asset('assets/vendor/circliful/circliful.custom.js')}}"></script>


		<!-- Bootstrap Select JS -->
		<script src="{{asset('assets/vendor/bs-select/bs-select.min.js')}}"></script>
		<script src="{{asset('assets/vendor/bs-select/bs-select-custom.js')}}"></script>


		<!-- Data Tables -->
		<script src="{{asset('assets/vendor/datatables/dataTables.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/dataTables.bootstrap.min.js')}}"></script>
		
		<!-- Custom Data tables -->
		<script src="{{asset('assets/vendor/datatables/custom/custom-datatables.js')}}"></script>

		<!-- Download / CSV / Copy / Print -->
		<script src="{{asset('assets/vendor/datatables/buttons.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/jszip.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/pdfmake.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/vfs_fonts.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/html5.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/buttons.print.min.js')}}"></script>

		<!-- Dropzone JS -->
		<script src="{{asset('assets/vendor/dropzone/dropzone.min.js')}}"></script>

		<!-- Date Range JS -->
		<script src="{{asset('assets/vendor/daterange/daterange.js')}}"></script>
		<script src="{{asset('assets/vendor/daterange/custom-daterange.js')}}"></script>

		<!-- Main Js Required -->
		<script src="{{asset('assets/js/main.js')}}"></script>

	</body>

</html>
