<!doctype html>
<html lang="en">
	
<head>
		<!-- Required meta tags -->
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

		<!-- Meta -->
		<meta name="description" content="Responsive Bootstrap4 Dashboard Template">
		<meta name="author" content="ParkerThemes">
		<link rel="shortcut icon" href="img/fav.png">

		<!-- Title -->
		<title>Income Statement - {{request()->date == null ? $dayClose->day_close : request()->date}}</title>

        <!-- Date Range CSS -->
        <link rel="stylesheet" href="{{asset('assets/vendor/daterange/daterange.css')}}">

                
        <!-- Uploader CSS -->
        <link rel="stylesheet" href="{{asset('assets/vendor/dropzone/dropzone.min.css')}}" />

        <!-- *************
            ************ Common Css Files *************
        ************ -->
        <!-- Bootstrap css -->
        <link rel="stylesheet" href="{{asset('assets/css/bootstrap.min.css')}}">

        <!-- Icomoon Font Icons css -->
        <link rel="stylesheet" href="{{asset('assets/fonts/style.css')}}">

        <!-- Main css -->
        <link rel="stylesheet" href="{{asset('assets/css/main.css')}}">

        <!-- fontAwesome -->
        <link href="{{asset('assets/fontawesome/css/all.css')}}" rel="stylesheet">


        <!-- Data Tables -->
        <link rel="stylesheet" href="{{asset('assets/vendor/datatables/dataTables.bs4.css')}}" />
        <link rel="stylesheet" href="{{asset('assets/vendor/datatables/dataTables.bs4-custom.css')}}" />
        <link href="{{asset('assets/vendor/datatables/buttons.bs.css')}}" rel="stylesheet" />

		<!-- Sweet Alert-->
		<link href="{{asset('assets/libs/sweetalert2/sweetalert2.min.css')}} " rel="stylesheet" type="text/css" />


        <script src="{{asset('assets/js/ajax.min.js')}}"></script>

        <!-- *************
            ************ Vendor Css Files *************
        ************ -->

        <!-- Bootstrap Select CSS -->
        <link rel="stylesheet" href="{{asset('assets/vendor/bs-select/bs-select.css')}}" />

        <!-- Mega Menu -->
        <link rel="stylesheet" href="{{asset('assets/vendor/megamenu/css/megamenu.css')}}">

        <!-- Search Filter JS -->
        <link rel="stylesheet" href="{{asset('assets/vendor/search-filter/search-filter.css')}}">
        <link rel="stylesheet" href="{{asset('assets/vendor/search-filter/custom-search-filter.css')}}">
	</head>

    <style>
         @media print {
                #back{
                    visibility: hidden;
                }
            }
    </style>

<body onload="window.print();">

<div class="card-body">
<div class="invoice-container">
    <div class="invoice-header">
        <!-- Row start -->
        <div class="row justify-content-between">
            <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-12">
            <!-- <a href="#" onclick="window.history.go(-1); return false" id="back" ><span class="badge bg-info">Return Back</span></a><br> -->
                <a href="#" class="logo">
                    <img src="/assets/img/{{$app->app_logo}}" alt="logo" style="max-width:70px;">
                </a>
            </div>
            <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-12">
                <address class="text-right">
                    Printed by: {{auth()->user()->name}} <br>
                    Printed Date:  <?=@strtoupper(date('Y-m-d h:i:s a')) ?><br>
                </address>
            </div>
        </div>
        <!-- Row end -->
    </div>


    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            <div class="invoice-details">
                <address class="m-0" style="width:70%">
                    <strong>{{$app->app_name}}</strong>,<br>
                    Income Statement<br>
                </address>

                <div class="invoice-num">
                    <div>For the year ended</div>
                    <div> {{request()->date == null ? $dayClose->day_close : request()->date}}</div>
                </div>
            </div>
        </div>
    </div>
    <!-- Row end -->

<div class="table-container light-blue">
		<table  class="table v-middle m-2">
        <thead>
        <tr>
            <th>Particulars</th>
            <th>{{empty($app->currency) ? "GHS" : $app->currency}}</th>
        </tr>
        </thead>
        <tbody>
            <tr>
                <td><strong style="font-weight:500">INCOME</strong></td>
                <td></td>
            </tr>
            <?php 
                                                
            $income_acimg = \DB::table('control_accounts')->where('control_group', "Income")->get();

            $income_finance = \DB::table('accounts')->where('account_type', "Income")
                        ->where('account_state', 1)
                        ->WhereNotIn('account_name', $income_acimg->pluck('control_name'))
                        ->where('control_account_id', Null)
                    ->get();
            ?>
            @foreach($income_acimg as $income_finance_)

            <?php 

                $getTransaction_income = \DB::table('accounts')->where('control_account_id', $income_finance_->id)->pluck('id');

                $total_income  = \DB::table('account_transactions')->whereIn('account_id', $getTransaction_income)->WhereDate('date','>=', $from)->WhereDate('date','<=', $to)->sum('debit') - \DB::table('account_transactions')->whereIn('account_id', $getTransaction_income)->WhereDate('date','>=', $from) ->WhereDate('date','<=', $to)->sum('credit');

            ?>
            @if(abs($total_income) != 0)
            <tr>
                <td>
                    <a href="#" class="text-dark">
                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;{{@ucwords(@strtolower($income_finance_->control_name))}}
                    </a>
                </td>
                <td><a href="{{route('ControlSub', $income_finance_->id)}}"  class="text-primary">@convert($control_income = abs($total_income))</a></td>
            </tr>
            @endif
            @endforeach 
            @foreach($income_finance as $income_ac)

            <?php $incom_asset = abs(\DB::table('account_transactions')->where('account_id', $income_ac->id)->WhereDate('date','>=', $from)->WhereDate('date','<=', $to)->sum('debit') - \DB::table('account_transactions')->where('account_id', $income_ac->id)->WhereDate('date','>=', $from)->WhereDate('date','<=', $to)->sum('credit')) ?>
            @if($incom_asset != 0)
            <tr>
                <td>
                    <a href="#" class="text-dark">
                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;{{@ucwords(@strtolower($income_ac->account_name))}}
                    </a>
                </td>
                <td> <a href="{{route('AccountBooks', $income_ac->id)}}"   class="text-primary"  data-toggle="tooltip" title="Account Book"> 
                    @convert($incom_asset)
               </a></td>

            </tr>
            @endif
            @endforeach 
            <tr>
                <td><strong>Total Income</strong></td>
                <td>
                    <?php

                     
                        $incom_asset  = \DB::table('account_transactions')->whereIn('account_id', \DB::table('accounts')->where('account_type', "Income")->pluck('id'))->WhereDate('date','>=', $from)->WhereDate('date','<=', $to)->sum('debit') - \DB::table('account_transactions')->whereIn('account_id', \DB::table('accounts')->where('account_type', "Income")->pluck('id'))->WhereDate('date','>=', $from)->WhereDate('date','<=', $to)->sum('credit') 


                    ?>
                    <strong> @convert($total_inc = abs($incom_asset))</strong>
                    
                </td>
            </tr>
            
            <tr>
            <td><strong style="font-weight:500">COST OF GOODS SOLD </strong></td>
                <td></td>
            </tr>
            <?php 
                                                
            $cos_acimg = \DB::table('control_accounts')->where('control_group', "Cost Of Sales")->get();

            $cos_finance = \DB::table('accounts')->where('account_type', "Cost Of Sales")
                        ->where('account_state', 1)
                        ->WhereNotIn('account_name', $cos_acimg->pluck('control_name'))
                        ->where('control_account_id', Null)
                    ->get();
            ?>
            @foreach($cos_acimg as $cos_finance_)

            <?php 

                $getTransaction_cos = \DB::table('accounts')->where('control_account_id', $cos_finance_->id)->pluck('id');

                $total_cos = \DB::table('account_transactions')->whereIn('account_id', $getTransaction_cos)->WhereDate('date','>=', $from)->WhereDate('date','<=', $to)->sum('debit') - \DB::table('account_transactions')->whereIn('account_id', $getTransaction_cos)->WhereDate('date','>=', $from) ->WhereDate('date','<=', $to)->sum('credit');
                
            ?>
            @if($total_cos != 0)
            <tr>
                <td>
                    <a href="#" class="text-dark">
                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;{{@ucwords(@strtolower($_financosce_->control_name))}}
                    </a>
                </td>
                <td><a href="{{route('ControlSub', $income_finance_->id)}}"  class="text-primary">@convert($control_cos = $total_cos)</a></td>
            </tr>
            @endif
            @endforeach 

            @foreach($cos_finance as $income_ac)
            <?php $incom_asset = \DB::table('account_transactions')->WhereDate('date','>=', $from)->WhereDate('date','<=', $to)->where('account_id', $income_ac->id)->sum('debit') - \DB::table('account_transactions')->WhereDate('date','>=', $from)->WhereDate('date','<=', $to)->where('account_id', $income_ac->id)->sum('credit') ?>
            @if($incom_asset != 0)
            <tr>
                <td>
                    <a href="#" class="text-dark">
                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;{{@ucwords(@strtolower($income_ac->account_name))}}
                    </a>
                </td>
                <td> <a href="{{route('AccountBooks', $income_ac->id)}}"   class="text-primary"  data-toggle="tooltip" title="Account Book"> 
               @convert($incom_asset)
            </a></td>
            </tr>
            @endif
            @endforeach 
                
            <tr>
                <td><strong>Total Cost of sales </strong></td>
                <td>
                     <?php

                        $cos_final = \DB::table('account_transactions')->whereIn('account_id', \DB::table('accounts')->where('account_type', "Cost Of Sales")->pluck('id'))->WhereDate('date','>=', $from)->WhereDate('date','<=', $to)->sum('debit') - \DB::table('account_transactions')->whereIn('account_id', \DB::table('accounts')->where('account_type', "Cost Of Sales")->pluck('id'))->WhereDate('date','>=', $from)->WhereDate('date','<=', $to)->sum('credit')

                    ?>
                    @convert($cos_final)
                </td>
            </tr>
            <tr>
                <td><strong>Gross Profit</strong></td>
                <td>
                <?php
                
                    $incom_e  = \DB::table('account_transactions')->whereIn('account_id', \DB::table('accounts')->where('account_type', "Income")->pluck('id'))->WhereDate('date','>=', $from)->WhereDate('date','<=', $to)->sum('debit') - \DB::table('account_transactions')->whereIn('account_id', \DB::table('accounts')->where('account_type', "Income")->pluck('id'))->WhereDate('date','>=', $from)->WhereDate('date','<=', $to)->sum('credit');

                    $cos = \DB::table('account_transactions')->whereIn('account_id', \DB::table('accounts')->where('account_type', "Cost Of Sales")->pluck('id'))->WhereDate('date','>=', $from)->WhereDate('date','<=', $to)->sum('debit') - \DB::table('account_transactions')->whereIn('account_id', \DB::table('accounts')->where('account_type', "Cost Of Sales")->pluck('id'))->WhereDate('date','>=', $from)->WhereDate('date','<=', $to)->sum('credit');

                ?>
                    <strong>  @convert($gross_profit = $total_inc - $cos_final )</strong>
                </td>
            </tr>
           
            <tr>
                <td><strong style="font-weight:500">EXPENSES</strong></td>
                <td></td>
            </tr>
            <?php 
                                                    
                $expensese_ac = \DB::table('control_accounts')->where('control_group', "Expenses")->get();

                $expense_finance = \DB::table('accounts')
                            ->where('account_state', 1)
                            ->where('account_type', "Expenses")
                            ->WhereNotIn('account_name', $expensese_ac->pluck('control_name'))
                            ->where('control_account_id', Null)
                            ->get();
        
            ?>
            @foreach($expensese_ac as $expense_finance_)

                <?php 
                    $getTransaction_exp = \DB::table('accounts')->where('control_account_id', $expense_finance_->id)->pluck('id');

                    $total_exp_control = \DB::table('account_transactions')->whereIn('account_id', $getTransaction_exp)->WhereDate('date','>=', $from)->WhereDate('date','<=', $to)->sum('debit') - \DB::table('account_transactions')->whereIn('account_id', $getTransaction_exp)->WhereDate('date','>=', $from)->WhereDate('date','<=', $to)->sum('credit');
                    
                ?>
            @if($total_exp_control != 0)
            <tr>
                <td>{{@ucwords(@strtolower($expense_finance_->control_name))}}</td>
                <td> <a href="{{route('ControlSub', $income_finance_->id)}}"  class="text-primary">@convert($total_exp_control)</a></td>
            </tr>
            @endif
            @endforeach
            @foreach($expense_finance as $income_ac)
            <?php $total_exp = \DB::table('account_transactions')->where('account_id', $income_ac->id)->WhereDate('date','>=', $from)->WhereDate('date','<=', $to)->sum('debit') - \DB::table('account_transactions')->where('account_id', $income_ac->id)->WhereDate('date','>=', $from)->WhereDate('date','<=', $to)->sum('credit') ?>

            @if($total_exp != 0)
            <tr>
            <td>
            <a href="#" class="text-dark">
                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;{{@ucwords(@strtolower($income_ac->account_name))}}</a></td>
            <td>
                <a href="{{route('AccountBooks', $income_ac->id)}}"   class="text-primary"  data-toggle="tooltip" title="Account Book"> 
                   @convert($total_exp)
            </a>
            </td>
            </tr>
            @endif
            @endforeach
            <?php

                        $expense_total = \DB::table('account_transactions')->whereIn('account_id', \DB::table('accounts')->where('account_type', "Expenses")->pluck('id'))->WhereDate('date','>=', $from)->WhereDate('date','<=', $to)->sum('debit') - \DB::table('account_transactions')->whereIn('account_id', \DB::table('accounts')->pluck('id'))->WhereDate('date','>=', $from)->WhereDate('date','<=', $to)->sum('credit');

                    ?>
            <tr>
                <td><strong>Total Operating Expenses</strong></td>
                <td><strong> 
                <?php $expense_total = \DB::table('expenses')->WhereDate('e_date','>=', $from)->WhereDate('e_date','<=', $to)->sum('e_amount') ?>
                 @convert($expense_total)
                    </strong>
                </td>
            </tr>
           
            <tr>
                <td><strong class="text-danger" style="font-weight:400">Net Income(Loss)</strong></td>
                <td><strong class="text-danger" style="text-decoration:underline overline; text-decoration-style:double;font-weight:400"> @convert($net_income = $gross_profit - $expense_total)</strong></td>
            </tr>
        
        </tbody>
	</table>
    </div>
</div>
</div>
</div>



		<!-- *************
			************ Required JavaScript Files *************
		************* -->
		<!-- Required jQuery first, then Bootstrap Bundle JS -->
		<script src="{{asset('assets/js/jquery.min.js')}}"></script>
		<script src="{{asset('assets/js/bootstrap.bundle.min.js')}}"></script>
		<script src="{{asset('assets/js/modernizr.js')}}"></script>
		<script src="{{asset('assets/js/moment.js')}}"></script>

		<!-- *************
			************ Vendor Js Files *************
		************* -->

		<!-- Sweet Alerts js -->
		<script src="{{asset('assets/libs/sweetalert2/sweetalert2.min.js')}}"></script>
		
		<!-- Megamenu JS -->
		<script src="{{asset('assets/vendor/megamenu/js/megamenu.js')}}"></script>
		<script src="{{asset('assets/vendor/megamenu/js/custom.js')}}"></script>

		<!-- Slimscroll JS -->
		<script src="{{asset('assets/vendor/slimscroll/slimscroll.min.js')}}"></script>
		<script src="{{asset('assets/vendor/slimscroll/custom-scrollbar.js')}}"></script>

		<!-- Search Filter JS -->
		<script src="{{asset('assets/vendor/search-filter/search-filter.js')}}"></script>
		<script src="{{asset('assets/vendor/search-filter/custom-search-filter.js')}}"></script>

		<!-- Apex Charts -->
		<script src="{{asset('assets/vendor/apex/apexcharts.min.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/salesGraph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/ordersGraph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/earningsGraph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/visitorsGraph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/customersGraph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/sparkline.js')}}"></script>

		<!-- Circleful Charts -->
		<script src="{{asset('assets/vendor/circliful/circliful.min.js')}}"></script>
		<script src="{{asset('assets/vendor/circliful/circliful.custom.js')}}"></script>


		<!-- Bootstrap Select JS -->
		<script src="{{asset('assets/vendor/bs-select/bs-select.min.js')}}"></script>
		<script src="{{asset('assets/vendor/bs-select/bs-select-custom.js')}}"></script>


		<!-- Data Tables -->
		<script src="{{asset('assets/vendor/datatables/dataTables.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/dataTables.bootstrap.min.js')}}"></script>
		
		<!-- Custom Data tables -->
		<script src="{{asset('assets/vendor/datatables/custom/custom-datatables.js')}}"></script>

		<!-- Download / CSV / Copy / Print -->
		<script src="{{asset('assets/vendor/datatables/buttons.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/jszip.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/pdfmake.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/vfs_fonts.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/html5.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/buttons.print.min.js')}}"></script>

		<!-- Dropzone JS -->
		<script src="{{asset('assets/vendor/dropzone/dropzone.min.js')}}"></script>

		<!-- Date Range JS -->
		<script src="{{asset('assets/vendor/daterange/daterange.js')}}"></script>
		<script src="{{asset('assets/vendor/daterange/custom-daterange.js')}}"></script>

		<!-- Main Js Required -->
		<script src="{{asset('assets/js/main.js')}}"></script>

	</body>

</html>
