@extends('layouts.app')

@section('content')

<?php $control = \DB::table('control_accounts')->select('control_name', 'id')->get() ?>
<!-- Content wrapper start -->
<div class="content-wrapper">

 <!-- Breadcrumb container start -->
 <div class="breadcrumb-container">

<!-- Row start -->
<div class="row gutters">
    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
              <li class="breadcrumb-item"><a href="/">Home</a></li>
              <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Dashboards</a></li>
              <li class="breadcrumb-item active" aria-current="page">General Ledger</li>
            </ol>
        </nav>
    </div>
    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
        <!-- Top Actions - DateRange and Buttons -->
        <div class="d-flex justify-content-end"><h5>General Ledger</h5></div>
    </div>
</div>
<!-- Row end -->

</div>
<!-- Breadcrumb container end -->


<!-- Row start -->
<div class="row">
    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

        <!-- Card start -->
        <div class="card">
            <div class="card-body">

                <div class="custom-tabs-container">
                    <ul class="nav nav-tabs" id="myTab" role="tablist">
                        <li class="nav-item" role="presentation">
                            <a class="nav-link active" id="first-tab" data-bs-toggle="tab" href="#first" role="tab" aria-controls="first" aria-selected="true"><i class="icon-credit-card"></i> Accounts</a>
                        </li>
                        <li class="nav-item" role="presentation">
                            <a class="nav-link" id="second-tab" data-bs-toggle="tab" href="#second" role="tab" aria-controls="second" aria-selected="false"> <i class="icon-list"></i> Account Type</a>
                        </li>
                    </ul>
                    <div class="tab-content" id="myTabContent">
                        <div class="tab-pane fade show active" id="first" role="tabpanel">

                        <div class="row gutters">
                                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                    <p> New Control Account. <a href="#" data-bs-toggle="modal" data-bs-target="#exampleModalControl" style="text-decoration:underline;" class="text-danger">Add new</a></p>

										<!-- Modal start -->
										<div class="modal fade" id="exampleModalControl" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
											<div class="modal-dialog">
												<div class="modal-content">
												<div class="modal-header">
													<h5 class="modal-title" id="exampleModalLabel">New Control Account</h5>
													<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
												</div>
												<div class="modal-body">
													<!-- Card start -->
								<div class="card">
									<div class="card-body">
										
										<form class="row row-cols-lg-auto g-3 align-items-center" method="post" action="{{route('SaveControlAccount')}}">
                                            @csrf
											<div class="col-12">
												<label class="visually-hidden">Name</label>
												<div class="input-group">
													<div class="input-group-text">
														<i class="icon-edit-2"></i>
													</div>
													<input type="text" class="form-control" name="control_name" placeholder="Name">
												</div>
											</div>

											<div class="col-12">
												<label class="visually-hidden">Code</label>
												<div class="input-group">
													<div class="input-group-text">
														<i class="icon-code"></i>
													</div>
													<input type="text" class="form-control"  name="control_code" placeholder="Code">
												</div>
											</div>

                                            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
												
												<!-- Field wrapper start -->
												<div class="field-wrapper">
													<div class="input-group">

														<select class="select-multiple js-states" name="control_group" title="Select Product Category">
                                                        <option selected disabled>uncategorised</option>
                                                            <option>Assets</option>
                                                            <option>Equity</option>
                                                            <option>Liabitites</option>
                                                            @foreach($account_type as $ac_name)
                                                            <option>{{@ucwords(@strtolower($ac_name->account_type_name))}}</option>
                                                            @endforeach
                                                        </select>
													</div>
													<div class="field-placeholder">Balance Sheet group</div>
												</div>
												<!-- Field wrapper end -->

											</div>

                                            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
													<div>
														<button class="btn btn-primary ms-1">Submit</button>
													</div>
											</div>

											
										</form>

									</div>
								</div>
								<!-- Card end -->
												</div>
												<div class="modal-footer">
													<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
												</div>
												</div>
											</div>
										</div>
										<!-- Modal end -->
                                </div>
                            </div>

                        <div style="margin-bottom:12px">
                            <span class="d-flex justify-content-end">
                            <button class="btn btn-outline-primary" data-bs-toggle="modal" data-bs-target="#newAccount"> <i class="icon-plus"></i> Add Account</button>
                            <!-- <button class="btn btn-outline-primary" style="margin-left:5px" data-bs-toggle="modal" data-bs-target="#newAccountBC"> <i class="icon-attach_money"></i> Bank & Cash Account</button> -->
                            </span>
                        </div>
                        <div class="table-responsive">
                            <table id="copy-print-csv" class="table custom-table">
                                <thead>
                                    <tr>
                                    <th>Account Name</th>
                                    <th>Account Type</th>
                                    <th>Code</th>
                                    <th>Balance <br><strong>{{empty($app->currency) ? "GHS" : $app->currency}}</strong></th>
                                    <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($accounts->chunk(3) as $row)
                                    @foreach($row as $account)
                                    <?php $balance_transaction = 
                                    \DB::table('account_transactions')->where('account_id', $account->id)->sum('debit') -
                                    \DB::table('account_transactions')->where('account_id', $account->id)->sum('credit');
                                    ?>
                                    <tr>
                                    <td> <a href="{{route('AccountBooks', $account->id)}}">{{@ucwords(@strtolower($account->account_name))}}</a></td>
                                    <td>{{@ucwords(@strtolower($account->account_type))}}</td>
                                    <td>{{$account->account_number}}</td>
                                    <td><a href="{{route('AccountBooks', $account->id)}}" class="text-primary" style="text-decoration:underline">@convert($balance_transaction)</a></td>
                                    <td>
                                        <div class="actions">
                                        @if(auth()->user()->role == "Administrator")
                                            <a href="#" data-toggle="tooltip" data-placement="top" title="Edit Account"  data-bs-toggle="modal" data-bs-target="#EditAccount{{$account->id}}" data-original-title="Edit">
                                                <i class="icon-edit1 text-secondary"></i>
                                            </a>
                                        @endif
                                            <a href="{{route('AccountBooks', $account->id)}}" data-toggle="tooltip" title="Account Book">
                                                <i class="icon-book text-secondary"></i>
                                            </a>
                                            <a href="#" data-toggle="tooltip" data-bs-toggle="modal" data-bs-target="#transactions{{$account->id}}" title="Funds Transfer">
                                                <i class="icon-swap text-secondary"></i>
                                            </a>
                                            <a href="#" data-toggle="tooltip" data-placement="top" title="Deposits" data-bs-toggle="modal" data-bs-target="#deposits{{$account->id}}">
                                                <i class="icon-thumbs-up1 text-info"></i>
                                            </a>
                                            @if($account->account_name == "Cash And Cash Equivalents")
                                            <a href="#" data-toggle="tooltip" data-placement="top" title="Default Account" data-original-title="">
                                                <i class="icon-lock1 text-light"></i>
                                            </a>
                                            @else
                                            @can('create', App\Models\User::class)
                                            <a href="#" id="{{$account->id}}" onclick="DeleteAccount(this.id)" data-toggle="tooltip" data-placement="top" title="" data-original-title="Delete">
                                                <i class="icon-x-circle text-danger"></i>
                                            </a>
                                            @endcan
                                            @endif
                                        </div>
                                    </td>
                                    </tr>
                                    @endforeach
                                    @endforeach
                                </tbody>
                        </table>
                        </div>

                        </div>
                        <!-- END TAB ONE -->
                        <div class="tab-pane fade" id="second" role="tabpanel">
                            <!-- Row start -->
						<div class="row gutters">
							<div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">

								<!-- Card start -->
								<div class="card">
									<div class="card-header">
										<div class="card-title">New Account Types</div>
									</div>
									<div class="card-body">
										<form action="{{route('accounttype.index')}}" method="post">
                                            @csrf
										<!-- Row start -->
										<div class="row gutters">
											<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
												
												<!-- Field wrapper start -->
												<div class="field-wrapper">
													<div class="input-group">
														<input class="form-control" type="text" name="account_type_name">
														<span class="input-group-text">
															<i class="icon-attachment1"></i>
														</span>
													</div>
													<div class="field-placeholder">Name <span class="text-danger">*</span></div>
												</div>
												<!-- Field wrapper end -->

											</div>
											<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
												
												<!-- Field wrapper start -->
												<div class="field-wrapper">
													<select class="select-multiple js-states" name="account_type_parent" title="Select Product Category">
                                                    <option selected disabled>uncategorised</option>
                                                        <option>Assets</option>
                                                        <option>Equity</option>
                                                        <option>Liabitites</option>
                                                        @foreach($account_type as $ac_name)
                                                        <option>{{@ucwords(@strtolower($ac_name->account_type_name))}}</option>
                                                        @endforeach
													</select>
													<div class="field-placeholder">Parent Account Type</div>
												</div>
												<!-- Field wrapper end -->

											</div>
									
											<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
												
												<!-- Field wrapper start -->
												<div class="field-wrapper">
													<textarea class="form-control" rows="2" name="account_type_description"></textarea>
													<div class="field-placeholder">Description</div>
												</div>
												<!-- Field wrapper end -->

											</div>
											
											<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
												<button class="btn btn-primary">Submit</button>
											</div>
										</div>
										<!-- Row end -->
                                        </form>
									</div>
								</div>
								<!-- Card end -->

							</div>
							<div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">

								<!-- Card start -->
								<div class="card">
									<div class="card-title">Account Type List</div>


                                    <div class="table-responsive" id="tabler">
											<table class="table table-bordered v-middle m-0">
												<thead>
													<tr>
														<th>Name</th>
														<th>Parent Account</th>
														<th>Action</th>
													</tr>
												</thead>
												<tbody>
                                                    @foreach($account_type as $type)
													<tr>
														<td>{{@strtoupper($type->account_type_name)}}
                                                            <p><small class="text-primary">DESCRIPTION: {{$type->account_type_description}}</small></p>
                                                        </td>
														<td><span class="badge bg-info">{{$type->account_type_parent}}</span></td>
														<td>
                                                            <div class="td-actions">
																
																<a href="#" class="icon green" data-bs-toggle="tooltip" data-bs-placement="top" title="" data-bs-original-title="Edit Row">
																	<i class="icon-edit"></i>
																</a>
																<a href="#" class="icon red" id="{{$type->id}}" onclick="DeleteAccountType(this.id)" data-bs-toggle="tooltip" data-bs-placement="top" title="" data-bs-original-title="Delete Row">
																	<i class="icon-cancel"></i>
																</a>
															</div>
														</td>
													</tr>
													@endforeach
												</tbody>
											</table>
										</div>
									
								</div>
								<!-- Card end -->

							</div>
						</div>
						<!-- Row end -->
                        </div>
                       
                    </div>
                </div>

            </div>
        </div>
        <!-- Card end -->

    </div>
</div>
<!-- Row end -->

</div>
<!-- Content wrapper end -->



@foreach($funds as $account)
<!--TRANSACTIONS TRANSFER Modal start -->
<div class="modal fade" id="transactions{{$account->id}}" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLabel">FUNDS TRANSFER</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
        <!-- Card start -->
            <div class="card">
                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-4 col-12">
                        <div class="form-section-header">SELCTED ACCOUNT-: {{$account->account_name}} </div>
                    </div>
               
                <div class="card-body">
                    <form action="{{route('FundsTransfer', $account->id)}}" method="post" id="fundtransfer" enctype="multipart/form-data">
                        @csrf

                    <input type="text" name="trans_type" value="FUNDS TRANSFER" hidden>
                    <!-- Row start -->
                    <div class="row gutters">

                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            
                           <!-- Field wrapper start -->
                        <div class="field-wrapper">
                            <select class="select-single js-states" name="transfer_to" title="Select Product Category" data-live-search="true">
                                @foreach($accounts as $ac_name)
                                <option {{$ac_name->account_name == $account->account_name ? 'disabled' : '' }} value="{{$ac_name->account_name}}">{{ @ucwords(@strtolower($ac_name->account_name))}} ~ {{ @ucwords(@strtolower($ac_name->account_type))}}</option>
                                @endforeach
                            </select>
                            <div class="field-placeholder">Transfer to <span class="text-danger">*</span></div>
                        </div>
                        <!-- Field wrapper end -->

                        </div>

                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            
                            <!-- Field wrapper start -->
                            <div class="field-wrapper"> 
                                <input class="form-control" type="number" min="0" step="0.0001" name="amount">
                                <div class="field-placeholder">Amount <span class="text-danger">*</span></div>
                            </div>
                            <!-- Field wrapper end -->

                        </div>
                        
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <input class="form-control" type="date" value="{{$dayClose->day_close}}" name="date">
                                <div class="field-placeholder">Date</div>
                            </div>
                            <!-- Field wrapper end -->

                        </div>

                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-4 col-12">
                                <div class="form-section-header"><small class="text-mute">Select the transfer method as the payment method to make your report more detailed</small></div>
                            </div>

                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            <div class="field-wrapper">
                                <select class="select-single js-states" title="Select Product Category" name="payment_method" data-live-search="true">
                                @foreach($payment_methods as $payment_name)
                                     <option>{{$payment_name}}</option>
                                @endforeach
                                </select>
                                <div class="field-placeholder">Payment Method</div>
                            </div>    
                        </div>

                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <textarea class="form-control" rows="2" name="note"></textarea>
                                <div class="field-placeholder">Note <span class="text-danger">*</span></div>
                            </div>
                            <!-- Field wrapper end -->

                        </div>

                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">														
                                <input type="file" name="image" class="form-control" id="inputGroupFile01">
                                <div class="field-placeholder">Attachment</div>
                                <small class="text-mute">Max File: 5MB, Allowed Files: .pdf, .csv,.zip, .doc, .jpeg,.jpg, .png</small>
                            </div>
                            <!-- Field wrapper end -->

                        </div>
                        
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            <button type="submit" class="btn btn-primary">Submit</button>
                        </div>
                    </div>
                    <!-- Row end -->
                    </form>
                </div>
            </div>
            <!-- Card end -->
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        </div>
        </div>
    </div>
</div>
<!-- Modal end -->


<!-- Edit Account -->
<!-- Modal start -->
<div class="modal fade" id="EditAccount{{$account->id}}" tabindex="-1" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalCenterTitle">{{$account->account_name}}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
        <!-- Row start -->
        <div class="row gutters">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

                <form action="{{route('account.update', $account->id)}}" method="post">
                    @csrf
                <!-- Card start -->
                <div class="card">
                    <div class="card-body">
                        
                        <!-- Row start -->
                        <div class="row gutters">
                            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-4 col-12">
                                <div class="form-section-header">Account Details</div>
                            </div>
                            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                                
                                <!-- Field wrapper start -->
                                <div class="field-wrapper">
                                    <div class="input-group">
                                        <input class="form-control" type="text" value="{{$account->account_name}}" name="account_name" required>
                                        <span class="input-group-text">
                                            <i class="icon-attachment1
                                            "></i>
                                        </span>
                                    </div>
                                    <div class="field-placeholder">Name <span class="text-danger">*</span></div>
                                </div>
                                <!-- Field wrapper end -->

                            </div>
                            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                                
                                <!-- Field wrapper start -->
                                <div class="field-wrapper">
                                    <div class="input-group">
                                        <input class="form-control" type="text" value="{{$account->account_number}}" name="account_number">
                                    </div>
                                    <div class="field-placeholder">Account Number <span class="text-danger">*</span></div>
                                </div>
                                <!-- Field wrapper end -->

                            </div>
                            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                                
                                <!-- Field wrapper start -->
                                <div class="field-wrapper">
                                    <select class="select-single js-states" name="account_type" title="Select Product Category" data-live-search="true">
                                        <option selected>{{{$account->account_type}}}</option>
                                        @foreach($account_type as $type)
                                         <option>{{$type->account_type_name}}</option>
                                        @endforeach
                                    </select>
                                    <div class="field-placeholder">Account Type</div>
                                </div>
                                <!-- Field wrapper end -->

                            </div>

                            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                                <?php $serachControl = \DB::table('accounts')->where('id', $account->id)->first();
                                      $serachControl_ = \DB::table('control_accounts')->where('id', $serachControl->control_account_id)->first();
                                ?>
                                <!-- Field wrapper start -->
                                <div class="field-wrapper">
                                    <select class="select-single js-states" name="control_account" title="Select Product Category" data-live-search="true">
                                        @if(empty($serachControl_))
                                        <option disabled selected>Please select</option>
                                        @else
                                        <option value="{{$serachControl_->id}}" selected>{{$serachControl_->control_name}}</option>
                                        @endif
                                        @foreach($control as $type)
                                         <option value="{{$type->id}}">{{@ucwords(@strtolower($type->control_name))}}</option>
                                        @endforeach
                                    </select>
                                    <div class="field-placeholder">Control Account</div>
                                </div>
                                <!-- Field wrapper end -->

                            </div>


                           
                            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                
                                <!-- Field wrapper start -->
                                <div class="field-wrapper">
                                    <textarea class="form-control" rows="2" name="account_note">{{$account->account_note}}</textarea>
                                    <div class="field-placeholder">Note <span class="text-danger">*</span></div>
                                </div>
                                <!-- Field wrapper end -->

                            </div>
                           
                            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                <button class="btn btn-primary">Submit</button>
                            </div>
                        </div>
                        <!-- Row end -->
                    </div>
                </div>
                <!-- Card end -->
                </form>
            </div>
        </div>
        <!-- Row end -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
<!-- Modal end -->

@endforeach


@foreach($funds as $account)
<!--TRANSACTIONS TRANSFER Modal start -->
<div class="modal fade" id="deposits{{$account->id}}" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLabel">DEPOSITS</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
        <!-- Card start -->
            <div class="card">
                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-4 col-12">
                        <div class="form-section-header">SELCTED ACCOUNT-: {{$account->account_name}} </div>
                    </div>
                <div class="card-body">
                    <form action="{{route('Deposit', $account->id)}}" method="post">

                    <input type="text" name="trans_type" value="DEPOSIT" hidden>

                    @csrf
                    <!-- Row start -->
                    <div class="row gutters">

                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            
                           <!-- Field wrapper start -->
                        <div class="field-wrapper">
                            <select class="select-single js-states" name="deposit_from" title="Select Product Category" data-live-search="true">
                                @foreach($accounts as $ac_name)
                                <option {{$ac_name->account_name == $account->account_name ? 'disabled' : '' }} value="{{$ac_name->account_name}}">{{ @ucwords(@strtolower($ac_name->account_name))}} ~ {{ @ucwords(@strtolower($ac_name->account_type))}}</option>
                                @endforeach
                            </select>
                            <div class="field-placeholder">DEPOSIT FROM <span class="text-danger">*</span></div>
                        </div>
                        <!-- Field wrapper end -->

                        </div>

                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <input class="form-control" type="number" step="0.001" name="amount">
                                <div class="field-placeholder">Amount <span class="text-danger">*</span></div>
                            </div>
                            <!-- Field wrapper end -->

                        </div>
                        
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <input class="form-control" type="datetime-local" name="date" required>
                                <div class="field-placeholder">Date</div>
                            </div>
                            <!-- Field wrapper end -->

                        </div>
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <textarea class="form-control" rows="2" name="note"></textarea>
                                <div class="field-placeholder">Note</div>
                            </div>
                            <!-- Field wrapper end -->

                        </div>
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            <button class="btn btn-primary">Submit</button>
                        </div>
                    </div>
                    <!-- Row end -->
                    </form>
                </div>
            </div>
            <!-- Card end -->
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        </div>
        </div>
    </div>
</div>
<!-- Modal end -->


@endforeach

@include('modal.new-account')

<script>
    function DeleteAccountType(id) {
        Swal.fire({
            title: 'Are you sure?',
            text: "This account will be deleted",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
            if (result.isConfirmed) {
                $("#tabler").load(" #tabler");
                const xhttp = new XMLHttpRequest();
                xhttp.onload = function() {
                    Swal.fire(
                        'Account Deletd!',
                        'This account is deleted',
                        'success'
                        )
                }
                xhttp.open("GET", "/dashboard/account-type/remove/"+id);
                xhttp.send();
            }
            })
            
    }


 function DeleteAccount(id) {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Delete Account!'
            }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = "/dashboard/account/delete-account/" + id;
            }
            })
    }
</script>



<script>
    function bill() {
        Swal.fire({
            title: 'Are you sure?',
            text: "You are creating a new bill, you may not be able to revert",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, save!'
            }).then((result) => {
            if (result.isConfirmed) {
                $('#loading-wrapper').show();
                document.getElementById("billing").submit();
            }
            })
    }
</script> 

@endsection