@extends('layouts.app')

@section('content')
<!-- Content wrapper start -->
<div class="content-wrapper">

<!-- Row start -->
<div class="row gutters">

    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
        <!-- Card start -->
        <div class="card">
            <div class="card-header">
                <div class="card-title">Payment Method</div>
            </div>
            <div class="card-body mt-4">
                
                <form class="needs-validation" novalidate method="POST" action="{{route('NewPaymentMethod')}}">
                @csrf   
                <!-- Row start -->
                    <div class="row gutters">
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <input type="text" class="form-control" name="payment_name" required="">
                                <div class="field-placeholder">Name <span class="text-danger">*</span></div>
                            </div>
                            <!-- Field wrapper end -->

                        </div>
            
                        <div class="col-12">
                            <button class="btn btn-primary" type="submit">Save</button>
                        </div>
                    </div>
                    <!-- Row end -->
                </form>

            </div>
        </div>
        <!-- Card end -->
    </div>

    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
        
        <!-- Card start -->
        <div class="card">
            <div class="card-header">
                <div class="card-title">Payment Methods</div>
            </div>
            <div class="card-body mt-4">
                
            <div class="table-responsive">
                <table id="copy-print-csv" class="table custom-table">
                    <thead>
                        <tr>
                        <th>Name</th>
                        <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($payment_methods as $payment_methods)
                        <tr>
                        <td>{{$payment_methods->payment_name}}</td>
                        <td><a onclick="DeleteCategory(this.id)"  id="{{$payment_methods->id}}" href="#" class="btn btn-outine-danger btn-sm"><i class="icon-trash-2"></i></a></td>
                        </tr>
                        @endforeach
                    </tbody>
            </table>
            </div>

            </div>
        </div>
        <!-- Card end -->

    </div>

</div>
<!-- Row end -->

</div>
<!-- Content wrapper end -->


<script>
    function DeleteCategory(id) {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Delete Payment Method!'
            }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = "/dashboard/account/delete-payment-method/" + id;
            }
            })
    }
</script>

@endsection