@extends('layouts.app')

@section('content')

<!-- Content wrapper start -->
<div class="content-wrapper" id="section-to-print">

<!-- Row start -->
<div class="row gutters">
<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

<!-- Card start -->
<div class="card">
    <div class="card-header-lg">
        <h4>New Income</h4>
    </div>
    
    <div class="card-body">

        <div class="invoice-container">

            <!-- Row start -->
            <form action="{{route('incomeReceive')}}"  method="post" id="income">

            
            @csrf
            <div class="row gutters">
                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="invoice-details">
                        <address class="m-0">
                        <div class="table-responsive">
                                    <h5>General Information</h5>
                                    <p>Here you can enter the general information of transaction such as date, amount, account, description, etc</p>
                                </div>
                            </address>
                    </div>
                </div>
            </div>
            <!-- Row end -->
            <!-- Row start -->
            <div class="row gutters">
                <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                    
                   <!-- Field wrapper start -->
                    <div class="field-wrapper">
                        <div class="input-group">
                            <input type="text" class="form-control datepicker-time" required name="income_date">
                            <span class="input-group-text">
                                <i class="icon-calendar1"></i>
                            </span>
                        </div>
                        <div class="field-placeholder">Date<span class="text-danger">*</span></div>
                    </div>
                    <!-- Field wrapper end -->

                </div>
                <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">

                <!-- Field wrapper start -->
                <div class="field-wrapper">
                        <div class="input-group">
                        <select class="select-single js-states" title="Select Product Category" name="income_payment_method" data-live-search="true">
                            <option value="CASH">CASH ({{empty($app->currency) ? "GHS" : $app->currency}})</option>
                                @foreach($payment_methods as $payment_name)
                                     <option value="{{$payment_name}} ">{{$payment_name}} ({{empty($app->currency) ? "GHS" : $app->currency}})</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="field-placeholder">Payment Methods<span class="text-danger">*</span></div>
                    </div>
                    <!-- Field wrapper end -->

                </div>
                <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                    
                <!-- Field wrapper start -->
                <div class="field-wrapper">
                    <select class="select-single js-states" title="Select Product Category" name="income_payment_account" data-live-search="true">
                    @foreach($payment_accounts as $payment_accounts)
                        <option value="{{$payment_accounts->account_number}}">{{$payment_accounts->account_name}} ({{empty($app->currency) ? "GHS" : $app->currency}})</option>
                    @endforeach
                    </select>
                    <div class="field-placeholder">Payment Account<span class="text-danger">*</span></div>
                </div>
                <!-- Field wrapper end -->

                </div>

                 <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                    
                    <!-- Field wrapper start -->
                    <div class="field-wrapper">
                        <input required class="form-control" type="number" required step="0.001" min="0" name="income_amount">
                        <div class="field-placeholder">Amount<span class="text-danger">*</span></div>
                    </div>
                    <!-- Field wrapper end -->

                </div>

              
                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    
                    <!-- Field wrapper start -->
                    <div class="field-wrapper">
                        <textarea class="form-control" rows="2" name="income_message"></textarea>
                        <div class="field-placeholder">Memo</div>
                        <div class="form-text">
                            Note
                        </div>
                    </div>
                    <!-- Field wrapper end -->

                </div>

                <!-- Row start -->
                <div class="row gutters">
                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        <div class="invoice-details">
                            <div class="table-responsive">
                            <h5>Assign</h5>
                            <p>Select a category and customer to make your report more detailed</p>
                        </div>
                        </div>
                    </div>
                </div>
                <!-- Row end -->

                <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                    
                    <!-- Field wrapper start -->
                     <div class="field-wrapper">
                         <div class="input-group">
                            <select class="select-single js-states" title="Select Product Category" name="income_category" data-live-search="true">
                                <option disabled selected> - Select Category - </option>
                                <option>Deposit</option>
                                <option>Sales</option>
                            </select>
                            <div class="form-text">
                                 New Category
                            </div>
                         </div>
                         <div class="field-placeholder">Category <span class="text-danger">*</span></div>
                     </div>
                     <!-- Field wrapper end -->
 
                 </div>

                 <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                    
                    <!-- Field wrapper start -->
                     <div class="field-wrapper">
                         <div class="input-group">
                         <select class="select-single js-states" title="Select Product Category" name="income_customer" data-live-search="true">
                            <option  disabled selected> - Select Customer - </option>
                                @foreach($customer as $customer)
                                     <option value="{{$customer->customer_name}} - {{$customer->customer_phone}}">{{$customer->customer_name}} [{{$customer->customer_phone}}]</option>
                                @endforeach
                            </select>
                         </div>
                         <div class="field-placeholder">Customer<span class="text-danger">*</span></div>
                     </div>
                     <!-- Field wrapper end -->
 
                 </div>

                 <!-- Row start -->
                <div class="row gutters">
                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        <div class="invoice-details">
                            <div class="table-responsive">
                                <h5>Other</h5>
                                <p>Enter a number and reference to keep transtion linked to your records</p>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Row end -->

                <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                    
                   <!-- Field wrapper start -->
                    <div class="field-wrapper">
                        <div class="input-group">
                            <input type="text" class="form-control" name="trans_number" value="<?= "TAN". md5(rand(100, 3990)) ?>" readonly>
                        </div>
                        <div class="field-placeholder">Trans. Number<span class="text-danger">*</span></div>
                    </div>
                    <!-- Field wrapper end -->

                </div>


                <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                    
                   <!-- Field wrapper start -->
                    <div class="field-wrapper">
                        <div class="input-group">
                            <input type="text" class="form-control" name="income_reference">
                         
                        </div>
                        <div class="field-placeholder">Reference</div>
                    </div>
                    <!-- Field wrapper end -->

                </div>


                <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                    
                   <!-- Field wrapper start -->
                    <div class="field-wrapper">
                        <div class="input-group">
                            <input type="file" class="form-control" name="file">
                            <span class="input-group-text">
                                <i class="icon-file"></i>
                            </span>
                        </div>
                        <div class="field-placeholder">Attachment</div>
                    </div>
                    <!-- Field wrapper end -->

                </div>

                

                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12" style="margin-top:15px">
                    <button type="button" class="btn btn-primary" onclick="SaveIncome()">Submit</button>
                </div>
            </div>
            <!-- Row end -->
            </form>
        </div>

    </div>
</div>
<!-- Card end -->


</div>
</div>
<!-- Row end -->

</div>


<script>
    function SaveIncome() {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Income Received!'
            }).then((result) => {
            if (result.isConfirmed) {
                document.getElementById("income").submit();
            }
            })
    }
</script>

@endsection