@extends('layouts.app')

@section('content')
<?php $currency = empty($app->currency) ? "GHS" : $app->currency ?>
<!-- Content wrapper start -->
<div class="content-wrapper">
<!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

            <!-- Card start -->
            <div class="card">

            <div class="card-header-lg">
										<h4>VAT Invoice </h4>
										<div class="text-end">
                                        @if($salesperson->status == 5)
                                        <span class="badge bg-warning">
                                            On Hold</span>
                                        @endif
										</div>
									</div>
                
                <div class="card-body">

                    <div class="invoice-container">

                        <div class="invoice-header">
                            <!-- Row start -->
                            <div class="row justify-content-between">
                                <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-12">
                                    <a href="#">
                                        <img src="/assets/img/{{$app->app_logo}}" alt="Logo" style="max-width:70px;">
                                    </a>
                                </div>
                                <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-12">
                                    <address class="text-right">
                                        {{$app->app_name}} <br>
                                        {{$app->app_website}}<br>
                                        {{$salesperson->user->branch}} <br>
                                        TIN: {{$branch_details -> tin_number}}
                                    </address>
                                </div>
                            </div>
                            <!-- Row end -->
                        </div>

                        <!-- Row start -->
                        <div class="row gutters">
                            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                <div class="invoice-details">
                                    <address class="m-0">
                                    {{$customer -> customer_name}},<br>
                                    @if(!empty($customer -> customer_address))
                                    {{$customer -> customer_address}},<br>
                                    @endif
                                    {{$customer -> customer_phone}}
                                    </address>

                                    <div class="invoice-num">
                                        <div>Invoice - #{{$number}}</div>
                                        <div>{{$salesperson->created_at}}</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Row end -->

                        <!-- Row start -->
                        <div class="row gutters">
                            <div class="col-12">
                                
                                <div class="table-responsive">
                                    <table class="table table-bordered">
                                        <thead>
                                            <tr>
                                                <th>Items</th>
                                                <th>Quantity</th>
                                                <th>Rate <br>{{empty($app->currency) ? "GHS" : $app->currency}}</th>
                                                <th>Amount (Net) <br>{{empty($app->currency) ? "GHS" : $app->currency}}</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $sumTotalPrice = 0 ; ?>
                                            @foreach($products as $item)
                                                <?php $sumTotalPrice += $item->invoice_quantity * $item->invoice_unit_price ?>
                                            <tr>
                                                <td>
                                                    <h6>{{$item->invoice_product_name}}</h6>
                                                    <p>{{$item->invoice_category}}</p>
                                                </td>
                                                <td>
                                                    <h6>@convert($item->invoice_quantity)</h6>
                                                </td>
                                                <td>
                                                    <h6>@convert($item->invoice_unit_price)</h6>
                                                </td>
                                                <td>
                                                    <h6>@convert($item->invoice_quantity * $item->invoice_unit_price)</h6>
                                                </td>
                                            </tr>
                                            @endforeach
                                          
                                            <tr>
                                                <td colspan="2">&nbsp;</td>
                                                <td>
                                                    <p class="m-0">Subtotal</p>
                                                    <p class="m-0">Discount</p>
                                                    <h5 class="mt-2 text-danger">Total {{empty($app->currency) ? "GHS" : $app->currency}}</h5>
                                                </td>
                                                <td>
                                                    <p class="m-0">@convert($sumTotalPrice)</p>
                                                    <p class="m-0">
                                                        @if(!empty($discount))
                                                        {!!$discount->type == "Percentage" ? (($salesperson->discount/$sumTotalPrice)*100) ."%" : $currency .$salesperson->discount!!}
                                                        @else
                                                        @convert(0)
                                                        @endif
                                                    </p>
                                                    <h5 class="mt-2 text-danger">@convert($sumTotalPrice - $salesperson->discount)</h5>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>

                                <div>
                                <address class="mb-10" style="float:right">
                                CASHIER:  {{strtoupper($salesperson->user->name)}}<br>
                                    </address>
                                    
                                </div>
                            </div>
                        </div>
                        <!-- Row end -->

                        <!-- Row start -->
                        <div class="row gutters">

                            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                <div class="text-start">
                                    <button class="btn btn-outline-primary ms-1" onclick="printInvoice()">  <i class="icon-printer" aria-hidden="true"></i> Print</button>
                                </div>
                            </div>

                        </div>
                        <!-- Row end -->
                    
                    </div>

                </div>
            </div>
            <!-- Card end -->

        </div>
    </div>
    <!-- Row end -->

    </div>


    <script>
         function printInvoice() {
            $('#loading-wrapper').show();
            window.location.href = "<?=config('app.url')?>/dashboard/print-invoice/<?= $number; ?>/<?= $customer->id; ?>" ;
         }
    </script>

<style>
     @media print {
      body * {
        visibility: hidden;
      }
      #section-to-print, #section-to-print * {
        visibility: visible;
      }
      #section-to-print {
        position: absolute;
        left: 0;
        top: 0;
      }
    }
</style>

<script>
    function PrintPage(params) {
        window.print();
    }
</script>
@endsection