@extends('layouts.fullscreen')

@section('content')

<!-- Content wrapper start -->
<div class="content-wrapper" id="section-to-print">


 <!-- Breadcrumb container start -->
 <div class="breadcrumb-container">

<!-- Row start -->
<div class="row gutters">
    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
              <li class="breadcrumb-item"><a href="/">Home</a></li>
              <li class="breadcrumb-item"><a href="/">Dashboards</a></li>
              <li class="breadcrumb-item active" aria-current="page">Trail Balance</li>
            </ol>
        </nav>
    </div>
        <!-- Top Actions - DateRange and Buttons -->
        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                    <form action="{{route('trial.index')}}" method="get">
                        <div class="d-flex justify-content-end">
                            <!-- Field wrapper start -->
                            <div class="field-wrapper m-0">
                                <div class="input-group">
                                <input type="text" class="form-control custom-daterange2" name="date">
                                    <span class="input-group-text">
                                    <i class="icon-calendar1"></i>
                                    </span>
                                </div>
                            </div>
                            <!-- Field wrapper end -->
                            <button class="btn btn-outline-info"><i class="icon-download1"></i>Reports</button>
                        </div>
                     </form>
                </div>
</div>
<!-- Row end -->

</div>
<!-- Breadcrumb container end -->

<!-- Row start -->
<div class="row gutters">
<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

<!-- Card start -->
<div class="card">
    <div class="card-header-lg">
        <h4>TRIAL BALANCE</h4>
    </div>


    <div class="card-body">

        <div class="invoice-container">


            <!-- Row start -->
            <div class="row gutters">
                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="invoice-details">
                        <address class="m-0">
                        <div class="table-responsive">
                                    <strong>{{@strtoupper($app->app_name)}} TRIAL BALANCE</strong>  AS OF {{request('date')}}
                                </div>
                            </address>
                    </div>
                </div>
            </div>
            <!-- Row end -->

            <!-- Row start -->
            <div class="row gutters">
                <div class="col-12">
                    
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped m-0">
                            <thead>
                                <tr>
                                    <th>Particulars</th>
                                    <th>Debit <br>{{empty($app->currency) ? "GHS" : $app->currency}}</th>
                                    <th>Credit <br> {{empty($app->currency) ? "GHS" : $app->currency}}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach( array_filter(session()->get('balance')) as $transactions)
                                <tr>
                                    <td>{{@ucwords(@strtolower($transactions['particulars']))}}</td>
                                    <td>
                                        @if(!empty($transactions['debit']) || null)
                                          @convert($transactions['debit'])
                                        @endif
                                    </td>
                                    <td>
                                        @if(!empty($transactions['credit']) || null)
                                          @convert($transactions['credit'])
                                        @endif
                                    </td>
                                </tr>
                                @endforeach
                                <tr>
                                    <td><strong>TOTAL</strong></td>
                                    <td><strong>@convert($sumdebit)</strong></td>
                                    <td><strong>@convert($sumcredit)</strong></td>
                                </tr>
                                
                            </tbody>
                        </table>
                    </div>
                    
                </div>
            </div>
            <!-- Row end -->

            <!-- Row start -->
            <div class="row gutters"  style="margin-top:20px">

                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="text-start">
                        <form action="{{route('TrialBalancePrint')}}" method="get">

                        <input type="text" value="{{request('date')}}" name="date" hidden>

                        <button type="submit" class="btn btn-outline-primary"> <i class="icon-printer"></i> Print</button>
                            
                        </form>
                    </div>
                </div>

            </div>
            <!-- Row end -->
        
        </div>

    </div>
</div>
<!-- Card end -->

</div>
</div>
<!-- Row end -->

</div>

<style>
     @media print {
      body * {
        visibility: hidden;
      }
      #section-to-print, #section-to-print * {
        visibility: visible;
      }
      #section-to-print {
        position: absolute;
        left: 0;
        top: 0;
      }
    }
</style>

<script>
    function PrintPage(params) {
        window.print();
    }
</script>
@endsection