@extends('layouts.app')

@section('content')

					<!-- Content wrapper start -->
<div class="content-wrapper">


    <!-- Breadcrumb container start -->
    <div class="breadcrumb-container">

        <!-- Row start -->
        <div class="row gutters">
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Dashboards</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Stock Adjustment</li>
                    </ol>
                </nav>
            </div>

            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
            
            <!-- Top Actions - DateRange and Buttons -->
            <form action="{{route('AdjustDate')}}" method="get">
           <div class="d-flex justify-content-end">
            
                <div class="d-flex justify-content-end">
                    <!-- Field wrapper start -->
                    <div class="field-wrapper m-0">
                        <div class="input-group">
                        <input type="date" class="form-control" min="{{date('Y-m-d', strtotime('-40 day', strtotime($dayClose->day_close)) )}}"  name="date" value="{{request('date')}}" max="{{$dayClose->day_close}}">
                            
                            <button class="btn btn-info"><i class="icon-eye1"></i> view</button>
                        </div>
                    </div>
                    <!-- Field wrapper end -->
                    
                </div>
                
            </div>
           </form>
            </div>
    
        </div>
        <!-- Row end -->

    </div>
    <!-- Breadcrumb container end -->


						<!-- Row start -->
						<div class="row gutters">
							<div class="col-xl-12">
								<!-- Card start -->
								<div class="card">
                                <div class="card-header">
                                        <div class="card-title">Adjustment</div>
                                        <div> Adjustment Date: <em>{{request()->date == null ? $dayClose->day_close : request()->date }}</em>, Station: <?=auth()->user()->station?></div>
                                    </div>
                                    
                                    <div style="margin-left:20px; margin-top:10px">
                                    <div class="alert alert-light alert-dismissible fade show" role="alert">
                                        Stock Adjustment involves updating the quantity and value of stock items to reflect the actual physical count and any discrepancies that may have occurred. Stock adjustments can occur for various reasons, including: Stock shrinkage or losses, Stock surplus, Stock obsolescence and Counting errors.
											<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
										</div>
                                    </div>
                                    
							<div class="card-body">
                            <form action="{{route('save.Adjust')}}" id="stocktakingadjust" method="POST">
                                        @csrf
                                    <div class="table-responsive">
                                    <table id="basicExample" class="table custom-table">
                            <thead>
                                <tr>
                                <th>Items</th>
                                <th>Category</th>
                                <th>UOM</th>
                                <th>Closing Stock</th>
                                <th>Phys. Stock</th>
                                <th>Ajustmet</th>
                                <th>Variance</th>
                                <th>Remark</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($record_physical as $report)
                                @if(in_array(auth()->user()->station, json_decode($report->inactive_station)) == true)
                                    @continue
                                @endif
                                <?php $closing_balance = (round($report->opening_stock, 2) + round($report->stock_in, 2)) - round($report->stock_out, 2) ?>

                                <tr>
                                <td>{{@ucwords(@strtolower($report->item_name))}}</td>
                                    <td>{{@ucwords(@strtolower($report->item_category))}}</td>
                                    <td>{{$report->item_unit}}</td>
                                    <td>@convert($closing_balance)</td>
                                    <td>@convert( $report -> physical_stock )</td>
                                    <td>

                                        <input type="number" step="0.0000001" class="form-control" value="@convert(-1*($report->physical_stock - $closing_balance))" name="items[<?=$report->id;?>][issue_item_adjustment]" readonly>
                                        <input type="text" class="form-control" name="items[<?=$report->id;?>][issue_station]" value="{{auth()->user()->station}}" hidden>
                                        <input type="text" class="form-control" name="items[<?=$report->id;?>][issue_item_id]" value="{{$report->item_id}}" hidden>
                                       
                                    </td>    
                                    <td>@convert($report->physical_stock - ($closing_balance))</td>
                                    <td><textarea name="items[<?=$report->id;?>][comment]" class="form-control" id="" cols="30" rows="2"></textarea></td>

                                </tr>
                                @endforeach
                            </tbody>
                            </table>
                                        </div>
                                       <div style="margin-top:12px">
                                         <button class="btn btn-primary" type="button" onclick="physical()">Save</button>
                                       </div>
                                        </form>
									</div>
								</div>
								<!-- Card end -->
                            </div>
						</div>
						<!-- Row end -->

					</div>
					<!-- Content wrapper end -->


                    <script>
                        function physical() {
                            Swal.fire({
                                title: 'Are you sure?',
                                text: "you are about to adjust stock, You won't be able to revert this!",
                                icon: 'warning',
                                showCancelButton: true,
                                confirmButtonColor: '#3085d6',
                                cancelButtonColor: '#d33',
                                confirmButtonText: 'Yes, Adjust!'
                                }).then((result) => {
                                if (result.isConfirmed) {
                                    document.getElementById("stocktakingadjust").submit();
                                }
                                })
                        }
                    </script> 
@endsection