<!doctype html>
<html lang="en">
	
<head>
		<!-- Required meta tags -->
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

		<!-- Meta -->
		<meta name="description" content="ANDAS POS">
		<meta name="author" content="ADORABLE WORKS">
		<link rel="shortcut icon" href="/assets/img/{{$app->fav_icon}}">

		<!-- Title -->
		<title>{{$app->app_name}} - Sales Transactions for {{$dayClose->day_close}}</title>

           <!-- *************
            ************ Common Css Files *************
        ************ -->
        <!-- Bootstrap css -->
        <link rel="stylesheet" href="{{asset('assets/css/bootstrap.min.css')}}">

        <!-- Icomoon Font Icons css -->
        <link rel="stylesheet" href="{{asset('assets/fonts/style.css')}}">

        <!-- Main css -->
        <link rel="stylesheet" href="{{asset('assets/css/main.css')}}">


        <!-- Data Tables -->
        <link rel="stylesheet" href="{{asset('assets/vendor/datatables/dataTables.bs4.css')}}" />
        <link rel="stylesheet" href="{{asset('assets/vendor/datatables/dataTables.bs4-custom.css')}}" />
        <link href="{{asset('assets/vendor/datatables/buttons.bs.css')}}" rel="stylesheet" />
		
	</head>

<body>

<div class="card-body">
<div class="invoice-container">
    <div class="invoice-header">
        <!-- Row start -->
        <div class="row justify-content-between">
            <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-12">
                <a href="/" class="logo">
                 <img src="/assets/img/{{$app->fav_icon}}" alt="logo3" style="max-width:70px;">
                </a>
            </div>
            <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-12">
                <address class="text-right">
                    Printed by: {{auth()->user()->name}} <br>
                    Printed Date:  <?=@strtoupper(date('Y-m-d h:i:s a')) ?><br>
                </address>
            </div>
        </div>
        <!-- Row end -->
    </div>

    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            <div class="invoice-details">
                <address class="m-0">
                    <strong>{{$app->app_name}}</strong>,<br>
                    <?= @strtoupper("SALES TRANSACTIONs - [ORDER SUMMARY]") ?><br>
                    REPORT ON SALES FROM: 
                    @if(Auth()->user()->role == "Administrator")
                    <strong>ALL OUTLETS</strong>
                    @elseif(Auth()->user()->role == "Branch Officer")
                    {{@strtoupper(auth()->user()->branch)}}
                    @else
                    {{@strtoupper(auth()->user()->name)}}
                    @endif
                </address>

                <div class="invoice-num">
                    <div>Report Date</div>
                    <div> {{request()->date == null ? $dayClose->day_close : request()->date}}</div>
                </div>
            </div>
        </div>
    </div>
    <!-- Row end -->

    <div class="table-responsive">
	<table class="table table-bordered table-striped m-0">
    <thead>
        <tr>
            <th>OrderID</th>
            <th>EnteredBy</th>
            <th>Date</th>
            <th>Category</th>
            <th>Outlet</th>	
            @if(auth()->user()->role == "Administrator")
            <th>Channel</th>	
            @endif	
            <th>Payment Status</th>										
            <th>Discount</th>
            <th>Amount Recieved</th>
            <th>Total Cost</th>
            
        </tr>
    </thead>
    <tbody>
        @foreach($all_sales as $list)
        <tr>
            <td><strong> <a href="{{route('orderTransaction',$list->order_id)}}">#{{$list->order_id}}</a></strong></td>
            <td>{{$list->user->name}}</td>
            <td>{{$list->created_at}}</td>
            <td>{{@strtoupper($list->category)}}</td>
            <td>{{$list->branch}}</td>
            
            <td>
                @if(auth()->user()->role == "Administrator")
                {!!$list->channel == 1 ? '<span class="badge bg-success">' . "Installed App" . '</span>' : '<span class="badge bg-warning">' . "Website" . '</span>' !!}
                @endif
            </td>
            <td>
                {!!$list->status == 5 ? '<span class="text-info"><i class="icon-slash"></i>' . " On Hold" . '</span>' : '<span class="text-success"><i class="icon-check-circle"></i>' . " Paid" . '</span>' !!}
                
            </td>
            
            <td>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($list->discount)</td>
            <td>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($list->total_cost_order-$list->discount)</td>
            <td>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($list->total_cost_order)</td>
        </tr>
        @endforeach
        <tr>
            <td><strong>Total: @convert($all_sales->count())</strong></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            @if(auth()->user()->role == "Administrator")
            <td></td>
            @endif
            <td><strong>Discount: {{empty($app->currency) ? "GHS" : $app->currency}}@convert($all_sales->sum('discount'))</strong></td>
            <td><strong>Total Amount Received: {{empty($app->currency) ? "GHS" : $app->currency}}@convert($all_sales->sum('total_cost_order') - $all_sales->sum('discount'))</strong></td>
            <td><strong>Total Cost: {{empty($app->currency) ? "GHS" : $app->currency}}@convert($all_sales->sum('total_cost_order'))</td>
        </tr>
    </tbody>
	</table>
</div>

</div>
</div>
</div>



		<!-- Data Tables -->
		<script src="{{asset('assets/vendor/datatables/dataTables.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/dataTables.bootstrap.min.js')}}"></script>
		
		<!-- Custom Data tables -->
		<script src="{{asset('assets/vendor/datatables/custom/custom-datatables.js')}}"></script>

		<!-- Download / CSV / Copy / Print -->
		<script src="{{asset('assets/vendor/datatables/buttons.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/jszip.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/pdfmake.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/vfs_fonts.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/html5.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/buttons.print.min.js')}}"></script>
		<!-- <script src="{{asset('assets/vendor/apex/custom/crm/sales.js')}}"></script> -->
		


		<!-- Main Js Required -->
		<script src="{{asset('assets/js/main.js')}}"></script>

	</body>

</html>