@extends('layouts.app')

@section('content')

<!-- Content wrapper start -->
<div class="content-wrapper">


<!-- Breadcrumb container start -->
<div class="breadcrumb-container">

<!-- Row start -->
<div class="row gutters">
    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
              <li class="breadcrumb-item"><a href="/">Home</a></li>
              <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Dashboards</a></li>
              <li class="breadcrumb-item"><a href="#">Voucher</a></li>
              <li class="breadcrumb-item active" aria-current="page">Pending Approvals</li>
            </ol>
        </nav>
    </div>


    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
            <!-- Top Actions - DateRange and Buttons -->
            
            <form action="{{route('VadminApproval')}}" method="get">
            
            <div class="d-flex justify-content-end">
                <!-- Field wrapper start -->
                <div class="field-wrapper m-0">
                    <div class="input-group">
                    <input type="text" class="form-control custom-daterange2" name="date">
                        <span class="input-group-text">
                        <i class="icon-calendar1"></i>
                        </span>
                    </div>
                </div>
                <!-- Field wrapper end -->
                <button class="btn btn-info"><i class="icon-download1"></i> Reports</button>
            </div>
            </form>
        </div>
</div>
<!-- Row end -->

</div>
<!-- Breadcrumb container end -->


<!-- Row start -->
<div class="row gutters">
    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
        
        <div class="card">
            
            <div class="card-body">
                <div class="pb-4">
                @if(Route::currentRouteName() == "approvedVoucherAdmin")
                <span><strong>Approved Voucher</strong> for {{$dayClose->day_close}}</span>
                @else
                    <span> <strong>Pending Vouchers for </strong>{{empty(request('date')) ? $dayClose->day_close : request('date')}}</span>  <span style="float:right"><a href="{{route('approvedVoucherAdmin')}}" class="btn btn-outline-primary btn-sm"> <i class="icon-lock2"></i> Approved </a></span>
                @endif
                </div>
                <div class="table-responsive">
                    <table id="copy-print-csv" class="table v-middle">
                        <thead>
                            <tr>
                              <th>Trans. No.</th>
                              <th>Date</th>	
                              <th>Transfer To</th>													  
                              <th>By User</th>                             
                              <th>Created at</th>												  
                              <th>Status</th>
                              <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($authorizeStatus as $list)
                            <tr>
                              <td>
                               #{{$list->transaction_no}}
                              </td>
                              <td>
                              {{$list->issue_date}}
                              </td>
                              <td>
                              {{$list->issue_to}}
                              </td>													  
                              <td><?php $user = \DB::table('users')->where('id', $list->user_id)->first(); echo $user->name ?></td>
                              <td>
                              <?php $comment = \DB::table('issue_lists')->where('transaction_no',$list->transaction_no)->first() ?>
                              {{$comment->created_at}}
                              </td>
                              <td>
                                 @if($comment->authorize_status == 0)
                                  <span class="badge bg-success"> Rejected </span>
                                  @elseif($comment->authorize_status == 1)
                                  <span class="badge bg-danger"> Approved </span>
                                  @else
                                  <span class="badge bg-info"> Pending </span>
                                  @endif
                                  
                              </td>
                              <td>
                              <div class="actions">
                                      <a href="{{route('viewVoucherAuthorize', $list->transaction_no)}}" data-toggle="tooltip" data-placement="top" title="" data-original-title="Edit">
                                          <i class="icon-edit1 text-info"></i>
                                      </a>
                                  </div>
                              </td>
                            </tr>
                            @endforeach
                        </tbody>
                </table>
                </div>

            </div>
        </div>

    </div>
</div>
<!-- Row end -->
@include('modal.voucher-modal')
</div>
<!-- Content wrapper end -->


@endsection